/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.kbinani.PortUtil;

public class PlaySound {
    private static final int UNIT_BUFFER = 512;
    private static SourceDataLine m_line;
    private static AudioFormat m_format;
    private static DataLine.Info m_info;
    private static byte[] m_buffer;

    public static void setResolution(int n) {
    }

    public static void init() {
        m_buffer = new byte[2048];
    }

    public static void kill() {
    }

    public static double getPosition() {
        return (double)m_line.getMicrosecondPosition() * 1.0E-6;
    }

    public static void waitForExit() {
        if (m_line == null) {
            return;
        }
        m_line.drain();
    }

    public static void append(double[] dArray, double[] dArray2, int n) {
        int n2;
        if (m_line == null) {
            return;
        }
        int n3 = 0;
        for (int i = dArray.length; i > 0; i -= n2) {
            n2 = i > 512 ? 512 : i;
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                short s = (short)(dArray[j + n3] * 32767.0);
                PlaySound.m_buffer[n4] = (byte)(0xFF & s);
                PlaySound.m_buffer[n4 + 1] = (byte)(0xFF & s >>> 8);
                short s2 = (short)(dArray2[j + n3] * 32767.0);
                PlaySound.m_buffer[n4 + 2] = (byte)(0xFF & s2);
                PlaySound.m_buffer[n4 + 3] = (byte)(0xFF & s2 >>> 8);
                n4 += 4;
            }
            m_line.write(m_buffer, 0, n2 * 4);
            n3 += n2;
        }
    }

    public static void prepare(int n) {
        m_format = new AudioFormat(n, 16, 2, true, false);
        m_info = new DataLine.Info(SourceDataLine.class, m_format);
        try {
            m_line = (SourceDataLine)AudioSystem.getLine(m_info);
            m_line.open(m_format);
            m_line.start();
        }
        catch (Exception exception) {
            m_line = null;
        }
    }

    public static void exit() {
        m_line.stop();
        m_line.close();
        m_info = new DataLine.Info(SourceDataLine.class, m_format);
        try {
            m_line = (SourceDataLine)AudioSystem.getLine(m_info);
            m_line.open(m_format);
            m_line.start();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("PlaySound#reset; ex=" + exception);
            m_line = null;
        }
    }

    public static void unprepare() {
    }
}

