/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.OtoArgs;
import org.kbinani.cadencii.PlaySound;
import org.kbinani.cadencii.PointD;
import org.kbinani.cadencii.RenderQueue;
import org.kbinani.cadencii.RenderingRunner;
import org.kbinani.cadencii.UtauVoiceDB;
import org.kbinani.cadencii.VibratoPointIterator;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.UstEnvelope;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtauRenderingRunner
extends RenderingRunner {
    public static final String FILEBASE = "temp.wav";
    private static final int MAX_CACHE = 512;
    private static TreeMap<String, ValuePair<String, Double>> s_cache = new TreeMap();
    private Vector<RenderQueue> m_resampler_queue = new Vector();
    private double[] m_left;
    private double[] m_right;
    private double m_progress = 0.0;
    VsqFileEx m_vsq;
    Vector<SingerConfig> m_singer_config_sys;
    String m_resampler;
    String m_wavtool;
    String m_temp_dir;
    boolean m_invoke_with_wine;
    boolean m_mode_infinite;
    double m_started_date;
    double m_running_rate;

    public UtauRenderingRunner(VsqFileEx vsqFileEx, int n, Vector<SingerConfig> vector, String string, String string2, boolean bl, int n2, int n3, long l, boolean bl2, WaveWriter waveWriter, double d, Vector<WaveReader> vector2, boolean bl3, boolean bl4) {
        super(n, bl4, waveWriter, d, vector2, bl3, n3, l, n2);
        this.m_vsq = vsqFileEx;
        this.m_singer_config_sys = vector;
        this.m_resampler = string;
        this.m_wavtool = string2;
        this.m_temp_dir = PortUtil.combinePath(AppManager.getCadenciiTempDir(), AppManager.getID());
        this.m_invoke_with_wine = bl;
        this.m_mode_infinite = bl2;
    }

    public static void clearCache() {
        for (String string : s_cache.keySet()) {
            ValuePair<String, Double> valuePair = s_cache.get(string);
            String string2 = valuePair.getKey();
            try {
                PortUtil.deleteFile(string2);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("UtauRenderingRunner#clearCache; ex=" + exception);
            }
        }
        s_cache.clear();
    }

    @Override
    public double getProgress() {
        return this.m_progress;
    }

    @Override
    public double getElapsedSeconds() {
        return PortUtil.getCurrentTime() - this.m_started_date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_started_date = PortUtil.getCurrentTime();
        this.m_rendering = true;
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            int n2;
            int n3;
            Object object4;
            Object object5;
            Object object6;
            int n4;
            String string;
            String string2;
            double d = this.m_vsq.getSecFromClock(this.m_vsq.TotalClocks) * (double)this.sampleRate;
            this.m_abort_required = false;
            this.m_progress = 0.0;
            if (!PortUtil.isDirectoryExists(this.m_temp_dir)) {
                PortUtil.createDirectory(this.m_temp_dir);
            }
            TreeMap<Integer, UtauVoiceDB> treeMap = new TreeMap<Integer, UtauVoiceDB>();
            Vector<SingerConfig> vector = this.m_singer_config_sys;
            VsqTrack vsqTrack = (VsqTrack)this.m_vsq.Track.get(this.renderingTrack);
            for (int i = 0; i < vector.size(); ++i) {
                string2 = vector.get((int)i).VOICENAME;
                string = vector.get((int)i).VOICEIDSTR;
                String string3 = PortUtil.combinePath(string, "oto.ini");
                UtauVoiceDB utauVoiceDB = new UtauVoiceDB(string3);
                treeMap.put(i, utauVoiceDB);
            }
            String string4 = PortUtil.combinePath(this.m_temp_dir, FILEBASE);
            if (PortUtil.isFileExists(string4)) {
                PortUtil.deleteFile(string4);
            }
            if (PortUtil.isFileExists(string2 = PortUtil.combinePath(this.m_temp_dir, "temp.wav.whd"))) {
                PortUtil.deleteFile(string2);
            }
            if (PortUtil.isFileExists(string = PortUtil.combinePath(this.m_temp_dir, "temp.wav.dat"))) {
                PortUtil.deleteFile(string);
            }
            int n5 = -1;
            double d2 = 0.0;
            double d3 = 0.0;
            int n6 = 0;
            this.m_resampler_queue.clear();
            Vector<VsqEvent> vector2 = new Vector<VsqEvent>();
            Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
            while (iterator.hasNext()) {
                vector2.add(iterator.next());
            }
            int n7 = vector2.size();
            for (n4 = 0; n4 < n7; ++n4) {
                String string5;
                int n8;
                Object object7;
                Object object8;
                double d4;
                VsqEvent vsqEvent = (VsqEvent)vector2.get(n4);
                VsqEvent vsqEvent2 = vsqTrack.getSingerEventAt(vsqEvent.Clock);
                n6 = vsqEvent2 == null ? 0 : vsqEvent2.ID.IconHandle.Program;
                if (this.m_abort_required) {
                    this.m_rendering = false;
                    return;
                }
                ++n5;
                double d5 = this.m_vsq.getSecFromClock(vsqEvent.Clock);
                double d6 = d5 - (double)vsqEvent.UstEvent.PreUtterance / 1000.0;
                d3 = d2;
                double d7 = d2 = this.m_vsq.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength());
                VsqEvent vsqEvent3 = null;
                if (n4 + 1 < n7) {
                    vsqEvent3 = (VsqEvent)vector2.get(n4 + 1);
                }
                if (vsqEvent3 != null && (d4 = this.m_vsq.getSecFromClock(vsqEvent3.Clock) - (double)vsqEvent3.UstEvent.PreUtterance / 1000.0 + (double)vsqEvent3.UstEvent.VoiceOverlap / 1000.0) < d7) {
                    d7 = d4;
                }
                float f = (float)((double)vsqEvent.ID.getLength() / (d2 - d5) / 8.0);
                if (n5 == 0 && d5 > 0.0 || d5 > d3) {
                    double d8 = d3;
                    double d9 = d5;
                    float f2 = (float)((double)vsqEvent.Clock / (d9 - d8) / 8.0);
                    object8 = "";
                    if (0 <= n6 && n6 < vector.size()) {
                        object8 = vector.get((int)n6).VOICEIDSTR;
                    }
                    object7 = new RenderQueue();
                    ((RenderQueue)object7).ResamplerArg = "";
                    ((RenderQueue)object7).WavtoolArgPrefix = "\"" + string4 + "\" \"" + PortUtil.combinePath((String)object8, "R.wav") + "\" 0 " + vsqEvent.Clock + "@" + PortUtil.formatMessage("{0:f2}", Float.valueOf(f2));
                    ((RenderQueue)object7).WavtoolArgSuffix = " 0 0";
                    ((RenderQueue)object7).Oto = new OtoArgs();
                    ((RenderQueue)object7).FileName = "";
                    ((RenderQueue)object7).secEnd = d9;
                    ((RenderQueue)object7).ResamplerFinished = true;
                    this.m_resampler_queue.add((RenderQueue)object7);
                    ++n5;
                }
                object6 = vsqEvent.ID.LyricHandle.L0.Phrase;
                object5 = UtauRenderingRunner.NoteStringFromNoteNumber(vsqEvent.ID.Note);
                int n9 = (int)((d7 - d6) * 1000.0) + 50;
                object4 = new OtoArgs();
                if (treeMap.containsKey(n6)) {
                    UtauVoiceDB utauVoiceDB = (UtauVoiceDB)treeMap.get(n6);
                    object4 = utauVoiceDB.attachFileNameFromLyric((String)object6);
                }
                String string6 = "";
                if (0 <= n6 && n6 < vector.size()) {
                    string6 = vector.get((int)n6).VOICEIDSTR;
                }
                ((OtoArgs)object4).msPreUtterance = vsqEvent.UstEvent.PreUtterance;
                ((OtoArgs)object4).msOverlap = vsqEvent.UstEvent.VoiceOverlap;
                object8 = new RenderQueue();
                object7 = "";
                object7 = PortUtil.getStringLength(((OtoArgs)object4).fileName) > 0 ? PortUtil.combinePath(string6, ((OtoArgs)object4).fileName) : PortUtil.combinePath(string6, (String)object6 + ".wav");
                String string7 = "\"" + (String)object7 + "\" ";
                String string8 = "\"" + (String)object5 + "\" 100 " + vsqEvent.UstEvent.Flags + "L" + " " + ((OtoArgs)object4).msOffset + " " + n9 + " " + ((OtoArgs)object4).msConsonant + " " + ((OtoArgs)object4).msBlank + " 100 " + vsqEvent.UstEvent.Moduration;
                String string9 = "";
                n3 = 1;
                int n10 = 5;
                n2 = 120;
                double d10 = (double)n10 / (8.0 * (double)n2);
                if (vsqEvent.ID.VibratoHandle == null) {
                    int n11 = (int)((d7 - d6) / d10) + 1;
                    for (int i = 0; i < n11; ++i) {
                        double d11 = d6 + d10 * (double)i;
                        int n12 = (int)this.m_vsq.getClockFromSec(d11);
                        float f3 = (float)vsqTrack.getPitchAt(n12);
                        if (f3 != 0.0f) {
                            n3 = 0;
                        }
                        string9 = string9 + " " + PortUtil.formatDecimal("0.00", f3);
                        if (i != 0) continue;
                        string9 = string9 + "Q" + n2;
                    }
                } else {
                    float f4;
                    int n13;
                    double d12 = this.m_vsq.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.VibratoDelay);
                    n8 = (int)((d12 - d6) / d10);
                    int n14 = 0;
                    for (int i = 0; i < n8; ++i) {
                        double d13 = d6 + d10 * (double)i;
                        n13 = (int)this.m_vsq.getClockFromSec(d13);
                        f4 = (float)vsqTrack.getPitchAt(n13);
                        string9 = string9 + " " + PortUtil.formatDecimal("0.00", f4);
                        if (n14 == 0) {
                            string9 = string9 + "Q" + n2;
                        }
                        ++n14;
                    }
                    VibratoPointIterator vibratoPointIterator = new VibratoPointIterator(this.m_vsq, vsqEvent.ID.VibratoHandle.getRateBP(), vsqEvent.ID.VibratoHandle.getStartRate(), vsqEvent.ID.VibratoHandle.getDepthBP(), vsqEvent.ID.VibratoHandle.getStartDepth(), vsqEvent.Clock + vsqEvent.ID.VibratoDelay, vsqEvent.ID.getLength() - vsqEvent.ID.VibratoDelay, (float)d10);
                    while (vibratoPointIterator.hasNext()) {
                        PointD pointD = (PointD)vibratoPointIterator.next();
                        float f5 = (float)pointD.getX();
                        n13 = (int)this.m_vsq.getClockFromSec(f5);
                        f4 = (float)vsqTrack.getPitchAt(n13);
                        string9 = string9 + " " + PortUtil.formatDecimal("0.00", (double)f4 + pointD.getY() * 100.0);
                        if (n14 == 0) {
                            string9 = string9 + "Q" + n2;
                        }
                        ++n14;
                    }
                    n3 = n14 == 0 ? 1 : 0;
                }
                object3 = PortUtil.combinePath(this.m_temp_dir, PortUtil.getMD5FromString(s_cache.size() + string7 + string8 + string9) + ".wav");
                ((RenderQueue)object8).ResamplerArg = string7 + " \"" + (String)object3 + "\" " + string8;
                if (n3 == 0) {
                    ((RenderQueue)object8).ResamplerArg = ((RenderQueue)object8).ResamplerArg + string9;
                }
                if ((n8 = (int)(s_cache.containsKey(string5 = string7 + string8 + string9) ? 1 : 0)) == 0) {
                    if (s_cache.size() + 1 >= 512) {
                        double d14 = PortUtil.getCurrentTime();
                        String string10 = "";
                        String string11 = "";
                        for (String string12 : s_cache.keySet()) {
                            ValuePair<String, Double> valuePair = s_cache.get(string12);
                            if (!(d14 < valuePair.getValue())) continue;
                            d14 = valuePair.getValue();
                            string10 = valuePair.getKey();
                            string11 = string12;
                        }
                        try {
                            PortUtil.deleteFile(string10);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("UtauRenderingRunner#run; ex=" + exception);
                        }
                        s_cache.remove(string11);
                    }
                    s_cache.put(string5, new ValuePair<double[], Double>((double[])object3, PortUtil.getCurrentTime()));
                } else {
                    object3 = s_cache.get(string5).getKey();
                }
                ((RenderQueue)object8).WavtoolArgPrefix = "\"" + string4 + "\" \"" + (String)object3 + "\" 0 " + vsqEvent.ID.getLength() + "@" + PortUtil.formatMessage("{0:f2}", Float.valueOf(f));
                object2 = vsqEvent.UstEvent.Envelope;
                if (object2 == null) {
                    object2 = new UstEnvelope();
                }
                ((RenderQueue)object8).WavtoolArgSuffix = " " + ((UstEnvelope)object2).p1 + " " + ((UstEnvelope)object2).p2 + " " + ((UstEnvelope)object2).p3 + " " + ((UstEnvelope)object2).v1 + " " + ((UstEnvelope)object2).v2 + " " + ((UstEnvelope)object2).v3 + " " + ((UstEnvelope)object2).v4;
                ((RenderQueue)object8).WavtoolArgSuffix = ((RenderQueue)object8).WavtoolArgSuffix + " " + ((OtoArgs)object4).msOverlap + " " + ((UstEnvelope)object2).p4 + " " + ((UstEnvelope)object2).p5 + " " + ((UstEnvelope)object2).v5;
                ((RenderQueue)object8).Oto = object4;
                ((RenderQueue)object8).FileName = object3;
                ((RenderQueue)object8).secEnd = d2;
                ((RenderQueue)object8).ResamplerFinished = n8;
                this.m_resampler_queue.add((RenderQueue)object8);
            }
            n4 = this.m_resampler_queue.size();
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            boolean bl = true;
            int n18 = (int)((double)this.trimMillisec / 1000.0 * (double)this.sampleRate);
            VsqBPList vsqBPList = ((VsqTrack)this.m_vsq.Track.get(this.renderingTrack)).getCurve("dyn");
            for (int i = 0; i < n4; ++i) {
                int n19;
                int n20;
                block110: {
                    object = this.m_resampler_queue.get(i);
                    if (!((RenderQueue)object).ResamplerFinished) {
                        String[] stringArray;
                        String string13 = ((RenderQueue)object).ResamplerArg;
                        if (this.m_invoke_with_wine) {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = "wine \"" + this.m_resampler + "\"";
                            stringArray = stringArray2;
                            stringArray2[1] = string13;
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = "\"" + this.m_resampler + "\"";
                            stringArray = stringArray3;
                            stringArray3[1] = string13;
                        }
                        String[] stringArray4 = stringArray;
                        object6 = new ProcessBuilder(stringArray4);
                        object5 = ((ProcessBuilder)object6).start();
                        ((Process)object5).waitFor();
                    }
                    if (this.m_abort_required) break;
                    object6 = this.m_resampler_queue.get(i);
                    object5 = i + 1 < n4 ? this.m_resampler_queue.get((int)(i + 1)).Oto : new OtoArgs();
                    double d15 = ((RenderQueue)object6).secEnd - (double)((OtoArgs)object5).msOverlap / 1000.0;
                    float f = ((RenderQueue)object6).Oto.msPreUtterance + ((OtoArgs)object5).msOverlap - ((OtoArgs)object5).msPreUtterance;
                    object4 = ((RenderQueue)object6).WavtoolArgPrefix + (f >= 0.0f ? "+" + f : "-" + -f) + ((RenderQueue)object6).WavtoolArgSuffix;
                    UtauRenderingRunner.ProcessWavtool((String)object4, string4, this.m_temp_dir, this.m_wavtool, this.m_invoke_with_wine);
                    int n21 = (int)(d15 * (double)this.sampleRate);
                    if (bl) {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = new RandomAccessFile(string2, "r");
                            randomAccessFile.seek(0L);
                            byte[] byArray = new byte[4];
                            int n22 = randomAccessFile.read(byArray, 0, 4);
                            if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) continue;
                            randomAccessFile.read(byArray, 0, 4);
                            randomAccessFile.read(byArray, 0, 4);
                            if (byArray[0] != 87 || byArray[1] != 65 || byArray[2] != 86 || byArray[3] != 69) continue;
                            randomAccessFile.read(byArray, 0, 4);
                            if (byArray[0] != 102 || byArray[1] != 109 || byArray[2] != 116 || byArray[3] != 32) continue;
                            randomAccessFile.read(byArray, 0, 4);
                            long l = randomAccessFile.getFilePointer();
                            l += (long)(byArray[0] | byArray[1] << 8 | byArray[2] << 16 | byArray[3] << 24);
                            randomAccessFile.read(byArray, 0, 2);
                            n3 = byArray[0] | byArray[1] << 8;
                            if (n3 != 1) continue;
                            randomAccessFile.read(byArray, 0, 2);
                            n16 = byArray[1] << 8 | byArray[0];
                            randomAccessFile.read(byArray, 0, 4);
                            int n23 = byArray[0] | byArray[1] << 8 | byArray[2] << 16 | byArray[3] << 24;
                            randomAccessFile.read(byArray, 0, 4);
                            randomAccessFile.read(byArray, 0, 2);
                            randomAccessFile.read(byArray, 0, 2);
                            n2 = byArray[1] << 8 | byArray[0];
                            n17 = n2 / 8;
                            randomAccessFile.seek(l);
                            randomAccessFile.read(byArray, 0, 4);
                            if (byArray[0] != 100 || byArray[1] != 97 || byArray[2] != 116 || byArray[3] != 97) continue;
                            randomAccessFile.read(byArray, 0, 4);
                            int n24 = byArray[3] << 24 | byArray[2] << 16 | byArray[1] << 8 | byArray[0];
                            int n25 = n24 / (n16 * n17);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("UtauRenderingRunner#run; ex=" + exception);
                        }
                        finally {
                            if (randomAccessFile != null) {
                                try {
                                    randomAccessFile.close();
                                }
                                catch (Exception exception) {
                                    PortUtil.stderr.println("UtauRenderingRunner#run; ex2=" + exception);
                                }
                            }
                        }
                        bl = false;
                    }
                    n20 = n21 - n15;
                    if (n16 <= 0 || n17 <= 0 || n20 <= 0) continue;
                    int n26 = n20 > this.sampleRate ? this.sampleRate : n20;
                    n19 = n20;
                    this.m_left = new double[n26];
                    this.m_right = new double[n26];
                    float f6 = 0.015625f;
                    float f7 = 3.0517578E-5f;
                    n3 = 1024;
                    byte[] byArray = new byte[n3];
                    n2 = 0;
                    RandomAccessFile randomAccessFile = null;
                    try {
                        float f8;
                        float f9;
                        float f10;
                        int n27;
                        int n28;
                        double d16;
                        int n29;
                        randomAccessFile = new RandomAccessFile(string, "r");
                        randomAccessFile.seek(n15 * n16 * n17);
                        double d17 = (double)n15 / (double)this.sampleRate;
                        double d18 = 1.0 / (double)this.sampleRate;
                        object2 = new ByRef<Integer>(0);
                        if (n17 == 1) {
                            if (n16 == 1) {
                                while (n19 > 0) {
                                    if (this.m_abort_required) {
                                        break block110;
                                    }
                                    int n30 = randomAccessFile.read(byArray, 0, n3);
                                    if (n30 <= 0) {
                                        break block110;
                                    }
                                    n29 = 0;
                                    while (n30 > 0 && n19 > 0 && !this.m_abort_required) {
                                        --n30;
                                        --n19;
                                        d16 = d17 + (double)n2 * d18;
                                        n28 = (int)this.m_vsq.getClockFromSec(d16);
                                        n27 = vsqBPList.getValue(n28, (ByRef<Integer>)object2);
                                        f10 = (float)n27 * f6;
                                        f9 = ((float)byArray[n29] - 64.0f) * f6 * f10;
                                        ++n29;
                                        this.m_left[n2] = f9;
                                        this.m_right[n2] = f9;
                                        if (++n2 < n26) continue;
                                        this.waveIncoming(this.m_left, this.m_right);
                                        n2 = 0;
                                    }
                                }
                                break block110;
                            }
                            while (n19 > 0) {
                                if (this.m_abort_required) {
                                    break block110;
                                }
                                int n31 = randomAccessFile.read(byArray, 0, n3);
                                if (n31 <= 0) {
                                    break block110;
                                }
                                n29 = 0;
                                while (n31 > 0 && n19 > 0 && !this.m_abort_required) {
                                    n31 -= 2;
                                    --n19;
                                    d16 = d17 + (double)n2 * d18;
                                    n28 = (int)this.m_vsq.getClockFromSec(d16);
                                    n27 = vsqBPList.getValue(n28, (ByRef<Integer>)object2);
                                    f10 = (float)n27 * f6;
                                    f9 = ((float)byArray[n29] - 64.0f) * f6 * f10;
                                    f8 = ((float)byArray[n29 + 1] - 64.0f) * f6 * f10;
                                    this.m_left[n2] = f9;
                                    this.m_right[n2] = f8;
                                    n29 += 2;
                                    if (++n2 < n26) continue;
                                    this.waveIncoming(this.m_left, this.m_right);
                                    n2 = 0;
                                }
                            }
                            break block110;
                        }
                        if (n17 != 2) break block110;
                        if (n16 == 1) {
                            while (n19 > 0) {
                                if (this.m_abort_required) {
                                    break block110;
                                }
                                int n32 = randomAccessFile.read(byArray, 0, n3);
                                if (n32 <= 0) {
                                    break block110;
                                }
                                n29 = 0;
                                while (n32 > 0 && n19 > 0 && !this.m_abort_required) {
                                    n32 -= 2;
                                    --n19;
                                    d16 = d17 + (double)n2 * d18;
                                    n28 = (int)this.m_vsq.getClockFromSec(d16);
                                    n27 = vsqBPList.getValue(n28, (ByRef<Integer>)object2);
                                    f10 = (float)n27 * f6;
                                    f9 = (float)((short)(byArray[n29] | byArray[n29 + 1] << 8)) * f7 * f10;
                                    this.m_left[n2] = f9;
                                    this.m_right[n2] = f9;
                                    n29 += 2;
                                    if (++n2 < n26) continue;
                                    this.waveIncoming(this.m_left, this.m_right);
                                    n2 = 0;
                                }
                            }
                            break block110;
                        }
                        while (n19 > 0) {
                            if (this.m_abort_required) {
                                break;
                            }
                            int n33 = randomAccessFile.read(byArray, 0, n3);
                            if (n33 <= 0) {
                                break;
                            }
                            n29 = 0;
                            while (n33 > 0 && n19 > 0 && !this.m_abort_required) {
                                n33 -= 4;
                                --n19;
                                d16 = d17 + (double)n2 * d18;
                                n28 = (int)this.m_vsq.getClockFromSec(d16);
                                n27 = vsqBPList.getValue(n28, (ByRef<Integer>)object2);
                                f10 = (float)n27 * f6;
                                f9 = (float)((short)(byArray[n29] | byArray[n29 + 1] << 8)) * f7 * f10;
                                f8 = (float)((short)(byArray[n29 + 2] | byArray[n29 + 3] << 8)) * f7 * f10;
                                this.m_left[n2] = f9;
                                this.m_right[n2] = f8;
                                n29 += 4;
                                if (++n2 < n26) continue;
                                this.waveIncoming(this.m_left, this.m_right);
                                n2 = 0;
                            }
                        }
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("UtauRenderingRunner#run; ex=" + exception);
                    }
                    finally {
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            }
                            catch (Exception exception) {
                                PortUtil.stderr.println("UtauRenderingRunner#run; ex2=" + exception);
                            }
                            randomAccessFile = null;
                        }
                    }
                }
                if (this.m_abort_required) {
                    this.m_rendering = false;
                    this.m_abort_required = false;
                    return;
                }
                if (n2 > 0) {
                    double[] dArray = new double[n2];
                    object3 = new double[n2];
                    for (int j = 0; j < n2; ++j) {
                        dArray[j] = this.m_left[j];
                        object3[j] = this.m_right[j];
                    }
                    this.waveIncoming(dArray, (double[])object3);
                    dArray = null;
                    object3 = null;
                }
                this.m_left = null;
                this.m_right = null;
                System.gc();
                this.m_progress = (double)(n15 += n20 - n19) / d * 100.0;
                double d19 = this.getElapsedSeconds();
                this.m_running_rate = this.m_progress / d19;
            }
            double[] dArray = new double[this.sampleRate];
            object = new double[this.sampleRate];
            for (int i = (int)(this.totalSamples - this.m_total_append); i > 0; i -= n) {
                n = i > this.sampleRate ? this.sampleRate : i;
                object6 = null;
                object5 = null;
                if (n != this.sampleRate) {
                    object6 = new double[n];
                    object5 = new double[n];
                } else {
                    object6 = dArray;
                    object5 = object;
                }
                this.waveIncoming((double[])object6, (double[])object5);
            }
            if (this.m_mode_infinite) {
                while (!this.m_abort_required) {
                    this.waveIncoming(dArray, (double[])object);
                }
                dArray = null;
                object = null;
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("UtauRenderingRunner#run; ex=" + exception);
        }
        finally {
            this.m_rendering = false;
        }
        if (this.directPlay) {
            PlaySound.waitForExit();
        }
    }

    @Override
    public double computeRemainingSeconds() {
        double d = 100.0 / this.m_running_rate;
        double d2 = this.getElapsedSeconds();
        double d3 = d - d2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    private static void ProcessWavtool(String string, String string2, String string3, String string4, boolean bl) {
        String[] stringArray = new String[]{(bl ? "wine \"" : "\"") + string4 + "\"", string};
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        try {
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String NoteStringFromNoteNumber(int n) {
        int n2 = n % 12;
        String string = (new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"})[n2];
        return string + (n / 12 - 1);
    }
}

