/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.EmptyRenderingRunner;
import org.kbinani.cadencii.PlaySound;
import org.kbinani.cadencii.RendererKind;
import org.kbinani.cadencii.RenderingRunner;
import org.kbinani.cadencii.StraightRenderingRunner;
import org.kbinani.cadencii.UtauRenderingRunner;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;
import org.kbinani.vsq.LyricHandle;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqTrack;

public class VSTiProxy {
    public static final String RENDERER_DSB2 = "DSB2";
    public static final String RENDERER_DSB3 = "DSB3";
    public static final String RENDERER_UTU0 = "UTU0";
    public static final String RENDERER_STR0 = "STR0";
    public static final String RENDERER_AQT0 = "AQT0";
    public static final String RENDERER_NULL = "NUL0";
    public static int SAMPLE_RATE = 44100;
    static final float a0 = -17317.562f;
    static final float a1 = 86.73121f;
    static final float a2 = -0.2373235f;
    public static String CurrentUser = "";
    private static RendererKind s_working_renderer = RendererKind.NULL;
    public static Thread directPlayThread = null;
    private static RenderingRunner s_rendering_context;

    public static void init() {
        VSTiProxy.initCor();
    }

    public static void initCor() {
    }

    public static boolean isRendererAvailable(RendererKind rendererKind) {
        if (rendererKind == RendererKind.UTAU && !AppManager.editorConfig.PathResampler.equals("") && PortUtil.isFileExists(AppManager.editorConfig.PathResampler) && !AppManager.editorConfig.PathWavtool.equals("") && PortUtil.isFileExists(AppManager.editorConfig.PathWavtool) && AppManager.editorConfig.UtauSingers.size() > 0) {
            return true;
        }
        if (rendererKind == RendererKind.STRAIGHT_UTAU && PortUtil.isFileExists(PortUtil.combinePath(PortUtil.getApplicationStartupPath(), StraightRenderingRunner.STRAIGHT_SYNTH))) {
            int n = AppManager.editorConfig.UtauSingers.size();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = PortUtil.combinePath(AppManager.editorConfig.UtauSingers.get((int)i).VOICEIDSTR, "analyzed");
                if (!PortUtil.isDirectoryExists(string2) || !PortUtil.isFileExists(string = PortUtil.combinePath(string2, "oto.ini"))) continue;
                return true;
            }
        }
        return false;
    }

    public static void terminate() {
    }

    public static void render(VsqFileEx vsqFileEx, int n, WaveWriter waveWriter, double d, double d2, int n2, boolean bl, WaveReader[] waveReaderArray, double d3, boolean bl2, String string, boolean bl3) {
        if (s_rendering_context != null) {
            try {
                s_rendering_context.abortRendering();
            }
            catch (Exception exception) {
                PortUtil.stderr.println("VSTiProxy#render; ex=" + exception);
            }
            while (s_rendering_context.isRendering()) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
        s_working_renderer = VsqFileEx.getTrackRendererKind((VsqTrack)vsqFileEx.Track.get(n));
        Vector<WaveReader> vector = new Vector<WaveReader>();
        for (int i = 0; i < waveReaderArray.length; ++i) {
            vector.add(waveReaderArray[i]);
        }
        VsqFileEx vsqFileEx2 = (VsqFileEx)vsqFileEx.clone();
        vsqFileEx2.updateTotalClocks();
        int n3 = (int)vsqFileEx.getClockFromSec(d);
        int n4 = (int)vsqFileEx.getClockFromSec(d2);
        if (n4 < vsqFileEx.TotalClocks) {
            vsqFileEx2.removePart(n4, vsqFileEx2.TotalClocks + 480);
        }
        int n5 = (int)vsqFileEx.getClockFromSec((float)d2 + 10.0f);
        int n6 = (int)vsqFileEx.getClockFromSec((float)d2 + 10.0f + 3.1f);
        VsqEvent vsqEvent = new VsqEvent(n5, new VsqID(0));
        vsqEvent.ID.type = VsqIDType.Anote;
        vsqEvent.ID.Note = 60;
        vsqEvent.ID.setLength(n6 - n5);
        vsqEvent.ID.VibratoHandle = null;
        vsqEvent.ID.LyricHandle = new LyricHandle("a", "a");
        ((VsqTrack)vsqFileEx2.Track.get(n)).addEvent(vsqEvent);
        double d4 = 0.0;
        if (n3 < vsqFileEx2.getPreMeasureClocks()) {
            d4 = vsqFileEx2.getSecFromClock(n3);
        } else {
            vsqFileEx2.removePart(vsqFileEx.getPreMeasureClocks(), n3);
            d4 = vsqFileEx2.getSecFromClock(vsqFileEx2.getPreMeasureClocks());
        }
        vsqFileEx2.updateTotalClocks();
        long l = (long)((d2 - d) * (double)SAMPLE_RATE);
        int n7 = (int)(d4 * 1000.0);
        s_rendering_context = null;
        if (s_working_renderer == RendererKind.UTAU) {
            s_rendering_context = new UtauRenderingRunner(vsqFileEx2, n, AppManager.editorConfig.UtauSingers, AppManager.editorConfig.PathResampler, AppManager.editorConfig.PathWavtool, AppManager.editorConfig.InvokeUtauCoreWithWine, SAMPLE_RATE, n7, l, bl2, waveWriter, d3, vector, bl, bl3);
        } else if (s_working_renderer == RendererKind.STRAIGHT_UTAU) {
            s_rendering_context = new StraightRenderingRunner(vsqFileEx2, n, AppManager.editorConfig.UtauSingers, SAMPLE_RATE, n7, l, bl2, waveWriter, d3, vector, bl, bl3);
        } else if (s_working_renderer == RendererKind.NULL) {
            s_rendering_context = new EmptyRenderingRunner(n, bl3, waveWriter, d3, vector, bl, n7, l, SAMPLE_RATE, bl2);
        } else {
            return;
        }
        if (bl) {
            directPlayThread = new Thread(s_rendering_context);
            directPlayThread.start();
        } else {
            s_rendering_context.run();
            s_rendering_context = null;
        }
    }

    public static double computeRemainintSeconds() {
        if (s_rendering_context != null) {
            return s_rendering_context.computeRemainingSeconds();
        }
        return 0.0;
    }

    public static double getElapsedSeconds() {
        if (s_rendering_context != null) {
            return s_rendering_context.getElapsedSeconds();
        }
        return 0.0;
    }

    public static double getProgress() {
        if (s_rendering_context == null) {
            return 0.0;
        }
        return s_rendering_context.getProgress();
    }

    public static void abortRendering() {
        if (s_rendering_context != null) {
            s_rendering_context.abortRendering();
            s_rendering_context = null;
        }
    }

    public static int getErrorSamples(float f) {
        if (f <= 240.0f) {
            return 4666;
        }
        float f2 = f - 240.0f;
        return (int)((-0.2373235f * f2 + 86.73121f) * f2 + -17317.562f);
    }

    public static float getPlayTime() {
        double d = PlaySound.getPosition();
        return (float)d;
    }

    private class RenderWithDirectPlayProc
    extends Thread {
        private RenderWithDirectPlayProc() {
        }

        public void run() {
            RenderingRunner renderingRunner = s_rendering_context;
            if (renderingRunner instanceof UtauRenderingRunner) {
                UtauRenderingRunner utauRenderingRunner = (UtauRenderingRunner)renderingRunner;
                utauRenderingRunner.run();
            } else if (renderingRunner instanceof StraightRenderingRunner) {
                StraightRenderingRunner straightRenderingRunner = (StraightRenderingRunner)renderingRunner;
                straightRenderingRunner.run();
            } else if (renderingRunner instanceof EmptyRenderingRunner) {
                EmptyRenderingRunner emptyRenderingRunner = (EmptyRenderingRunner)renderingRunner;
                emptyRenderingRunner.run();
            }
        }
    }
}

