/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.util.Iterator;
import org.kbinani.cadencii.PointD;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.VibratoBPList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VibratoPointIterator
implements Iterator<PointD> {
    VsqFileEx vsq;
    VibratoBPList rate;
    int start_rate;
    VibratoBPList depth;
    int start_depth;
    int clock_start;
    int clock_width;
    float sec_resolution;
    double sec0;
    double sec1;
    int count = 0;
    double phase = 0.0;
    double amplitude;
    float period;
    float omega;
    double sec;
    float fadewidth;
    int i;
    boolean first = true;

    @Override
    public PointD next() {
        if (this.first) {
            this.i = 0;
            this.first = false;
            return new PointD(this.sec0, 0.0);
        }
        ++this.i;
        if (this.i < this.count) {
            double d = this.sec0 + (double)(this.sec_resolution * (float)this.i);
            double d2 = this.vsq.getClockFromSec(d);
            if (this.sec0 <= d && d <= this.sec0 + (double)this.fadewidth) {
                this.amplitude *= (double)((float)(d - this.sec0) / this.fadewidth);
            }
            if (this.sec1 - (double)this.fadewidth <= d && d <= this.sec1) {
                this.amplitude *= (double)((float)(this.sec1 - d) / this.fadewidth);
            }
            this.phase += (double)this.omega * (d - this.sec);
            PointD pointD = new PointD(d, this.amplitude * Math.sin(this.phase));
            float f = (float)(d2 - (double)this.clock_start) / (float)this.clock_width;
            int n = this.rate.getValue(f, this.start_rate);
            int n2 = this.depth.getValue(f, this.start_depth);
            this.amplitude = (float)n2 * 2.5f / 127.0f / 2.0f;
            this.period = (float)Math.exp(5.24 - 0.0107 * (double)n) * 2.0f / 1000.0f;
            this.omega = (float)(Math.PI * 2 / (double)this.period);
            this.sec = d;
            return pointD;
        }
        return new PointD();
    }

    @Override
    public boolean hasNext() {
        if (this.first) {
            return true;
        }
        return this.i + 1 < this.count;
    }

    @Override
    public void remove() {
    }

    public VibratoPointIterator(VsqFileEx vsqFileEx, VibratoBPList vibratoBPList, int n, VibratoBPList vibratoBPList2, int n2, int n3, int n4, float f) {
        this.vsq = vsqFileEx;
        this.rate = vibratoBPList;
        this.start_rate = n;
        this.depth = vibratoBPList2;
        this.start_depth = n2;
        this.clock_start = n3;
        this.clock_width = n4;
        this.sec_resolution = f;
        this.sec0 = vsqFileEx.getSecFromClock(n3);
        this.sec1 = vsqFileEx.getSecFromClock(n3 + n4);
        this.count = (int)((this.sec1 - this.sec0) / (double)f);
        this.phase = 0.0;
        n = vibratoBPList.getValue(0.0f, n);
        n2 = vibratoBPList2.getValue(0.0f, n2);
        this.amplitude = (float)n2 * 2.5f / 127.0f / 2.0f;
        this.period = (float)Math.exp(5.24 - 0.0107 * (double)n) * 2.0f / 1000.0f;
        this.omega = (float)(Math.PI * 2 / (double)this.period);
        this.sec = this.sec0;
        this.fadewidth = (float)(this.sec1 - this.sec0) * 0.2f;
    }
}

