/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani;

public class math {
    private static final double _PI2 = Math.PI * 2;
    private static final double _PI4 = Math.PI * 4;
    private static final double _PI6 = Math.PI * 6;
    private static final double _PI8 = Math.PI * 8;

    public static long gcd(long l, long l2) {
        long l3;
        if (l2 > l) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        while (l2 != 0L) {
            l3 = l / l2;
            long l4 = l - l2 * l3;
            if (l4 == 0L) {
                return l2;
            }
            l = l2;
            l2 = l4;
        }
        return l;
    }

    public static double window_func(WindowFunctionType windowFunctionType, double d) throws Exception {
        if (windowFunctionType == WindowFunctionType.Akaike) {
            return math.wnd_akaike(d);
        }
        if (windowFunctionType == WindowFunctionType.Bartlett) {
            return math.wnd_bartlett(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman) {
            return math.wnd_blackman(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman_Harris) {
            return math.wnd_blackman_harris(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman_Nattall) {
            return math.wnd_blackman_nattall(d);
        }
        if (windowFunctionType == WindowFunctionType.flap_top) {
            return math.wnd_flap_top(d);
        }
        if (windowFunctionType == WindowFunctionType.Gauss) {
            throw new Exception("too few argument for Gauss window function");
        }
        if (windowFunctionType == WindowFunctionType.Hamming) {
            return math.wnd_hamming(d);
        }
        if (windowFunctionType == WindowFunctionType.Hann) {
            return math.wnd_hann(d);
        }
        if (windowFunctionType == WindowFunctionType.Kaiser) {
            throw new Exception("too few argument for Kaiser window function");
        }
        if (windowFunctionType == WindowFunctionType.Nuttall) {
            return math.wnd_nuttall(d);
        }
        if (windowFunctionType == WindowFunctionType.Parzen) {
            return math.wnd_parzen(d);
        }
        if (windowFunctionType == WindowFunctionType.rectangular) {
            return math.wnd_rectangular(d);
        }
        if (windowFunctionType == WindowFunctionType.Welch) {
            return math.wnd_welch(d);
        }
        return 0.0;
    }

    public static double window_func(WindowFunctionType windowFunctionType, double d, double ... dArray) {
        if (windowFunctionType == WindowFunctionType.Akaike) {
            return math.wnd_akaike(d);
        }
        if (windowFunctionType == WindowFunctionType.Bartlett) {
            return math.wnd_bartlett(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman) {
            return math.wnd_blackman(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman_Harris) {
            return math.wnd_blackman_harris(d);
        }
        if (windowFunctionType == WindowFunctionType.Blackman_Nattall) {
            return math.wnd_blackman_nattall(d);
        }
        if (windowFunctionType == WindowFunctionType.flap_top) {
            return math.wnd_flap_top(d);
        }
        if (windowFunctionType == WindowFunctionType.Gauss) {
            return math.wnd_gauss(d, dArray[0]);
        }
        if (windowFunctionType == WindowFunctionType.Hamming) {
            return math.wnd_hamming(d);
        }
        if (windowFunctionType == WindowFunctionType.Hann) {
            return math.wnd_hann(d);
        }
        if (windowFunctionType == WindowFunctionType.Kaiser) {
            return math.wnd_kaiser(d, dArray[0]);
        }
        if (windowFunctionType == WindowFunctionType.Nuttall) {
            return math.wnd_nuttall(d);
        }
        if (windowFunctionType == WindowFunctionType.Parzen) {
            return math.wnd_parzen(d);
        }
        if (windowFunctionType == WindowFunctionType.rectangular) {
            return math.wnd_rectangular(d);
        }
        if (windowFunctionType == WindowFunctionType.Welch) {
            return math.wnd_welch(d);
        }
        return 0.0;
    }

    public static double wnd_kaiser(double d, double d2) {
        if (0.0 <= d && d <= 1.0) {
            double d3 = 2.0 * d - 1.0;
            return math.besi0(Math.PI * d2 * Math.sqrt(1.0 - d3 * d3)) / math.besi0(Math.PI * d2);
        }
        return 0.0;
    }

    public static double wnd_welch(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 4.0 * d * (1.0 - d);
        }
        return 0.0;
    }

    public static double wnd_akaike(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.625 - 0.5 * Math.cos(Math.PI * 2 * d) - 0.125 * Math.cos(Math.PI * 4 * d);
        }
        return 0.0;
    }

    public static double wnd_parzen(double d) {
        double d2 = Math.abs(d);
        if (d2 <= 1.0) {
            return (0.75 * d2 - 1.5) * d2 * d2 + 1.0;
        }
        d2 = 2.0 - d2;
        return 0.25 * d2 * d2 * d2;
    }

    public static double wnd_flap_top(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 1.0 - 1.93 * Math.cos(Math.PI * 2 * d) + 1.29 * Math.cos(Math.PI * 4 * d) - 0.388 * Math.cos(Math.PI * 6 * d) + 0.032 * Math.cos(Math.PI * 8 * d);
        }
        return 0.0;
    }

    public static double wnd_blackman_nattall(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.3635819 - 0.4891775 * Math.cos(Math.PI * 2 * d) + 0.1365995 * Math.cos(Math.PI * 4 * d) - 0.0106411 * Math.cos(Math.PI * 6 * d);
        }
        return 0.0;
    }

    public static double wnd_blackman_harris(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.35875 - 0.48829 * Math.cos(Math.PI * 2 * d) + 0.14128 * Math.cos(Math.PI * 4 * d) - 0.01168 * Math.cos(Math.PI * 6 * d);
        }
        return 0.0;
    }

    public static double wnd_nuttall(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.355768 - 0.487396 * Math.cos(Math.PI * 2 * d) + 0.144232 * Math.cos(Math.PI * 4 * d) - 0.012604 * Math.cos(Math.PI * 6 * d);
        }
        return 0.0;
    }

    public static double wnd_bartlett(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 1.0 - 2.0 * Math.abs(d - 0.5);
        }
        return 0.0;
    }

    public static double wnd_blackman(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.42 - 0.5 * Math.cos(Math.PI * 2 * d) + 0.08 * Math.cos(Math.PI * 4 * d);
        }
        return 0.0;
    }

    public static double wnd_hann(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.5 - 0.5 * Math.cos(Math.PI * 2 * d);
        }
        return 0.0;
    }

    public static double wnd_gauss(double d, double d2) {
        return Math.exp(-d * d / (d2 * d2));
    }

    public static double wnd_rectangular(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double wnd_hamming(double d) {
        if (0.0 <= d && d <= 1.0) {
            return 0.54 - 0.46 * Math.cos(Math.PI * 2 * d);
        }
        return 0.0;
    }

    public static double besi0(double d) {
        double[] dArray = new double[]{1.0, 3.5156229, 3.0899424, 1.2067492, 0.2659732, 0.0360768};
        double[] dArray2 = new double[]{0.39894228, 0.013285917, 0.002253187, -0.001575649, 0.009162808, -0.020577063, 0.026355372, -0.016476329};
        if (d < 0.0) {
            return 0.0;
        }
        if (d <= 3.75) {
            double d2 = d * d / 14.0625;
            double d3 = 0.0045813;
            for (int i = 5; i >= 0; --i) {
                d3 = d3 * d2 + dArray[i];
            }
            return d3;
        }
        double d4 = 3.75 / d;
        double d5 = 0.003923767;
        for (int i = 7; i >= 0; --i) {
            d5 = d5 * d4 + dArray2[i];
        }
        return d5 / Math.sqrt(d) * Math.exp(d);
    }

    public static double erf(double d) {
        return 1.0 - math.erfc(d);
    }

    public static double erfc(double d) {
        double d2 = Math.abs(d);
        double d3 = 1.0 / (1.0 + 0.5 * d2);
        double d4 = d3 * Math.exp(-d2 * d2 - 1.26551223 + d3 * (1.00002368 + d3 * (0.37409196 + d3 * (0.09678418 + d3 * (-0.18628806 + d3 * (0.27886807 + d3 * (-1.13520398 + d3 * (1.48851587 + d3 * (-0.82215223 + d3 * 0.17087277)))))))));
        if (d < 0.0) {
            d4 = 2.0 - d4;
        }
        return d4;
    }

    public static double erfcinv(double d) {
        double d2 = d;
        if (d > 1.0) {
            d2 = 2.0 - d;
        }
        double d3 = 0.916461398268964 - Math.log(d2);
        double d4 = Math.sqrt(d3);
        double d5 = (Math.log(d4) + 0.488826640273108) / d3;
        double d6 = 1.0 / (d4 + 0.231729200323405);
        double d7 = d4 * (1.0 - d5 * (d5 * 0.124610454613712 + 0.5)) - ((((-0.0728846765585675 * d6 + 0.269999308670029) * d6 + 0.150689047360223) * d6 + 0.116065025341614) * d6 + 0.499999303439796) * d6;
        d6 = 3.97886080735226 / (d7 + 3.97886080735226);
        d4 = d6 - 0.5;
        d5 = (((((((((0.0011264809618897792 * d4 + 1.0573929962342305E-4) * d4 - 0.003512871461291) * d4 - 7.71708358954121E-4) * d4 + 0.006856494260745586) * d4 + 0.0033972191036777586) * d4 - 0.011274916933250487) * d4 - 0.01185981170477711) * d4 + 0.014296198869789802) * d4 + 0.03464942077890999) * d4 + 0.002209959270121791;
        d5 = ((((((((((((d5 * d4 - 0.07434243572417848) * d4 - 0.1058721779415955) * d4 + 0.014729793833148512) * d4 + 0.3168476385201359) * d4 + 0.7136576358687303) * d4 + 1.0537502497084714) * d4 + 1.2144873077999523) * d4 + 1.1637458193156083) * d4 + 0.956464974744799) * d4 + 0.6862659482740978) * d4 + 0.4343974923314301) * d4 + 0.24404451059319093) * d6 - d2 * Math.exp(d7 * d7 - 0.12078223763524522);
        d7 += d5 * (d7 * d5 + 1.0);
        if (d > 1.0) {
            d7 = -d7;
        }
        return d7;
    }

    public static double erfinv(double d) {
        return -math.erfcinv(d + 1.0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowFunctionType {
        Hamming,
        rectangular,
        Gauss,
        Hann,
        Blackman,
        Bartlett,
        Nuttall,
        Blackman_Harris,
        Blackman_Nattall,
        flap_top,
        Parzen,
        Akaike,
        Welch,
        Kaiser;

    }
}

