/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.util.Arrays;
import org.kbinani.media.IWaveReceiver;

public class WaveRateConvertAdapter {
    private IWaveReceiver receiver = null;
    private long bCount = 0L;
    private long aCount = 0L;
    private int bRate = 44100;
    private int aRate = 44100;
    private double invBRate = 2.2675736961451248E-5;
    private double invARate = 2.2675736961451248E-5;
    private double[] bBufLeft;
    private double[] bBufRight;
    private long bBufBase;

    public WaveRateConvertAdapter(IWaveReceiver iWaveReceiver, int n) {
        this.receiver = iWaveReceiver;
        this.bRate = n;
        this.aRate = iWaveReceiver.getSampleRate();
        this.invBRate = 1.0 / (double)this.bRate;
        this.invARate = 1.0 / (double)this.aRate;
    }

    public void append(double[] dArray, double[] dArray2) {
        long l;
        if (this.aRate == this.bRate) {
            this.receiver.append(dArray, dArray2);
            this.aCount += (long)dArray.length;
            this.bCount += (long)dArray.length;
            return;
        }
        double d = (double)this.bCount * this.invBRate;
        double d2 = (double)(this.bCount + (long)dArray.length) * this.invBRate;
        long l2 = (long)(d * (double)this.aRate);
        long l3 = (long)(d2 * (double)this.aRate) - 1L;
        double d3 = (double)(l3 - 1L) * this.invARate;
        long l4 = (long)(d3 * (double)this.bRate);
        int n = (int)(l4 - this.bCount) + 1;
        if (n >= dArray.length) {
            --l3;
        }
        double[] dArray3 = new double[(int)(l3 - this.aCount)];
        double[] dArray4 = new double[(int)(l3 - this.aCount)];
        for (l = this.aCount; l < l3; ++l) {
            int n2;
            double d4;
            double d5 = (double)l * this.invARate;
            long l5 = (long)(d5 * (double)this.bRate);
            double d6 = (double)l5 * this.invBRate;
            double d7 = (double)(l5 + 1L) * this.invBRate;
            int n3 = (int)(l5 - this.bCount);
            int n4 = n3 + 1;
            double d8 = 0.0;
            if (0 <= n3) {
                if (n3 < dArray.length) {
                    d8 = dArray[n3];
                }
            } else {
                int n5 = (int)(l5 - this.bBufBase);
                if (0 <= n5 && n5 < this.bBufLeft.length) {
                    d8 = this.bBufLeft[n5];
                }
            }
            double d9 = 0.0;
            if (n4 >= 0) {
                if (n4 < dArray.length) {
                    d9 = dArray[n4];
                }
            } else {
                int n6 = (int)(l5 + 1L - this.bBufBase);
                if (0 <= n6 && n6 < this.bBufLeft.length) {
                    d9 = this.bBufLeft[n6];
                }
            }
            double d10 = (d9 - d8) / (d7 - d6);
            dArray3[(int)(l - this.aCount)] = d4 = d8 + d10 * (d5 - d6);
            if (n3 >= 0) {
                if (n3 < dArray2.length) {
                    d8 = dArray2[n3];
                }
            } else {
                n2 = (int)(l5 - this.bBufBase);
                if (0 <= n2 && n2 < this.bBufRight.length) {
                    d8 = this.bBufRight[n2];
                }
            }
            if (n4 >= 0) {
                if (n4 < dArray2.length) {
                    d9 = dArray2[n4];
                }
            } else {
                n2 = (int)(l5 + 1L - this.bBufBase);
                if (0 <= n2 && n2 < this.bBufRight.length) {
                    d9 = this.bBufRight[n2];
                }
            }
            d10 = (d9 - d8) / (d7 - d6);
            dArray4[(int)(l - this.aCount)] = d4 = d8 + d10 * (d5 - d6);
        }
        this.receiver.append(dArray3, dArray4);
        l = (long)((double)(this.bCount + (long)dArray.length + 1L) * this.invBRate * (double)this.aRate) + 1L;
        if (l3 + 1L < l) {
            this.bBufBase = (long)((double)(l3 + 1L) * this.invARate * (double)this.bRate) - 2L;
            int n7 = (int)(this.bCount + (long)dArray.length - this.bBufBase);
            if (n7 > 0) {
                if (this.bBufLeft == null) {
                    this.bBufLeft = new double[n7];
                } else if (this.bBufLeft.length < n7) {
                    this.bBufLeft = Arrays.copyOf(this.bBufLeft, n7);
                }
                if (this.bBufRight == null) {
                    this.bBufRight = new double[n7];
                } else if (this.bBufRight.length < n7) {
                    this.bBufRight = Arrays.copyOf(this.bBufRight, n7);
                }
                for (int i = 0; i < n7; ++i) {
                    this.bBufLeft[i] = dArray[(int)(this.bBufBase + (long)i - this.bCount)];
                    this.bBufRight[i] = dArray2[(int)(this.bBufBase + (long)i - this.bCount)];
                }
            }
        }
        this.bCount += (long)dArray.length;
        this.aCount = l3;
    }
}

