/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.IconParameter;
import org.kbinani.vsq.NoteHeadHandle;
import org.kbinani.vsq.TransCodeUtil;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionConfigSys {
    private final int MAX_VIBRATO = 1024;
    private Vector<VibratoHandle> m_vibrato_configs;
    private Vector<NoteHeadHandle> m_attack_configs;
    private Vector<IconDynamicsHandle> m_dynamics_configs;

    public static ExpressionConfigSys getVocaloid1Default() {
        ExpressionConfigSys expressionConfigSys = new ExpressionConfigSys();
        expressionConfigSys.m_vibrato_configs = new Vector();
        expressionConfigSys.m_attack_configs = new Vector();
        expressionConfigSys.m_dynamics_configs = new Vector();
        VibratoHandle vibratoHandle = new VibratoHandle();
        vibratoHandle.Index = 1;
        vibratoHandle.IconID = "$04040001";
        vibratoHandle.IDS = "normal";
        vibratoHandle.Original = 0;
        vibratoHandle.setCaption("Normal Vibrato");
        vibratoHandle.setLength(480);
        vibratoHandle.setStartDepth(64);
        vibratoHandle.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle.setStartRate(64);
        vibratoHandle.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle);
        VibratoHandle vibratoHandle2 = new VibratoHandle();
        vibratoHandle2.Index = 2;
        vibratoHandle2.IconID = "$04040002";
        vibratoHandle2.IDS = "normal";
        vibratoHandle2.Original = 0;
        vibratoHandle2.setCaption("Subtle Vibrato");
        vibratoHandle2.setLength(480);
        vibratoHandle2.setStartDepth(32);
        vibratoHandle2.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle2.setStartRate(56);
        vibratoHandle2.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle2);
        VibratoHandle vibratoHandle3 = new VibratoHandle();
        vibratoHandle3.Index = 3;
        vibratoHandle3.IconID = "$04040003";
        vibratoHandle3.IDS = "slight";
        vibratoHandle3.Original = 0;
        vibratoHandle3.setCaption("Slight Vibrato");
        vibratoHandle3.setLength(480);
        vibratoHandle3.setStartDepth(32);
        vibratoHandle3.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle3.setStartRate(64);
        vibratoHandle3.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle3);
        VibratoHandle vibratoHandle4 = new VibratoHandle();
        vibratoHandle4.Index = 4;
        vibratoHandle4.IconID = "$04040004";
        vibratoHandle4.IDS = "deep";
        vibratoHandle4.Original = 0;
        vibratoHandle4.setCaption("Deep Vibrato");
        vibratoHandle4.setLength(480);
        vibratoHandle4.setStartDepth(64);
        vibratoHandle4.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle4.setStartRate(64);
        vibratoHandle4.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle4);
        VibratoHandle vibratoHandle5 = new VibratoHandle();
        vibratoHandle5.Index = 5;
        vibratoHandle5.IconID = "$04040005";
        vibratoHandle5.IDS = "extreme";
        vibratoHandle5.Original = 0;
        vibratoHandle5.setCaption("Very Deep Vibrato");
        vibratoHandle5.setLength(480);
        vibratoHandle5.setStartDepth(64);
        vibratoHandle5.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle5.setStartRate(120);
        vibratoHandle5.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle5);
        VibratoHandle vibratoHandle6 = new VibratoHandle();
        vibratoHandle6.Index = 6;
        vibratoHandle6.IconID = "$04040006";
        vibratoHandle6.IDS = "extreme";
        vibratoHandle6.Original = 0;
        vibratoHandle6.setCaption("Extreme Vibrato (like Japanese Enka)");
        vibratoHandle6.setLength(480);
        vibratoHandle6.setStartDepth(64);
        vibratoHandle6.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle6.setStartRate(64);
        vibratoHandle6.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle6);
        NoteHeadHandle noteHeadHandle = new NoteHeadHandle();
        noteHeadHandle.Index = 1;
        noteHeadHandle.IconID = "$01010001";
        noteHeadHandle.IDS = "tenuto";
        noteHeadHandle.Original = 0;
        noteHeadHandle.setCaption("Tenuto");
        noteHeadHandle.setLength(120);
        noteHeadHandle.setDuration(64);
        noteHeadHandle.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle);
        NoteHeadHandle noteHeadHandle2 = new NoteHeadHandle();
        noteHeadHandle2.Index = 2;
        noteHeadHandle2.IconID = "$01010002";
        noteHeadHandle2.IDS = "accent";
        noteHeadHandle2.Original = 0;
        noteHeadHandle2.setCaption("Accent");
        noteHeadHandle2.setLength(120);
        noteHeadHandle2.setDuration(64);
        noteHeadHandle2.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle2);
        NoteHeadHandle noteHeadHandle3 = new NoteHeadHandle();
        noteHeadHandle3.Index = 3;
        noteHeadHandle3.IconID = "$01010003";
        noteHeadHandle3.IDS = "accent_extreme";
        noteHeadHandle3.Original = 0;
        noteHeadHandle3.setCaption("Extreme Accent");
        noteHeadHandle3.setLength(120);
        noteHeadHandle3.setDuration(64);
        noteHeadHandle3.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle3);
        NoteHeadHandle noteHeadHandle4 = new NoteHeadHandle();
        noteHeadHandle4.Index = 4;
        noteHeadHandle4.IconID = "$01010004";
        noteHeadHandle4.IDS = "legato";
        noteHeadHandle4.Original = 0;
        noteHeadHandle4.setCaption("Legato");
        noteHeadHandle4.setLength(120);
        noteHeadHandle4.setDuration(64);
        noteHeadHandle4.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle4);
        NoteHeadHandle noteHeadHandle5 = new NoteHeadHandle();
        noteHeadHandle5.Index = 5;
        noteHeadHandle5.IconID = "$01010005";
        noteHeadHandle5.IDS = "bendup_fast";
        noteHeadHandle5.Original = 0;
        noteHeadHandle5.setCaption("Fast Bendu");
        noteHeadHandle5.setLength(120);
        noteHeadHandle5.setDuration(64);
        noteHeadHandle5.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle5);
        NoteHeadHandle noteHeadHandle6 = new NoteHeadHandle();
        noteHeadHandle6.Index = 6;
        noteHeadHandle6.IconID = "$01010006";
        noteHeadHandle6.IDS = "bendup_slow";
        noteHeadHandle6.Original = 0;
        noteHeadHandle6.setCaption("Slow Bendup");
        noteHeadHandle6.setLength(120);
        noteHeadHandle6.setDuration(64);
        noteHeadHandle6.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle6);
        NoteHeadHandle noteHeadHandle7 = new NoteHeadHandle();
        noteHeadHandle7.Index = 7;
        noteHeadHandle7.IconID = "$01010007";
        noteHeadHandle7.IDS = "trill_semi";
        noteHeadHandle7.Original = 0;
        noteHeadHandle7.setCaption("Trill Semitone");
        noteHeadHandle7.setLength(120);
        noteHeadHandle7.setDuration(64);
        noteHeadHandle7.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle7);
        NoteHeadHandle noteHeadHandle8 = new NoteHeadHandle();
        noteHeadHandle8.Index = 8;
        noteHeadHandle8.IconID = "$01010008";
        noteHeadHandle8.IDS = "trill_whole";
        noteHeadHandle8.Original = 0;
        noteHeadHandle8.setCaption("Trill Wholetone");
        noteHeadHandle8.setLength(120);
        noteHeadHandle8.setDuration(64);
        noteHeadHandle8.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle8);
        NoteHeadHandle noteHeadHandle9 = new NoteHeadHandle();
        noteHeadHandle9.Index = 9;
        noteHeadHandle9.IconID = "$01010009";
        noteHeadHandle9.IDS = "mordent_semi";
        noteHeadHandle9.Original = 0;
        noteHeadHandle9.setCaption("Mordent Semitone");
        noteHeadHandle9.setLength(120);
        noteHeadHandle9.setDuration(64);
        noteHeadHandle9.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle9);
        NoteHeadHandle noteHeadHandle10 = new NoteHeadHandle();
        noteHeadHandle10.Index = 10;
        noteHeadHandle10.IconID = "$0101000a";
        noteHeadHandle10.IDS = "mordent_whole";
        noteHeadHandle10.Original = 0;
        noteHeadHandle10.setCaption("Mordent Wholetone");
        noteHeadHandle10.setLength(120);
        noteHeadHandle10.setDuration(64);
        noteHeadHandle10.setDepth(64);
        expressionConfigSys.m_attack_configs.add(noteHeadHandle10);
        IconDynamicsHandle iconDynamicsHandle = new IconDynamicsHandle();
        iconDynamicsHandle.IDS = "Dynaff11";
        iconDynamicsHandle.IconID = "$05010000";
        iconDynamicsHandle.Original = 0;
        iconDynamicsHandle.setCaption("Fortississimo");
        iconDynamicsHandle.setStartDyn(120);
        iconDynamicsHandle.setEndDyn(120);
        iconDynamicsHandle.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle);
        IconDynamicsHandle iconDynamicsHandle2 = new IconDynamicsHandle();
        iconDynamicsHandle2.IDS = "Dynaff12";
        iconDynamicsHandle2.IconID = "$05010001";
        iconDynamicsHandle2.Original = 1;
        iconDynamicsHandle2.setCaption("Fortissimo");
        iconDynamicsHandle2.setStartDyn(104);
        iconDynamicsHandle2.setEndDyn(104);
        iconDynamicsHandle2.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle2);
        IconDynamicsHandle iconDynamicsHandle3 = new IconDynamicsHandle();
        iconDynamicsHandle3.IDS = "Dynaff13";
        iconDynamicsHandle3.IconID = "$05010002";
        iconDynamicsHandle3.Original = 2;
        iconDynamicsHandle3.setCaption("Forte");
        iconDynamicsHandle3.setStartDyn(88);
        iconDynamicsHandle3.setEndDyn(88);
        iconDynamicsHandle3.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle3);
        IconDynamicsHandle iconDynamicsHandle4 = new IconDynamicsHandle();
        iconDynamicsHandle4.IDS = "Dynaff21";
        iconDynamicsHandle4.IconID = "$05010003";
        iconDynamicsHandle4.Original = 3;
        iconDynamicsHandle4.setCaption("MesoForte");
        iconDynamicsHandle4.setStartDyn(72);
        iconDynamicsHandle4.setEndDyn(72);
        iconDynamicsHandle4.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle4);
        IconDynamicsHandle iconDynamicsHandle5 = new IconDynamicsHandle();
        iconDynamicsHandle5.IDS = "Dynaff22";
        iconDynamicsHandle5.IconID = "$05010004";
        iconDynamicsHandle5.Original = 4;
        iconDynamicsHandle5.setCaption("MesoPiano");
        iconDynamicsHandle5.setStartDyn(56);
        iconDynamicsHandle5.setEndDyn(56);
        iconDynamicsHandle5.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle5);
        IconDynamicsHandle iconDynamicsHandle6 = new IconDynamicsHandle();
        iconDynamicsHandle6.IDS = "Dynaff31";
        iconDynamicsHandle6.IconID = "$05010005";
        iconDynamicsHandle6.Original = 5;
        iconDynamicsHandle6.setCaption("Piano");
        iconDynamicsHandle6.setStartDyn(40);
        iconDynamicsHandle6.setEndDyn(40);
        iconDynamicsHandle6.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle6);
        IconDynamicsHandle iconDynamicsHandle7 = new IconDynamicsHandle();
        iconDynamicsHandle7.IDS = "Dynaff32";
        iconDynamicsHandle7.IconID = "$05010006";
        iconDynamicsHandle7.Original = 6;
        iconDynamicsHandle7.setCaption("Pianissimo");
        iconDynamicsHandle7.setStartDyn(24);
        iconDynamicsHandle7.setEndDyn(24);
        iconDynamicsHandle7.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle7);
        IconDynamicsHandle iconDynamicsHandle8 = new IconDynamicsHandle();
        iconDynamicsHandle8.IDS = "Dynaff33";
        iconDynamicsHandle8.IconID = "$05010007";
        iconDynamicsHandle8.Original = 7;
        iconDynamicsHandle8.setCaption("Pianississimo");
        iconDynamicsHandle8.setStartDyn(8);
        iconDynamicsHandle8.setEndDyn(8);
        iconDynamicsHandle8.setLength(0);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle8);
        IconDynamicsHandle iconDynamicsHandle9 = new IconDynamicsHandle();
        iconDynamicsHandle9.IDS = "cresc_1";
        iconDynamicsHandle9.IconID = "$05020000";
        iconDynamicsHandle9.Original = 0;
        iconDynamicsHandle9.setCaption("Zero Crescendo");
        iconDynamicsHandle9.setStartDyn(0);
        iconDynamicsHandle9.setEndDyn(38);
        iconDynamicsHandle9.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle9);
        IconDynamicsHandle iconDynamicsHandle10 = new IconDynamicsHandle();
        iconDynamicsHandle10.IDS = "cresc_2";
        iconDynamicsHandle10.IconID = "$05020001";
        iconDynamicsHandle10.Original = 1;
        iconDynamicsHandle10.setCaption("Zero Crescendo");
        iconDynamicsHandle10.setStartDyn(0);
        iconDynamicsHandle10.setEndDyn(64);
        iconDynamicsHandle10.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle10);
        IconDynamicsHandle iconDynamicsHandle11 = new IconDynamicsHandle();
        iconDynamicsHandle11.IDS = "cresc_3";
        iconDynamicsHandle11.IconID = "$05020002";
        iconDynamicsHandle11.Original = 2;
        iconDynamicsHandle11.setCaption("Zero Crescendo");
        iconDynamicsHandle11.setStartDyn(0);
        iconDynamicsHandle11.setEndDyn(127);
        iconDynamicsHandle11.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle11);
        IconDynamicsHandle iconDynamicsHandle12 = new IconDynamicsHandle();
        iconDynamicsHandle12.IDS = "cresc_4";
        iconDynamicsHandle12.IconID = "$05020003";
        iconDynamicsHandle12.Original = 3;
        iconDynamicsHandle12.setCaption("Zero Crescendo Curve");
        iconDynamicsHandle12.setStartDyn(0);
        iconDynamicsHandle12.setEndDyn(38);
        iconDynamicsHandle12.setLength(960);
        iconDynamicsHandle12.setDynBP(new VibratoBPList(new float[]{0.5f}, new int[]{11}));
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle12);
        IconDynamicsHandle iconDynamicsHandle13 = new IconDynamicsHandle();
        iconDynamicsHandle13.IDS = "cresc_5";
        iconDynamicsHandle13.IconID = "$05020004";
        iconDynamicsHandle13.Original = 4;
        iconDynamicsHandle13.setCaption("Zero Crescendo Curve");
        iconDynamicsHandle13.setStartDyn(0);
        iconDynamicsHandle13.setEndDyn(102);
        iconDynamicsHandle13.setLength(960);
        iconDynamicsHandle13.setDynBP(new VibratoBPList(new float[]{0.5f}, new int[]{40}));
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle13);
        IconDynamicsHandle iconDynamicsHandle14 = new IconDynamicsHandle();
        iconDynamicsHandle14.IDS = "dim_1";
        iconDynamicsHandle14.IconID = "$05030000";
        iconDynamicsHandle14.Original = 0;
        iconDynamicsHandle14.setCaption("Zero Decrescendo");
        iconDynamicsHandle14.setStartDyn(0);
        iconDynamicsHandle14.setEndDyn(-38);
        iconDynamicsHandle14.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle14);
        IconDynamicsHandle iconDynamicsHandle15 = new IconDynamicsHandle();
        iconDynamicsHandle15.IDS = "dim_2";
        iconDynamicsHandle15.IconID = "$05030001";
        iconDynamicsHandle15.Original = 1;
        iconDynamicsHandle15.setCaption("Zero Decrescendo");
        iconDynamicsHandle15.setStartDyn(0);
        iconDynamicsHandle15.setEndDyn(-64);
        iconDynamicsHandle15.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle15);
        IconDynamicsHandle iconDynamicsHandle16 = new IconDynamicsHandle();
        iconDynamicsHandle16.IDS = "dim_3";
        iconDynamicsHandle16.IconID = "$05030002";
        iconDynamicsHandle16.Original = 2;
        iconDynamicsHandle16.setCaption("Zero Decrescendo");
        iconDynamicsHandle16.setStartDyn(0);
        iconDynamicsHandle16.setEndDyn(-127);
        iconDynamicsHandle16.setLength(960);
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle16);
        IconDynamicsHandle iconDynamicsHandle17 = new IconDynamicsHandle();
        iconDynamicsHandle17.IDS = "dim_4";
        iconDynamicsHandle17.IconID = "$05030003";
        iconDynamicsHandle17.Original = 3;
        iconDynamicsHandle17.setCaption("Zero Decrescendo Curve");
        iconDynamicsHandle17.setStartDyn(0);
        iconDynamicsHandle17.setEndDyn(-38);
        iconDynamicsHandle17.setLength(960);
        iconDynamicsHandle17.setDynBP(new VibratoBPList(new float[]{0.5f}, new int[]{-11}));
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle17);
        IconDynamicsHandle iconDynamicsHandle18 = new IconDynamicsHandle();
        iconDynamicsHandle18.IDS = "dim_5";
        iconDynamicsHandle18.IconID = "$05030004";
        iconDynamicsHandle18.Original = 4;
        iconDynamicsHandle18.setCaption("Zero Decrescendo Curve");
        iconDynamicsHandle18.setStartDyn(0);
        iconDynamicsHandle18.setEndDyn(-102);
        iconDynamicsHandle18.setLength(960);
        iconDynamicsHandle18.setDynBP(new VibratoBPList(new float[]{0.5f}, new int[]{-40}));
        expressionConfigSys.m_dynamics_configs.add(iconDynamicsHandle18);
        return expressionConfigSys;
    }

    public static ExpressionConfigSys getVocaloid2Default() {
        ExpressionConfigSys expressionConfigSys = new ExpressionConfigSys();
        expressionConfigSys.m_vibrato_configs = new Vector();
        expressionConfigSys.m_attack_configs = new Vector();
        expressionConfigSys.m_dynamics_configs = new Vector();
        VibratoHandle vibratoHandle = new VibratoHandle();
        vibratoHandle.Index = 1;
        vibratoHandle.IconID = "$04040001";
        vibratoHandle.IDS = "normal";
        vibratoHandle.Original = 0;
        vibratoHandle.setCaption("[Normal] Class 1");
        vibratoHandle.setLength(480);
        vibratoHandle.setStartDepth(64);
        vibratoHandle.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle.setStartRate(50);
        vibratoHandle.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle);
        VibratoHandle vibratoHandle2 = new VibratoHandle();
        vibratoHandle2.Index = 2;
        vibratoHandle2.IconID = "$04040002";
        vibratoHandle2.IDS = "normal";
        vibratoHandle2.Original = 0;
        vibratoHandle2.setCaption("[Normal] Class 2");
        vibratoHandle2.setLength(480);
        vibratoHandle2.setStartDepth(40);
        vibratoHandle2.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle2.setStartRate(50);
        vibratoHandle2.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle2);
        VibratoHandle vibratoHandle3 = new VibratoHandle();
        vibratoHandle3.Index = 3;
        vibratoHandle3.IconID = "$04040003";
        vibratoHandle3.IDS = "normal";
        vibratoHandle3.Original = 0;
        vibratoHandle3.setCaption("[Normal] Class 3");
        vibratoHandle3.setLength(480);
        vibratoHandle3.setStartDepth(127);
        vibratoHandle3.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle3.setStartRate(50);
        vibratoHandle3.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle3);
        VibratoHandle vibratoHandle4 = new VibratoHandle();
        vibratoHandle4.Index = 4;
        vibratoHandle4.IconID = "$04040004";
        vibratoHandle4.IDS = "normal";
        vibratoHandle4.Original = 0;
        vibratoHandle4.setCaption("[Normal] Class 4");
        vibratoHandle4.setLength(480);
        vibratoHandle4.setStartDepth(64);
        vibratoHandle4.setDepthBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        vibratoHandle4.setStartRate(50);
        vibratoHandle4.setRateBP(new VibratoBPList(new float[]{0.6f, 0.6125f, 0.6167f, 0.6208f, 0.6292f, 0.6333f, 0.6375f, 0.6417f, 0.6542f, 0.6583f, 0.6625f, 0.6667f, 0.675f, 0.6833f, 0.6875f, 0.6917f, 0.7f, 0.7042f, 0.7083f, 0.7125f, 0.725f, 0.7292f, 0.7333f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7708f, 0.775f, 0.7792f, 0.7833f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8167f, 0.8208f, 0.8292f, 0.8333f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8667f, 0.8708f, 0.875f, 0.8792f, 0.8875f, 0.8917f, 0.9f, 1.0f}, new int[]{50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle4);
        VibratoHandle vibratoHandle5 = new VibratoHandle();
        vibratoHandle5.Index = 5;
        vibratoHandle5.IconID = "$04040005";
        vibratoHandle5.IDS = "extreme";
        vibratoHandle5.Original = 0;
        vibratoHandle5.setCaption("[Extreme] Class 1");
        vibratoHandle5.setLength(480);
        vibratoHandle5.setStartDepth(64);
        vibratoHandle5.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle5.setStartRate(64);
        vibratoHandle5.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle5);
        VibratoHandle vibratoHandle6 = new VibratoHandle();
        vibratoHandle6.Index = 6;
        vibratoHandle6.IconID = "$04040006";
        vibratoHandle6.IDS = "extreme";
        vibratoHandle6.Original = 0;
        vibratoHandle6.setCaption("[Extreme] Class 2");
        vibratoHandle6.setLength(480);
        vibratoHandle6.setStartDepth(32);
        vibratoHandle6.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle6.setStartRate(32);
        vibratoHandle6.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle6);
        VibratoHandle vibratoHandle7 = new VibratoHandle();
        vibratoHandle7.Index = 7;
        vibratoHandle7.IconID = "$04040007";
        vibratoHandle7.IDS = "extreme";
        vibratoHandle7.Original = 0;
        vibratoHandle7.setCaption("[Extreme] Class 3");
        vibratoHandle7.setLength(480);
        vibratoHandle7.setStartDepth(100);
        vibratoHandle7.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle7.setStartRate(50);
        vibratoHandle7.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle7);
        VibratoHandle vibratoHandle8 = new VibratoHandle();
        vibratoHandle8.Index = 8;
        vibratoHandle8.IconID = "$04040008";
        vibratoHandle8.IDS = "extreme";
        vibratoHandle8.Original = 0;
        vibratoHandle8.setCaption("[Extreme] Class 4");
        vibratoHandle8.setLength(480);
        vibratoHandle8.setStartDepth(64);
        vibratoHandle8.setDepthBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        vibratoHandle8.setStartRate(64);
        vibratoHandle8.setRateBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle8);
        VibratoHandle vibratoHandle9 = new VibratoHandle();
        vibratoHandle9.Index = 9;
        vibratoHandle9.IconID = "$04040009";
        vibratoHandle9.IDS = "fast";
        vibratoHandle9.Original = 0;
        vibratoHandle9.setCaption("[Fast] Class 1");
        vibratoHandle9.setLength(480);
        vibratoHandle9.setStartDepth(64);
        vibratoHandle9.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle9.setStartRate(64);
        vibratoHandle9.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle9);
        VibratoHandle vibratoHandle10 = new VibratoHandle();
        vibratoHandle10.Index = 10;
        vibratoHandle10.IconID = "$0404000a";
        vibratoHandle10.IDS = "fast";
        vibratoHandle10.Original = 0;
        vibratoHandle10.setCaption("[Fast] Class 2");
        vibratoHandle10.setLength(480);
        vibratoHandle10.setStartDepth(40);
        vibratoHandle10.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle10.setStartRate(50);
        vibratoHandle10.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle10);
        VibratoHandle vibratoHandle11 = new VibratoHandle();
        vibratoHandle11.Index = 11;
        vibratoHandle11.IconID = "$0404000b";
        vibratoHandle11.IDS = "fast";
        vibratoHandle11.Original = 0;
        vibratoHandle11.setCaption("[Fast] Class 3");
        vibratoHandle11.setLength(480);
        vibratoHandle11.setStartDepth(80);
        vibratoHandle11.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle11.setStartRate(70);
        vibratoHandle11.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle11);
        VibratoHandle vibratoHandle12 = new VibratoHandle();
        vibratoHandle12.Index = 12;
        vibratoHandle12.IconID = "$0404000c";
        vibratoHandle12.IDS = "fast";
        vibratoHandle12.Original = 0;
        vibratoHandle12.setCaption("[Fast] Class 4");
        vibratoHandle12.setLength(480);
        vibratoHandle12.setStartDepth(64);
        vibratoHandle12.setDepthBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        vibratoHandle12.setStartRate(64);
        vibratoHandle12.setRateBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle12);
        VibratoHandle vibratoHandle13 = new VibratoHandle();
        vibratoHandle13.Index = 13;
        vibratoHandle13.IconID = "$0404000d";
        vibratoHandle13.IDS = "slight";
        vibratoHandle13.Original = 0;
        vibratoHandle13.setCaption("[Slight] Class 1");
        vibratoHandle13.setLength(480);
        vibratoHandle13.setStartDepth(64);
        vibratoHandle13.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle13.setStartRate(64);
        vibratoHandle13.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle13);
        VibratoHandle vibratoHandle14 = new VibratoHandle();
        vibratoHandle14.Index = 14;
        vibratoHandle14.IconID = "$0404000e";
        vibratoHandle14.IDS = "slight";
        vibratoHandle14.Original = 0;
        vibratoHandle14.setCaption("[Slight] Class 2");
        vibratoHandle14.setLength(480);
        vibratoHandle14.setStartDepth(40);
        vibratoHandle14.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle14.setStartRate(64);
        vibratoHandle14.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle14);
        VibratoHandle vibratoHandle15 = new VibratoHandle();
        vibratoHandle15.Index = 15;
        vibratoHandle15.IconID = "$0404000f";
        vibratoHandle15.IDS = "slight";
        vibratoHandle15.Original = 0;
        vibratoHandle15.setCaption("[Slight] Class 3");
        vibratoHandle15.setLength(480);
        vibratoHandle15.setStartDepth(72);
        vibratoHandle15.setDepthBP(new VibratoBPList(new float[0], new int[0]));
        vibratoHandle15.setStartRate(64);
        vibratoHandle15.setRateBP(new VibratoBPList(new float[0], new int[0]));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle15);
        VibratoHandle vibratoHandle16 = new VibratoHandle();
        vibratoHandle16.Index = 16;
        vibratoHandle16.IconID = "$04040010";
        vibratoHandle16.IDS = "slight";
        vibratoHandle16.Original = 0;
        vibratoHandle16.setCaption("[Slight] Class 4");
        vibratoHandle16.setLength(480);
        vibratoHandle16.setStartDepth(64);
        vibratoHandle16.setDepthBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        vibratoHandle16.setStartRate(64);
        vibratoHandle16.setRateBP(new VibratoBPList(new float[]{0.6042f, 0.6125f, 0.6167f, 0.6208f, 0.625f, 0.6333f, 0.6375f, 0.6417f, 0.6458f, 0.6542f, 0.6583f, 0.6667f, 0.6708f, 0.675f, 0.6792f, 0.6833f, 0.6917f, 0.6958f, 0.7042f, 0.7083f, 0.7125f, 0.7167f, 0.7208f, 0.725f, 0.7292f, 0.7375f, 0.7458f, 0.75f, 0.7583f, 0.7625f, 0.7667f, 0.7708f, 0.775f, 0.7833f, 0.7917f, 0.7958f, 0.8f, 0.8042f, 0.8083f, 0.8125f, 0.8208f, 0.8292f, 0.8375f, 0.8417f, 0.8458f, 0.85f, 0.8542f, 0.8625f, 0.8667f, 0.875f, 0.8792f, 0.8833f, 0.8875f, 0.8917f, 0.8958f, 0.9f, 1.0f}, new int[]{64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0}));
        expressionConfigSys.m_vibrato_configs.add(vibratoHandle16);
        return expressionConfigSys;
    }

    public int getVibratoConfigCount() {
        return this.m_vibrato_configs.size();
    }

    public int getAttackConfigCount() {
        return this.m_attack_configs.size();
    }

    public int getDynamicsConfigCount() {
        return this.m_dynamics_configs.size();
    }

    public Iterator<VibratoHandle> vibratoConfigIterator() {
        return this.m_vibrato_configs.iterator();
    }

    public Iterator<NoteHeadHandle> attackConfigIterator() {
        return this.m_attack_configs.iterator();
    }

    public Iterator<IconDynamicsHandle> dynamicsConfigIterator() {
        return this.m_dynamics_configs.iterator();
    }

    private ExpressionConfigSys() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionConfigSys(String string, String string2) {
        Object object;
        String string3;
        String string4;
        String[] stringArray;
        int n;
        String string5;
        String[] stringArray2;
        String string6;
        Object[] objectArray;
        Vector vector;
        Object object2;
        Object object3;
        Object object4;
        String string7;
        this.m_vibrato_configs = new Vector();
        this.m_attack_configs = new Vector();
        this.m_dynamics_configs = new Vector();
        String string8 = PortUtil.getDirectoryName(string);
        String string9 = PortUtil.combinePath(string8, "AiconDB.def");
        if (PortUtil.isFileExists(string9)) {
            String string10;
            string7 = "";
            object4 = new TreeMap();
            object3 = null;
            try {
                object3 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string9), "Shift_JIS"));
                string10 = "";
                Object object5 = "";
                while ((string10 = ((BufferedReader)object3).readLine()) != null) {
                    int n2 = string10.indexOf(59);
                    if (n2 >= 0) {
                        string10 = string10.substring(0, n2);
                    }
                    if ((string10 = string10.trim()).startsWith("[")) {
                        object5 = string10;
                        continue;
                    }
                    int n3 = string10.indexOf(61);
                    if (n3 <= 0 || ((String[])(object2 = PortUtil.splitString(string10, '='))).length != 2) continue;
                    if (((String)object5).equals("[Common]")) {
                        if (!object2[0].equals("FolderName")) continue;
                        string7 = object2[1];
                        continue;
                    }
                    vector = null;
                    if (((TreeMap)object4).containsKey(object5)) {
                        vector = (Vector)((TreeMap)object4).get(object5);
                        ((TreeMap)object4).remove(object5);
                    } else {
                        vector = new Vector();
                    }
                    vector.add(string10);
                    ((TreeMap)object4).put(object5, vector);
                }
            }
            catch (Exception exception) {
                PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex=" + exception);
            }
            finally {
                if (object3 != null) {
                    try {
                        ((BufferedReader)object3).close();
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex2=" + exception);
                    }
                }
            }
            if (!string7.equals("") && PortUtil.isDirectoryExists(string10 = PortUtil.combinePath(string8, string7))) {
                for (String string11 : ((TreeMap)object4).keySet()) {
                    String string12 = string11.replace("[", "").replace("]", "");
                    object2 = PortUtil.combinePath(string10, string12);
                    if (!PortUtil.isDirectoryExists((String)object2)) continue;
                    for (Object object6 : (Vector)((TreeMap)object4).get(string11)) {
                        objectArray = PortUtil.splitString((String)object6, '=');
                        if (objectArray.length != 2) continue;
                        string6 = objectArray[0];
                        stringArray2 = PortUtil.splitString(objectArray[1], ',');
                        string5 = "";
                        if (string6.equals("Dynaff")) {
                            string5 = "$0501";
                        } else if (string6.equals("Crescendo")) {
                            string5 = "$0502";
                        } else if (string6.equals("Decrescendo")) {
                            string5 = "$0503";
                        }
                        for (n = 0; n < stringArray2.length; ++n) {
                            stringArray = stringArray2[n];
                            if (!stringArray.endsWith(".aic")) {
                                stringArray = (String)stringArray + ".aic";
                            }
                            string4 = PortUtil.combinePath((String)object2, (String)stringArray);
                            string3 = stringArray2[n];
                            String string13 = string5 + PortUtil.formatDecimal("0000", n);
                            if (!PortUtil.isFileExists(string4)) continue;
                            object = new IconDynamicsHandle(string4, string3, string13, n);
                            ((IconParameter)object).setButtonImageFullPath(PortUtil.combinePath((String)object2, ((IconParameter)object).getButton()));
                            this.m_dynamics_configs.add((IconDynamicsHandle)object);
                        }
                    }
                }
            }
        }
        if (!PortUtil.isFileExists(string7 = PortUtil.combinePath(string2, "expression.map"))) {
            return;
        }
        object4 = null;
        try {
            object4 = new RandomAccessFile(string7, "r");
            object3 = new byte[8];
            ((RandomAccessFile)object4).seek(32L);
            for (int i = 0; i < 1024; ++i) {
                String string14;
                Object object6;
                ((RandomAccessFile)object4).read((byte[])object3, 0, 8);
                long l = PortUtil.make_int64_le((byte[])object3);
                if (l <= 0L || !PortUtil.isFileExists(string14 = PortUtil.combinePath(string2, "vexp" + l + ".ved")) || !PortUtil.isDirectoryExists((String)(object2 = PortUtil.combinePath(string2, "vexp" + l)))) continue;
                vector = "\r\n";
                object6 = null;
                try {
                    object6 = new RandomAccessFile(string14, "r");
                    objectArray = new byte[(int)((RandomAccessFile)object6).length()];
                    ((RandomAccessFile)object6).read((byte[])objectArray, 0, objectArray.length);
                    TransCodeUtil.decodeBytes((byte[])objectArray);
                    string6 = PortUtil.getDecodedString("ASCII", (byte[])objectArray);
                    stringArray2 = PortUtil.splitString(string6, new String[]{vector}, true);
                    string5 = "";
                    for (n = 0; n < stringArray2.length; ++n) {
                        IconParameter iconParameter;
                        String string15;
                        if (stringArray2[n].startsWith("[")) {
                            string5 = stringArray2[n];
                            continue;
                        }
                        if (stringArray2[n].equals("")) continue;
                        if (string5.equals("[VIBRATO]")) {
                            stringArray = PortUtil.splitString(stringArray2[n], ',');
                            if (stringArray.length < 6) continue;
                            string4 = stringArray[3].replace("\"", "");
                            string3 = PortUtil.combinePath((String)object2, string4);
                            int n4 = PortUtil.parseInt(stringArray[0]);
                            object = "$0404" + PortUtil.toHexString(n4, 4);
                            String string16 = "";
                            string15 = stringArray[4].replace("\"", "").replace(":", " ");
                            iconParameter = new VibratoHandle(string3, string16, (String)object, n4);
                            ((VibratoHandle)iconParameter).setCaption(string15);
                            this.m_vibrato_configs.add((VibratoHandle)iconParameter);
                        }
                        if (!string5.equals("[NOTEATTACK]") || (stringArray = PortUtil.splitString(stringArray2[n], ',')).length < 6 || !PortUtil.isFileExists(string3 = PortUtil.combinePath((String)object2, string4 = stringArray[3].replace("\"", "")))) continue;
                        String string17 = "";
                        object = stringArray[4].replace("\"", "").replace(":", " ");
                        int n5 = PortUtil.parseInt(stringArray[0]);
                        string15 = "$0101" + PortUtil.toHexString(n5, 4);
                        iconParameter = new NoteHeadHandle(string3, string17, string15, n5);
                        ((NoteHeadHandle)iconParameter).setCaption((String)object);
                        this.m_attack_configs.add((NoteHeadHandle)iconParameter);
                    }
                    continue;
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex=" + exception);
                    continue;
                }
                finally {
                    if (object6 != null) {
                        try {
                            ((RandomAccessFile)object6).close();
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex2=" + exception);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex=" + exception);
        }
        finally {
            if (object4 != null) {
                try {
                    ((RandomAccessFile)object4).close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("ExpressionConfigSys#.ctor; ex2=" + exception);
                }
            }
        }
    }
}

