/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.RandomAccessFile;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;

public class SingerConfigSys {
    public static final int MAX_SINGERS = 16384;
    private Vector<SingerConfig> m_installed_singers = new Vector();
    private Vector<SingerConfig> m_singer_configs = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingerConfigSys(String string, String[] stringArray) {
        Object object;
        this.m_installed_singers = new Vector();
        this.m_singer_configs = new Vector();
        String string2 = PortUtil.combinePath(string, "voice.map");
        if (!PortUtil.isFileExists(string2)) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            String[] stringArray2 = PortUtil.listFiles((String)object, "*.vvd");
            if (stringArray2.length <= 0) continue;
            SingerConfig singerConfig = SingerConfig.fromVvd(stringArray2[0], 0, 0);
            this.m_installed_singers.add(singerConfig);
            break;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string2, "r");
            object = new byte[8];
            randomAccessFile.seek(32L);
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    randomAccessFile.read((byte[])object, 0, 8);
                    long l = PortUtil.make_int64_le(object);
                    if (l < 1L) continue;
                    String string3 = PortUtil.combinePath(string, "vvoice" + l + ".vvd");
                    SingerConfig singerConfig = SingerConfig.fromVvd(string3, i, j);
                    this.m_singer_configs.add(singerConfig);
                }
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("SingerConfigSys#.ctor; ex=" + exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("SingerConfigSys#.ctor; ex2=" + exception);
                }
            }
        }
        block14: for (SingerConfig singerConfig : this.m_installed_singers) {
            String string4 = singerConfig.VOICEIDSTR;
            for (SingerConfig singerConfig2 : this.m_singer_configs) {
                if (!singerConfig2.VOICEIDSTR.equals(string4)) continue;
                singerConfig.Language = singerConfig2.Language;
                continue block14;
            }
        }
    }

    public SingerConfig[] getInstalledSingers() {
        return this.m_installed_singers.toArray(new SingerConfig[0]);
    }

    public VsqID getSingerID(int n, int n2) {
        VsqID vsqID = new VsqID(0);
        vsqID.type = VsqIDType.Singer;
        SingerConfig singerConfig = null;
        for (int i = 0; i < this.m_singer_configs.size(); ++i) {
            SingerConfig singerConfig2 = this.m_singer_configs.get(i);
            if (singerConfig2.Language != n || singerConfig2.Program != n2) continue;
            singerConfig = singerConfig2;
            break;
        }
        if (singerConfig == null) {
            singerConfig = new SingerConfig();
        }
        vsqID.IconHandle = new IconHandle();
        vsqID.IconHandle.IconID = "$0701" + PortUtil.toHexString(singerConfig.Language, 2) + PortUtil.toHexString(singerConfig.Program, 2);
        vsqID.IconHandle.IDS = singerConfig.VOICENAME;
        vsqID.IconHandle.Index = 0;
        vsqID.IconHandle.Language = singerConfig.Language;
        vsqID.IconHandle.setLength(1);
        vsqID.IconHandle.Original = singerConfig.Language << 8 | singerConfig.Program;
        vsqID.IconHandle.Program = singerConfig.Program;
        vsqID.IconHandle.Caption = "";
        return vsqID;
    }

    public SingerConfig getSingerInfo(int n, int n2) {
        for (SingerConfig singerConfig : this.m_installed_singers) {
            if (singerConfig.Language != n || singerConfig.Program != n2) continue;
            return singerConfig;
        }
        return null;
    }

    public SingerConfig[] getSingerConfigs() {
        return this.m_singer_configs.toArray(new SingerConfig[0]);
    }
}

