/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ExpressionConfigSys;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.NoteHeadHandle;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.SingerConfigSys;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqVoiceLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VocaloSysUtil {
    private static TreeMap<SynthesizerType, SingerConfigSys> s_singer_config_sys = new TreeMap();
    private static TreeMap<SynthesizerType, ExpressionConfigSys> s_exp_config_sys = new TreeMap();
    private static TreeMap<SynthesizerType, String> s_path_vsti = new TreeMap();
    private static TreeMap<SynthesizerType, String> s_path_editor = new TreeMap();
    private static Boolean isInitialized = false;
    private static int defaultDseVersion = 100;
    private static boolean dseVersion101Available = false;

    private VocaloSysUtil() {
    }

    public static SingerConfigSys getSingerConfigSys(SynthesizerType synthesizerType) {
        if (s_singer_config_sys.containsKey((Object)synthesizerType)) {
            return s_singer_config_sys.get((Object)synthesizerType);
        }
        return null;
    }

    public static boolean isDSEVersion101Available() {
        return dseVersion101Available;
    }

    public static int getDefaultDseVersion() {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        return defaultDseVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object;
        Object object2;
        ByRef<String> byRef;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Vector<String> vector;
        Object object7;
        ExpressionConfigSys expressionConfigSys;
        block27: {
            if (isInitialized.booleanValue()) {
                return;
            }
            expressionConfigSys = null;
            try {
                String string;
                String string2;
                object7 = new Vector<String>();
                vector = new ByRef<String>("");
                object6 = new ByRef<String>("");
                object5 = new Vector<String>();
                object4 = "HKLM\\SOFTWARE\\VOCALOID";
                VocaloSysUtil.initPrint("SOFTWARE\\VOCALOID", (String)object4, object7);
                object3 = new ByRef<String>("");
                byRef = new ByRef<String>("");
                VocaloSysUtil.initExtract(object7, (String)object4, object3, vector, object6, byRef, object5);
                s_path_vsti.put(SynthesizerType.VOCALOID1, (String)((ByRef)object3).value);
                s_path_editor.put(SynthesizerType.VOCALOID1, (String)byRef.value);
                object2 = new SingerConfigSys((String)((ByRef)((Object)vector)).value, ((Vector)object5).toArray(new String[0]));
                object = PortUtil.combinePath((String)((ByRef)object6).value, "expression.map");
                if (PortUtil.isFileExists((String)object)) {
                    expressionConfigSys = new ExpressionConfigSys((String)byRef.value, (String)((ByRef)object6).value);
                }
                s_singer_config_sys.put(SynthesizerType.VOCALOID1, (SingerConfigSys)object2);
                if (!((String)((ByRef)object3).value).equals("")) {
                    string2 = PortUtil.getDirectoryName((String)((ByRef)object3).value);
                    string = PortUtil.combinePath(string2, "DSE1_1.dll");
                    dseVersion101Available = PortUtil.isFileExists(string);
                } else {
                    dseVersion101Available = false;
                }
                if (byRef.value == null || ((String)byRef.value).equals("") || !PortUtil.isFileExists((String)byRef.value) || !PortUtil.isFileExists(string = PortUtil.combinePath(string2 = PortUtil.getDirectoryName((String)byRef.value), "VOCALOID.ini"))) break block27;
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Shift_JIS"));
                    while (bufferedReader.ready()) {
                        String string3 = bufferedReader.readLine();
                        if (string3 == null || string3.equals("") || !string3.startsWith("DSEVersion")) continue;
                        String[] stringArray = PortUtil.splitString(string3, '=');
                        if (stringArray.length >= 2) {
                            String string4 = stringArray[1];
                            try {
                                defaultDseVersion = PortUtil.parseInt(string4);
                            }
                            catch (Exception exception) {
                                PortUtil.stderr.println("VocaloSysUtil#init; ex=" + exception);
                                defaultDseVersion = 100;
                            }
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VocaloSysUtil#init; ex=" + exception);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("VocaloSysUtil#init; ex2=" + exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                PortUtil.stderr.println("VocaloSysUtil#init; ex=" + exception);
                vector = new SingerConfigSys("", new String[0]);
                expressionConfigSys = null;
                s_singer_config_sys.put(SynthesizerType.VOCALOID1, (SingerConfigSys)((Object)vector));
            }
        }
        if (expressionConfigSys == null) {
            expressionConfigSys = ExpressionConfigSys.getVocaloid1Default();
        }
        s_exp_config_sys.put(SynthesizerType.VOCALOID1, expressionConfigSys);
        object7 = null;
        try {
            vector = new Vector<String>();
            object6 = new ByRef<String>("");
            object5 = new ByRef<String>("");
            object4 = new Vector();
            object3 = "HKLM\\SOFTWARE\\VOCALOID2";
            VocaloSysUtil.initPrint("SOFTWARE\\VOCALOID2", (String)object3, vector);
            byRef = new ByRef<String>("");
            object2 = new ByRef<String>("");
            VocaloSysUtil.initExtract(vector, (String)object3, byRef, (ByRef<String>)object6, (ByRef<String>)object5, (ByRef<String>)object2, (Vector<String>)object4);
            s_path_vsti.put(SynthesizerType.VOCALOID2, (String)byRef.value);
            s_path_editor.put(SynthesizerType.VOCALOID2, (String)((ByRef)object2).value);
            object = new SingerConfigSys((String)((ByRef)object6).value, ((Vector)object4).toArray(new String[0]));
            if (PortUtil.isFileExists(PortUtil.combinePath((String)((ByRef)object5).value, "expression.map"))) {
                object7 = new ExpressionConfigSys((String)((ByRef)object2).value, (String)((ByRef)object5).value);
            }
            s_singer_config_sys.put(SynthesizerType.VOCALOID2, (SingerConfigSys)object);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VocaloSysUtil..cctor; ex=" + exception);
            object6 = new SingerConfigSys("", new String[0]);
            object7 = null;
            s_singer_config_sys.put(SynthesizerType.VOCALOID2, (SingerConfigSys)object6);
        }
        if (object7 == null) {
            object7 = ExpressionConfigSys.getVocaloid2Default();
        }
        s_exp_config_sys.put(SynthesizerType.VOCALOID2, (ExpressionConfigSys)object7);
        isInitialized = true;
    }

    public static VibratoHandle getDefaultVibratoHandle(String string, int n, SynthesizerType synthesizerType) {
        Object object;
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (s_exp_config_sys.containsKey((Object)synthesizerType)) {
            object = s_exp_config_sys.get((Object)synthesizerType).vibratoConfigIterator();
            while (object.hasNext()) {
                VibratoHandle vibratoHandle = (VibratoHandle)object.next();
                if (!vibratoHandle.IconID.equals(string)) continue;
                VibratoHandle vibratoHandle2 = (VibratoHandle)vibratoHandle.clone();
                vibratoHandle2.setLength(n);
                return vibratoHandle2;
            }
        }
        object = new VibratoHandle();
        ((VibratoHandle)object).IconID = "$04040000";
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void initExtract(Vector<String> vector, String string, ByRef<String> byRef, ByRef<String> byRef2, ByRef<String> byRef3, ByRef<String> byRef4, Vector<String> vector2) {
        String[] stringArray;
        String[] stringArray2;
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        byRef.value = "";
        byRef3.value = "";
        byRef2.value = "";
        byRef4.value = "";
        for (String object22 : vector) {
            if (object22.startsWith(string + "\\APPLICATION")) {
                vector3.add(object22.substring(PortUtil.getStringLength(string + "\\APPLICATION")));
                continue;
            }
            if (object22.startsWith(string + "\\DATABASE\\EXPRESSION")) {
                vector4.add(object22.substring(PortUtil.getStringLength(string + "\\DATABASE\\EXPRESSION")));
                continue;
            }
            if (!object22.startsWith(string + "\\DATABASE\\VOICE")) continue;
            vector5.add(object22.substring(PortUtil.getStringLength(string + "\\DATABASE\\VOICE\\")));
        }
        for (String string2 : vector3) {
            String[] stringArray3 = PortUtil.splitString(string2, '\t');
            if (stringArray3.length < 3 || !stringArray3[1].equals("PATH")) continue;
            if (stringArray3[2].toLowerCase().endsWith(".dll")) {
                byRef.value = stringArray3[2];
                continue;
            }
            if (!stringArray3[2].toLowerCase().endsWith(".exe")) continue;
            byRef4.value = stringArray3[2];
        }
        TreeMap treeMap = new TreeMap();
        for (String string3 : vector5) {
            String[] stringArray4 = PortUtil.splitString(string3, '\t');
            if (stringArray4.length < 2) continue;
            if (stringArray4[0].equals("VOICEDIR")) {
                byRef2.value = stringArray4[1];
                continue;
            }
            if (stringArray4.length < 3 || (stringArray2 = PortUtil.splitString(stringArray4[0], '\\')).length != 1) continue;
            stringArray = stringArray2[0];
            if (!treeMap.containsKey(stringArray)) {
                treeMap.put(stringArray, "");
            }
            if (!stringArray4[1].equals("INSTALLDIR")) continue;
            String string4 = stringArray4[2];
            treeMap.put(stringArray, PortUtil.combinePath(string4, (String)stringArray));
        }
        for (String string5 : treeMap.keySet()) {
            void var13_27;
            String string6 = (String)treeMap.get(string5);
            if (string6.equals("")) {
                String string7 = PortUtil.combinePath((String)byRef2.value, string5);
            }
            vector2.add((String)var13_27);
        }
        Vector<String> vector6 = new Vector<String>();
        for (String string8 : vector4) {
            stringArray2 = PortUtil.splitString(string8, new char[]{'\t'}, true);
            if (stringArray2.length < 3) continue;
            if (stringArray2[1].equals("EXPRESSIONDIR")) {
                byRef3.value = stringArray2[2];
                continue;
            }
            if (stringArray2.length < 3 || (stringArray = PortUtil.splitString(stringArray2[0], '\\')).length != 1 || vector6.contains(stringArray[0])) continue;
            vector6.add(stringArray[0]);
        }
    }

    private static void initPrint(String string, String string2, Vector<String> vector) {
    }

    public static Iterator<NoteHeadHandle> attackConfigIterator(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (s_exp_config_sys.containsKey((Object)synthesizerType)) {
            return s_exp_config_sys.get((Object)synthesizerType).attackConfigIterator();
        }
        return new Vector().iterator();
    }

    public static Iterator<VibratoHandle> vibratoConfigIterator(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (s_exp_config_sys.containsKey((Object)synthesizerType)) {
            return s_exp_config_sys.get((Object)synthesizerType).vibratoConfigIterator();
        }
        return new Vector().iterator();
    }

    public static Iterator<IconDynamicsHandle> dynamicsConfigIterator(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (s_exp_config_sys.containsKey((Object)synthesizerType)) {
            return s_exp_config_sys.get((Object)synthesizerType).dynamicsConfigIterator();
        }
        return new Vector().iterator();
    }

    public static String getOriginalSinger(int n, int n2, SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        String string = "";
        if (!s_singer_config_sys.containsKey((Object)synthesizerType)) {
            return "";
        }
        SingerConfigSys singerConfigSys = s_singer_config_sys.get((Object)synthesizerType);
        SingerConfig[] singerConfigArray = singerConfigSys.getSingerConfigs();
        for (int i = 0; i < singerConfigArray.length; ++i) {
            if (n != singerConfigArray[i].Language || n2 != singerConfigArray[i].Program) continue;
            string = singerConfigArray[i].VOICEIDSTR;
            break;
        }
        if (string.equals("")) {
            return "";
        }
        SingerConfig[] singerConfigArray2 = singerConfigSys.getInstalledSingers();
        for (int i = 0; i < singerConfigArray2.length; ++i) {
            if (!string.equals(singerConfigArray2[i].VOICEIDSTR)) continue;
            return singerConfigArray2[i].VOICENAME;
        }
        return "";
    }

    public static VsqID getSingerID(int n, int n2, SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (!s_singer_config_sys.containsKey((Object)synthesizerType)) {
            return null;
        }
        return s_singer_config_sys.get((Object)synthesizerType).getSingerID(n, n2);
    }

    public static String getEditorPath(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (!s_path_editor.containsKey((Object)synthesizerType)) {
            return "";
        }
        return s_path_editor.get((Object)synthesizerType);
    }

    public static String getDllPathVsti(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (!s_path_vsti.containsKey((Object)synthesizerType)) {
            return "";
        }
        return s_path_vsti.get((Object)synthesizerType);
    }

    public static SingerConfig[] getSingerConfigs(SynthesizerType synthesizerType) {
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if (!s_singer_config_sys.containsKey((Object)synthesizerType)) {
            return new SingerConfig[0];
        }
        return s_singer_config_sys.get((Object)synthesizerType).getSingerConfigs();
    }

    public static VsqVoiceLanguage getLanguageFromName(String string) {
        String string2;
        if (!isInitialized.booleanValue()) {
            VocaloSysUtil.init();
        }
        if ((string2 = string.toLowerCase()).equals("meiko") || string2.equals("kaito") || string2.equals("miku") || string2.equals("rin") || string2.equals("len") || string2.equals("rin_act2") || string2.equals("len_act2") || string2.equals("gackpoid") || string2.equals("luka_jpn") || string2.equals("megpoid") || string2.equals("sfa2_miki") || string2.equals("yuki") || string2.equals("kiyoteru")) {
            return VsqVoiceLanguage.Japanese;
        }
        if (string2.equals("sweet_ann") || string2.equals("prima") || string2.equals("luka_eng") || string2.equals("sonika") || string2.equals("lola") || string2.equals("leon") || string2.equals("miriam") || string2.equals("big_al")) {
            return VsqVoiceLanguage.English;
        }
        return VsqVoiceLanguage.Japanese;
    }

    public static double getAmplifyCoeffFromPanLeft(int n) {
        return (double)n / -64.0 + 1.0;
    }

    public static double getAmplifyCoeffFromPanRight(int n) {
        return (double)n / 64.0 + 1.0;
    }

    public static double getAmplifyCoeffFromFeder(int n) {
        return Math.exp(-0.0126697245 + 0.11844842 * (double)n / 10.0);
    }
}

