/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqBPPairSearchContext;
import org.kbinani.vsq.WrappedStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqBPList
implements Cloneable,
Serializable {
    private int[] clocks;
    private VsqBPPair[] items;
    private int length = 0;
    private int defaultValue = 0;
    private int maxValue = 127;
    private int minValue = 0;
    private long maxId = 0L;
    private String name = "";
    static final int INIT_BUFLEN = 512;

    public VsqBPList() {
        this("", 0, 0, 64);
    }

    public VsqBPList(String string, int n, int n2, int n3) {
        this.name = string;
        this.defaultValue = n;
        this.maxValue = n3;
        this.minValue = n2;
        this.maxId = 0L;
    }

    private void ensureBufferLength(int n) {
        if (this.clocks == null) {
            this.clocks = new int[512];
        }
        if (this.items == null) {
            this.items = new VsqBPPair[512];
        }
        if (n > this.clocks.length) {
            int n2 = n;
            if (this.length <= 0) {
                n2 = (int)((double)n * 1.2);
            } else {
                int n3 = n / this.clocks.length;
                if (n3 <= 1) {
                    n3 = 2;
                }
                n2 = this.clocks.length * n3;
            }
            this.clocks = Arrays.copyOf(this.clocks, n2);
            this.items = Arrays.copyOf(this.items, n2);
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string == null ? "" : string;
    }

    public long getMaxID() {
        return this.maxId;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    public void setDefault(int n) {
        this.defaultValue = n;
    }

    public void renumberIDs() {
        this.maxId = 0L;
        for (int i = 0; i < this.length; ++i) {
            VsqBPPair vsqBPPair = this.items[i];
            vsqBPPair.id = ++this.maxId;
            this.items[i] = vsqBPPair;
        }
    }

    public String getData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            stringBuilder.append((i == 0 ? "" : ",") + this.clocks[i] + "=" + this.items[i].value);
        }
        return stringBuilder.toString();
    }

    public void setData(String string) {
        this.length = 0;
        this.maxId = 0L;
        String[] stringArray = PortUtil.splitString(string, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PortUtil.splitString(stringArray[i], '=');
            if (stringArray2.length < 2) continue;
            try {
                int n = PortUtil.parseInt(stringArray2[0]);
                this.ensureBufferLength(this.length + 1);
                this.clocks[this.length] = n;
                this.items[this.length] = new VsqBPPair(PortUtil.parseInt(stringArray2[1]), this.maxId + 1L);
                ++this.maxId;
                ++this.length;
                continue;
            }
            catch (Exception exception) {
                PortUtil.stderr.println("VsqBPList#setData; ex=" + exception);
            }
        }
    }

    public Object clone() {
        VsqBPList vsqBPList = new VsqBPList(this.name, this.defaultValue, this.minValue, this.maxValue);
        vsqBPList.ensureBufferLength(this.length);
        for (int i = 0; i < this.length; ++i) {
            vsqBPList.clocks[i] = this.clocks[i];
            vsqBPList.items[i] = (VsqBPPair)this.items[i].clone();
        }
        vsqBPList.length = this.length;
        vsqBPList.maxId = this.maxId;
        return vsqBPList;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(int n) {
        this.maxValue = n;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void setMinimum(int n) {
        this.minValue = n;
    }

    public void remove(int n) {
        this.ensureBufferLength(this.length);
        int n2 = this.find(n);
        this.removeElementAt(n2);
    }

    public void removeElementAt(int n) {
        if (n >= 0) {
            for (int i = n; i < this.length - 1; ++i) {
                this.clocks[i] = this.clocks[i + 1];
                this.items[i] = this.items[i + 1];
            }
            --this.length;
        }
    }

    public boolean isContainsKey(int n) {
        this.ensureBufferLength(this.length);
        return this.find(n) >= 0;
    }

    public void move(int n, int n2, int n3) {
        int n4;
        this.ensureBufferLength(this.length);
        int n5 = this.find(n);
        if (n5 < 0) {
            return;
        }
        VsqBPPair vsqBPPair = this.items[n5];
        for (n4 = n5; n4 < this.length - 1; ++n4) {
            this.clocks[n4] = this.clocks[n4 + 1];
            this.items[n4] = this.items[n4 + 1];
        }
        --this.length;
        n4 = this.find(n2);
        if (n4 >= 0) {
            vsqBPPair.value = n3;
            this.items[n4] = vsqBPPair;
            return;
        }
        ++this.length;
        this.ensureBufferLength(this.length);
        this.clocks[this.length - 1] = n2;
        Arrays.sort(this.clocks, 0, this.length);
        n4 = this.find(n2);
        vsqBPPair.value = n3;
        for (int i = this.length - 1; i > n4; --i) {
            this.items[i] = this.items[i - 1];
        }
        this.items[n4] = vsqBPPair;
    }

    public void clear() {
        this.length = 0;
    }

    public int getElement(int n) {
        return this.getElementA(n);
    }

    public int getElementA(int n) {
        return this.items[n].value;
    }

    public VsqBPPair getElementB(int n) {
        return this.items[n];
    }

    public int getKeyClock(int n) {
        return this.clocks[n];
    }

    public int findValueFromID(long l) {
        for (int i = 0; i < this.length; ++i) {
            VsqBPPair vsqBPPair = this.items[i];
            if (vsqBPPair.id != l) continue;
            return vsqBPPair.value;
        }
        return this.defaultValue;
    }

    public VsqBPPairSearchContext findElement(long l) {
        VsqBPPairSearchContext vsqBPPairSearchContext = new VsqBPPairSearchContext();
        for (int i = 0; i < this.length; ++i) {
            VsqBPPair vsqBPPair = this.items[i];
            if (vsqBPPair.id != l) continue;
            vsqBPPairSearchContext.clock = this.clocks[i];
            vsqBPPairSearchContext.index = i;
            vsqBPPairSearchContext.point = vsqBPPair;
            return vsqBPPairSearchContext;
        }
        vsqBPPairSearchContext.clock = -1;
        vsqBPPairSearchContext.index = -1;
        vsqBPPairSearchContext.point = new VsqBPPair(this.defaultValue, -1L);
        return vsqBPPairSearchContext;
    }

    public void setValueForID(long l, int n) {
        for (int i = 0; i < this.length; ++i) {
            VsqBPPair vsqBPPair = this.items[i];
            if (vsqBPPair.id != l) continue;
            vsqBPPair.value = n;
            this.items[i] = vsqBPPair;
            break;
        }
    }

    public int getValue(int n, ByRef<Integer> byRef) {
        if (this.length == 0) {
            return this.defaultValue;
        }
        if ((Integer)byRef.value < 0) {
            byRef.value = 0;
        }
        for (int i = ((Integer)byRef.value).intValue(); i < this.length; ++i) {
            int n2 = this.clocks[i];
            if (n >= n2) continue;
            if (i > 0) {
                byRef.value = i - 1;
                return this.items[i - 1].value;
            }
            byRef.value = i - 1;
            return this.defaultValue;
        }
        byRef.value = this.length - 1;
        return this.items[this.length - 1].value;
    }

    private void printCor(ITextWriter iTextWriter, int n, String string) throws IOException {
        iTextWriter.writeLine(string);
        for (int i = 0; i < this.length; ++i) {
            int n2 = this.clocks[i];
            if (n > n2) continue;
            int n3 = this.items[i].value;
            iTextWriter.writeLine(n2 + "=" + n3);
        }
    }

    public void print(BufferedWriter bufferedWriter, int n, String string) throws IOException {
        this.printCor(new WrappedStreamWriter(bufferedWriter), n, string);
    }

    public void print(ITextWriter iTextWriter, int n, String string) throws IOException {
        this.printCor(iTextWriter, n, string);
    }

    public String appendFromText(TextStream textStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        while (textStream.ready()) {
            char c = textStream.get();
            if (c == '\n') {
                if (!bl) continue;
                this.addWithoutSort(n, n2 * n3);
                bl = false;
                n = 0;
                n2 = 0;
                n3 = 1;
                continue;
            }
            if (c == '[') {
                if (bl) {
                    this.addWithoutSort(n, n2 * n3);
                    bl = false;
                    n = 0;
                    n2 = 0;
                    n3 = 1;
                }
                textStream.setPointer(textStream.getPointer() - 1);
                break;
            }
            if (c == '=') {
                bl = true;
                continue;
            }
            if (c == '-') {
                n3 = -1;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            int n4 = 0;
            if (c == '1') {
                n4 = 1;
            } else if (c == '2') {
                n4 = 2;
            } else if (c == '3') {
                n4 = 3;
            } else if (c == '4') {
                n4 = 4;
            } else if (c == '5') {
                n4 = 5;
            } else if (c == '6') {
                n4 = 6;
            } else if (c == '7') {
                n4 = 7;
            } else if (c == '8') {
                n4 = 8;
            } else if (c == '9') {
                n4 = 9;
            }
            if (!bl) {
                n = n * 10 + n4;
                continue;
            }
            n2 = n2 * 10 + n4;
        }
        return textStream.readLine();
    }

    public int size() {
        return this.length;
    }

    public Iterator<Integer> keyClockIterator() {
        return new KeyClockIterator(this);
    }

    private int find(int n) {
        for (int i = 0; i < this.length; ++i) {
            if (this.clocks[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void addWithoutSort(int n, int n2) {
        this.ensureBufferLength(this.length + 1);
        this.clocks[this.length] = n;
        ++this.maxId;
        this.items[this.length] = new VsqBPPair(n2, this.maxId);
        ++this.length;
    }

    public long add(int n, int n2) {
        this.ensureBufferLength(this.length);
        int n3 = this.find(n);
        if (n3 >= 0) {
            VsqBPPair vsqBPPair = this.items[n3];
            vsqBPPair.value = n2;
            this.items[n3] = vsqBPPair;
            return vsqBPPair.id;
        }
        ++this.length;
        this.ensureBufferLength(this.length);
        this.clocks[this.length - 1] = n;
        Arrays.sort(this.clocks, 0, this.length);
        n3 = this.find(n);
        ++this.maxId;
        for (int i = this.length - 1; i > n3; --i) {
            this.items[i] = this.items[i - 1];
        }
        this.items[n3] = new VsqBPPair(n2, this.maxId);
        return this.maxId;
    }

    public void addWithID(int n, int n2, long l) {
        this.ensureBufferLength(this.length);
        int n3 = this.find(n);
        if (n3 >= 0) {
            VsqBPPair vsqBPPair = this.items[n3];
            vsqBPPair.value = n2;
            vsqBPPair.id = l;
            this.items[n3] = vsqBPPair;
        } else {
            ++this.length;
            this.ensureBufferLength(this.length);
            this.clocks[this.length - 1] = n;
            Arrays.sort(this.clocks, 0, this.length);
            n3 = this.find(n);
            for (int i = this.length - 1; i > n3; --i) {
                this.items[i] = this.items[i - 1];
            }
            this.items[n3] = new VsqBPPair(n2, l);
            this.maxId = Math.max(this.maxId, l);
        }
    }

    public void removeWithID(long l) {
        for (int i = 0; i < this.length; ++i) {
            if (this.items[i].id != l) continue;
            for (int j = i; j < this.length - 1; ++j) {
                this.items[j] = this.items[j + 1];
                this.clocks[j] = this.clocks[j + 1];
            }
            --this.length;
            break;
        }
    }

    public int getValue(int n) {
        int n2;
        this.ensureBufferLength(this.length);
        int n3 = this.find(n);
        if (n3 >= 0) {
            return this.items[n3].value;
        }
        if (this.length <= 0) {
            return this.defaultValue;
        }
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.length && n >= (n2 = this.clocks[n5])) {
            n4 = n5++;
        }
        if (n4 < 0) {
            return this.defaultValue;
        }
        return this.items[n4].value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyClockIterator
    implements Iterator<Integer> {
        private VsqBPList m_list;
        private int m_pos;

        public KeyClockIterator(VsqBPList vsqBPList2) {
            this.m_list = vsqBPList2;
            this.m_pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this.m_pos + 1 < this.m_list.length;
        }

        @Override
        public Integer next() {
            ++this.m_pos;
            return this.m_list.clocks[this.m_pos];
        }

        @Override
        public void remove() {
            if (0 <= this.m_pos && this.m_pos < this.m_list.length) {
                int n = this.m_list.clocks[this.m_pos];
                for (int i = this.m_pos; i < this.m_list.length - 1; ++i) {
                    ((VsqBPList)this.m_list).clocks[i] = this.m_list.clocks[i + 1];
                    ((VsqBPList)this.m_list).items[i] = this.m_list.items[i + 1];
                }
                this.m_list.length = this.m_list.length - 1;
            }
        }
    }
}

