/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.UstEvent;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoBPPair;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.WrappedStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqEvent
implements Comparable<VsqEvent>,
Cloneable,
Serializable {
    public String Tag;
    public int InternalID;
    public int Clock;
    public VsqID ID;
    public UstEvent UstEvent = new UstEvent();

    public boolean equals(VsqEvent vsqEvent) {
        if (this.Clock != vsqEvent.Clock) {
            return false;
        }
        if (this.ID.type != vsqEvent.ID.type) {
            return false;
        }
        if (this.ID.type == VsqIDType.Anote) {
            if (this.ID.Note != vsqEvent.ID.Note) {
                return false;
            }
            if (this.ID.getLength() != vsqEvent.ID.getLength()) {
                return false;
            }
            if (this.ID.d4mean != vsqEvent.ID.d4mean) {
                return false;
            }
            if (this.ID.DEMaccent != vsqEvent.ID.DEMaccent) {
                return false;
            }
            if (this.ID.DEMdecGainRate != vsqEvent.ID.DEMdecGainRate) {
                return false;
            }
            if (this.ID.Dynamics != vsqEvent.ID.Dynamics) {
                return false;
            }
            if (this.ID.LyricHandle == null && vsqEvent.ID.LyricHandle != null) {
                return false;
            }
            if (this.ID.LyricHandle != null && vsqEvent.ID.LyricHandle == null) {
                return false;
            }
            if (this.ID.LyricHandle != null && vsqEvent.ID.LyricHandle != null) {
                if (!this.ID.LyricHandle.L0.equalsForSynth(vsqEvent.ID.LyricHandle.L0)) {
                    return false;
                }
                int n = this.ID.LyricHandle.Trailing.size();
                if (n != vsqEvent.ID.LyricHandle.Trailing.size()) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.ID.LyricHandle.Trailing.get(i).equalsForSynth(vsqEvent.ID.LyricHandle.Trailing.get(i))) continue;
                    return false;
                }
            }
            if (this.ID.NoteHeadHandle == null && vsqEvent.ID.NoteHeadHandle != null) {
                return false;
            }
            if (this.ID.NoteHeadHandle != null && vsqEvent.ID.NoteHeadHandle == null) {
                return false;
            }
            if (this.ID.NoteHeadHandle != null && vsqEvent.ID.NoteHeadHandle != null) {
                if (!this.ID.NoteHeadHandle.IconID.equals(vsqEvent.ID.NoteHeadHandle.IconID)) {
                    return false;
                }
                if (this.ID.NoteHeadHandle.getDepth() != vsqEvent.ID.NoteHeadHandle.getDepth()) {
                    return false;
                }
                if (this.ID.NoteHeadHandle.getDuration() != vsqEvent.ID.NoteHeadHandle.getDuration()) {
                    return false;
                }
                if (this.ID.NoteHeadHandle.getLength() != vsqEvent.ID.NoteHeadHandle.getLength()) {
                    return false;
                }
            }
            if (this.ID.PMBendDepth != vsqEvent.ID.PMBendDepth) {
                return false;
            }
            if (this.ID.PMBendLength != vsqEvent.ID.PMBendLength) {
                return false;
            }
            if (this.ID.PMbPortamentoUse != vsqEvent.ID.PMbPortamentoUse) {
                return false;
            }
            if (this.ID.pMeanEndingNote != vsqEvent.ID.pMeanEndingNote) {
                return false;
            }
            if (this.ID.pMeanOnsetFirstNote != vsqEvent.ID.pMeanOnsetFirstNote) {
                return false;
            }
            VibratoHandle vibratoHandle = this.ID.VibratoHandle;
            VibratoHandle vibratoHandle2 = vsqEvent.ID.VibratoHandle;
            if (vibratoHandle == null && vibratoHandle2 != null) {
                return false;
            }
            if (vibratoHandle != null && vibratoHandle2 == null) {
                return false;
            }
            if (vibratoHandle != null && vibratoHandle2 != null) {
                if (this.ID.VibratoDelay != vsqEvent.ID.VibratoDelay) {
                    return false;
                }
                if (!vibratoHandle.IconID.equals(vibratoHandle2.IconID)) {
                    return false;
                }
                if (vibratoHandle.getStartDepth() != vibratoHandle2.getStartDepth()) {
                    return false;
                }
                if (vibratoHandle.getStartRate() != vibratoHandle2.getStartRate()) {
                    return false;
                }
                VibratoBPList vibratoBPList = vibratoHandle.getRateBP();
                VibratoBPList vibratoBPList2 = vibratoHandle2.getRateBP();
                if (vibratoBPList == null && vibratoBPList2 != null) {
                    return false;
                }
                if (vibratoBPList != null && vibratoBPList2 == null) {
                    return false;
                }
                if (vibratoBPList != null && vibratoBPList2 != null) {
                    int n = vibratoBPList.getCount();
                    if (n != vibratoBPList2.getCount()) {
                        return false;
                    }
                    for (int i = 0; i < n; ++i) {
                        VibratoBPPair vibratoBPPair = vibratoBPList.getElement(i);
                        VibratoBPPair vibratoBPPair2 = vibratoBPList2.getElement(i);
                        if (vibratoBPPair.X != vibratoBPPair2.X) {
                            return false;
                        }
                        if (vibratoBPPair.Y == vibratoBPPair2.Y) continue;
                        return false;
                    }
                }
                VibratoBPList vibratoBPList3 = vibratoHandle.getDepthBP();
                VibratoBPList vibratoBPList4 = vibratoHandle2.getDepthBP();
                if (vibratoBPList3 == null && vibratoBPList4 != null) {
                    return false;
                }
                if (vibratoBPList3 != null && vibratoBPList4 == null) {
                    return false;
                }
                if (vibratoBPList3 != null && vibratoBPList4 != null) {
                    int n = vibratoBPList3.getCount();
                    if (n != vibratoBPList4.getCount()) {
                        return false;
                    }
                    for (int i = 0; i < n; ++i) {
                        VibratoBPPair vibratoBPPair = vibratoBPList3.getElement(i);
                        VibratoBPPair vibratoBPPair3 = vibratoBPList4.getElement(i);
                        if (vibratoBPPair.X != vibratoBPPair3.X) {
                            return false;
                        }
                        if (vibratoBPPair.Y == vibratoBPPair3.Y) continue;
                        return false;
                    }
                }
            }
            if (this.ID.vMeanNoteTransition != vsqEvent.ID.vMeanNoteTransition) {
                return false;
            }
        } else if (this.ID.type == VsqIDType.Singer) {
            if (this.ID.IconHandle.Program != vsqEvent.ID.IconHandle.Program) {
                return false;
            }
        } else if (this.ID.type == VsqIDType.Aicon) {
            if (!this.ID.IconDynamicsHandle.IconID.equals(vsqEvent.ID.IconDynamicsHandle.IconID)) {
                return false;
            }
            if (!this.ID.IconDynamicsHandle.isDynaffType() && this.ID.getLength() != vsqEvent.ID.getLength()) {
                return false;
            }
        }
        return true;
    }

    public void write(ITextWriter iTextWriter) throws IOException {
        Vector<String> vector = new Vector<String>(Arrays.asList("Length", "Note#", "Dynamics", "PMBendDepth", "PMBendLength", "PMbPortamentoUse", "DEMdecGainRate", "DEMaccent"));
        this.write(iTextWriter, vector);
    }

    public void write(ITextWriter iTextWriter, Vector<String> vector) throws IOException {
        this.writeCor(iTextWriter, vector);
    }

    public void write(BufferedWriter bufferedWriter, Vector<String> vector) throws IOException {
        this.writeCor(new WrappedStreamWriter(bufferedWriter), vector);
    }

    private void writeCor(ITextWriter iTextWriter, Vector<String> vector) throws IOException {
        iTextWriter.writeLine("[ID#" + PortUtil.formatDecimal("0000", this.ID.value) + "]");
        iTextWriter.writeLine("Type=" + (Object)((Object)this.ID.type));
        if (this.ID.type == VsqIDType.Anote) {
            if (vector.contains("Length")) {
                iTextWriter.writeLine("Length=" + this.ID.getLength());
            }
            if (vector.contains("Note#")) {
                iTextWriter.writeLine("Note#=" + this.ID.Note);
            }
            if (vector.contains("Dynamics")) {
                iTextWriter.writeLine("Dynamics=" + this.ID.Dynamics);
            }
            if (vector.contains("PMBendDepth")) {
                iTextWriter.writeLine("PMBendDepth=" + this.ID.PMBendDepth);
            }
            if (vector.contains("PMBendLength")) {
                iTextWriter.writeLine("PMBendLength=" + this.ID.PMBendLength);
            }
            if (vector.contains("PMbPortamentoUse")) {
                iTextWriter.writeLine("PMbPortamentoUse=" + this.ID.PMbPortamentoUse);
            }
            if (vector.contains("DEMdecGainRate")) {
                iTextWriter.writeLine("DEMdecGainRate=" + this.ID.DEMdecGainRate);
            }
            if (vector.contains("DEMaccent")) {
                iTextWriter.writeLine("DEMaccent=" + this.ID.DEMaccent);
            }
            if (vector.contains("PreUtterance")) {
                iTextWriter.writeLine("PreUtterance=" + this.UstEvent.PreUtterance);
            }
            if (vector.contains("VoiceOverlap")) {
                iTextWriter.writeLine("VoiceOverlap=" + this.UstEvent.VoiceOverlap);
            }
            if (this.ID.LyricHandle != null) {
                iTextWriter.writeLine("LyricHandle=h#" + PortUtil.formatDecimal("0000", this.ID.LyricHandle_index));
            }
            if (this.ID.VibratoHandle != null) {
                iTextWriter.writeLine("VibratoHandle=h#" + PortUtil.formatDecimal("0000", this.ID.VibratoHandle_index));
                iTextWriter.writeLine("VibratoDelay=" + this.ID.VibratoDelay);
            }
            if (this.ID.NoteHeadHandle != null) {
                iTextWriter.writeLine("NoteHeadHandle=h#" + PortUtil.formatDecimal("0000", this.ID.NoteHeadHandle_index));
            }
        } else if (this.ID.type == VsqIDType.Singer) {
            iTextWriter.writeLine("IconHandle=h#" + PortUtil.formatDecimal("0000", this.ID.IconHandle_index));
        } else if (this.ID.type == VsqIDType.Aicon) {
            iTextWriter.writeLine("IconHandle=h#" + PortUtil.formatDecimal("0000", this.ID.IconHandle_index));
            iTextWriter.writeLine("Note#=" + this.ID.Note);
        }
    }

    public Object clone() {
        VsqEvent vsqEvent = new VsqEvent(this.Clock, (VsqID)this.ID.clone());
        vsqEvent.InternalID = this.InternalID;
        if (this.UstEvent != null) {
            vsqEvent.UstEvent = (UstEvent)this.UstEvent.clone();
        }
        vsqEvent.Tag = this.Tag;
        return vsqEvent;
    }

    @Override
    public int compareTo(VsqEvent vsqEvent) {
        int n = this.Clock - vsqEvent.Clock;
        if (n == 0) {
            if (this.ID != null && vsqEvent.ID != null) {
                return this.ID.type.ordinal() - vsqEvent.ID.type.ordinal();
            }
            return n;
        }
        return n;
    }

    public VsqEvent(String string) {
        String[] stringArray = PortUtil.splitString(string, '=');
        this.Clock = PortUtil.parseInt(stringArray[0]);
        if (stringArray[1].equals("EOS")) {
            this.ID = VsqID.EOS;
        }
    }

    public VsqEvent() {
        this(0, new VsqID());
    }

    public VsqEvent(int n, VsqID vsqID) {
        this.Clock = n;
        this.ID = vsqID;
        this.InternalID = 0;
    }
}

