/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.kbinani.vsq.VsqEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqEventList
implements Serializable {
    public Vector<VsqEvent> Events = new Vector();
    private Vector<Integer> m_ids = new Vector();

    public VsqEvent findFromID(int n) {
        for (VsqEvent vsqEvent : this.Events) {
            if (vsqEvent.InternalID != n) continue;
            return vsqEvent;
        }
        return null;
    }

    public void setForID(int n, VsqEvent vsqEvent) {
        int n2 = this.Events.size();
        for (int i = 0; i < n2; ++i) {
            if (this.Events.get((int)i).InternalID != n) continue;
            this.Events.set(i, vsqEvent);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        VsqEventList vsqEventList = this;
        synchronized (vsqEventList) {
            Collections.sort(this.Events);
            this.updateIDList();
        }
    }

    public void clear() {
        this.Events.clear();
        this.m_ids.clear();
    }

    public Iterator<VsqEvent> iterator() {
        this.updateIDList();
        return this.Events.iterator();
    }

    public void add(VsqEvent vsqEvent) {
        this.add(vsqEvent, this.getNextId(0));
        Collections.sort(this.Events);
        int n = this.Events.size();
        for (int i = 0; i < n; ++i) {
            this.m_ids.set(i, this.Events.get((int)i).InternalID);
        }
    }

    public void add(VsqEvent vsqEvent, int n) {
        this.updateIDList();
        vsqEvent.InternalID = n;
        this.Events.add(vsqEvent);
        this.m_ids.add(n);
    }

    public void removeAt(int n) {
        this.updateIDList();
        this.Events.removeElementAt(n);
        this.m_ids.removeElementAt(n);
    }

    private int getNextId(int n) {
        this.updateIDList();
        int n2 = -1;
        Vector<Integer> vector = new Vector<Integer>(this.m_ids);
        int n3 = 0;
        while (true) {
            if (vector.contains(++n2)) {
                continue;
            }
            if (++n3 == n + 1) {
                return n2;
            }
            vector.add(n2);
        }
    }

    public int getCount() {
        return this.Events.size();
    }

    public VsqEvent getElement(int n) {
        return this.Events.get(n);
    }

    public void setElement(int n, VsqEvent vsqEvent) {
        vsqEvent.InternalID = this.Events.get((int)n).InternalID;
        this.Events.set(n, vsqEvent);
    }

    public void updateIDList() {
        if (this.m_ids.size() != this.Events.size()) {
            this.m_ids.clear();
            int n = this.Events.size();
            for (int i = 0; i < n; ++i) {
                this.m_ids.add(this.Events.get((int)i).InternalID);
            }
        } else {
            int n = this.Events.size();
            for (int i = 0; i < n; ++i) {
                this.m_ids.set(i, this.Events.get((int)i).InternalID);
            }
        }
    }
}

