/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqCommon;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqEventList;
import org.kbinani.vsq.VsqHandle;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqMaster;
import org.kbinani.vsq.VsqMixer;
import org.kbinani.vsq.VsqVoiceLanguage;
import org.kbinani.vsq.WrappedStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqMetaText
implements Cloneable,
Serializable {
    public VsqCommon Common;
    public VsqMaster master;
    public VsqMixer mixer;
    public VsqEventList Events;
    public VsqBPList PIT;
    public VsqBPList PBS;
    public VsqBPList DYN;
    public VsqBPList BRE;
    public VsqBPList BRI;
    public VsqBPList CLE;
    public VsqBPList reso1FreqBPList;
    public VsqBPList reso2FreqBPList;
    public VsqBPList reso3FreqBPList;
    public VsqBPList reso4FreqBPList;
    public VsqBPList reso1BWBPList;
    public VsqBPList reso2BWBPList;
    public VsqBPList reso3BWBPList;
    public VsqBPList reso4BWBPList;
    public VsqBPList reso1AmpBPList;
    public VsqBPList reso2AmpBPList;
    public VsqBPList reso3AmpBPList;
    public VsqBPList reso4AmpBPList;
    public VsqBPList harmonics;
    public VsqBPList fx2depth;
    public VsqBPList GEN;
    public VsqBPList POR;
    public VsqBPList OPE;

    public Object clone() {
        VsqMetaText vsqMetaText = new VsqMetaText();
        if (this.Common != null) {
            vsqMetaText.Common = (VsqCommon)this.Common.clone();
        }
        if (this.master != null) {
            vsqMetaText.master = (VsqMaster)this.master.clone();
        }
        if (this.mixer != null) {
            vsqMetaText.mixer = (VsqMixer)this.mixer.clone();
        }
        if (this.Events != null) {
            vsqMetaText.Events = new VsqEventList();
            Iterator<VsqEvent> iterator = this.Events.iterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                vsqMetaText.Events.add((VsqEvent)vsqEvent.clone(), vsqEvent.InternalID);
            }
        }
        if (this.PIT != null) {
            vsqMetaText.PIT = (VsqBPList)this.PIT.clone();
        }
        if (this.PBS != null) {
            vsqMetaText.PBS = (VsqBPList)this.PBS.clone();
        }
        if (this.DYN != null) {
            vsqMetaText.DYN = (VsqBPList)this.DYN.clone();
        }
        if (this.BRE != null) {
            vsqMetaText.BRE = (VsqBPList)this.BRE.clone();
        }
        if (this.BRI != null) {
            vsqMetaText.BRI = (VsqBPList)this.BRI.clone();
        }
        if (this.CLE != null) {
            vsqMetaText.CLE = (VsqBPList)this.CLE.clone();
        }
        if (this.reso1FreqBPList != null) {
            vsqMetaText.reso1FreqBPList = (VsqBPList)this.reso1FreqBPList.clone();
        }
        if (this.reso2FreqBPList != null) {
            vsqMetaText.reso2FreqBPList = (VsqBPList)this.reso2FreqBPList.clone();
        }
        if (this.reso3FreqBPList != null) {
            vsqMetaText.reso3FreqBPList = (VsqBPList)this.reso3FreqBPList.clone();
        }
        if (this.reso4FreqBPList != null) {
            vsqMetaText.reso4FreqBPList = (VsqBPList)this.reso4FreqBPList.clone();
        }
        if (this.reso1BWBPList != null) {
            vsqMetaText.reso1BWBPList = (VsqBPList)this.reso1BWBPList.clone();
        }
        if (this.reso2BWBPList != null) {
            vsqMetaText.reso2BWBPList = (VsqBPList)this.reso2BWBPList.clone();
        }
        if (this.reso3BWBPList != null) {
            vsqMetaText.reso3BWBPList = (VsqBPList)this.reso3BWBPList.clone();
        }
        if (this.reso4BWBPList != null) {
            vsqMetaText.reso4BWBPList = (VsqBPList)this.reso4BWBPList.clone();
        }
        if (this.reso1AmpBPList != null) {
            vsqMetaText.reso1AmpBPList = (VsqBPList)this.reso1AmpBPList.clone();
        }
        if (this.reso2AmpBPList != null) {
            vsqMetaText.reso2AmpBPList = (VsqBPList)this.reso2AmpBPList.clone();
        }
        if (this.reso3AmpBPList != null) {
            vsqMetaText.reso3AmpBPList = (VsqBPList)this.reso3AmpBPList.clone();
        }
        if (this.reso4AmpBPList != null) {
            vsqMetaText.reso4AmpBPList = (VsqBPList)this.reso4AmpBPList.clone();
        }
        if (this.harmonics != null) {
            vsqMetaText.harmonics = (VsqBPList)this.harmonics.clone();
        }
        if (this.fx2depth != null) {
            vsqMetaText.fx2depth = (VsqBPList)this.fx2depth.clone();
        }
        if (this.GEN != null) {
            vsqMetaText.GEN = (VsqBPList)this.GEN.clone();
        }
        if (this.POR != null) {
            vsqMetaText.POR = (VsqBPList)this.POR.clone();
        }
        if (this.OPE != null) {
            vsqMetaText.OPE = (VsqBPList)this.OPE.clone();
        }
        return vsqMetaText;
    }

    public VsqEventList getEventList() {
        return this.Events;
    }

    public VsqBPList getElement(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.equals("bre")) {
            return this.BRE;
        }
        if (string2.equals("bri")) {
            return this.BRI;
        }
        if (string2.equals("cle")) {
            return this.CLE;
        }
        if (string2.equals("dyn")) {
            return this.DYN;
        }
        if (string2.equals("gen")) {
            return this.GEN;
        }
        if (string2.equals("ope")) {
            return this.OPE;
        }
        if (string2.equals("pbs")) {
            return this.PBS;
        }
        if (string2.equals("pit")) {
            return this.PIT;
        }
        if (string2.equals("por")) {
            return this.POR;
        }
        if (string2.equals("harmonics")) {
            return this.harmonics;
        }
        if (string2.equals("fx2depth")) {
            return this.fx2depth;
        }
        if (string2.equals("reso1amp")) {
            return this.reso1AmpBPList;
        }
        if (string2.equals("reso1bw")) {
            return this.reso1BWBPList;
        }
        if (string2.equals("reso1freq")) {
            return this.reso1FreqBPList;
        }
        if (string2.equals("reso2amp")) {
            return this.reso2AmpBPList;
        }
        if (string2.equals("reso2bw")) {
            return this.reso2BWBPList;
        }
        if (string2.equals("reso2freq")) {
            return this.reso2FreqBPList;
        }
        if (string2.equals("reso3amp")) {
            return this.reso3AmpBPList;
        }
        if (string2.equals("reso3bw")) {
            return this.reso3BWBPList;
        }
        if (string2.equals("reso3freq")) {
            return this.reso3FreqBPList;
        }
        if (string2.equals("reso4amp")) {
            return this.reso4AmpBPList;
        }
        if (string2.equals("reso4bw")) {
            return this.reso4BWBPList;
        }
        if (string2.equals("reso4freq")) {
            return this.reso4FreqBPList;
        }
        return null;
    }

    public void setElement(String string, VsqBPList vsqBPList) {
        String string2 = string.trim().toLowerCase();
        if (string2.equals("bre")) {
            this.BRE = vsqBPList;
        } else if (string2.equals("bri")) {
            this.BRI = vsqBPList;
        } else if (string2.equals("cle")) {
            this.CLE = vsqBPList;
        } else if (string2.equals("dyn")) {
            this.DYN = vsqBPList;
        } else if (string2.equals("gen")) {
            this.GEN = vsqBPList;
        } else if (string2.equals("ope")) {
            this.OPE = vsqBPList;
        } else if (string2.equals("pbs")) {
            this.PBS = vsqBPList;
        } else if (string2.equals("pit")) {
            this.PIT = vsqBPList;
        } else if (string2.equals("por")) {
            this.POR = vsqBPList;
        } else if (string2.equals("harmonics")) {
            this.harmonics = vsqBPList;
        } else if (string2.equals("fx2depth")) {
            this.fx2depth = vsqBPList;
        } else if (string2.equals("reso1amp")) {
            this.reso1AmpBPList = vsqBPList;
        } else if (string2.equals("reso1bw")) {
            this.reso1BWBPList = vsqBPList;
        } else if (string2.equals("reso1freq")) {
            this.reso1FreqBPList = vsqBPList;
        } else if (string2.equals("reso2amp")) {
            this.reso2AmpBPList = vsqBPList;
        } else if (string2.equals("reso2bw")) {
            this.reso2BWBPList = vsqBPList;
        } else if (string2.equals("reso2freq")) {
            this.reso2FreqBPList = vsqBPList;
        } else if (string2.equals("reso3amp")) {
            this.reso3AmpBPList = vsqBPList;
        } else if (string2.equals("reso3bw")) {
            this.reso3BWBPList = vsqBPList;
        } else if (string2.equals("reso3freq")) {
            this.reso3FreqBPList = vsqBPList;
        } else if (string2.equals("reso4amp")) {
            this.reso4AmpBPList = vsqBPList;
        } else if (string2.equals("reso4bw")) {
            this.reso4BWBPList = vsqBPList;
        } else if (string2.equals("reso4freq")) {
            this.reso4FreqBPList = vsqBPList;
        }
    }

    public VsqBPList getCurve(int n) {
        switch (n) {
            case 1: {
                return this.DYN;
            }
            case 2: {
                return this.BRE;
            }
            case 3: {
                return this.BRI;
            }
            case 4: {
                return this.CLE;
            }
            case 5: {
                return this.OPE;
            }
            case 6: {
                return this.GEN;
            }
            case 7: {
                return this.POR;
            }
            case 8: {
                return this.PIT;
            }
            case 9: {
                return this.PBS;
            }
        }
        return null;
    }

    public static String getCurveName(int n) {
        switch (n) {
            case 0: {
                return "VEL";
            }
            case 1: {
                return "DYN";
            }
            case 2: {
                return "BRE";
            }
            case 3: {
                return "BRI";
            }
            case 4: {
                return "CLE";
            }
            case 5: {
                return "OPE";
            }
            case 6: {
                return "GEN";
            }
            case 7: {
                return "POR";
            }
            case 8: {
                return "PIT";
            }
            case 9: {
                return "PBS";
            }
        }
        return "";
    }

    public String getSinger() {
        Iterator<VsqEvent> iterator = this.Events.iterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            if (vsqEvent.ID.type != VsqIDType.Singer) continue;
            return vsqEvent.ID.IconHandle.IDS;
        }
        return "";
    }

    public void setSinger(String string) {
        Iterator<VsqEvent> iterator = this.Events.iterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            if (vsqEvent.ID.type != VsqIDType.Singer) continue;
            vsqEvent.ID.IconHandle.IDS = string;
            break;
        }
    }

    public int getIndexOfEOS() {
        int n;
        if (this.Events.getCount() > 0) {
            int n2 = this.Events.getCount() - 1;
            n = this.Events.getElement((int)n2).Clock;
        } else {
            n = -1;
        }
        return n;
    }

    private Vector<VsqHandle> buildHandleList() {
        Vector<VsqHandle> vector = new Vector<VsqHandle>();
        int n = -1;
        int n2 = -1;
        boolean bl = true;
        boolean bl2 = this.Common.Version.startsWith("DSB2");
        boolean bl3 = this.Common.Version.startsWith("DSB3");
        Iterator<VsqEvent> iterator = this.Events.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            VsqEvent vsqEvent = iterator.next();
            vsqEvent.ID.value = ++n;
            if (vsqEvent.ID.IconHandle != null && vsqEvent.ID.IconHandle instanceof IconHandle) {
                VsqVoiceLanguage vsqVoiceLanguage;
                serializable = vsqEvent.ID.IconHandle;
                VsqHandle vsqHandle = ((IconHandle)serializable).castToVsqHandle();
                vsqHandle.Index = ++n2;
                vector.add(vsqHandle);
                vsqEvent.ID.IconHandle_index = n2;
                if (bl2) {
                    vsqVoiceLanguage = VocaloSysUtil.getLanguageFromName(((IconHandle)serializable).IDS);
                    bl = vsqVoiceLanguage == VsqVoiceLanguage.Japanese;
                } else if (bl3) {
                    vsqVoiceLanguage = VocaloSysUtil.getLanguageFromName(((IconHandle)serializable).IDS);
                    boolean bl4 = bl = vsqVoiceLanguage == VsqVoiceLanguage.Japanese;
                }
            }
            if (vsqEvent.ID.LyricHandle != null) {
                serializable = vsqEvent.ID.LyricHandle.castToVsqHandle();
                ((VsqHandle)serializable).Index = ++n2;
                ((VsqHandle)serializable).addQuotationMark = bl;
                vector.add((VsqHandle)serializable);
                vsqEvent.ID.LyricHandle_index = n2;
            }
            if (vsqEvent.ID.VibratoHandle != null) {
                serializable = vsqEvent.ID.VibratoHandle.castToVsqHandle();
                ((VsqHandle)serializable).Index = ++n2;
                vector.add((VsqHandle)serializable);
                vsqEvent.ID.VibratoHandle_index = n2;
            }
            if (vsqEvent.ID.NoteHeadHandle != null) {
                serializable = vsqEvent.ID.NoteHeadHandle.castToVsqHandle();
                ((VsqHandle)serializable).Index = ++n2;
                vector.add((VsqHandle)serializable);
                vsqEvent.ID.NoteHeadHandle_index = n2;
            }
            if (vsqEvent.ID.IconDynamicsHandle == null) continue;
            serializable = vsqEvent.ID.IconDynamicsHandle.castToVsqHandle();
            ((VsqHandle)serializable).Index = ++n2;
            ((VsqHandle)serializable).setLength(vsqEvent.ID.getLength());
            vector.add((VsqHandle)serializable);
            vsqEvent.ID.IconHandle_index = n2;
        }
        return vector;
    }

    public void print(ITextWriter iTextWriter, int n, int n2) throws IOException {
        if (this.Common != null) {
            this.Common.write(iTextWriter);
        }
        if (this.master != null) {
            this.master.write(iTextWriter);
        }
        if (this.mixer != null) {
            this.mixer.write(iTextWriter);
        }
        Vector<VsqHandle> vector = this.writeEventList(iTextWriter, n);
        Iterator<VsqEvent> iterator = this.Events.iterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            vsqEvent.write(iTextWriter);
        }
        for (int i = 0; i < vector.size(); ++i) {
            vector.get(i).write(iTextWriter);
        }
        String string = this.Common.Version;
        if (this.PIT.size() > 0) {
            this.PIT.print(iTextWriter, n2, "[PitchBendBPList]");
        }
        if (this.PBS.size() > 0) {
            this.PBS.print(iTextWriter, n2, "[PitchBendSensBPList]");
        }
        if (this.DYN.size() > 0) {
            this.DYN.print(iTextWriter, n2, "[DynamicsBPList]");
        }
        if (this.BRE.size() > 0) {
            this.BRE.print(iTextWriter, n2, "[EpRResidualBPList]");
        }
        if (this.BRI.size() > 0) {
            this.BRI.print(iTextWriter, n2, "[EpRESlopeBPList]");
        }
        if (this.CLE.size() > 0) {
            this.CLE.print(iTextWriter, n2, "[EpRESlopeDepthBPList]");
        }
        if (string.startsWith("DSB2")) {
            if (this.harmonics.size() > 0) {
                this.harmonics.print(iTextWriter, n2, "[EpRSineBPList]");
            }
            if (this.fx2depth.size() > 0) {
                this.fx2depth.print(iTextWriter, n2, "[VibTremDepthBPList]");
            }
            if (this.reso1FreqBPList.size() > 0) {
                this.reso1FreqBPList.print(iTextWriter, n2, "[Reso1FreqBPList]");
            }
            if (this.reso2FreqBPList.size() > 0) {
                this.reso2FreqBPList.print(iTextWriter, n2, "[Reso2FreqBPList]");
            }
            if (this.reso3FreqBPList.size() > 0) {
                this.reso3FreqBPList.print(iTextWriter, n2, "[Reso3FreqBPList]");
            }
            if (this.reso4FreqBPList.size() > 0) {
                this.reso4FreqBPList.print(iTextWriter, n2, "[Reso4FreqBPList]");
            }
            if (this.reso1BWBPList.size() > 0) {
                this.reso1BWBPList.print(iTextWriter, n2, "[Reso1BWBPList]");
            }
            if (this.reso2BWBPList.size() > 0) {
                this.reso2BWBPList.print(iTextWriter, n2, "[Reso2BWBPList]");
            }
            if (this.reso3BWBPList.size() > 0) {
                this.reso3BWBPList.print(iTextWriter, n2, "[Reso3BWBPList]");
            }
            if (this.reso4BWBPList.size() > 0) {
                this.reso4BWBPList.print(iTextWriter, n2, "[Reso4BWBPList]");
            }
            if (this.reso1AmpBPList.size() > 0) {
                this.reso1AmpBPList.print(iTextWriter, n2, "[Reso1AmpBPList]");
            }
            if (this.reso2AmpBPList.size() > 0) {
                this.reso2AmpBPList.print(iTextWriter, n2, "[Reso2AmpBPList]");
            }
            if (this.reso3AmpBPList.size() > 0) {
                this.reso3AmpBPList.print(iTextWriter, n2, "[Reso3AmpBPList]");
            }
            if (this.reso4AmpBPList.size() > 0) {
                this.reso4AmpBPList.print(iTextWriter, n2, "[Reso4AmpBPList]");
            }
        }
        if (this.GEN.size() > 0) {
            this.GEN.print(iTextWriter, n2, "[GenderFactorBPList]");
        }
        if (this.POR.size() > 0) {
            this.POR.print(iTextWriter, n2, "[PortamentoTimingBPList]");
        }
        if (string.startsWith("DSB3") && this.OPE.size() > 0) {
            this.OPE.print(iTextWriter, n2, "[OpeningBPList]");
        }
    }

    private Vector<VsqHandle> writeEventListCor(ITextWriter iTextWriter, int n) throws IOException {
        Vector<VsqHandle> vector = this.buildHandleList();
        iTextWriter.writeLine("[EventList]");
        Vector<VsqEvent> vector2 = new Vector<VsqEvent>();
        Iterator<VsqEvent> iterator = this.Events.iterator();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Collections.sort(vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            VsqEvent vsqEvent = (VsqEvent)vector2.get(i);
            if (vsqEvent.ID.equals(VsqID.EOS)) continue;
            String string = "ID#" + PortUtil.formatDecimal("0000", vsqEvent.ID.value);
            int n2 = ((VsqEvent)vector2.get((int)i)).Clock;
            while (i + 1 < vector2.size() && n2 == ((VsqEvent)vector2.get((int)(i + 1))).Clock) {
                string = string + ",ID#" + PortUtil.formatDecimal("0000", ((VsqEvent)vector2.get((int)(++i + 1))).ID.value);
            }
            iTextWriter.writeLine(n2 + "=" + string);
        }
        iTextWriter.writeLine(n + "=EOS");
        return vector;
    }

    public Vector<VsqHandle> writeEventList(ITextWriter iTextWriter, int n) throws IOException {
        return this.writeEventListCor(iTextWriter, n);
    }

    public Vector<VsqHandle> writeEventList(BufferedWriter bufferedWriter, int n) throws IOException {
        return this.writeEventListCor(new WrappedStreamWriter(bufferedWriter), n);
    }

    public VsqMetaText() {
    }

    public VsqMetaText(String string, String string2) {
        this(string, 0, string2, false);
    }

    public VsqMetaText(String string, String string2, int n) {
        this(string, n, string2, true);
    }

    private VsqMetaText(String string, int n, String string2, boolean bl) {
        this.Common = new VsqCommon(string, 179, 181, 123, 1, 1);
        this.PIT = new VsqBPList("pit", 0, -8192, 8191);
        this.PBS = new VsqBPList("pbs", 2, 0, 24);
        this.DYN = new VsqBPList("dyn", 64, 0, 127);
        this.BRE = new VsqBPList("bre", 0, 0, 127);
        this.BRI = new VsqBPList("bri", 64, 0, 127);
        this.CLE = new VsqBPList("cle", 0, 0, 127);
        this.reso1FreqBPList = new VsqBPList("reso1freq", 64, 0, 127);
        this.reso2FreqBPList = new VsqBPList("reso2freq", 64, 0, 127);
        this.reso3FreqBPList = new VsqBPList("reso3freq", 64, 0, 127);
        this.reso4FreqBPList = new VsqBPList("reso4freq", 64, 0, 127);
        this.reso1BWBPList = new VsqBPList("reso1bw", 64, 0, 127);
        this.reso2BWBPList = new VsqBPList("reso2bw", 64, 0, 127);
        this.reso3BWBPList = new VsqBPList("reso3bw", 64, 0, 127);
        this.reso4BWBPList = new VsqBPList("reso4bw", 64, 0, 127);
        this.reso1AmpBPList = new VsqBPList("reso1amp", 64, 0, 127);
        this.reso2AmpBPList = new VsqBPList("reso2amp", 64, 0, 127);
        this.reso3AmpBPList = new VsqBPList("reso3amp", 64, 0, 127);
        this.reso4AmpBPList = new VsqBPList("reso4amp", 64, 0, 127);
        this.harmonics = new VsqBPList("harmonics", 64, 0, 127);
        this.fx2depth = new VsqBPList("fx2depth", 64, 0, 127);
        this.GEN = new VsqBPList("gen", 64, 0, 127);
        this.POR = new VsqBPList("por", 64, 0, 127);
        this.OPE = new VsqBPList("ope", 127, 0, 127);
        this.master = bl ? new VsqMaster(n) : null;
        this.Events = new VsqEventList();
        VsqID vsqID = new VsqID(0);
        vsqID.type = VsqIDType.Singer;
        IconHandle iconHandle = new IconHandle();
        iconHandle.IconID = "$07010000";
        iconHandle.IDS = string2;
        iconHandle.Original = 0;
        iconHandle.Caption = "";
        iconHandle.setLength(1);
        iconHandle.Language = 0;
        iconHandle.Program = 0;
        vsqID.IconHandle = iconHandle;
        this.Events.add(new VsqEvent(0, vsqID));
    }

    public VsqMetaText(TextStream textStream) {
        int n;
        int n2;
        Vector<ValuePair<Integer, Integer>> vector = new Vector<ValuePair<Integer, Integer>>();
        TreeMap<Integer, VsqID> treeMap = new TreeMap<Integer, VsqID>();
        TreeMap<Integer, VsqHandle> treeMap2 = new TreeMap<Integer, VsqHandle>();
        this.PIT = new VsqBPList("pit", 0, -8192, 8191);
        this.PBS = new VsqBPList("pbs", 2, 0, 24);
        this.DYN = new VsqBPList("dyn", 64, 0, 127);
        this.BRE = new VsqBPList("bre", 0, 0, 127);
        this.BRI = new VsqBPList("bri", 64, 0, 127);
        this.CLE = new VsqBPList("cle", 0, 0, 127);
        this.reso1FreqBPList = new VsqBPList("reso1freq", 64, 0, 127);
        this.reso2FreqBPList = new VsqBPList("reso2freq", 64, 0, 127);
        this.reso3FreqBPList = new VsqBPList("reso3freq", 64, 0, 127);
        this.reso4FreqBPList = new VsqBPList("reso4freq", 64, 0, 127);
        this.reso1BWBPList = new VsqBPList("reso1bw", 64, 0, 127);
        this.reso2BWBPList = new VsqBPList("reso2bw", 64, 0, 127);
        this.reso3BWBPList = new VsqBPList("reso3bw", 64, 0, 127);
        this.reso4BWBPList = new VsqBPList("reso4bw", 64, 0, 127);
        this.reso1AmpBPList = new VsqBPList("reso1amp", 64, 0, 127);
        this.reso2AmpBPList = new VsqBPList("reso2amp", 64, 0, 127);
        this.reso3AmpBPList = new VsqBPList("reso3amp", 64, 0, 127);
        this.reso4AmpBPList = new VsqBPList("reso4amp", 64, 0, 127);
        this.harmonics = new VsqBPList("harmonics", 64, 0, 127);
        this.fx2depth = new VsqBPList("fx2depth", 64, 0, 127);
        this.GEN = new VsqBPList("gen", 64, 0, 127);
        this.POR = new VsqBPList("por", 64, 0, 127);
        this.OPE = new VsqBPList("ope", 127, 0, 127);
        ByRef<String> byRef = new ByRef<String>(textStream.readLine());
        while (PortUtil.getStringLength((String)byRef.value) != 0) {
            int n3;
            Object object;
            if (((String)byRef.value).equals("[Common]")) {
                this.Common = new VsqCommon(textStream, byRef);
            } else if (((String)byRef.value).equals("[Master]")) {
                this.master = new VsqMaster(textStream, byRef);
            } else if (((String)byRef.value).equals("[Mixer]")) {
                this.mixer = new VsqMixer(textStream, byRef);
            } else if (((String)byRef.value).equals("[EventList]")) {
                byRef.value = textStream.readLine();
                while (!((String)byRef.value).startsWith("[")) {
                    object = PortUtil.splitString((String)byRef.value, '=');
                    n2 = PortUtil.parseInt(object[0]);
                    n3 = -1;
                    if (object[1] != "EOS") {
                        String[] stringArray = PortUtil.splitString(object[1], ',');
                        for (n = 0; n < stringArray.length; ++n) {
                            String[] stringArray2 = PortUtil.splitString(stringArray[n], '#');
                            n3 = PortUtil.parseInt(stringArray2[1]);
                            vector.add(new ValuePair<Integer, Integer>(n2, n3));
                        }
                    } else {
                        vector.add(new ValuePair<Integer, Integer>(n2, -1));
                    }
                    if (textStream.ready()) {
                        byRef.value = textStream.readLine();
                        continue;
                    }
                    break;
                }
            } else if (((String)byRef.value).equals("[PitchBendBPList]")) {
                byRef.value = this.PIT.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[PitchBendSensBPList]")) {
                byRef.value = this.PBS.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[DynamicsBPList]")) {
                byRef.value = this.DYN.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[EpRResidualBPList]")) {
                byRef.value = this.BRE.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[EpRESlopeBPList]")) {
                byRef.value = this.BRI.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[EpRESlopeDepthBPList]")) {
                byRef.value = this.CLE.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[EpRSineBPList]")) {
                byRef.value = this.harmonics.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[VibTremDepthBPList]")) {
                byRef.value = this.fx2depth.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso1FreqBPList]")) {
                byRef.value = this.reso1FreqBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso2FreqBPList]")) {
                byRef.value = this.reso2FreqBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso3FreqBPList]")) {
                byRef.value = this.reso3FreqBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso4FreqBPList]")) {
                byRef.value = this.reso4FreqBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso1BWBPList]")) {
                byRef.value = this.reso1BWBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso2BWBPList]")) {
                byRef.value = this.reso2BWBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso3BWBPList]")) {
                byRef.value = this.reso3BWBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso4BWBPList]")) {
                byRef.value = this.reso4BWBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso1AmpBPList]")) {
                byRef.value = this.reso1AmpBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso2AmpBPList]")) {
                byRef.value = this.reso2AmpBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso3AmpBPList]")) {
                byRef.value = this.reso3AmpBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[Reso4AmpBPList]")) {
                byRef.value = this.reso4AmpBPList.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[GenderFactorBPList]")) {
                byRef.value = this.GEN.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[PortamentoTimingBPList]")) {
                byRef.value = this.POR.appendFromText(textStream);
            } else if (((String)byRef.value).equals("[OpeningBPList]")) {
                byRef.value = this.OPE.appendFromText(textStream);
            } else {
                object = (String)byRef.value;
                object = ((String)object).replace("[", "");
                object = ((String)object).replace("]", "");
                String[] stringArray = PortUtil.splitString((String)object, '#');
                n3 = PortUtil.parseInt(stringArray[1]);
                if (((String)byRef.value).startsWith("[ID#")) {
                    treeMap.put(n3, new VsqID(textStream, n3, byRef));
                } else if (((String)byRef.value).startsWith("[h#")) {
                    treeMap2.put(n3, new VsqHandle(textStream, n3, byRef));
                }
            }
            if (textStream.ready()) continue;
        }
        int n4 = treeMap.size();
        for (n2 = 0; n2 < n4; ++n2) {
            VsqID vsqID = (VsqID)treeMap.get(n2);
            if (treeMap2.containsKey(vsqID.IconHandle_index)) {
                if (vsqID.type == VsqIDType.Singer) {
                    vsqID.IconHandle = ((VsqHandle)treeMap2.get(vsqID.IconHandle_index)).castToIconHandle();
                } else if (vsqID.type == VsqIDType.Aicon) {
                    vsqID.IconDynamicsHandle = ((VsqHandle)treeMap2.get(vsqID.IconHandle_index)).castToIconDynamicsHandle();
                }
            }
            if (treeMap2.containsKey(vsqID.LyricHandle_index)) {
                vsqID.LyricHandle = ((VsqHandle)treeMap2.get(vsqID.LyricHandle_index)).castToLyricHandle();
            }
            if (treeMap2.containsKey(vsqID.VibratoHandle_index)) {
                vsqID.VibratoHandle = ((VsqHandle)treeMap2.get(vsqID.VibratoHandle_index)).castToVibratoHandle();
            }
            if (!treeMap2.containsKey(vsqID.NoteHeadHandle_index)) continue;
            vsqID.NoteHeadHandle = ((VsqHandle)treeMap2.get(vsqID.NoteHeadHandle_index)).castToNoteHeadHandle();
        }
        this.Events = new VsqEventList();
        n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n5 = (Integer)((ValuePair)vector.get(i)).getKey();
            n = (Integer)((ValuePair)vector.get(i)).getValue();
            if (!treeMap.containsKey(n)) continue;
            this.Events.add(new VsqEvent(n5, (VsqID)((VsqID)treeMap.get(n)).clone()), ++n2);
        }
        this.Events.sort();
        if (this.Common == null) {
            this.Common = new VsqCommon();
        }
    }
}

