/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.MidiEvent;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoBPPair;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqCommon;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqEventList;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqMaster;
import org.kbinani.vsq.VsqMetaText;
import org.kbinani.vsq.VsqMixer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqTrack
implements Cloneable,
Serializable {
    public String Tag;
    public VsqMetaText MetaText;

    public Iterator<Integer> indexIterator(int n) {
        if (this.MetaText == null) {
            return new IndexIterator(new VsqEventList(), n);
        }
        return new IndexIterator(this.MetaText.getEventList(), n);
    }

    public int getPlayMode() {
        if (this.MetaText == null) {
            return 1;
        }
        if (this.MetaText.Common == null) {
            return 1;
        }
        if (this.MetaText.Common.LastPlayMode != 0 && this.MetaText.Common.LastPlayMode != 1) {
            this.MetaText.Common.LastPlayMode = 1;
        }
        return this.MetaText.Common.LastPlayMode;
    }

    public void setPlayMode(int n) {
        if (this.MetaText == null) {
            return;
        }
        if (this.MetaText.Common == null) {
            this.MetaText.Common = new VsqCommon("Miku", 128, 128, 128, 1, n);
            return;
        }
        if (n == -1) {
            if (this.MetaText.Common.PlayMode != -1) {
                this.MetaText.Common.LastPlayMode = this.MetaText.Common.PlayMode;
            }
        } else {
            this.MetaText.Common.LastPlayMode = n;
        }
        this.MetaText.Common.PlayMode = n;
    }

    public boolean isTrackOn() {
        if (this.MetaText == null) {
            return true;
        }
        if (this.MetaText.Common == null) {
            return true;
        }
        return this.MetaText.Common.PlayMode != -1;
    }

    public void setTrackOn(boolean bl) {
        if (this.MetaText == null) {
            return;
        }
        if (this.MetaText.Common == null) {
            this.MetaText.Common = new VsqCommon("Miku", 128, 128, 128, 1, bl ? 1 : -1);
        }
        if (bl) {
            if (this.MetaText.Common.LastPlayMode != 0 && this.MetaText.Common.LastPlayMode != 1) {
                this.MetaText.Common.LastPlayMode = 1;
            }
            this.MetaText.Common.PlayMode = this.MetaText.Common.LastPlayMode;
        } else {
            if (this.MetaText.Common.PlayMode == 0 || this.MetaText.Common.PlayMode == 1) {
                this.MetaText.Common.LastPlayMode = this.MetaText.Common.PlayMode;
            }
            this.MetaText.Common.PlayMode = -1;
        }
    }

    public String getName() {
        if (this.MetaText == null || this.MetaText != null && this.MetaText.Common == null) {
            return "Master Track";
        }
        return this.MetaText.Common.Name;
    }

    public void setName(String string) {
        if (this.MetaText != null) {
            if (this.MetaText.Common == null) {
                this.MetaText.Common = new VsqCommon();
            }
            this.MetaText.Common.Name = string;
        }
    }

    public double getPitchAt(int n) {
        double d = 1.220703125E-4;
        int n2 = this.MetaText.PIT.getValue(n);
        int n3 = this.MetaText.PBS.getValue(n);
        return (double)n2 * (double)n3 * d * 100.0;
    }

    public void reflectDynamics() {
        VsqBPList vsqBPList = this.getCurve("dyn");
        vsqBPList.clear();
        Iterator<VsqEvent> iterator = this.getDynamicsEventIterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            int n3;
            int n4;
            VibratoBPList vibratoBPList;
            int n5;
            VsqEvent vsqEvent = iterator.next();
            IconDynamicsHandle iconDynamicsHandle = vsqEvent.ID.IconDynamicsHandle;
            if (iconDynamicsHandle == null) continue;
            int n6 = vsqEvent.Clock;
            int n7 = vsqEvent.ID.getLength();
            if (iconDynamicsHandle.isDynaffType()) {
                vsqBPList.add(n6, iconDynamicsHandle.getStartDyn());
                continue;
            }
            int n8 = vsqBPList.getValue(n6);
            int n9 = vsqBPList.size();
            for (int i = n9 - 1; i >= 0; --i) {
                n5 = vsqBPList.getKeyClock(i);
                if (n6 <= n5 && n5 <= n6 + n7) {
                    vsqBPList.removeElementAt(i);
                    continue;
                }
                if (n5 < n6) break;
            }
            if ((vibratoBPList = iconDynamicsHandle.getDynBP()) == null || vibratoBPList != null && vibratoBPList.getCount() <= 0) {
                double d = 0.0;
                if (n7 > 0) {
                    d = (double)(iconDynamicsHandle.getEndDyn() - iconDynamicsHandle.getStartDyn()) / (double)n7;
                }
                n4 = n8;
                for (n3 = n6; n3 < n6 + n7; ++n3) {
                    n2 = n8 + (int)(d * (double)(n3 - n6));
                    if (n2 < vsqBPList.getMinimum()) {
                        n2 = vsqBPList.getMinimum();
                    } else if (vsqBPList.getMaximum() < n2) {
                        n2 = vsqBPList.getMaximum();
                    }
                    if (n4 == n2) continue;
                    vsqBPList.add(n3, n2);
                    n4 = n2;
                }
                continue;
            }
            n5 = iconDynamicsHandle.getStartDyn();
            int n10 = n6;
            n4 = vibratoBPList.getCount();
            n3 = n8;
            for (n2 = 0; n2 < n4; ++n2) {
                VibratoBPPair vibratoBPPair = vibratoBPList.getElement(n2);
                int n11 = n6 + (int)((float)n7 * vibratoBPPair.X);
                if (n11 <= n10) continue;
                n = vibratoBPPair.Y;
                double d = (double)(n - n5) / (double)(n11 - n10);
                for (int i = n10; i <= n11; ++i) {
                    int n12 = n8 + (int)((double)(i - n10) * d);
                    if (n12 < vsqBPList.getMinimum()) {
                        n12 = vsqBPList.getMinimum();
                    } else if (vsqBPList.getMaximum() < n12) {
                        n12 = vsqBPList.getMaximum();
                    }
                    if (n12 == n3) continue;
                    vsqBPList.add(i, n12);
                    n3 = n12;
                }
                n5 = vibratoBPPair.Y;
                n10 = n11;
            }
            n2 = n3;
            if (n10 >= n6 + n7) continue;
            double d = (double)(iconDynamicsHandle.getEndDyn() - n5) / (double)(n6 + n7 - n10);
            for (n = n10; n < n6 + n7; ++n) {
                int n13 = n2 + (int)((double)(n - n10) * d);
                if (n13 < vsqBPList.getMinimum()) {
                    n13 = vsqBPList.getMinimum();
                } else if (vsqBPList.getMaximum() < n13) {
                    n13 = vsqBPList.getMaximum();
                }
                if (n13 == n3) continue;
                vsqBPList.add(n, n13);
                n3 = n13;
            }
        }
    }

    public VsqEvent getSingerEventAt(int n) {
        VsqEvent vsqEvent = null;
        Iterator<VsqEvent> iterator = this.getSingerEventIterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent2 = iterator.next();
            if (n < vsqEvent2.Clock) {
                return vsqEvent;
            }
            vsqEvent = vsqEvent2;
        }
        return vsqEvent;
    }

    public void sortEvent() {
        this.MetaText.Events.sort();
    }

    public Iterator<VsqEvent> getSingerEventIterator() {
        return new SingerEventIterator(this.MetaText.getEventList());
    }

    public Iterator<VsqEvent> getNoteEventIterator() {
        if (this.MetaText == null) {
            return new NoteEventIterator(new VsqEventList());
        }
        return new NoteEventIterator(this.MetaText.getEventList());
    }

    public Iterator<VsqEvent> getDynamicsEventIterator() {
        if (this.MetaText == null) {
            return new DynamicsEventIterator(new VsqEventList());
        }
        return new DynamicsEventIterator(this.MetaText.getEventList());
    }

    public void printMetaText(ITextWriter iTextWriter, int n, int n2) throws IOException {
        this.MetaText.print(iTextWriter, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMetaText(String string, String string2) throws IOException {
        TextStream textStream = new TextStream();
        int n = this.MetaText.getEventList().getCount();
        int n2 = this.MetaText.getEventList().getElement((int)(n - 1)).Clock + 480;
        this.MetaText.print(textStream, n2, 0);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
            textStream.setPointer(-1);
            while (textStream.ready()) {
                String string3 = textStream.readLine().toString();
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqTrack#printMetaText; ex=" + exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqTrack#printMetaText; ex2=" + exception);
                }
            }
        }
    }

    public VsqMaster getMaster() {
        return this.MetaText.master;
    }

    public void setMaster(VsqMaster vsqMaster) {
        this.MetaText.master = vsqMaster;
    }

    public VsqMixer getMixer() {
        return this.MetaText.mixer;
    }

    public void setMixer(VsqMixer vsqMixer) {
        this.MetaText.mixer = vsqMixer;
    }

    public VsqCommon getCommon() {
        return this.MetaText.Common;
    }

    public void changeRenderer(String string, Vector<VsqID> vector) {
        Object object;
        VsqID vsqID = null;
        int n = vector.size();
        if (n <= 0) {
            vsqID = new VsqID();
            vsqID.type = VsqIDType.Singer;
            object = new IconHandle();
            ((IconHandle)object).IconID = "$0701" + PortUtil.toHexString(0L, 4);
            ((IconHandle)object).IDS = "Unknown";
            ((IconHandle)object).Index = 0;
            ((IconHandle)object).Language = 0;
            ((IconHandle)object).setLength(1);
            ((IconHandle)object).Original = 0;
            ((IconHandle)object).Program = 0;
            ((IconHandle)object).Caption = "";
            vsqID.IconHandle = object;
        } else {
            vsqID = vector.get(0);
        }
        object = this.getSingerEventIterator();
        while (object.hasNext()) {
            VsqEvent vsqEvent = (VsqEvent)object.next();
            IconHandle iconHandle = vsqEvent.ID.IconHandle;
            int n2 = iconHandle.Program;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                VsqID vsqID2 = vector.get(i);
                if (n2 != iconHandle.Program) continue;
                vsqEvent.ID = (VsqID)vsqID2.clone();
                bl = true;
                break;
            }
            if (bl) continue;
            VsqID vsqID3 = (VsqID)vsqID.clone();
            vsqID3.IconHandle.Program = n2;
            vsqEvent.ID = vsqID3;
        }
        this.MetaText.Common.Version = string;
    }

    public VsqBPList getCurve(String string) {
        return this.MetaText.getElement(string);
    }

    public void setCurve(String string, VsqBPList vsqBPList) {
        this.MetaText.setElement(string, vsqBPList);
    }

    public int getEventCount() {
        return this.MetaText.getEventList().getCount();
    }

    public VsqEvent getEvent(int n) {
        return this.MetaText.getEventList().getElement(n);
    }

    public VsqEvent findEventFromID(int n) {
        return this.MetaText.getEventList().findFromID(n);
    }

    public void setEvent(int n, VsqEvent vsqEvent) {
        this.MetaText.getEventList().setElement(n, vsqEvent);
    }

    public void addEvent(VsqEvent vsqEvent) {
        this.MetaText.getEventList().add(vsqEvent);
    }

    public void addEvent(VsqEvent vsqEvent, int n) {
        this.MetaText.Events.add(vsqEvent, n);
    }

    public Iterator<VsqEvent> getEventIterator() {
        return new EventIterator(this.MetaText.getEventList());
    }

    public void removeEvent(int n) {
        this.MetaText.getEventList().removeAt(n);
    }

    public Object clone() {
        VsqTrack vsqTrack = new VsqTrack();
        vsqTrack.setName(this.getName());
        if (this.MetaText != null) {
            vsqTrack.MetaText = (VsqMetaText)this.MetaText.clone();
        }
        vsqTrack.Tag = this.Tag;
        return vsqTrack;
    }

    public VsqTrack(int n, int n2, int n3) {
        this.MetaText = null;
    }

    public VsqTrack(String string, String string2) {
        this.MetaText = new VsqMetaText(string, string2);
    }

    public VsqTrack() {
        this("Voice1", "Miku");
    }

    public int getLyricLength() {
        int n = 0;
        for (int i = 0; i < this.MetaText.getEventList().getCount(); ++i) {
            if (this.MetaText.getEventList().getElement((int)i).ID.type != VsqIDType.Anote) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VsqTrack(Vector<MidiEvent> vector, String string) {
        String string2 = "";
        TextStream textStream = null;
        try {
            int n;
            Object object;
            int n2;
            textStream = new TextStream();
            int n3 = vector.size();
            Vector<Byte> vector2 = new Vector<Byte>();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                object = vector.get(n2);
                if (((MidiEvent)object).firstByte != 255 || ((MidiEvent)object).data.length <= 0 || (n = ((MidiEvent)object).data[0]) != 1 && n != 3) continue;
                if (n == 1) {
                    int n5;
                    n4 = 0;
                    for (n5 = 0; n5 < ((MidiEvent)object).data.length - 1; ++n5) {
                        byte by = ((MidiEvent)object).data[n5 + 1];
                        if (by == 58 && ++n4 <= 2 || n4 < 2) continue;
                        vector2.add(by);
                    }
                    n5 = vector2.indexOf(10);
                    while (n5 >= 0) {
                        byte[] byArray = new byte[n5];
                        for (int i = 0; i < n5; ++i) {
                            byArray[i] = (Byte)vector2.get(0);
                            vector2.removeElementAt(0);
                        }
                        String string3 = PortUtil.getDecodedString(string, byArray);
                        textStream.writeLine(string3);
                        vector2.removeElementAt(0);
                        n5 = vector2.indexOf(10);
                    }
                    continue;
                }
                for (n4 = 0; n4 < ((MidiEvent)object).data.length - 1; ++n4) {
                    vector2.add(((MidiEvent)object).data[n4 + 1]);
                }
                string2 = PortUtil.getDecodedString(string, PortUtil.convertByteArray(vector2.toArray(new Byte[0])));
                vector2.clear();
            }
            n2 = vector2.size();
            if (n2 > 0) {
                object = new byte[n2];
                for (n = 0; n < n2; ++n) {
                    object[n] = (Byte)vector2.get(n);
                }
                String string4 = PortUtil.getDecodedString(string, (byte[])object);
                textStream.writeLine(string4);
            }
            this.MetaText = new VsqMetaText(textStream);
            this.setName(string2);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("org.kbinani.vsq.VsqTrack#.ctor; ex=" + exception);
        }
        finally {
            if (textStream != null) {
                try {
                    textStream.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("org.kbinani.vsq.VsqTrack#.ctor; ex2=" + exception);
                }
            }
        }
    }

    private class EventIterator
    implements Iterator {
        private VsqEventList m_list;
        private int m_pos;

        public EventIterator(VsqEventList vsqEventList) {
            this.m_list = vsqEventList;
            this.m_pos = -1;
        }

        public boolean hasNext() {
            return 0 <= this.m_pos + 1 && this.m_pos + 1 < this.m_list.getCount();
        }

        public VsqEvent next() {
            ++this.m_pos;
            return this.m_list.getElement(this.m_pos);
        }

        public void remove() {
            if (0 <= this.m_pos && this.m_pos < this.m_list.getCount()) {
                this.m_list.removeAt(this.m_pos);
            }
        }
    }

    private class DynamicsEventIterator
    implements Iterator {
        VsqEventList m_list;
        int m_pos;

        public DynamicsEventIterator(VsqEventList vsqEventList) {
            this.m_list = vsqEventList;
            this.m_pos = -1;
        }

        public boolean hasNext() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                if (this.m_list.getElement((int)i).ID.type != VsqIDType.Aicon) continue;
                return true;
            }
            return false;
        }

        public VsqEvent next() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                VsqEvent vsqEvent = this.m_list.getElement(i);
                if (vsqEvent.ID.type != VsqIDType.Aicon) continue;
                this.m_pos = i;
                return vsqEvent;
            }
            return null;
        }

        public void remove() {
            if (0 <= this.m_pos && this.m_pos < this.m_list.getCount()) {
                this.m_list.removeAt(this.m_pos);
            }
        }
    }

    private class NoteEventIterator
    implements Iterator {
        VsqEventList m_list;
        int m_pos;

        public NoteEventIterator(VsqEventList vsqEventList) {
            this.m_list = vsqEventList;
            this.m_pos = -1;
        }

        public boolean hasNext() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                if (this.m_list.getElement((int)i).ID.type != VsqIDType.Anote) continue;
                return true;
            }
            return false;
        }

        public VsqEvent next() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                VsqEvent vsqEvent = this.m_list.getElement(i);
                if (vsqEvent.ID.type != VsqIDType.Anote) continue;
                this.m_pos = i;
                return vsqEvent;
            }
            return null;
        }

        public void remove() {
            if (0 <= this.m_pos && this.m_pos < this.m_list.getCount()) {
                this.m_list.removeAt(this.m_pos);
            }
        }
    }

    private class SingerEventIterator
    implements Iterator {
        VsqEventList m_list;
        int m_pos;

        public SingerEventIterator(VsqEventList vsqEventList) {
            this.m_list = vsqEventList;
            this.m_pos = -1;
        }

        public boolean hasNext() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                if (this.m_list.getElement((int)i).ID.type != VsqIDType.Singer) continue;
                return true;
            }
            return false;
        }

        public VsqEvent next() {
            int n = this.m_list.getCount();
            for (int i = this.m_pos + 1; i < n; ++i) {
                VsqEvent vsqEvent = this.m_list.getElement(i);
                if (vsqEvent.ID.type != VsqIDType.Singer) continue;
                this.m_pos = i;
                return vsqEvent;
            }
            return null;
        }

        public void remove() {
            if (0 <= this.m_pos && this.m_pos < this.m_list.getCount()) {
                this.m_list.removeAt(this.m_pos);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexIterator
    implements Iterator<Integer> {
        VsqEventList list;
        int pos;
        boolean kindSinger = false;
        boolean kindNote = false;
        boolean kindCrescend = false;
        boolean kindDecrescend = false;
        boolean kindDynaff = false;

        public IndexIterator(VsqEventList vsqEventList, int n) {
            this.list = vsqEventList;
            this.pos = -1;
            this.kindSinger = (n & 1) == 1;
            this.kindNote = (n & 2) == 2;
            this.kindCrescend = (n & 4) == 4;
            this.kindDecrescend = (n & 8) == 8;
            this.kindDynaff = (n & 0x10) == 16;
        }

        @Override
        public boolean hasNext() {
            int n = this.list.getCount();
            for (int i = this.pos + 1; i < n; ++i) {
                VsqEvent vsqEvent = this.list.getElement(i);
                if (this.kindSinger && vsqEvent.ID.type == VsqIDType.Singer) {
                    return true;
                }
                if (this.kindNote && vsqEvent.ID.type == VsqIDType.Anote) {
                    return true;
                }
                if (vsqEvent.ID.type != VsqIDType.Aicon || vsqEvent.ID.IconDynamicsHandle == null || vsqEvent.ID.IconDynamicsHandle.IconID == null) continue;
                String string = vsqEvent.ID.IconDynamicsHandle.IconID;
                if (this.kindDynaff && string.startsWith("$0501")) {
                    return true;
                }
                if (this.kindCrescend && string.startsWith("$0502")) {
                    return true;
                }
                if (!this.kindDecrescend || !string.startsWith("$0503")) continue;
                return true;
            }
            return false;
        }

        @Override
        public Integer next() {
            int n = this.list.getCount();
            for (int i = this.pos + 1; i < n; ++i) {
                VsqEvent vsqEvent = this.list.getElement(i);
                if (this.kindSinger && vsqEvent.ID.type == VsqIDType.Singer) {
                    this.pos = i;
                    return i;
                }
                if (this.kindNote && vsqEvent.ID.type == VsqIDType.Anote) {
                    this.pos = i;
                    return i;
                }
                if (!this.kindDynaff && !this.kindCrescend && !this.kindDecrescend || vsqEvent.ID.type != VsqIDType.Aicon || vsqEvent.ID.IconDynamicsHandle == null || vsqEvent.ID.IconDynamicsHandle.IconID == null) continue;
                String string = vsqEvent.ID.IconDynamicsHandle.IconID;
                if (this.kindDynaff && string.startsWith("$0501")) {
                    this.pos = i;
                    return i;
                }
                if (this.kindCrescend && string.startsWith("$0502")) {
                    this.pos = i;
                    return i;
                }
                if (!this.kindDecrescend || !string.startsWith("$0503")) continue;
                this.pos = i;
                return i;
            }
            return -1;
        }

        @Override
        public void remove() {
            if (0 <= this.pos && this.pos < this.list.getCount()) {
                this.list.removeAt(this.pos);
            }
        }
    }
}

