/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.windows.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.windows.forms.BListViewItem;

public class BListView
extends JPanel
implements MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private boolean isMultiSelect = true;
    private boolean isCheckBoxes = false;
    private final int FIRST_COLUMN_WIDTH = 25;
    protected Vector<Group> groups = new Vector();
    protected Group defaultGroup = null;
    private JScrollPane jScrollPane10 = null;
    private JPanel panel = null;
    private JLabel label = null;
    private String[] headers;
    public BEvent<BEventHandler> selectedIndexChangedEvent = new BEvent();

    public BListView() {
        this.initialize();
        this.addGroup("");
    }

    private void handleListSelection(Group group, ListSelectionEvent listSelectionEvent) {
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            Group group2 = this.groups.get(i);
            if (group2 == group) continue;
            group2.table.clearSelection();
        }
        try {
            this.selectedIndexChangedEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BListView#handleListSelection; ex=" + exception);
        }
    }

    public void ensureRowVisible(String string, int n) {
        Group group = this.getGroupFromName(string);
        group.table.scrollRectToVisible(group.table.getCellRect(n, 0, true));
    }

    public void setGroupHeader(String string, String string2) {
        Group group = this.getGroupFromName(string);
        group.setHeader(string2);
    }

    public void setItemBackColorAt(String string, int n, Color color) {
    }

    public void clear() {
        this.clearItems(this.defaultGroup);
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            this.clearItems(this.groups.get(i));
        }
    }

    private void clearItems(Group group) {
        int n = group.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            group.tableModel.removeRow(0);
        }
    }

    public int getSelectedIndex(String string) {
        Group group = this.getGroupFromName(string);
        return group.table.getSelectedRow();
    }

    public void setItemSelectedAt(String string, int n, boolean bl) {
        int n2;
        Group group = this.getGroupFromName(string);
        Vector<Integer> vector = new Vector<Integer>();
        int[] nArray = group.table.getSelectedRows();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == n && (nArray[n2] != n || bl)) continue;
            vector.add(n2);
        }
        group.table.clearSelection();
        n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = (Integer)vector.get(i);
            group.table.addRowSelectionInterval(n3, n3);
        }
    }

    public void clearSelection(String string) {
        Group group = this.getGroupFromName(string);
        group.table.clearSelection();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        System.out.println("BListView_DRAFT#mouseDragged");
        TableColumn tableColumn = null;
        Group group = null;
        group = this.groups.size() == 0 ? this.defaultGroup : this.groups.get(0);
        tableColumn = group.table.getTableHeader().getResizingColumn();
        if (tableColumn == null) {
            return;
        }
        int n2 = group.table.getColumnModel().getColumnCount();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = group.table.getColumnModel().getColumn(n).getWidth();
        }
        n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            Group group2 = this.groups.get(i);
            this.updateColumnWidth(nArray, group2);
        }
        this.updateColumnWidth(nArray, this.defaultGroup);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void updateColumnWidth(int[] nArray, Group group) {
        int n = group.table.getColumnCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            group.table.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
            n2 += nArray[i];
        }
        group.updatePaneHeight();
    }

    public int getGroupCount() {
        return this.groups.size() + 1;
    }

    public String getGroupNameAt(int n) {
        if (n < this.groups.size()) {
            return this.groups.get(n).getName();
        }
        return this.defaultGroup.getName();
    }

    public void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(365, 179));
        this.add((Component)this.getJScrollPane10(), gridBagConstraints);
    }

    public boolean isCheckBoxes() {
        return this.isCheckBoxes;
    }

    public void setCheckBoxes(boolean bl) {
        this.isCheckBoxes = bl;
        if (this.defaultGroup != null) {
            this.defaultGroup.updateColumnModel();
        }
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            this.groups.get(i).updateColumnModel();
        }
    }

    private Group getGroupFromName(String string) {
        if (string == null || string != null && string.equals("")) {
            return this.defaultGroup;
        }
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = this.groups.get(i);
            if (!group.getName().equals(string)) continue;
            return group;
        }
        return this.defaultGroup;
    }

    public void setItemAt(String string, int n, BListViewItem bListViewItem) {
        Group group = this.getGroupFromName(string);
        group.setItemAtCor(n, bListViewItem);
    }

    public void removeItemAt(String string, int n) {
        Group group = this.getGroupFromName(string);
        group.removeItemAtCor(n);
    }

    public BListViewItem getItemAt(String string, int n) {
        return null;
    }

    public int getItemCount(String string) {
        Group group = this.getGroupFromName(string);
        return group.getItemCountCor();
    }

    public boolean isItemCheckedAt(String string, int n) {
        Group group = this.getGroupFromName(string);
        return group.isItemChecked(n);
    }

    public void setItemCheckedAt(String string, int n, boolean bl) {
        Group group = this.getGroupFromName(string);
        group.setItemChecked(n, bl);
    }

    public Group addGroup(String string) {
        Serializable serializable;
        if (string == null || string != null && string.equals("")) {
            if (this.defaultGroup == null) {
                this.defaultGroup = new Group("");
                this.defaultGroup.updateColumnModel();
                this.defaultGroup.table.getTableHeader().addMouseMotionListener(this);
                this.defaultGroup.setHeader("Another");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 11;
                this.panel.add((Component)this.defaultGroup.label, gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.ipadx = 0;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.weighty = 0.0;
                gridBagConstraints2.anchor = 11;
                this.panel.add((Component)this.defaultGroup, gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 2;
                gridBagConstraints3.weighty = 1.0;
                gridBagConstraints3.weightx = 1.0;
                this.panel.add((Component)this.label, gridBagConstraints3);
                this.updateHeaders();
            }
            return this.defaultGroup;
        }
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            serializable = this.groups.get(i);
            if (!serializable.getName().equals(string)) continue;
            return serializable;
        }
        this.panel.remove(this.label);
        this.panel.remove(this.defaultGroup);
        this.panel.remove(this.defaultGroup.label);
        this.defaultGroup.setColumnHeader(null);
        Group group = new Group(string);
        group.updateColumnModel();
        group.table.getTableHeader().addMouseMotionListener(this);
        if (this.groups.size() > 0) {
            System.out.println("BListView_DRAFT#addGroup; header set to null");
            group.setColumnHeader(null);
        }
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = this.groups.size() * 2;
        ((GridBagConstraints)serializable).ipadx = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 11;
        this.panel.add((Component)group.label, serializable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.groups.size() * 2 + 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        this.panel.add((Component)group, gridBagConstraints);
        this.groups.add(group);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = this.groups.size() * 2;
        gridBagConstraints4.ipadx = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.anchor = 11;
        this.panel.add((Component)this.defaultGroup.label, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = this.groups.size() * 2 + 1;
        gridBagConstraints5.ipadx = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 11;
        this.panel.add((Component)this.defaultGroup, gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = this.groups.size() * 2 + 2;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 1.0;
        this.panel.add((Component)this.label, gridBagConstraints6);
        this.updateHeaders();
        return group;
    }

    public void addItem(String string, BListViewItem bListViewItem) {
        this.addItem(string, bListViewItem, true);
    }

    public void addItem(String string, BListViewItem bListViewItem, boolean bl) {
        int n;
        if (string == null || string != null && string.equals("")) {
            this.defaultGroup.addItemCor(bListViewItem);
        } else {
            n = this.groups.size();
            Group group = null;
            for (int i = 0; i < n; ++i) {
                Group group2 = this.groups.get(i);
                if (!group2.getName().equals(string)) continue;
                group = group2;
                break;
            }
            if (group == null) {
                group = this.addGroup(string);
            }
            group.addItemCor(bListViewItem);
        }
        this.defaultGroup.updateColumnModel();
        n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            this.groups.get(i).updateColumnModel();
        }
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void setMultiSelect(boolean bl) {
        this.isMultiSelect = bl;
        int n = this.isMultiSelect ? 2 : 0;
        this.defaultGroup.table.setSelectionMode(n);
        int n2 = this.groups.size();
        for (int i = 0; i < n2; ++i) {
            this.groups.get((int)i).table.setSelectionMode(n);
        }
    }

    public void setColumnHeaders(String[] stringArray) {
        this.headers = stringArray;
        this.updateHeaders();
    }

    public void setColumnWidth(int n, int n2) {
        this.defaultGroup.setColumnWidth(n, n2);
        int n3 = this.groups.size();
        for (int i = 0; i < n3; ++i) {
            this.groups.get(i).setColumnWidth(n, n2);
        }
    }

    public int getColumnWidth(int n) {
        if (this.groups.size() > 0) {
            return this.groups.get((int)0).table.getColumnModel().getColumn(n + 1).getWidth();
        }
        return this.defaultGroup.table.getColumnModel().getColumn(n + 1).getWidth();
    }

    private void updateHeaders() {
        if (this.headers == null) {
            return;
        }
        int n = this.groups.size();
        if (n > 0) {
            this.groups.get(0).setColumnHeaderCor(this.headers);
        } else {
            this.defaultGroup.setColumnHeaderCor(this.headers);
        }
    }

    public String[] getColumnHeaders() {
        return null;
    }

    private JScrollPane getJScrollPane10() {
        if (this.jScrollPane10 == null) {
            this.jScrollPane10 = new JScrollPane();
            this.jScrollPane10.setHorizontalScrollBarPolicy(30);
            this.jScrollPane10.setViewportView(this.getPanel());
        }
        return this.jScrollPane10;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 2;
            this.label = new JLabel();
            this.label.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.gridx = 0;
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.panel.add((Component)this.label, gridBagConstraints);
        }
        return this.panel;
    }

    private class CheckCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            void var7_10;
            if (object == null) {
                return this;
            }
            Object var7_7 = null;
            String string = "";
            if (object != null) {
                if (object instanceof String) {
                    string = (String)object;
                } else if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    string = "true";
                }
            }
            if (n2 == 0) {
                if (!BListView.this.isCheckBoxes) return null;
                JCheckBox jCheckBox = new JCheckBox();
                Boolean bl3 = false;
                if (string.toLowerCase().equals("true")) {
                    bl3 = true;
                }
                jCheckBox.setSelected(bl3);
                JCheckBox jCheckBox2 = jCheckBox;
                return var7_10;
            } else {
                JLabel jLabel;
                JLabel jLabel2 = jLabel = new JLabel();
            }
            return var7_10;
        }
    }

    class Group
    extends JScrollPane
    implements ListSelectionListener {
        private static final long serialVersionUID = 1L;
        public JTable table;
        public DefaultTableModel tableModel;
        private boolean isColumnModelUpdated = true;
        public JLabel label;
        public Component headerView = null;

        public Group(String string) {
            this.setName(string);
            this.tableModel = new DefaultTableModel(){
                private static final long serialVersionUID = 1L;

                public boolean isCellEditable(int n, int n2) {
                    return BListView.this.isCheckBoxes && n2 == 0;
                }
            };
            this.table = new JTable();
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.setModel(this.tableModel);
            this.table.setAutoResizeMode(0);
            this.setPreferredSize(new Dimension(200, 100));
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
            this.setViewportView(this.table);
            this.label = new JLabel(string);
        }

        public BListViewItem getItemAt(int n) {
            int n2 = this.tableModel.getColumnCount() - 1;
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = (String)this.tableModel.getValueAt(n, i + 1);
            }
            BListViewItem bListViewItem = new BListViewItem(stringArray);
            return bListViewItem;
        }

        public boolean isItemChecked(int n) {
            return (Boolean)this.tableModel.getValueAt(n, 0);
        }

        public void setItemChecked(int n, boolean bl) {
            this.tableModel.setValueAt(bl, n, 0);
        }

        public int getItemCountCor() {
            return this.tableModel.getRowCount();
        }

        public void removeItemAtCor(int n) {
            this.tableModel.removeRow(n);
        }

        public void setItemAtCor(int n, BListViewItem bListViewItem) {
            int n2 = bListViewItem.getSubItemCount();
            this.tableModel.setValueAt(false, n, 0);
            for (int i = 0; i < n2; ++i) {
                this.tableModel.setValueAt(bListViewItem.getSubItemAt(i), n, i + 1);
            }
        }

        public String getHeader() {
            return this.label.getText();
        }

        public void setHeader(String string) {
            this.label.setText(string);
        }

        public void addItemCor(BListViewItem bListViewItem) {
            this.addItemCor(bListViewItem, false, true);
        }

        public void addItemCor(BListViewItem bListViewItem, boolean bl) {
            this.addItemCor(bListViewItem, false, bl);
        }

        public void addItemCor(BListViewItem bListViewItem, boolean bl, boolean bl2) {
            int n;
            System.err.println("info; BListView#$Group#addItemCor; not implemented yet; \"enabled\"");
            if (this.tableModel.getColumnCount() <= 0) {
                this.tableModel.setColumnCount(bListViewItem.getSubItemCount() + 1);
            }
            int n2 = Math.min(this.tableModel.getColumnCount() - 1, bListViewItem.getSubItemCount());
            Object[] objectArray = new Object[n2 + 1];
            objectArray[0] = bl;
            for (n = 0; n < n2; ++n) {
                objectArray[n + 1] = bListViewItem.getSubItemAt(n);
            }
            n = this.tableModel.getColumnCount() <= 0 ? 1 : 0;
            this.tableModel.addRow(objectArray);
            if (n != 0) {
                this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
            }
            if (!this.isColumnModelUpdated) {
                this.updateColumnModel();
            }
            this.updatePaneHeight();
        }

        private void updatePaneHeight() {
            this.setPreferredSize(new Dimension(0, (this.tableModel.getRowCount() + 1) * (this.table.getRowHeight() + this.table.getRowMargin()) + this.horizontalScrollBar.getHeight()));
        }

        public void updateColumnModel() {
            if (this.table.getColumnModel().getColumnCount() > 0) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
                tableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
                tableColumn.setCellRenderer(new CheckCellRenderer());
                tableColumn.setResizable(true);
                tableColumn.setPreferredWidth(25);
                tableColumn.setResizable(false);
                this.table.getTableHeader().setReorderingAllowed(false);
                this.isColumnModelUpdated = true;
            } else {
                this.isColumnModelUpdated = false;
            }
        }

        public void setColumnHeaderCor(String[] stringArray) {
            int n = Math.max(this.tableModel.getColumnCount(), stringArray.length + 1);
            Object[] objectArray = new String[n];
            objectArray[0] = "";
            for (int i = 1; i < n && i - 1 < stringArray.length; ++i) {
                objectArray[i] = stringArray[i - 1];
            }
            this.tableModel.setColumnIdentifiers(objectArray);
            this.updateColumnModel();
        }

        public void setColumnWidth(int n, int n2) {
            this.table.getColumnModel().getColumn(n + 1).setPreferredWidth(n2);
        }

        public int getColumnHeight(int n) {
            return this.table.getColumnModel().getColumn(n + 1).getWidth();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BListView.this.handleListSelection(this, listSelectionEvent);
        }
    }
}

