--[[
  luavsq.lua
  Copyright © 2011 kbinani, All Rights Reserved.

  luavsq is free software; you can redistribute it and/or
  modify it under the terms of the BSD License.

  luavsq is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
]]

-- This file is automatically generated by SourceFilePacker.
-- To generate this file, just execute the command below:
--     $cd tool && make
-- See tool/makefile and tool/SourceFilePacker.java.

local _G = _G;
local _VERSION = _VERSION;
local assert = assert;
local collectgarbage = collectgarbage;
local coroutine = coroutine;
local debug = debug;
local dofile = dofile;
local error = error;
local file = file;
local getfenv = getfenv;
local getmetatable = getmetatable;
local io = io;
local ipairs = ipairs;
local load = load;
local loadfile = loadfile;
local loadstring = loadstring;
local math = math;
local module = module;
local next = next;
local os = os;
local package = package;
local pairs = pairs;
local pcall = pcall;
local print = print;
local rawequal = rawequal;
local rawget = rawget;
local rawset = rawset;
local require = require;
local select = select;
local setfenv = setfenv;
local setmetatable = setmetatable;
local string = string;
local table = table;
local tonumber = tonumber;
local tostring = tostring;
local type = type;
local unpack = unpack;
local xpcall = xpcall;

module( "luavsq" );

ArticulationTypeEnum = {
	VIBRATO = 0,
	CRESCENDO = 1,
	DYNAFF = 2,
	NOTE_ATTACK = 3,
	NOTE_TRANSITION = 4,
};
BP = {};
function BP.new( value, id )
	local this = {};
	this.value = value;
	this.id = id;
	function this:clone()
		return BP.new( self.value, self.id );
	end
	return this;
end
if( nil == BPList )then
	BPList = {};
end
function BPList.new( ... )
	local this = {};
	local arguments = { ... };
	this._clocks = nil;
	this._items = nil;
	this._length = 0;
	this._defaultValue = 0;
	this._maxValue = 127;
	this._minValue = 0;
	this._maxId = 0;
	this._name = "";
	function this:_init_4( name, defaultValue, minimum, maximum )
		self._name = name;
		self._defaultValue = defaultValue;
		self._maxValue = maximum;
		self._minValue = minimum;
		self._maxId = 0;
	end
	function this:_ensureBufferLength( length )
		if( self._clocks == nil )then
			self._clocks = {};
		end
		if( self._items == nil )then
			self._items = {};
		end
		if( length > #self._clocks )then
			local newLength = length;
			if( #self._clocks <= 0 )then
				newLength = math.floor( length * 1.2 );
			else
				local order = math.floor( length / #self._clocks );
				if( order <= 1 )then
					order = 2;
				end
				newLength = #self._clocks * order;
			end
			local delta = newLength - #self._clocks;
			local i;
			for i = 1, delta, 1 do
				table.insert( self._clocks, 0 );
				table.insert( self._items, BP.new() );
			end
		end
	end
	function this:getName()
		if( self._name == nil )then
			self._name = "";
		end
		return self._name;
	end
	function this:setName( value )
		if( value == nil )then
			self._name = "";
		else
			self._name = value;
		end
	end
	function this:getMaxId()
		return self._maxId;
	end
	function this:getDefault()
		return self._defaultValue;
	end
	function this:setDefault( value )
		self._defaultValue = value;
	end
	function this:clone()
		local res = BPList.new( self._name, self._defaultValue, self._minValue, self._maxValue );
		res:_ensureBufferLength( self._length );
		local i;
		for i = 1, self._length, 1 do
			res._clocks[i] = self._clocks[i];
			res._items[i] = self._items[i]:clone();
		end
		res._length = self._length;
		res._maxId = self._maxId;
		return res;
	end
	function this:getMaximum()
		return self._maxValue;
	end
	function this:setMaximum( value )
		self._maxValue = value;
	end
	function this:getMinimum()
		return self._minValue;
	end
	function this:setMinimum( value )
		self._minValue = value;
	end
	function this:isContainsKey( clock )
		self:_ensureBufferLength( self._length );
		return (self:_find( clock ) >= 0);
	end
	function this:clear()
		self._length = 0;
	end
	function this:getValue( index )
		return self._items[index + 1].value;
	end
	function this:get( index )
		return self._items[index + 1]:clone();
	end
	function this:getKeyClock( index )
		return self._clocks[index + 1];
	end
	function this:findValueFromId( id )
		local i;
		for i = 1, self._length, 1 do
			local item = self._items[i];
			if( item.id == id )then
				return item.value;
			end
		end
		return self._defaultValue;
	end
	function this:findElement( id )
		local context = BPListSearchResult.new();
		local i;
		for i = 1, self._length, 1 do
			local item = self._items[i];
			if( item.id == id )then
				context.clock = self._clocks[i];
				context.index = i - 1;
				context.point = item:clone();
				return context;
			end
		end
		context.clock = -1;
		context.index = -1;
		context.point = BP.new( self._defaultValue, -1 );
		return context;
	end
	function this:setValueForId( id, value )
		local i;
		for i = 1, self._length, 1 do
			if( self._items[i].id == id )then
				self._items[i].value = value;
				break;
			end
		end
	end
	function this:print( stream, startClock, header )
		stream:writeLine( header );
		local lastvalue = self._defaultValue;
		local value_at_start_written = false;
		local i;
		for i = 1, self._length, 1 do
			local key = self._clocks[i];
			if( startClock == key )then
				stream:writeLine( key .. "=" .. self._items[i].value );
				value_at_start_written = true;
			elseif( startClock < key )then
				if( (not value_at_start_written) and (lastvalue ~= self._defaultValue) )then
					stream:writeLine( startClock .. "=" .. lastvalue );
					value_at_start_written = true;
				end
				local val = self._items[i].value;
				stream:writeLine( key .. "=" .. val );
			else
				lastvalue = self._items[i].value;
			end
		end
		if( (not value_at_start_written) and (lastvalue ~= self._defaultValue) )then
			stream:writeLine( startClock .. "=" .. lastvalue );
		end
	end
	function this:size()
		return self._length;
	end
	function this:keyClockIterator()
		return BPList.KeyClockIterator.new( self );
	end
	function this:_find( value )
		local i;
		for i = 1, self._length, 1 do
			if( self._clocks[i] == value )then
				return i - 1;
			end
		end
		return -1;
	end
	function this:addWithoutSort( clock, value )
		self:_ensureBufferLength( self._length + 1 );
		self._clocks[self._length + 1] = clock;
		self._maxId = self._maxId + 1;
		self._items[self._length + 1].value = value;
		self._items[self._length + 1].id = self._maxId;
		self._length = self._length + 1;
	end
	function this:add( clock, value )
		self:_ensureBufferLength( self._length );
		local index = self:_find( clock );
		if( index >= 0 )then
			self._items[index + 1].value = value;
			return self._items[index + 1].id;
		else
			self._length = self._length + 1;
			self:_ensureBufferLength( self._length );
			self._clocks[self._length] = clock;
			Util.sort( self._clocks, 0, self._length );
			index = self:_find( clock );
			self._maxId = self._maxId + 1;
			local i;
			for i = self._length, index + 2, -1 do
				self._items[i].value = self._items[i - 1].value;
				self._items[i].id = self._items[i - 1].id;
			end
			self._items[index + 1].value = value;
			self._items[index + 1].id = self._maxId;
			return self._maxId;
		end
	end
	function this:addWithId( clock, value, id )
		self:_ensureBufferLength( self._length );
		local index = self:_find( clock );
		if( index >= 0 )then
			self._items[index + 1].value = value;
			self._items[index + 1].id = id;
		else
			self._length = self._length + 1;
			self:_ensureBufferLength( self._length );
			self._clocks[self._length] = clock;
			Util.sort( self._clocks, 0, self._length );
			index = self:_find( clock );
			local i;
			for i = self._length, index + 2, -1 do
				self._items[i].value = self._items[i - 1].value;
				self._items[i].id = self._items[i - 1].id;
			end
			self._items[index + 1].value = value;
			self._items[index + 1].id = id;
		end
		self._maxId = math.max( self._maxId, id );
		return id;
	end
	function this:getValueAt( ... )
		local arguments = { ... };
		if( #arguments == 2 )then
			return self:_getValueAt_2( arguments[1], arguments[2] );
		elseif( #arguments == 1 )then
			return self:_getValueAt_1( arguments[1] );
		end
	end
	function this:_getValueAt_1( clock )
		self:_ensureBufferLength( self._length );
		local index = self:_find( clock );
		if( index >= 0 )then
			return self._items[index + 1].value;
		else
			if( self._length <= 0 )then
				return self._defaultValue;
			else
				local draft = 0;
				local i;
				for i = 1, self._length, 1 do
					local c = self._clocks[i];
					if( clock < c )then
						break;
					end
					draft = i;
				end
				if( draft == 0 )then
					return self._defaultValue;
				else
					return self._items[draft].value;
				end
			end
		end
	end
	function this:_getValueAt_2( clock, index )
		if( self._length == 0 )then
			return self._defaultValue;
		else
			if( index.value < 0 )then
				index.value = 0;
			end
			if( index.value > 0 and clock < self._clocks[index.value + 1] )then
				index.value = 0;
			end
			local i;
			for i = index.value + 1, self._length, 1 do
				local keyclock = self._clocks[i];
				if( clock < keyclock )then
					if( i > 1 )then
						index.value = i - 2;
						return self._items[i - 1].value;
					else
						index.value = 0;
						return self._defaultValue;
					end
				end
			end
			index.value = self._length - 1;
			return self._items[self._length].value;
		end
	end
	if( #arguments == 4 )then
		this:_init_4( arguments[1], arguments[2], arguments[3], arguments[4] );
	end
	return this;
end
BPList.INIT_BUFLEN = 512;
if( nil == BPList )then
	BPList = {};
end
BPList.KeyClockIterator = {};
function BPList.KeyClockIterator.new( ... )
	local this = {};
	local arguments = { ... };
	this._list = nil;
	this._pos = 0;
	function this:_init_1( list )
		self._list = list;
		self._pos = 0;
	end
	function this:hasNext()
		if( self._pos + 1 <= self._list._length )then
			return true;
		else
			return false;
		end
	end
	function this:next()
		self._pos = self._pos + 1;
		return self._list._clocks[self._pos];
	end
	function this:remove()
		if( 0 < self._pos and self._pos <= self._list._length )then
			local key = self._list._clocks[self._pos];
			local i;
			for i = self._pos, self._list._length - 1, 1 do
				self._list._clocks[i] = self._list._clocks[i + 1];
				self._list._items[i].value = self._list._items[i + 1].value;
				self._list._items[i].id = self._list._items[i + 1].id;
			end
			self._list._length = self._list._length - 1;
		end
	end
	if( #arguments == 1 )then
		this:_init_1( arguments[1] );
	end
	return this;
end
BPListSearchResult = {};
function BPListSearchResult.new()
	local this = {};
	this.clock = 0;
	this.index = 0;
	this.point = BP.new();
	return this;
end
ByteArrayOutputStream = {};
function ByteArrayOutputStream.new()
	local this = {};
	this._pointer = -1;
	this._array = {};
	function this:write( ... )
		local arguments = { ... };
		if( #arguments == 1 )then
			self:_write_1( arguments[1] );
		elseif( #arguments == 3 )then
			self:_write_3( arguments[1], arguments[2], arguments[3] );
		end
	end
	function this:_write_1( byte )
		if( byte == nil )then
			byte = 0;
		end
		local index = self._pointer + 2;
		local remain = index - #self._array;
		if( remain > 0 )then
			local i;
			for i = 1, remain, 1 do
				table.insert( self._array, 0 );
			end
		end
		self._array[index] = byte;
		self._pointer = self._pointer + 1;
	end
	function this:_write_3( array, startIndex, length )
		local i;
		for i = 1, length, 1 do
			self:_write_1( array[startIndex + i - 1] );
		end
	end
	function this:toString()
		local result = "";
		local i;
		for i = 1, #self._array, 1 do
			result = result .. string.char( self._array[i] );
		end
		return result;
	end
	function this:getPointer()
		return self._pointer;
	end
	function this:seek( position )
		self._pointer = position;
	end
	function this:close()
	end
	return this;
end
CP932Converter = {};
CP932Converter._unicode_to_cp932 = {
	[0] = {
		[0] = { 0 }, [1] = { 1 }, [2] = { 2 }, [3] = { 3 }, [4] = { 4 }, [5] = { 5 }, [6] = { 6 }, [7] = { 7 }, [8] = { 8 }, [9] = { 9 }, [10] = { 10 }, [11] = { 11 }, [12] = { 12 }, [13] = { 13 }, [14] = { 14 }, [15] = { 15 }, [16] = { 16 }, [17] = { 17 }, [18] = { 18 }, [19] = { 19 }, [20] = { 20 }, [21] = { 21 }, [22] = { 22 }, [23] = { 23 },
		[24] = { 24 }, [25] = { 25 }, [26] = { 26 }, [27] = { 27 }, [28] = { 28 }, [29] = { 29 }, [30] = { 30 }, [31] = { 31 }, [32] = { 32 }, [33] = { 33 }, [34] = { 34 }, [35] = { 35 }, [36] = { 36 }, [37] = { 37 }, [38] = { 38 }, [39] = { 39 }, [40] = { 40 }, [41] = { 41 }, [42] = { 42 }, [43] = { 43 }, [44] = { 44 }, [45] = { 45 }, [46] = { 46 }, [47] = { 47 }, [48] = { 48 },
		[49] = { 49 }, [50] = { 50 }, [51] = { 51 }, [52] = { 52 }, [53] = { 53 }, [54] = { 54 }, [55] = { 55 }, [56] = { 56 }, [57] = { 57 }, [58] = { 58 }, [59] = { 59 }, [60] = { 60 }, [61] = { 61 }, [62] = { 62 }, [63] = { 63 }, [64] = { 64 }, [65] = { 65 }, [66] = { 66 }, [67] = { 67 }, [68] = { 68 }, [69] = { 69 }, [70] = { 70 }, [71] = { 71 }, [72] = { 72 }, [73] = { 73 },
		[74] = { 74 }, [75] = { 75 }, [76] = { 76 }, [77] = { 77 }, [78] = { 78 }, [79] = { 79 }, [80] = { 80 }, [81] = { 81 }, [82] = { 82 }, [83] = { 83 }, [84] = { 84 }, [85] = { 85 }, [86] = { 86 }, [87] = { 87 }, [88] = { 88 }, [89] = { 89 }, [90] = { 90 }, [91] = { 91 }, [92] = { 92 }, [93] = { 93 }, [94] = { 94 }, [95] = { 95 }, [96] = { 96 }, [97] = { 97 }, [98] = { 98 },
		[99] = { 99 }, [100] = { 100 }, [101] = { 101 }, [102] = { 102 }, [103] = { 103 }, [104] = { 104 }, [105] = { 105 }, [106] = { 106 }, [107] = { 107 }, [108] = { 108 }, [109] = { 109 }, [110] = { 110 }, [111] = { 111 }, [112] = { 112 }, [113] = { 113 }, [114] = { 114 }, [115] = { 115 }, [116] = { 116 }, [117] = { 117 }, [118] = { 118 }, [119] = { 119 }, [120] = { 120 }, [121] = { 121 }, [122] = { 122 }, [123] = { 123 },
		[124] = { 124 }, [125] = { 125 }, [126] = { 126 }, [127] = { 127 }, [167] = { 129, 152 }, [168] = { 129, 78 }, [176] = { 129, 139 }, [177] = { 129, 125 }, [180] = { 129, 76 }, [182] = { 129, 247 }, [215] = { 129, 126 }, [247] = { 129, 128 },
	},
	[3] = {
		[145] = { 131, 159 }, [146] = { 131, 160 }, [147] = { 131, 161 }, [148] = { 131, 162 }, [149] = { 131, 163 }, [150] = { 131, 164 }, [151] = { 131, 165 }, [152] = { 131, 166 }, [153] = { 131, 167 }, [154] = { 131, 168 }, [155] = { 131, 169 }, [156] = { 131, 170 }, [157] = { 131, 171 }, [158] = { 131, 172 }, [159] = { 131, 173 }, [160] = { 131, 174 }, [161] = { 131, 175 }, [163] = { 131, 176 }, [164] = { 131, 177 }, [165] = { 131, 178 }, [166] = { 131, 179 }, [167] = { 131, 180 }, [168] = { 131, 181 }, [169] = { 131, 182 },
		[177] = { 131, 191 }, [178] = { 131, 192 }, [179] = { 131, 193 }, [180] = { 131, 194 }, [181] = { 131, 195 }, [182] = { 131, 196 }, [183] = { 131, 197 }, [184] = { 131, 198 }, [185] = { 131, 199 }, [186] = { 131, 200 }, [187] = { 131, 201 }, [188] = { 131, 202 }, [189] = { 131, 203 }, [190] = { 131, 204 }, [191] = { 131, 205 }, [192] = { 131, 206 }, [193] = { 131, 207 }, [195] = { 131, 208 }, [196] = { 131, 209 }, [197] = { 131, 210 }, [198] = { 131, 211 }, [199] = { 131, 212 }, [200] = { 131, 213 }, [201] = { 131, 214 },
	},
	[4] = {
		[1] = { 132, 70 }, [16] = { 132, 64 }, [17] = { 132, 65 }, [18] = { 132, 66 }, [19] = { 132, 67 }, [20] = { 132, 68 }, [21] = { 132, 69 }, [22] = { 132, 71 }, [23] = { 132, 72 }, [24] = { 132, 73 }, [25] = { 132, 74 }, [26] = { 132, 75 }, [27] = { 132, 76 }, [28] = { 132, 77 }, [29] = { 132, 78 }, [30] = { 132, 79 }, [31] = { 132, 80 }, [32] = { 132, 81 }, [33] = { 132, 82 }, [34] = { 132, 83 }, [35] = { 132, 84 }, [36] = { 132, 85 }, [37] = { 132, 86 }, [38] = { 132, 87 },
		[39] = { 132, 88 }, [40] = { 132, 89 }, [41] = { 132, 90 }, [42] = { 132, 91 }, [43] = { 132, 92 }, [44] = { 132, 93 }, [45] = { 132, 94 }, [46] = { 132, 95 }, [47] = { 132, 96 }, [48] = { 132, 112 }, [49] = { 132, 113 }, [50] = { 132, 114 }, [51] = { 132, 115 }, [52] = { 132, 116 }, [53] = { 132, 117 }, [54] = { 132, 119 }, [55] = { 132, 120 }, [56] = { 132, 121 }, [57] = { 132, 122 }, [58] = { 132, 123 }, [59] = { 132, 124 }, [60] = { 132, 125 }, [61] = { 132, 126 }, [62] = { 132, 128 }, [63] = { 132, 129 },
		[64] = { 132, 130 }, [65] = { 132, 131 }, [66] = { 132, 132 }, [67] = { 132, 133 }, [68] = { 132, 134 }, [69] = { 132, 135 }, [70] = { 132, 136 }, [71] = { 132, 137 }, [72] = { 132, 138 }, [73] = { 132, 139 }, [74] = { 132, 140 }, [75] = { 132, 141 }, [76] = { 132, 142 }, [77] = { 132, 143 }, [78] = { 132, 144 }, [79] = { 132, 145 }, [81] = { 132, 118 },
	},
	[32] = {
		[16] = { 129, 93 }, [21] = { 129, 92 }, [24] = { 129, 101 }, [25] = { 129, 102 }, [28] = { 129, 103 }, [29] = { 129, 104 }, [32] = { 129, 245 }, [33] = { 129, 246 }, [37] = { 129, 100 }, [38] = { 129, 99 }, [48] = { 129, 241 }, [50] = { 129, 140 }, [51] = { 129, 141 }, [59] = { 129, 166 },
	},
	[33] = {
		[3] = { 129, 142 }, [22] = { 250, 89 }, [33] = { 250, 90 }, [43] = { 129, 240 }, [96] = { 250, 74 }, [97] = { 250, 75 }, [98] = { 250, 76 }, [99] = { 250, 77 }, [100] = { 250, 78 }, [101] = { 250, 79 }, [102] = { 250, 80 }, [103] = { 250, 81 }, [104] = { 250, 82 }, [105] = { 250, 83 }, [112] = { 250, 64 }, [113] = { 250, 65 }, [114] = { 250, 66 }, [115] = { 250, 67 }, [116] = { 250, 68 }, [117] = { 250, 69 }, [118] = { 250, 70 }, [119] = { 250, 71 }, [120] = { 250, 72 }, [121] = { 250, 73 },
		[144] = { 129, 169 }, [145] = { 129, 170 }, [146] = { 129, 168 }, [147] = { 129, 171 }, [210] = { 129, 203 }, [212] = { 129, 204 },
	},
	[34] = {
		[0] = { 129, 205 }, [2] = { 129, 221 }, [3] = { 129, 206 }, [7] = { 129, 222 }, [8] = { 129, 184 }, [11] = { 129, 185 }, [17] = { 135, 148 }, [26] = { 135, 149 }, [29] = { 129, 229 }, [30] = { 129, 135 }, [31] = { 135, 152 }, [32] = { 135, 151 }, [37] = { 129, 97 }, [39] = { 129, 200 }, [40] = { 129, 201 }, [41] = { 135, 155 }, [42] = { 135, 156 }, [43] = { 135, 146 }, [44] = { 129, 232 }, [46] = { 135, 147 }, [52] = { 129, 136 }, [53] = { 250, 91 }, [61] = { 129, 228 }, [82] = { 135, 144 },
		[96] = { 129, 130 }, [97] = { 135, 145 }, [102] = { 129, 133 }, [103] = { 129, 134 }, [106] = { 129, 225 }, [107] = { 129, 226 }, [130] = { 129, 188 }, [131] = { 129, 189 }, [134] = { 129, 186 }, [135] = { 129, 187 }, [165] = { 135, 150 }, [191] = { 135, 153 },
	},
	[35] = {
		[18] = { 129, 220 },
	},
	[36] = {
		[96] = { 135, 64 }, [97] = { 135, 65 }, [98] = { 135, 66 }, [99] = { 135, 67 }, [100] = { 135, 68 }, [101] = { 135, 69 }, [102] = { 135, 70 }, [103] = { 135, 71 }, [104] = { 135, 72 }, [105] = { 135, 73 }, [106] = { 135, 74 }, [107] = { 135, 75 }, [108] = { 135, 76 }, [109] = { 135, 77 }, [110] = { 135, 78 }, [111] = { 135, 79 }, [112] = { 135, 80 }, [113] = { 135, 81 }, [114] = { 135, 82 }, [115] = { 135, 83 },
	},
	[37] = {
		[0] = { 132, 159 }, [1] = { 132, 170 }, [2] = { 132, 160 }, [3] = { 132, 171 }, [12] = { 132, 161 }, [15] = { 132, 172 }, [16] = { 132, 162 }, [19] = { 132, 173 }, [20] = { 132, 164 }, [23] = { 132, 175 }, [24] = { 132, 163 }, [27] = { 132, 174 }, [28] = { 132, 165 }, [29] = { 132, 186 }, [32] = { 132, 181 }, [35] = { 132, 176 }, [36] = { 132, 167 }, [37] = { 132, 188 }, [40] = { 132, 183 }, [43] = { 132, 178 }, [44] = { 132, 166 }, [47] = { 132, 182 }, [48] = { 132, 187 }, [51] = { 132, 177 },
		[52] = { 132, 168 }, [55] = { 132, 184 }, [56] = { 132, 189 }, [59] = { 132, 179 }, [60] = { 132, 169 }, [63] = { 132, 185 }, [66] = { 132, 190 }, [75] = { 132, 180 }, [160] = { 129, 161 }, [161] = { 129, 160 }, [178] = { 129, 163 }, [179] = { 129, 162 }, [188] = { 129, 165 }, [189] = { 129, 164 }, [198] = { 129, 159 }, [199] = { 129, 158 }, [203] = { 129, 155 }, [206] = { 129, 157 }, [207] = { 129, 156 }, [239] = { 129, 252 },
	},
	[38] = {
		[5] = { 129, 154 }, [6] = { 129, 153 }, [64] = { 129, 138 }, [66] = { 129, 137 }, [106] = { 129, 244 }, [109] = { 129, 243 }, [111] = { 129, 242 },
	},
	[48] = {
		[0] = { 129, 64 }, [1] = { 129, 65 }, [2] = { 129, 66 }, [3] = { 129, 86 }, [5] = { 129, 88 }, [6] = { 129, 89 }, [7] = { 129, 90 }, [8] = { 129, 113 }, [9] = { 129, 114 }, [10] = { 129, 115 }, [11] = { 129, 116 }, [12] = { 129, 117 }, [13] = { 129, 118 }, [14] = { 129, 119 }, [15] = { 129, 120 }, [16] = { 129, 121 }, [17] = { 129, 122 }, [18] = { 129, 167 }, [19] = { 129, 172 }, [20] = { 129, 107 }, [21] = { 129, 108 }, [29] = { 135, 128 }, [31] = { 135, 129 }, [65] = { 130, 159 },
		[66] = { 130, 160 }, [67] = { 130, 161 }, [68] = { 130, 162 }, [69] = { 130, 163 }, [70] = { 130, 164 }, [71] = { 130, 165 }, [72] = { 130, 166 }, [73] = { 130, 167 }, [74] = { 130, 168 }, [75] = { 130, 169 }, [76] = { 130, 170 }, [77] = { 130, 171 }, [78] = { 130, 172 }, [79] = { 130, 173 }, [80] = { 130, 174 }, [81] = { 130, 175 }, [82] = { 130, 176 }, [83] = { 130, 177 }, [84] = { 130, 178 }, [85] = { 130, 179 }, [86] = { 130, 180 }, [87] = { 130, 181 }, [88] = { 130, 182 }, [89] = { 130, 183 }, [90] = { 130, 184 },
		[91] = { 130, 185 }, [92] = { 130, 186 }, [93] = { 130, 187 }, [94] = { 130, 188 }, [95] = { 130, 189 }, [96] = { 130, 190 }, [97] = { 130, 191 }, [98] = { 130, 192 }, [99] = { 130, 193 }, [100] = { 130, 194 }, [101] = { 130, 195 }, [102] = { 130, 196 }, [103] = { 130, 197 }, [104] = { 130, 198 }, [105] = { 130, 199 }, [106] = { 130, 200 }, [107] = { 130, 201 }, [108] = { 130, 202 }, [109] = { 130, 203 }, [110] = { 130, 204 }, [111] = { 130, 205 }, [112] = { 130, 206 }, [113] = { 130, 207 }, [114] = { 130, 208 }, [115] = { 130, 209 },
		[116] = { 130, 210 }, [117] = { 130, 211 }, [118] = { 130, 212 }, [119] = { 130, 213 }, [120] = { 130, 214 }, [121] = { 130, 215 }, [122] = { 130, 216 }, [123] = { 130, 217 }, [124] = { 130, 218 }, [125] = { 130, 219 }, [126] = { 130, 220 }, [127] = { 130, 221 }, [128] = { 130, 222 }, [129] = { 130, 223 }, [130] = { 130, 224 }, [131] = { 130, 225 }, [132] = { 130, 226 }, [133] = { 130, 227 }, [134] = { 130, 228 }, [135] = { 130, 229 }, [136] = { 130, 230 }, [137] = { 130, 231 }, [138] = { 130, 232 }, [139] = { 130, 233 }, [140] = { 130, 234 },
		[141] = { 130, 235 }, [142] = { 130, 236 }, [143] = { 130, 237 }, [144] = { 130, 238 }, [145] = { 130, 239 }, [146] = { 130, 240 }, [147] = { 130, 241 }, [155] = { 129, 74 }, [156] = { 129, 75 }, [157] = { 129, 84 }, [158] = { 129, 85 }, [161] = { 131, 64 }, [162] = { 131, 65 }, [163] = { 131, 66 }, [164] = { 131, 67 }, [165] = { 131, 68 }, [166] = { 131, 69 }, [167] = { 131, 70 }, [168] = { 131, 71 }, [169] = { 131, 72 }, [170] = { 131, 73 }, [171] = { 131, 74 }, [172] = { 131, 75 }, [173] = { 131, 76 }, [174] = { 131, 77 },
		[175] = { 131, 78 }, [176] = { 131, 79 }, [177] = { 131, 80 }, [178] = { 131, 81 }, [179] = { 131, 82 }, [180] = { 131, 83 }, [181] = { 131, 84 }, [182] = { 131, 85 }, [183] = { 131, 86 }, [184] = { 131, 87 }, [185] = { 131, 88 }, [186] = { 131, 89 }, [187] = { 131, 90 }, [188] = { 131, 91 }, [189] = { 131, 92 }, [190] = { 131, 93 }, [191] = { 131, 94 }, [192] = { 131, 95 }, [193] = { 131, 96 }, [194] = { 131, 97 }, [195] = { 131, 98 }, [196] = { 131, 99 }, [197] = { 131, 100 }, [198] = { 131, 101 }, [199] = { 131, 102 },
		[200] = { 131, 103 }, [201] = { 131, 104 }, [202] = { 131, 105 }, [203] = { 131, 106 }, [204] = { 131, 107 }, [205] = { 131, 108 }, [206] = { 131, 109 }, [207] = { 131, 110 }, [208] = { 131, 111 }, [209] = { 131, 112 }, [210] = { 131, 113 }, [211] = { 131, 114 }, [212] = { 131, 115 }, [213] = { 131, 116 }, [214] = { 131, 117 }, [215] = { 131, 118 }, [216] = { 131, 119 }, [217] = { 131, 120 }, [218] = { 131, 121 }, [219] = { 131, 122 }, [220] = { 131, 123 }, [221] = { 131, 124 }, [222] = { 131, 125 }, [223] = { 131, 126 }, [224] = { 131, 128 },
		[225] = { 131, 129 }, [226] = { 131, 130 }, [227] = { 131, 131 }, [228] = { 131, 132 }, [229] = { 131, 133 }, [230] = { 131, 134 }, [231] = { 131, 135 }, [232] = { 131, 136 }, [233] = { 131, 137 }, [234] = { 131, 138 }, [235] = { 131, 139 }, [236] = { 131, 140 }, [237] = { 131, 141 }, [238] = { 131, 142 }, [239] = { 131, 143 }, [240] = { 131, 144 }, [241] = { 131, 145 }, [242] = { 131, 146 }, [243] = { 131, 147 }, [244] = { 131, 148 }, [245] = { 131, 149 }, [246] = { 131, 150 }, [251] = { 129, 69 }, [252] = { 129, 91 }, [253] = { 129, 82 },
		[254] = { 129, 83 },
	},
	[50] = {
		[49] = { 250, 88 }, [50] = { 135, 139 }, [57] = { 135, 140 }, [164] = { 135, 133 }, [165] = { 135, 134 }, [166] = { 135, 135 }, [167] = { 135, 136 }, [168] = { 135, 137 },
	},
	[51] = {
		[3] = { 135, 101 }, [13] = { 135, 105 }, [20] = { 135, 96 }, [24] = { 135, 99 }, [34] = { 135, 97 }, [35] = { 135, 107 }, [38] = { 135, 106 }, [39] = { 135, 100 }, [43] = { 135, 108 }, [54] = { 135, 102 }, [59] = { 135, 110 }, [73] = { 135, 95 }, [74] = { 135, 109 }, [77] = { 135, 98 }, [81] = { 135, 103 }, [87] = { 135, 104 }, [123] = { 135, 126 }, [124] = { 135, 143 }, [125] = { 135, 142 }, [126] = { 135, 141 }, [142] = { 135, 114 }, [143] = { 135, 115 }, [156] = { 135, 111 }, [157] = { 135, 112 },
		[158] = { 135, 113 }, [161] = { 135, 117 }, [196] = { 135, 116 }, [205] = { 135, 131 },
	},
	[78] = {
		[0] = { 136, 234 }, [1] = { 146, 154 }, [3] = { 142, 181 }, [7] = { 150, 156 }, [8] = { 143, 228 }, [9] = { 142, 79 }, [10] = { 143, 227 }, [11] = { 137, 186 }, [13] = { 149, 115 }, [14] = { 151, 94 }, [16] = { 152, 160 }, [17] = { 137, 78 }, [20] = { 138, 142 }, [21] = { 152, 161 }, [22] = { 144, 162 }, [23] = { 153, 192 }, [24] = { 139, 117 }, [25] = { 149, 184 }, [30] = { 143, 229 }, [33] = { 151, 188 }, [38] = { 149, 192 }, [40] = { 250, 104 }, [42] = { 152, 162 }, [45] = { 146, 134 },
		[49] = { 152, 163 }, [50] = { 139, 248 }, [54] = { 152, 164 }, [56] = { 138, 219 }, [57] = { 146, 79 }, [59] = { 142, 229 }, [60] = { 152, 165 }, [63] = { 152, 166 }, [66] = { 152, 167 }, [67] = { 148, 84 }, [69] = { 139, 118 }, [75] = { 148, 86 }, [77] = { 147, 225 }, [78] = { 140, 193 }, [79] = { 150, 82 }, [85] = { 229, 104 }, [86] = { 152, 168 }, [87] = { 143, 230 }, [88] = { 152, 169 }, [89] = { 137, 179 }, [93] = { 139, 227 }, [94] = { 140, 238 }, [95] = { 150, 231 }, [98] = { 155, 164 }, [113] = { 151, 144 },
		[115] = { 147, 251 }, [126] = { 138, 163 }, [128] = { 139, 84 }, [130] = { 152, 170 }, [133] = { 152, 171 }, [134] = { 151, 185 }, [136] = { 151, 92 }, [137] = { 145, 136 }, [138] = { 152, 173 }, [139] = { 142, 150 }, [140] = { 147, 241 }, [142] = { 152, 176 }, [145] = { 137, 93 }, [146] = { 140, 221 }, [148] = { 140, 220 }, [149] = { 136, 228 }, [152] = { 152, 106 }, [153] = { 152, 105 }, [155] = { 141, 177 }, [156] = { 136, 159 }, [158] = { 152, 177 }, [159] = { 152, 178 }, [160] = { 152, 179 }, [161] = { 150, 83 }, [162] = { 152, 180 },
		[164] = { 140, 240 }, [165] = { 136, 229 }, [166] = { 150, 146 }, [168] = { 139, 156 }, [171] = { 139, 157 }, [172] = { 139, 158 }, [173] = { 146, 224 }, [174] = { 151, 186 }, [176] = { 152, 181 }, [179] = { 152, 182 }, [182] = { 152, 183 }, [186] = { 144, 108 }, [192] = { 143, 89 }, [193] = { 144, 109 }, [194] = { 152, 188 }, [196] = { 152, 186 }, [198] = { 152, 187 }, [199] = { 139, 119 }, [202] = { 141, 161 }, [203] = { 137, 238 }, [205] = { 152, 185 }, [206] = { 152, 184 }, [207] = { 149, 167 }, [212] = { 142, 101 }, [213] = { 142, 100 },
		[214] = { 145, 188 }, [215] = { 152, 189 }, [216] = { 149, 116 }, [217] = { 144, 229 }, [221] = { 129, 87 }, [222] = { 152, 190 }, [223] = { 152, 192 }, [225] = { 250, 105 }, [227] = { 145, 227 }, [228] = { 151, 223 }, [229] = { 136, 200 }, [237] = { 152, 191 }, [238] = { 137, 188 }, [240] = { 139, 194 }, [242] = { 146, 135 }, [246] = { 140, 143 }, [247] = { 152, 193 }, [251] = { 148, 67 }, [252] = { 250, 106 },
	},
	[79] = {
		[0] = { 250, 107 }, [1] = { 138, 233 }, [3] = { 250, 108 }, [9] = { 152, 194 }, [10] = { 136, 201 }, [13] = { 140, 222 }, [14] = { 138, 234 }, [15] = { 149, 154 }, [16] = { 148, 176 }, [17] = { 139, 120 }, [26] = { 137, 239 }, [28] = { 152, 229 }, [29] = { 147, 96 }, [47] = { 148, 140 }, [48] = { 152, 196 }, [52] = { 148, 186 }, [54] = { 151, 224 }, [56] = { 144, 76 }, [57] = { 250, 109 }, [58] = { 142, 102 }, [60] = { 142, 151 }, [61] = { 137, 190 }, [67] = { 146, 207 }, [70] = { 146, 65 },
		[71] = { 152, 200 }, [77] = { 136, 202 }, [78] = { 146, 225 }, [79] = { 143, 90 }, [80] = { 141, 178 }, [81] = { 151, 67 }, [83] = { 145, 204 }, [85] = { 137, 189 }, [86] = { 250, 110 }, [87] = { 152, 199 }, [89] = { 151, 93 }, [90] = { 152, 195 }, [91] = { 152, 197 }, [92] = { 141, 236 }, [93] = { 152, 198 }, [94] = { 155, 67 }, [105] = { 152, 206 }, [111] = { 152, 209 }, [112] = { 152, 207 }, [115] = { 137, 192 }, [117] = { 149, 185 }, [118] = { 152, 201 }, [123] = { 152, 205 }, [124] = { 140, 241 }, [127] = { 142, 103 },
		[131] = { 138, 164 }, [134] = { 152, 210 }, [136] = { 152, 202 }, [138] = { 250, 112 }, [139] = { 151, 225 }, [141] = { 142, 152 }, [143] = { 152, 203 }, [145] = { 152, 208 }, [146] = { 250, 111 }, [148] = { 250, 114 }, [150] = { 152, 211 }, [152] = { 152, 204 }, [154] = { 250, 113 }, [155] = { 139, 159 }, [157] = { 136, 203 }, [160] = { 139, 160 }, [161] = { 137, 191 }, [171] = { 155, 68 }, [173] = { 150, 153 }, [174] = { 149, 142 }, [175] = { 140, 242 }, [181] = { 144, 78 }, [182] = { 151, 181 }, [191] = { 149, 214 }, [194] = { 140, 87 },
		[195] = { 145, 163 }, [196] = { 137, 226 }, [201] = { 250, 97 }, [202] = { 143, 114 }, [205] = { 250, 115 }, [206] = { 152, 215 }, [208] = { 152, 220 }, [209] = { 152, 218 }, [212] = { 152, 213 }, [215] = { 145, 173 }, [216] = { 152, 216 }, [218] = { 152, 219 }, [219] = { 152, 217 }, [221] = { 149, 219 }, [223] = { 152, 214 }, [225] = { 144, 77 }, [227] = { 150, 147 }, [228] = { 152, 221 }, [229] = { 152, 222 }, [238] = { 143, 67 }, [239] = { 152, 235 }, [243] = { 148, 111 }, [245] = { 149, 85 }, [246] = { 152, 230 }, [248] = { 149, 238 },
		[250] = { 137, 180 }, [254] = { 152, 234 }, [255] = { 250, 118 },
	},
	[80] = {
		[5] = { 152, 228 }, [6] = { 152, 237 }, [9] = { 145, 113 }, [11] = { 140, 194 }, [13] = { 148, 123 }, [15] = { 224, 197 }, [17] = { 152, 236 }, [18] = { 147, 124 }, [20] = { 152, 225 }, [22] = { 140, 244 }, [25] = { 140, 243 }, [26] = { 152, 223 }, [30] = { 250, 119 }, [31] = { 142, 216 }, [33] = { 152, 231 }, [34] = { 250, 117 }, [35] = { 149, 237 }, [36] = { 146, 108 }, [37] = { 152, 227 }, [38] = { 140, 145 }, [40] = { 152, 224 }, [41] = { 152, 232 }, [42] = { 152, 226 }, [43] = { 151, 207 },
		[44] = { 152, 233 }, [45] = { 152, 96 }, [54] = { 139, 228 }, [57] = { 140, 144 }, [64] = { 250, 116 }, [66] = { 250, 122 }, [67] = { 152, 238 }, [70] = { 250, 120 }, [71] = { 152, 239 }, [72] = { 152, 243 }, [73] = { 136, 204 }, [79] = { 149, 206 }, [80] = { 152, 242 }, [85] = { 152, 241 }, [86] = { 152, 245 }, [90] = { 152, 244 }, [92] = { 146, 226 }, [101] = { 140, 146 }, [108] = { 152, 246 }, [112] = { 250, 121 }, [114] = { 142, 195 }, [116] = { 145, 164 }, [117] = { 146, 227 }, [118] = { 139, 244 }, [120] = { 152, 247 },
		[125] = { 139, 85 }, [128] = { 152, 248 }, [133] = { 152, 250 }, [141] = { 150, 84 }, [145] = { 140, 134 }, [148] = { 250, 123 }, [152] = { 142, 80 }, [153] = { 148, 245 }, [154] = { 152, 249 }, [172] = { 141, 195 }, [173] = { 151, 98 }, [178] = { 152, 252 }, [179] = { 153, 66 }, [180] = { 152, 251 }, [181] = { 141, 194 }, [183] = { 143, 157 }, [190] = { 140, 88 }, [194] = { 153, 67 }, [197] = { 139, 205 }, [201] = { 153, 64 }, [202] = { 153, 65 }, [205] = { 147, 173 }, [207] = { 145, 156 }, [209] = { 139, 161 }, [213] = { 150, 108 },
		[214] = { 153, 68 }, [216] = { 250, 125 }, [218] = { 151, 187 }, [222] = { 153, 69 }, [227] = { 153, 72 }, [229] = { 153, 70 }, [231] = { 145, 109 }, [237] = { 153, 71 }, [238] = { 153, 73 }, [244] = { 250, 124 }, [245] = { 153, 75 }, [249] = { 153, 74 }, [251] = { 149, 198 },
	},
	[81] = {
		[0] = { 139, 86 }, [1] = { 153, 77 }, [2] = { 153, 78 }, [4] = { 137, 173 }, [9] = { 153, 76 }, [18] = { 142, 242 }, [20] = { 153, 81 }, [21] = { 153, 80 }, [22] = { 153, 79 }, [24] = { 152, 212 }, [26] = { 153, 82 }, [31] = { 143, 158 }, [33] = { 153, 83 }, [42] = { 151, 68 }, [50] = { 150, 215 }, [55] = { 153, 85 }, [58] = { 153, 84 }, [59] = { 153, 87 }, [60] = { 153, 86 }, [63] = { 153, 88 }, [64] = { 153, 89 }, [65] = { 136, 242 }, [67] = { 140, 179 }, [68] = { 140, 90 },
		[69] = { 143, 91 }, [70] = { 146, 155 }, [71] = { 139, 162 }, [72] = { 144, 230 }, [73] = { 140, 245 }, [74] = { 250, 126 }, [75] = { 141, 142 }, [76] = { 153, 91 }, [77] = { 150, 198 }, [78] = { 147, 101 }, [80] = { 142, 153 }, [82] = { 153, 90 }, [84] = { 153, 92 }, [90] = { 147, 125 }, [92] = { 138, 149 }, [98] = { 153, 93 }, [100] = { 250, 128 }, [101] = { 147, 252 }, [104] = { 145, 83 }, [105] = { 153, 95 }, [106] = { 153, 96 }, [107] = { 148, 170 }, [108] = { 140, 246 }, [109] = { 152, 90 }, [110] = { 153, 97 },
		[113] = { 139, 164 }, [117] = { 149, 186 }, [118] = { 145, 180 }, [119] = { 139, 239 }, [120] = { 147, 84 }, [124] = { 140, 147 }, [128] = { 153, 98 }, [130] = { 153, 99 }, [133] = { 147, 224 }, [134] = { 137, 126 }, [137] = { 153, 102 }, [138] = { 141, 251 }, [140] = { 153, 101 }, [141] = { 141, 196 }, [143] = { 153, 103 }, [144] = { 227, 236 }, [145] = { 153, 104 }, [146] = { 150, 96 }, [147] = { 153, 105 }, [149] = { 153, 106 }, [150] = { 153, 107 }, [151] = { 143, 231 }, [153] = { 142, 202 }, [157] = { 250, 129 }, [160] = { 138, 165 },
		[162] = { 153, 110 }, [164] = { 153, 108 }, [165] = { 150, 187 }, [166] = { 153, 109 }, [168] = { 149, 121 }, [169] = { 153, 111 }, [170] = { 153, 112 }, [171] = { 153, 113 }, [172] = { 147, 126 }, [176] = { 153, 117 }, [177] = { 153, 115 }, [178] = { 153, 116 }, [179] = { 153, 114 }, [180] = { 141, 225 }, [181] = { 153, 118 }, [182] = { 150, 232 }, [183] = { 151, 226 }, [189] = { 153, 119 }, [190] = { 250, 130 }, [196] = { 144, 166 }, [197] = { 153, 120 }, [198] = { 143, 121 }, [201] = { 153, 121 }, [203] = { 146, 156 }, [204] = { 151, 189 },
		[205] = { 147, 128 }, [214] = { 153, 195 }, [219] = { 153, 122 }, [220] = { 234, 163 }, [221] = { 139, 195 }, [224] = { 153, 123 }, [225] = { 150, 125 }, [230] = { 143, 136 }, [231] = { 145, 250 }, [233] = { 153, 125 }, [234] = { 147, 226 }, [236] = { 250, 131 }, [237] = { 153, 126 }, [240] = { 153, 128 }, [241] = { 138, 77 }, [245] = { 153, 129 }, [246] = { 139, 165 }, [248] = { 147, 202 }, [249] = { 137, 154 }, [250] = { 143, 111 }, [253] = { 148, 159 }, [254] = { 153, 130 },
	},
	[82] = {
		[0] = { 147, 129 }, [3] = { 144, 110 }, [4] = { 153, 131 }, [6] = { 149, 170 }, [7] = { 144, 216 }, [8] = { 138, 160 }, [10] = { 138, 167 }, [11] = { 153, 132 }, [14] = { 153, 134 }, [17] = { 140, 89 }, [20] = { 153, 133 }, [21] = { 250, 132 }, [23] = { 151, 241 }, [29] = { 143, 137 }, [36] = { 148, 187 }, [37] = { 149, 202 }, [39] = { 153, 135 }, [41] = { 151, 152 }, [42] = { 153, 136 }, [46] = { 153, 137 }, [48] = { 147, 158 }, [51] = { 153, 138 }, [54] = { 144, 167 }, [55] = { 141, 252 },
		[56] = { 140, 148 }, [57] = { 153, 139 }, [58] = { 142, 104 }, [59] = { 141, 143 }, [67] = { 146, 228 }, [68] = { 153, 141 }, [71] = { 145, 165 }, [74] = { 141, 237 }, [75] = { 153, 142 }, [76] = { 153, 143 }, [77] = { 145, 79 }, [79] = { 153, 140 }, [84] = { 153, 145 }, [86] = { 150, 85 }, [91] = { 141, 132 }, [94] = { 153, 144 }, [99] = { 140, 149 }, [100] = { 141, 220 }, [101] = { 148, 141 }, [105] = { 153, 148 }, [106] = { 153, 146 }, [111] = { 149, 155 }, [112] = { 143, 232 }, [113] = { 153, 155 }, [114] = { 138, 132 },
		[115] = { 153, 149 }, [116] = { 153, 147 }, [117] = { 145, 110 }, [125] = { 153, 151 }, [127] = { 153, 150 }, [131] = { 138, 99 }, [135] = { 140, 128 }, [136] = { 153, 156 }, [137] = { 151, 171 }, [141] = { 153, 152 }, [145] = { 153, 157 }, [146] = { 153, 154 }, [148] = { 153, 153 }, [155] = { 151, 205 }, [156] = { 250, 133 }, [159] = { 140, 247 }, [160] = { 137, 193 }, [163] = { 151, 242 }, [166] = { 250, 134 }, [169] = { 143, 149 }, [170] = { 147, 119 }, [171] = { 141, 133 }, [172] = { 153, 160 }, [173] = { 153, 161 }, [175] = { 251, 119 },
		[177] = { 151, 227 }, [180] = { 152, 74 }, [181] = { 153, 163 }, [185] = { 140, 248 }, [188] = { 153, 162 }, [190] = { 138, 78 }, [192] = { 250, 135 }, [193] = { 153, 164 }, [195] = { 150, 117 }, [197] = { 146, 186 }, [199] = { 151, 69 }, [201] = { 149, 215 }, [205] = { 153, 165 }, [210] = { 232, 211 }, [213] = { 147, 174 }, [215] = { 153, 166 }, [216] = { 138, 168 }, [217] = { 150, 177 }, [219] = { 250, 136 }, [221] = { 143, 159 }, [222] = { 153, 167 }, [223] = { 149, 229 }, [224] = { 153, 171 }, [226] = { 144, 168 }, [227] = { 153, 168 },
		[228] = { 139, 206 }, [230] = { 153, 169 }, [231] = { 138, 169 }, [242] = { 140, 77 }, [243] = { 153, 172 }, [245] = { 153, 173 }, [248] = { 153, 174 }, [249] = { 153, 175 }, [250] = { 142, 217 }, [254] = { 140, 249 }, [255] = { 150, 220 },
	},
	[83] = {
		[0] = { 250, 137 }, [1] = { 150, 230 }, [2] = { 147, 245 }, [5] = { 149, 239 }, [6] = { 153, 176 }, [7] = { 250, 138 }, [8] = { 153, 177 }, [13] = { 153, 179 }, [15] = { 153, 181 }, [16] = { 153, 180 }, [21] = { 153, 182 }, [22] = { 137, 187 }, [23] = { 150, 107 }, [25] = { 141, 250 }, [26] = { 153, 183 }, [29] = { 145, 120 }, [32] = { 143, 160 }, [33] = { 139, 167 }, [35] = { 153, 184 }, [36] = { 250, 139 }, [42] = { 148, 217 }, [47] = { 153, 185 }, [49] = { 153, 186 }, [51] = { 153, 187 },
		[56] = { 153, 188 }, [57] = { 149, 67 }, [58] = { 139, 230 }, [59] = { 136, 227 }, [63] = { 147, 189 }, [64] = { 153, 189 }, [65] = { 143, 92 }, [67] = { 144, 231 }, [69] = { 153, 191 }, [70] = { 153, 190 }, [71] = { 143, 161 }, [72] = { 140, 223 }, [73] = { 153, 193 }, [74] = { 148, 188 }, [77] = { 153, 194 }, [81] = { 148, 218 }, [82] = { 145, 178 }, [83] = { 145, 236 }, [84] = { 139, 166 }, [87] = { 147, 236 }, [88] = { 146, 80 }, [90] = { 148, 142 }, [92] = { 150, 109 }, [94] = { 153, 196 }, [96] = { 144, 232 },
		[102] = { 140, 84 }, [105] = { 153, 197 }, [110] = { 153, 198 }, [111] = { 137, 75 }, [112] = { 136, 243 }, [113] = { 138, 235 }, [114] = { 250, 140 }, [115] = { 145, 166 }, [116] = { 139, 112 }, [117] = { 151, 145 }, [119] = { 153, 201 }, [120] = { 137, 181 }, [123] = { 153, 200 }, [127] = { 139, 168 }, [130] = { 153, 202 }, [132] = { 150, 239 }, [147] = { 250, 141 }, [150] = { 153, 203 }, [152] = { 151, 208 }, [154] = { 140, 250 }, [159] = { 140, 180 }, [160] = { 153, 204 }, [165] = { 153, 206 }, [166] = { 153, 205 }, [168] = { 144, 126 },
		[169] = { 137, 88 }, [173] = { 137, 125 }, [174] = { 153, 207 }, [176] = { 153, 208 }, [178] = { 250, 142 }, [179] = { 140, 181 }, [182] = { 153, 209 }, [187] = { 139, 142 }, [194] = { 142, 81 }, [195] = { 153, 210 }, [200] = { 150, 148 }, [201] = { 141, 179 }, [202] = { 139, 121 }, [203] = { 151, 70 }, [204] = { 145, 111 }, [205] = { 148, 189 }, [206] = { 142, 251 }, [212] = { 143, 102 }, [214] = { 142, 230 }, [215] = { 142, 243 }, [217] = { 143, 150 }, [219] = { 148, 190 }, [221] = { 250, 143 }, [223] = { 153, 213 }, [225] = { 137, 98 },
		[226] = { 145, 112 }, [227] = { 140, 251 }, [228] = { 140, 195 }, [229] = { 139, 229 }, [232] = { 153, 217 }, [233] = { 146, 64 }, [234] = { 145, 252 }, [235] = { 139, 169 }, [236] = { 143, 162 }, [237] = { 153, 218 }, [238] = { 153, 216 }, [239] = { 137, 194 }, [240] = { 145, 228 }, [241] = { 142, 182 }, [242] = { 142, 106 }, [243] = { 137, 69 }, [246] = { 138, 144 }, [247] = { 141, 134 }, [248] = { 142, 105 }, [250] = { 153, 219 },
	},
	[84] = {
		[1] = { 153, 220 }, [3] = { 139, 104 }, [4] = { 138, 101 }, [8] = { 141, 135 }, [9] = { 139, 103 }, [10] = { 146, 221 }, [11] = { 137, 68 }, [12] = { 147, 175 }, [13] = { 150, 188 }, [14] = { 141, 64 }, [15] = { 151, 153 }, [16] = { 147, 102 }, [17] = { 140, 252 }, [27] = { 140, 78 }, [29] = { 153, 229 }, [31] = { 139, 225 }, [32] = { 150, 105 }, [38] = { 148, 219 }, [41] = { 153, 228 }, [43] = { 138, 220 }, [44] = { 153, 223 }, [45] = { 153, 224 }, [46] = { 153, 226 }, [54] = { 153, 227 },
		[56] = { 139, 122 }, [57] = { 144, 129 }, [59] = { 149, 171 }, [60] = { 153, 225 }, [61] = { 153, 221 }, [62] = { 140, 225 }, [64] = { 153, 222 }, [66] = { 152, 67 }, [70] = { 149, 240 }, [72] = { 146, 230 }, [73] = { 140, 224 }, [74] = { 141, 144 }, [78] = { 153, 230 }, [81] = { 147, 219 }, [95] = { 153, 234 }, [104] = { 142, 252 }, [106] = { 142, 244 }, [112] = { 153, 237 }, [113] = { 153, 235 }, [115] = { 150, 161 }, [117] = { 153, 232 }, [118] = { 153, 241 }, [119] = { 153, 236 }, [123] = { 153, 239 }, [124] = { 140, 196 },
		[125] = { 150, 189 }, [128] = { 153, 240 }, [132] = { 153, 242 }, [134] = { 153, 244 }, [138] = { 250, 146 }, [139] = { 141, 238 }, [140] = { 152, 97 }, [142] = { 153, 233 }, [143] = { 153, 231 }, [144] = { 153, 243 }, [146] = { 153, 238 }, [156] = { 250, 145 }, [162] = { 153, 246 }, [164] = { 154, 66 }, [165] = { 153, 248 }, [168] = { 153, 252 }, [169] = { 250, 147 }, [171] = { 154, 64 }, [172] = { 153, 249 }, [175] = { 154, 93 }, [178] = { 141, 231 }, [179] = { 138, 80 }, [184] = { 153, 247 }, [188] = { 154, 68 }, [189] = { 136, 244 },
		[190] = { 154, 67 }, [192] = { 136, 163 }, [193] = { 149, 105 }, [194] = { 154, 65 }, [196] = { 153, 250 }, [199] = { 153, 245 }, [200] = { 153, 251 }, [201] = { 141, 198 }, [216] = { 154, 69 }, [225] = { 136, 245 }, [226] = { 154, 78 }, [229] = { 154, 70 }, [230] = { 154, 71 }, [232] = { 143, 163 }, [233] = { 150, 137 }, [237] = { 154, 76 }, [238] = { 154, 75 }, [242] = { 147, 78 }, [250] = { 154, 77 }, [253] = { 154, 74 }, [255] = { 250, 148 },
	},
	[85] = {
		[4] = { 137, 83 }, [6] = { 141, 180 }, [7] = { 144, 79 }, [15] = { 154, 72 }, [16] = { 147, 130 }, [20] = { 154, 73 }, [22] = { 136, 160 }, [46] = { 154, 83 }, [47] = { 151, 66 }, [49] = { 143, 165 }, [51] = { 154, 89 }, [56] = { 154, 88 }, [57] = { 154, 79 }, [62] = { 145, 193 }, [64] = { 154, 80 }, [68] = { 145, 237 }, [69] = { 154, 85 }, [70] = { 143, 164 }, [76] = { 154, 82 }, [79] = { 150, 226 }, [83] = { 140, 91 }, [86] = { 154, 86 }, [87] = { 154, 87 }, [92] = { 154, 84 },
		[93] = { 154, 90 }, [99] = { 154, 81 }, [123] = { 154, 96 }, [124] = { 154, 101 }, [126] = { 154, 97 }, [128] = { 154, 92 }, [131] = { 154, 102 }, [132] = { 145, 80 }, [134] = { 250, 149 }, [135] = { 154, 104 }, [137] = { 141, 65 }, [138] = { 154, 94 }, [139] = { 146, 157 }, [152] = { 154, 98 }, [153] = { 154, 91 }, [154] = { 138, 171 }, [156] = { 138, 236 }, [157] = { 138, 133 }, [158] = { 154, 99 }, [159] = { 154, 95 }, [167] = { 140, 150 }, [168] = { 154, 105 }, [169] = { 154, 103 }, [170] = { 145, 114 }, [171] = { 139, 105 },
		[172] = { 139, 170 }, [174] = { 154, 100 }, [176] = { 139, 242 }, [182] = { 137, 99 }, [196] = { 154, 109 }, [197] = { 154, 107 }, [199] = { 154, 165 }, [212] = { 154, 112 }, [218] = { 154, 106 }, [220] = { 154, 110 }, [223] = { 154, 108 }, [227] = { 142, 107 }, [228] = { 154, 111 }, [247] = { 154, 114 }, [249] = { 154, 119 }, [253] = { 154, 117 }, [254] = { 154, 116 },
	},
	[86] = {
		[6] = { 146, 81 }, [9] = { 137, 195 }, [20] = { 154, 113 }, [22] = { 154, 115 }, [23] = { 143, 166 }, [24] = { 137, 82 }, [27] = { 154, 118 }, [41] = { 137, 220 }, [47] = { 154, 130 }, [49] = { 143, 250 }, [50] = { 154, 125 }, [52] = { 154, 123 }, [54] = { 154, 124 }, [56] = { 154, 126 }, [66] = { 137, 92 }, [76] = { 145, 88 }, [78] = { 154, 120 }, [80] = { 154, 121 }, [91] = { 138, 154 }, [100] = { 154, 129 }, [104] = { 138, 237 }, [106] = { 154, 132 }, [107] = { 154, 128 }, [108] = { 154, 131 },
		[116] = { 149, 172 }, [120] = { 147, 211 }, [122] = { 148, 182 }, [128] = { 154, 134 }, [134] = { 154, 133 }, [135] = { 138, 100 }, [138] = { 154, 135 }, [143] = { 154, 138 }, [148] = { 154, 137 }, [160] = { 154, 136 }, [162] = { 148, 88 }, [165] = { 154, 139 }, [174] = { 154, 140 }, [180] = { 154, 142 }, [182] = { 154, 141 }, [188] = { 154, 144 }, [192] = { 154, 147 }, [193] = { 154, 145 }, [194] = { 154, 143 }, [195] = { 154, 146 }, [200] = { 154, 148 }, [206] = { 154, 149 }, [209] = { 154, 150 }, [211] = { 154, 151 }, [215] = { 154, 152 },
		[216] = { 153, 100 }, [218] = { 142, 250 }, [219] = { 142, 108 }, [222] = { 137, 241 }, [224] = { 136, 246 }, [227] = { 146, 99 }, [238] = { 154, 153 }, [240] = { 141, 162 }, [242] = { 136, 205 }, [243] = { 144, 125 }, [249] = { 154, 154 }, [250] = { 140, 197 }, [253] = { 141, 145 }, [255] = { 154, 156 },
	},
	[87] = {
		[0] = { 154, 155 }, [3] = { 149, 222 }, [4] = { 154, 157 }, [8] = { 154, 159 }, [9] = { 154, 158 }, [11] = { 154, 160 }, [13] = { 154, 161 }, [15] = { 140, 151 }, [18] = { 137, 128 }, [19] = { 154, 162 }, [22] = { 154, 164 }, [24] = { 154, 163 }, [28] = { 154, 166 }, [31] = { 147, 121 }, [38] = { 154, 167 }, [39] = { 136, 179 }, [40] = { 141, 221 }, [45] = { 140, 92 }, [48] = { 146, 110 }, [55] = { 154, 168 }, [56] = { 154, 169 }, [59] = { 154, 171 }, [64] = { 154, 172 }, [66] = { 141, 226 },
		[71] = { 139, 207 }, [74] = { 150, 86 }, [78] = { 154, 170 }, [79] = { 154, 173 }, [80] = { 141, 191 }, [81] = { 141, 66 }, [89] = { 250, 150 }, [97] = { 154, 177 }, [100] = { 141, 163 }, [101] = { 250, 151 }, [102] = { 146, 82 }, [105] = { 154, 174 }, [106] = { 146, 216 }, [127] = { 154, 178 }, [130] = { 144, 130 }, [136] = { 154, 176 }, [137] = { 154, 179 }, [139] = { 140, 94 }, [147] = { 154, 180 }, [160] = { 154, 181 }, [162] = { 141, 67 }, [163] = { 138, 95 }, [164] = { 154, 183 }, [170] = { 154, 184 }, [172] = { 250, 152 },
		[176] = { 154, 185 }, [179] = { 154, 182 }, [192] = { 154, 175 }, [195] = { 154, 186 }, [198] = { 154, 187 }, [199] = { 250, 154 }, [200] = { 250, 153 }, [203] = { 150, 132 }, [206] = { 143, 233 }, [210] = { 154, 189 }, [211] = { 154, 190 }, [212] = { 154, 188 }, [214] = { 154, 192 }, [220] = { 148, 87 }, [223] = { 136, 230 }, [224] = { 149, 117 }, [227] = { 154, 193 }, [244] = { 143, 251 }, [247] = { 142, 183 }, [249] = { 148, 124 }, [250] = { 138, 238 }, [252] = { 141, 233 },
	},
	[88] = {
		[0] = { 150, 120 }, [2] = { 147, 176 }, [5] = { 140, 152 }, [6] = { 145, 205 }, [10] = { 154, 191 }, [11] = { 154, 194 }, [21] = { 145, 194 }, [25] = { 154, 195 }, [29] = { 154, 196 }, [33] = { 154, 198 }, [36] = { 146, 231 }, [42] = { 138, 172 }, [47] = { 234, 159 }, [48] = { 137, 129 }, [49] = { 149, 241 }, [52] = { 143, 234 }, [53] = { 147, 103 }, [58] = { 141, 228 }, [61] = { 154, 204 }, [64] = { 149, 187 }, [65] = { 151, 219 }, [74] = { 137, 242 }, [75] = { 154, 200 }, [81] = { 145, 89 },
		[82] = { 154, 203 }, [84] = { 147, 131 }, [87] = { 147, 104 }, [88] = { 147, 132 }, [89] = { 148, 183 }, [90] = { 146, 203 }, [94] = { 141, 199 }, [98] = { 154, 199 }, [105] = { 137, 150 }, [107] = { 147, 85 }, [112] = { 154, 201 }, [114] = { 154, 197 }, [117] = { 144, 111 }, [121] = { 154, 205 }, [126] = { 143, 109 }, [131] = { 139, 171 }, [133] = { 154, 206 }, [147] = { 149, 230 }, [151] = { 145, 157 }, [156] = { 146, 196 }, [158] = { 250, 157 }, [159] = { 154, 208 }, [168] = { 150, 110 }, [171] = { 154, 209 }, [174] = { 154, 214 },
		[178] = { 250, 158 }, [179] = { 149, 173 }, [184] = { 154, 213 }, [185] = { 154, 207 }, [186] = { 154, 210 }, [187] = { 154, 212 }, [190] = { 141, 164 }, [193] = { 149, 199 }, [197] = { 154, 215 }, [199] = { 146, 100 }, [202] = { 137, 243 }, [204] = { 143, 235 }, [209] = { 154, 217 }, [211] = { 154, 216 }, [213] = { 141, 136 }, [215] = { 154, 218 }, [216] = { 154, 220 }, [217] = { 154, 219 }, [220] = { 154, 222 }, [222] = { 154, 211 }, [223] = { 154, 224 }, [228] = { 154, 223 }, [229] = { 154, 221 }, [235] = { 142, 109 }, [236] = { 144, 112 },
		[238] = { 145, 115 }, [239] = { 154, 225 }, [240] = { 144, 186 }, [241] = { 136, 235 }, [242] = { 148, 132 }, [247] = { 146, 217 }, [249] = { 154, 227 }, [250] = { 154, 226 }, [251] = { 154, 228 }, [252] = { 154, 229 }, [253] = { 154, 230 },
	},
	[89] = {
		[2] = { 154, 231 }, [9] = { 149, 207 }, [10] = { 154, 232 }, [11] = { 250, 159 }, [15] = { 137, 196 }, [16] = { 154, 233 }, [21] = { 151, 91 }, [22] = { 138, 79 }, [24] = { 153, 199 }, [25] = { 143, 103 }, [26] = { 145, 189 }, [27] = { 154, 234 }, [28] = { 150, 233 }, [34] = { 150, 178 }, [37] = { 154, 236 }, [39] = { 145, 229 }, [41] = { 147, 86 }, [42] = { 145, 190 }, [43] = { 149, 118 }, [44] = { 154, 237 }, [45] = { 154, 238 }, [46] = { 137, 155 }, [49] = { 142, 184 }, [50] = { 154, 239 },
		[55] = { 136, 206 }, [56] = { 154, 240 }, [62] = { 154, 241 }, [68] = { 137, 130 }, [71] = { 138, 239 }, [72] = { 147, 222 }, [73] = { 149, 242 }, [78] = { 154, 245 }, [79] = { 145, 116 }, [80] = { 154, 244 }, [81] = { 140, 95 }, [83] = { 250, 160 }, [84] = { 150, 122 }, [85] = { 154, 243 }, [87] = { 147, 133 }, [88] = { 154, 247 }, [90] = { 154, 246 }, [91] = { 250, 161 }, [93] = { 250, 162 }, [96] = { 154, 249 }, [98] = { 154, 248 }, [99] = { 250, 163 }, [101] = { 137, 156 }, [103] = { 154, 250 }, [104] = { 143, 167 },
		[105] = { 154, 252 }, [106] = { 146, 68 }, [108] = { 154, 251 }, [110] = { 149, 177 }, [115] = { 143, 151 }, [116] = { 147, 122 }, [120] = { 155, 64 }, [125] = { 141, 68 }, [129] = { 155, 65 }, [130] = { 148, 64 }, [131] = { 148, 220 }, [132] = { 150, 207 }, [138] = { 148, 68 }, [141] = { 155, 74 }, [147] = { 139, 87 }, [150] = { 151, 100 }, [153] = { 150, 173 }, [155] = { 155, 170 }, [157] = { 155, 66 }, [163] = { 155, 69 }, [164] = { 250, 164 }, [165] = { 145, 195 }, [168] = { 150, 87 }, [172] = { 147, 105 }, [178] = { 155, 70 },
		[185] = { 150, 133 }, [186] = { 250, 165 }, [187] = { 141, 200 }, [190] = { 143, 168 }, [198] = { 155, 71 }, [201] = { 142, 111 }, [203] = { 142, 110 }, [208] = { 136, 183 }, [209] = { 140, 198 }, [211] = { 144, 169 }, [212] = { 136, 207 }, [217] = { 155, 75 }, [218] = { 155, 76 }, [220] = { 155, 73 }, [229] = { 137, 87 }, [230] = { 138, 173 }, [232] = { 155, 72 }, [234] = { 150, 195 }, [235] = { 149, 80 }, [246] = { 136, 166 }, [251] = { 136, 247 }, [255] = { 142, 112 },
	},
	[90] = {
		[1] = { 136, 208 }, [3] = { 136, 161 }, [9] = { 155, 81 }, [17] = { 155, 79 }, [24] = { 150, 186 }, [26] = { 155, 82 }, [28] = { 155, 80 }, [31] = { 155, 78 }, [32] = { 144, 80 }, [37] = { 155, 77 }, [41] = { 149, 216 }, [47] = { 140, 226 }, [53] = { 155, 86 }, [54] = { 155, 87 }, [60] = { 143, 169 }, [64] = { 155, 83 }, [65] = { 152, 75 }, [70] = { 148, 107 }, [73] = { 155, 85 }, [90] = { 141, 165 }, [98] = { 155, 88 }, [102] = { 149, 119 }, [106] = { 155, 89 }, [108] = { 155, 84 },
		[127] = { 150, 185 }, [146] = { 148, 125 }, [154] = { 155, 90 }, [155] = { 149, 81 }, [188] = { 155, 91 }, [189] = { 155, 95 }, [190] = { 155, 92 }, [193] = { 137, 197 }, [194] = { 155, 94 }, [201] = { 142, 185 }, [203] = { 155, 93 }, [204] = { 140, 153 }, [208] = { 155, 107 }, [214] = { 155, 100 }, [215] = { 155, 97 }, [225] = { 146, 132 }, [227] = { 155, 96 }, [230] = { 155, 98 }, [233] = { 155, 99 }, [250] = { 155, 101 }, [251] = { 155, 102 },
	},
	[91] = {
		[9] = { 138, 240 }, [11] = { 155, 104 }, [12] = { 155, 103 }, [22] = { 155, 105 }, [34] = { 143, 236 }, [42] = { 155, 108 }, [44] = { 146, 218 }, [48] = { 137, 100 }, [50] = { 155, 106 }, [54] = { 155, 109 }, [62] = { 155, 110 }, [64] = { 155, 113 }, [67] = { 155, 111 }, [69] = { 155, 112 }, [80] = { 142, 113 }, [81] = { 155, 114 }, [84] = { 141, 69 }, [85] = { 155, 115 }, [86] = { 250, 166 }, [87] = { 142, 154 }, [88] = { 145, 182 }, [90] = { 155, 116 }, [91] = { 155, 117 }, [92] = { 142, 121 },
		[93] = { 141, 70 }, [95] = { 150, 208 }, [99] = { 139, 71 }, [100] = { 140, 199 }, [101] = { 155, 118 }, [102] = { 138, 119 }, [105] = { 155, 119 }, [107] = { 145, 183 }, [112] = { 155, 120 }, [113] = { 155, 161 }, [115] = { 155, 121 }, [117] = { 155, 122 }, [120] = { 155, 123 }, [122] = { 155, 125 }, [128] = { 155, 126 }, [131] = { 155, 128 }, [133] = { 145, 238 }, [135] = { 137, 70 }, [136] = { 142, 231 }, [137] = { 136, 192 }, [139] = { 145, 118 }, [140] = { 138, 174 }, [141] = { 142, 179 }, [143] = { 141, 71 }, [149] = { 147, 134 },
		[151] = { 143, 64 }, [152] = { 138, 175 }, [153] = { 146, 136 }, [154] = { 146, 232 }, [155] = { 136, 182 }, [156] = { 139, 88 }, [157] = { 149, 243 }, [159] = { 142, 192 }, [162] = { 139, 113 }, [163] = { 144, 233 }, [164] = { 142, 186 }, [165] = { 151, 71 }, [166] = { 155, 129 }, [174] = { 139, 123 }, [176] = { 141, 201 }, [179] = { 138, 81 }, [180] = { 137, 131 }, [181] = { 143, 170 }, [182] = { 137, 198 }, [184] = { 155, 130 }, [185] = { 151, 101 }, [191] = { 143, 104 }, [192] = { 250, 167 }, [194] = { 142, 226 }, [195] = { 155, 131 },
		[196] = { 138, 241 }, [197] = { 147, 208 }, [198] = { 150, 167 }, [199] = { 155, 132 }, [201] = { 155, 133 }, [204] = { 149, 120 }, [208] = { 155, 135 }, [210] = { 138, 166 }, [211] = { 139, 245 }, [212] = { 155, 134 }, [216] = { 250, 169 }, [219] = { 138, 176 }, [221] = { 144, 81 }, [222] = { 155, 139 }, [223] = { 142, 64 }, [225] = { 137, 199 }, [226] = { 155, 138 }, [228] = { 155, 136 }, [229] = { 155, 140 }, [230] = { 155, 137 }, [231] = { 148, 74 }, [232] = { 158, 203 }, [233] = { 144, 82 }, [235] = { 155, 141 }, [236] = { 250, 170 },
		[238] = { 151, 190 }, [240] = { 155, 142 }, [243] = { 155, 144 }, [245] = { 146, 158 }, [246] = { 155, 143 }, [248] = { 144, 161 }, [250] = { 142, 155 }, [254] = { 145, 206 }, [255] = { 142, 245 },
	},
	[92] = {
		[1] = { 149, 149 }, [2] = { 144, 234 }, [4] = { 142, 203 }, [5] = { 155, 145 }, [6] = { 143, 171 }, [7] = { 155, 146 }, [8] = { 155, 147 }, [9] = { 136, 209 }, [10] = { 145, 184 }, [11] = { 144, 113 }, [13] = { 155, 148 }, [14] = { 147, 177 }, [15] = { 143, 172 }, [17] = { 143, 173 }, [19] = { 155, 149 }, [22] = { 144, 235 }, [26] = { 143, 174 }, [30] = { 250, 171 }, [32] = { 155, 150 }, [34] = { 155, 151 }, [36] = { 150, 222 }, [40] = { 155, 152 }, [45] = { 139, 196 }, [49] = { 143, 65 },
		[56] = { 155, 153 }, [57] = { 155, 154 }, [58] = { 142, 218 }, [59] = { 144, 75 }, [60] = { 147, 242 }, [61] = { 144, 115 }, [62] = { 148, 246 }, [63] = { 148, 65 }, [64] = { 139, 199 }, [65] = { 155, 155 }, [69] = { 139, 143 }, [70] = { 155, 156 }, [72] = { 139, 252 }, [74] = { 147, 205 }, [75] = { 137, 174 }, [77] = { 142, 114 }, [78] = { 155, 157 }, [79] = { 155, 160 }, [80] = { 155, 159 }, [81] = { 139, 251 }, [83] = { 155, 158 }, [85] = { 147, 87 }, [94] = { 145, 174 }, [96] = { 147, 106 }, [97] = { 142, 198 },
		[100] = { 145, 119 }, [101] = { 151, 154 }, [108] = { 155, 162 }, [110] = { 155, 163 }, [111] = { 147, 212 }, [113] = { 142, 82 }, [118] = { 155, 165 }, [121] = { 155, 166 }, [140] = { 155, 167 }, [144] = { 138, 242 }, [145] = { 155, 168 }, [148] = { 155, 169 }, [161] = { 137, 170 }, [166] = { 250, 172 }, [168] = { 145, 90 }, [169] = { 138, 226 }, [171] = { 155, 171 }, [172] = { 150, 166 }, [177] = { 145, 208 }, [179] = { 138, 120 }, [182] = { 155, 173 }, [183] = { 155, 175 }, [184] = { 138, 221 }, [186] = { 250, 173 }, [187] = { 155, 172 },
		[188] = { 155, 174 }, [190] = { 155, 177 }, [197] = { 155, 176 }, [199] = { 155, 178 }, [217] = { 155, 179 }, [224] = { 147, 187 }, [225] = { 139, 172 }, [232] = { 137, 227 }, [233] = { 155, 180 }, [234] = { 155, 185 }, [237] = { 155, 183 }, [239] = { 149, 245 }, [240] = { 149, 244 }, [245] = { 250, 174 }, [246] = { 147, 135 }, [250] = { 155, 182 }, [251] = { 143, 115 }, [253] = { 155, 181 },
	},
	[93] = {
		[7] = { 144, 146 }, [11] = { 155, 186 }, [14] = { 141, 232 }, [17] = { 155, 192 }, [20] = { 155, 193 }, [21] = { 155, 187 }, [22] = { 138, 82 }, [23] = { 155, 188 }, [24] = { 155, 197 }, [25] = { 155, 196 }, [26] = { 155, 195 }, [27] = { 155, 191 }, [31] = { 155, 190 }, [34] = { 155, 194 }, [39] = { 250, 175 }, [41] = { 149, 246 }, [66] = { 250, 178 }, [75] = { 155, 201 }, [76] = { 155, 198 }, [78] = { 155, 200 }, [80] = { 151, 146 }, [82] = { 155, 199 }, [83] = { 250, 176 }, [92] = { 155, 189 },
		[105] = { 144, 147 }, [108] = { 155, 202 }, [109] = { 250, 179 }, [111] = { 141, 181 }, [115] = { 155, 203 }, [118] = { 155, 204 }, [130] = { 155, 207 }, [132] = { 155, 206 }, [135] = { 155, 205 }, [139] = { 147, 136 }, [140] = { 155, 184 }, [144] = { 155, 213 }, [157] = { 155, 209 }, [162] = { 155, 208 }, [172] = { 155, 210 }, [174] = { 155, 211 }, [183] = { 155, 214 }, [184] = { 250, 180 }, [185] = { 250, 181 }, [186] = { 151, 228 }, [188] = { 155, 215 }, [189] = { 155, 212 }, [201] = { 155, 216 }, [204] = { 138, 222 }, [205] = { 155, 217 },
		[208] = { 250, 182 }, [210] = { 155, 219 }, [211] = { 155, 218 }, [214] = { 155, 220 }, [219] = { 155, 221 }, [221] = { 144, 236 }, [222] = { 143, 66 }, [225] = { 143, 132 }, [227] = { 145, 131 }, [229] = { 141, 72 }, [230] = { 141, 182 }, [231] = { 141, 73 }, [232] = { 139, 144 }, [235] = { 155, 222 }, [238] = { 141, 183 }, [241] = { 140, 200 }, [242] = { 155, 223 }, [243] = { 150, 164 }, [244] = { 148, 98 }, [245] = { 155, 224 }, [247] = { 141, 74 }, [251] = { 138, 170 }, [253] = { 146, 70 }, [254] = { 139, 208 },
	},
	[94] = {
		[2] = { 142, 115 }, [3] = { 149, 122 }, [6] = { 148, 191 }, [11] = { 155, 225 }, [12] = { 138, 243 }, [17] = { 155, 228 }, [22] = { 146, 159 }, [25] = { 155, 227 }, [26] = { 155, 226 }, [27] = { 155, 229 }, [29] = { 146, 233 }, [37] = { 144, 131 }, [43] = { 142, 116 }, [45] = { 144, 200 }, [47] = { 145, 209 }, [48] = { 139, 65 }, [51] = { 146, 160 }, [54] = { 155, 230 }, [55] = { 155, 231 }, [56] = { 143, 237 }, [61] = { 150, 88 }, [64] = { 155, 234 }, [67] = { 155, 233 }, [68] = { 155, 232 },
		[69] = { 149, 157 }, [71] = { 155, 241 }, [76] = { 150, 121 }, [78] = { 155, 235 }, [84] = { 155, 237 }, [85] = { 150, 139 }, [87] = { 155, 236 }, [95] = { 155, 238 }, [97] = { 148, 166 }, [98] = { 155, 239 }, [99] = { 149, 188 }, [100] = { 155, 240 }, [114] = { 138, 177 }, [115] = { 149, 189 }, [116] = { 148, 78 }, [117] = { 155, 242 }, [118] = { 155, 243 }, [120] = { 141, 75 }, [121] = { 138, 178 }, [122] = { 155, 244 }, [123] = { 140, 182 }, [124] = { 151, 99 }, [125] = { 151, 72 }, [126] = { 138, 244 }, [127] = { 155, 246 },
		[129] = { 146, 161 }, [131] = { 141, 76 }, [132] = { 143, 175 }, [135] = { 148, 221 }, [138] = { 143, 176 }, [143] = { 143, 152 }, [149] = { 146, 234 }, [150] = { 149, 247 }, [151] = { 147, 88 }, [154] = { 141, 77 }, [156] = { 149, 123 }, [160] = { 155, 247 }, [166] = { 147, 120 }, [167] = { 141, 192 }, [171] = { 140, 201 }, [173] = { 146, 235 }, [181] = { 136, 193 }, [182] = { 143, 142 }, [183] = { 141, 78 }, [184] = { 151, 102 }, [193] = { 155, 248 }, [194] = { 155, 249 }, [195] = { 148, 112 }, [200] = { 155, 250 }, [201] = { 151, 245 },
		[202] = { 152, 76 }, [207] = { 155, 252 }, [208] = { 155, 251 }, [211] = { 138, 102 }, [214] = { 156, 64 }, [218] = { 156, 67 }, [219] = { 156, 68 }, [221] = { 156, 66 }, [223] = { 149, 95 }, [224] = { 143, 177 }, [225] = { 156, 70 }, [226] = { 156, 69 }, [227] = { 156, 65 }, [232] = { 156, 71 }, [233] = { 156, 72 }, [236] = { 156, 73 }, [240] = { 156, 76 }, [241] = { 156, 74 }, [243] = { 156, 75 }, [244] = { 156, 77 }, [246] = { 137, 132 }, [247] = { 146, 236 }, [248] = { 156, 78 }, [250] = { 140, 154 }, [251] = { 137, 244 },
		[252] = { 148, 85 }, [254] = { 156, 79 }, [255] = { 147, 249 },
	},
	[95] = {
		[1] = { 149, 217 }, [3] = { 156, 80 }, [4] = { 152, 77 }, [9] = { 156, 81 }, [10] = { 149, 190 }, [11] = { 156, 84 }, [12] = { 152, 159 }, [13] = { 152, 175 }, [15] = { 142, 174 }, [16] = { 147, 243 }, [17] = { 156, 85 }, [19] = { 139, 124 }, [20] = { 146, 162 }, [21] = { 136, 248 }, [22] = { 156, 86 }, [23] = { 149, 164 }, [24] = { 141, 79 }, [27] = { 146, 111 }, [31] = { 146, 237 }, [33] = { 250, 183 }, [37] = { 150, 237 }, [38] = { 140, 183 }, [39] = { 140, 202 }, [41] = { 156, 87 },
		[45] = { 156, 88 }, [47] = { 156, 94 }, [49] = { 142, 227 }, [52] = { 250, 184 }, [53] = { 146, 163 }, [55] = { 139, 173 }, [56] = { 156, 89 }, [60] = { 149, 74 }, [62] = { 146, 101 }, [65] = { 156, 90 }, [69] = { 250, 103 }, [72] = { 156, 91 }, [74] = { 139, 174 }, [76] = { 156, 92 }, [78] = { 156, 93 }, [81] = { 156, 95 }, [83] = { 147, 150 }, [86] = { 156, 96 }, [87] = { 156, 97 }, [89] = { 156, 98 }, [92] = { 156, 83 }, [93] = { 156, 82 }, [97] = { 156, 99 }, [98] = { 140, 96 }, [102] = { 149, 70 },
		[103] = { 250, 185 }, [105] = { 141, 202 }, [106] = { 149, 86 }, [107] = { 146, 164 }, [108] = { 149, 106 }, [109] = { 156, 100 }, [112] = { 143, 178 }, [113] = { 137, 101 }, [115] = { 156, 101 }, [119] = { 156, 102 }, [121] = { 150, 240 }, [124] = { 148, 222 }, [127] = { 156, 105 }, [128] = { 137, 157 }, [129] = { 144, 170 }, [130] = { 156, 104 }, [131] = { 156, 103 }, [132] = { 140, 97 }, [133] = { 145, 210 }, [135] = { 156, 109 }, [136] = { 156, 107 }, [138] = { 156, 106 }, [139] = { 151, 165 }, [140] = { 140, 227 }, [144] = { 143, 153 },
		[145] = { 156, 108 }, [146] = { 147, 107 }, [147] = { 143, 93 }, [151] = { 147, 190 }, [152] = { 156, 112 }, [153] = { 156, 111 }, [158] = { 156, 110 }, [160] = { 156, 113 }, [161] = { 140, 228 }, [168] = { 156, 114 }, [169] = { 149, 156 }, [170] = { 143, 122 }, [173] = { 156, 115 }, [174] = { 148, 247 }, [179] = { 147, 191 }, [180] = { 146, 165 }, [183] = { 250, 186 }, [185] = { 147, 79 }, [188] = { 156, 116 }, [189] = { 139, 74 }, [195] = { 144, 83 }, [197] = { 149, 75 }, [204] = { 138, 245 }, [205] = { 148, 69 }, [214] = { 156, 117 },
		[215] = { 142, 117 }, [216] = { 150, 89 }, [217] = { 150, 90 }, [220] = { 137, 158 }, [221] = { 156, 122 }, [222] = { 250, 187 }, [224] = { 146, 137 }, [228] = { 156, 119 }, [235] = { 137, 245 }, [240] = { 156, 171 }, [241] = { 156, 121 }, [245] = { 148, 79 }, [248] = { 156, 120 }, [251] = { 156, 118 }, [253] = { 141, 154 }, [255] = { 156, 124 },
	},
	[96] = {
		[14] = { 156, 131 }, [15] = { 156, 137 }, [16] = { 156, 129 }, [18] = { 147, 123 }, [21] = { 156, 134 }, [22] = { 149, 124 }, [25] = { 156, 128 }, [27] = { 156, 133 }, [28] = { 151, 229 }, [29] = { 142, 118 }, [32] = { 145, 211 }, [33] = { 156, 125 }, [37] = { 139, 125 }, [38] = { 156, 136 }, [39] = { 144, 171 }, [40] = { 137, 133 }, [41] = { 156, 130 }, [42] = { 137, 246 }, [43] = { 156, 135 }, [47] = { 139, 175 }, [49] = { 156, 132 }, [58] = { 156, 138 }, [65] = { 156, 140 }, [66] = { 156, 150 },
		[67] = { 156, 148 }, [70] = { 156, 145 }, [74] = { 156, 144 }, [75] = { 151, 246 }, [77] = { 156, 146 }, [80] = { 139, 176 }, [82] = { 141, 80 }, [85] = { 143, 154 }, [89] = { 156, 153 }, [90] = { 156, 139 }, [93] = { 250, 188 }, [95] = { 156, 143 }, [96] = { 156, 126 }, [98] = { 137, 248 }, [99] = { 156, 147 }, [100] = { 156, 149 }, [101] = { 146, 112 }, [104] = { 141, 166 }, [105] = { 137, 182 }, [106] = { 156, 141 }, [107] = { 156, 152 }, [108] = { 156, 151 }, [109] = { 139, 177 }, [111] = { 145, 167 }, [112] = { 138, 134 },
		[117] = { 140, 98 }, [119] = { 156, 142 }, [129] = { 156, 154 }, [131] = { 156, 157 }, [132] = { 156, 159 }, [133] = { 250, 189 }, [137] = { 142, 187 }, [138] = { 250, 190 }, [139] = { 156, 165 }, [140] = { 146, 238 }, [141] = { 156, 155 }, [146] = { 156, 163 }, [148] = { 137, 247 }, [150] = { 156, 161 }, [151] = { 156, 162 }, [154] = { 156, 158 }, [155] = { 156, 160 }, [159] = { 140, 229 }, [160] = { 151, 73 }, [163] = { 138, 179 }, [166] = { 137, 120 }, [167] = { 156, 164 }, [169] = { 148, 89 }, [170] = { 136, 171 }, [178] = { 148, 223 },
		[179] = { 156, 123 }, [180] = { 156, 170 }, [181] = { 156, 174 }, [182] = { 150, 227 }, [184] = { 156, 167 }, [188] = { 147, 137 }, [189] = { 156, 172 }, [197] = { 143, 238 }, [198] = { 156, 173 }, [199] = { 147, 213 }, [209] = { 152, 102 }, [211] = { 156, 169 }, [213] = { 250, 192 }, [216] = { 156, 175 }, [218] = { 141, 155 }, [220] = { 144, 201 }, [222] = { 250, 191 }, [223] = { 136, 210 }, [224] = { 156, 168 }, [225] = { 156, 166 }, [227] = { 145, 121 }, [231] = { 156, 156 }, [232] = { 142, 83 }, [240] = { 145, 196 }, [241] = { 156, 187 },
		[242] = { 250, 194 }, [243] = { 145, 122 }, [244] = { 156, 182 }, [246] = { 156, 179 }, [247] = { 156, 180 }, [249] = { 142, 228 }, [250] = { 156, 183 }, [251] = { 156, 186 },
	},
	[97] = {
		[0] = { 156, 181 }, [1] = { 143, 68 }, [3] = { 156, 184 }, [6] = { 156, 178 }, [8] = { 150, 250 }, [9] = { 150, 249 }, [13] = { 156, 188 }, [14] = { 156, 189 }, [15] = { 136, 211 }, [17] = { 250, 195 }, [21] = { 156, 177 }, [26] = { 139, 240 }, [27] = { 136, 164 }, [31] = { 138, 180 }, [32] = { 250, 193 }, [33] = { 156, 185 }, [39] = { 156, 193 }, [40] = { 156, 192 }, [44] = { 156, 197 }, [48] = { 250, 197 }, [52] = { 156, 198 }, [55] = { 250, 196 }, [60] = { 156, 196 }, [61] = { 156, 199 },
		[62] = { 156, 191 }, [63] = { 156, 195 }, [66] = { 156, 200 }, [68] = { 156, 201 }, [71] = { 156, 190 }, [72] = { 142, 156 }, [74] = { 156, 194 }, [75] = { 145, 212 }, [76] = { 141, 81 }, [77] = { 156, 176 }, [78] = { 144, 84 }, [83] = { 156, 214 }, [85] = { 149, 231 }, [88] = { 156, 204 }, [89] = { 156, 205 }, [90] = { 156, 206 }, [93] = { 156, 213 }, [95] = { 156, 212 }, [98] = { 150, 157 }, [99] = { 138, 181 }, [101] = { 156, 210 }, [103] = { 140, 100 }, [104] = { 138, 83 }, [107] = { 156, 207 }, [110] = { 151, 182 },
		[111] = { 156, 209 }, [112] = { 136, 212 }, [113] = { 156, 211 }, [115] = { 156, 202 }, [116] = { 156, 208 }, [117] = { 156, 215 }, [118] = { 140, 99 }, [119] = { 156, 203 }, [126] = { 151, 124 }, [130] = { 151, 74 }, [135] = { 156, 218 }, [138] = { 156, 222 }, [142] = { 145, 158 }, [144] = { 151, 247 }, [145] = { 156, 223 }, [148] = { 156, 220 }, [150] = { 156, 217 }, [152] = { 250, 198 }, [153] = { 156, 216 }, [154] = { 156, 221 }, [164] = { 149, 174 }, [167] = { 147, 178 }, [169] = { 140, 101 }, [171] = { 156, 224 }, [172] = { 156, 219 },
		[174] = { 156, 225 }, [178] = { 140, 155 }, [182] = { 137, 175 }, [186] = { 156, 233 }, [190] = { 138, 182 }, [195] = { 156, 231 }, [198] = { 156, 232 }, [199] = { 141, 167 }, [200] = { 156, 230 }, [201] = { 156, 228 }, [202] = { 156, 227 }, [203] = { 156, 234 }, [204] = { 156, 226 }, [205] = { 156, 236 }, [208] = { 137, 249 }, [227] = { 156, 238 }, [230] = { 156, 237 }, [242] = { 146, 166 }, [244] = { 156, 241 }, [246] = { 156, 239 }, [247] = { 156, 229 }, [248] = { 140, 156 }, [250] = { 156, 240 }, [252] = { 156, 244 }, [253] = { 156, 243 },
		[254] = { 156, 245 }, [255] = { 156, 242 },
	},
	[98] = {
		[0] = { 156, 246 }, [8] = { 156, 247 }, [9] = { 156, 248 }, [10] = { 149, 232 }, [12] = { 156, 250 }, [13] = { 156, 249 }, [14] = { 143, 94 }, [16] = { 144, 172 }, [17] = { 137, 228 }, [18] = { 137, 250 }, [19] = { 250, 199 }, [20] = { 156, 251 }, [22] = { 136, 189 }, [26] = { 144, 202 }, [27] = { 156, 252 }, [29] = { 230, 193 }, [30] = { 157, 64 }, [31] = { 140, 129 }, [33] = { 157, 65 }, [38] = { 144, 237 }, [42] = { 157, 66 }, [46] = { 157, 67 }, [47] = { 139, 89 }, [48] = { 157, 68 },
		[50] = { 157, 69 }, [51] = { 157, 70 }, [52] = { 145, 213 }, [56] = { 140, 203 }, [59] = { 150, 223 }, [63] = { 150, 91 }, [64] = { 143, 138 }, [65] = { 157, 71 }, [71] = { 144, 238 }, [72] = { 231, 187 }, [73] = { 148, 224 }, [75] = { 142, 232 }, [77] = { 141, 203 }, [78] = { 157, 72 }, [83] = { 145, 197 }, [85] = { 149, 165 }, [88] = { 145, 239 }, [91] = { 157, 75 }, [94] = { 157, 73 }, [96] = { 157, 76 }, [99] = { 157, 74 }, [104] = { 157, 77 }, [110] = { 149, 175 }, [113] = { 136, 181 }, [118] = { 149, 125 },
		[121] = { 148, 225 }, [124] = { 157, 78 }, [126] = { 157, 81 }, [127] = { 143, 179 }, [128] = { 139, 90 }, [130] = { 157, 79 }, [131] = { 157, 86 }, [132] = { 143, 180 }, [137] = { 157, 80 }, [138] = { 148, 99 }, [145] = { 151, 125 }, [146] = { 157, 82 }, [147] = { 157, 83 }, [148] = { 157, 87 }, [149] = { 147, 138 }, [150] = { 157, 84 }, [151] = { 141, 82 }, [152] = { 144, 220 }, [155] = { 157, 101 }, [156] = { 148, 178 }, [158] = { 145, 240 }, [166] = { 250, 200 }, [171] = { 148, 226 }, [172] = { 157, 171 }, [177] = { 149, 248 },
		[181] = { 146, 239 }, [185] = { 150, 149 }, [187] = { 157, 90 }, [188] = { 137, 159 }, [189] = { 146, 138 }, [194] = { 157, 99 }, [197] = { 146, 83 }, [198] = { 157, 93 }, [199] = { 157, 100 }, [200] = { 157, 95 }, [201] = { 157, 102 }, [202] = { 157, 98 }, [204] = { 157, 97 }, [205] = { 148, 143 }, [207] = { 157, 91 }, [208] = { 137, 251 }, [209] = { 157, 89 }, [210] = { 139, 145 }, [211] = { 145, 241 }, [212] = { 157, 85 }, [215] = { 157, 88 }, [216] = { 141, 83 }, [217] = { 144, 217 }, [219] = { 143, 181 }, [220] = { 157, 96 },
		[221] = { 148, 113 }, [224] = { 139, 146 }, [225] = { 138, 103 }, [236] = { 138, 135 }, [237] = { 144, 64 }, [238] = { 157, 104 }, [239] = { 157, 109 }, [241] = { 157, 105 }, [243] = { 140, 157 }, [245] = { 157, 110 }, [246] = { 142, 65 }, [247] = { 141, 137 }, [254] = { 143, 69 }, [255] = { 157, 92 },
	},
	[99] = {
		[1] = { 142, 157 }, [2] = { 157, 107 }, [7] = { 142, 119 }, [8] = { 157, 108 }, [9] = { 136, 194 }, [12] = { 157, 103 }, [17] = { 146, 167 }, [25] = { 139, 147 }, [31] = { 139, 178 }, [39] = { 157, 106 }, [40] = { 136, 165 }, [43] = { 141, 193 }, [47] = { 144, 85 }, [58] = { 146, 240 }, [61] = { 148, 210 }, [62] = { 157, 112 }, [63] = { 145, 125 }, [73] = { 145, 168 }, [76] = { 142, 74 }, [77] = { 157, 113 }, [79] = { 157, 115 }, [80] = { 157, 111 }, [85] = { 149, 223 }, [87] = { 146, 187 },
		[92] = { 145, 123 }, [103] = { 149, 249 }, [104] = { 142, 204 }, [105] = { 157, 128 }, [107] = { 157, 126 }, [110] = { 144, 152 }, [114] = { 140, 158 }, [118] = { 157, 120 }, [119] = { 143, 183 }, [122] = { 147, 230 }, [123] = { 148, 80 }, [128] = { 157, 118 }, [131] = { 145, 124 }, [136] = { 142, 246 }, [137] = { 157, 123 }, [140] = { 143, 182 }, [142] = { 157, 117 }, [143] = { 157, 122 }, [146] = { 148, 114 }, [150] = { 157, 116 }, [152] = { 140, 64 }, [155] = { 138, 124 }, [159] = { 157, 124 }, [160] = { 151, 169 }, [161] = { 141, 204 },
		[162] = { 146, 84 }, [163] = { 157, 121 }, [165] = { 144, 218 }, [167] = { 141, 84 }, [168] = { 144, 132 }, [169] = { 137, 134 }, [170] = { 145, 91 }, [171] = { 157, 119 }, [172] = { 139, 100 }, [178] = { 140, 102 }, [180] = { 146, 205 }, [181] = { 157, 125 }, [187] = { 145, 126 }, [190] = { 157, 129 }, [192] = { 157, 131 }, [195] = { 145, 181 }, [196] = { 157, 137 }, [198] = { 157, 132 }, [201] = { 157, 134 }, [207] = { 149, 96 }, [208] = { 146, 241 }, [210] = { 157, 135 }, [214] = { 151, 75 }, [218] = { 151, 103 }, [219] = { 138, 183 },
		[225] = { 136, 172 }, [227] = { 157, 133 }, [233] = { 157, 130 }, [238] = { 138, 246 }, [244] = { 137, 135 }, [245] = { 250, 201 }, [246] = { 157, 136 }, [250] = { 151, 104 },
	},
	[100] = {
		[6] = { 157, 140 }, [13] = { 145, 185 }, [15] = { 157, 147 }, [19] = { 157, 141 }, [22] = { 157, 138 }, [23] = { 157, 145 }, [28] = { 157, 114 }, [38] = { 157, 142 }, [40] = { 157, 146 }, [44] = { 148, 192 }, [45] = { 147, 139 }, [52] = { 157, 139 }, [54] = { 157, 143 }, [58] = { 140, 103 }, [62] = { 141, 239 }, [66] = { 144, 219 }, [78] = { 157, 151 }, [88] = { 147, 69 }, [96] = { 250, 202 }, [103] = { 157, 148 }, [105] = { 150, 128 }, [111] = { 157, 149 }, [118] = { 157, 150 }, [120] = { 150, 204 },
		[122] = { 144, 160 }, [131] = { 140, 130 }, [136] = { 157, 157 }, [146] = { 142, 84 }, [147] = { 157, 154 }, [149] = { 157, 153 }, [154] = { 148, 81 }, [157] = { 250, 203 }, [158] = { 147, 179 }, [164] = { 147, 80 }, [165] = { 157, 155 }, [169] = { 157, 156 }, [171] = { 149, 143 }, [173] = { 148, 100 }, [174] = { 142, 66 }, [176] = { 144, 239 }, [178] = { 150, 111 }, [185] = { 138, 104 }, [187] = { 157, 163 }, [188] = { 157, 158 }, [193] = { 151, 105 }, [194] = { 157, 165 }, [197] = { 157, 161 }, [199] = { 157, 162 }, [205] = { 145, 128 },
		[206] = { 250, 204 }, [210] = { 157, 160 }, [212] = { 157, 94 }, [216] = { 157, 164 }, [218] = { 157, 159 }, [224] = { 157, 169 }, [225] = { 157, 170 }, [226] = { 147, 70 }, [227] = { 157, 172 }, [230] = { 142, 67 }, [231] = { 157, 167 }, [236] = { 139, 91 }, [239] = { 157, 173 }, [241] = { 157, 166 }, [242] = { 157, 177 }, [244] = { 157, 176 }, [246] = { 157, 175 }, [250] = { 157, 178 }, [253] = { 157, 180 }, [254] = { 143, 239 },
	},
	[101] = {
		[0] = { 157, 179 }, [5] = { 157, 183 }, [24] = { 157, 181 }, [28] = { 157, 182 }, [29] = { 157, 144 }, [35] = { 157, 185 }, [36] = { 157, 184 }, [42] = { 157, 152 }, [43] = { 157, 186 }, [44] = { 157, 174 }, [47] = { 142, 120 }, [52] = { 157, 187 }, [53] = { 157, 188 }, [54] = { 157, 190 }, [55] = { 157, 189 }, [56] = { 157, 191 }, [57] = { 137, 252 }, [59] = { 141, 85 }, [62] = { 149, 250 }, [63] = { 144, 173 }, [69] = { 140, 204 }, [72] = { 157, 193 }, [77] = { 157, 196 }, [78] = { 250, 205 },
		[79] = { 149, 113 }, [81] = { 139, 126 }, [85] = { 157, 195 }, [86] = { 157, 194 }, [87] = { 148, 115 }, [88] = { 157, 197 }, [89] = { 139, 179 }, [93] = { 157, 199 }, [94] = { 157, 198 }, [98] = { 138, 184 }, [99] = { 142, 85 }, [102] = { 147, 214 }, [108] = { 140, 104 }, [112] = { 144, 148 }, [114] = { 157, 200 }, [116] = { 144, 174 }, [117] = { 147, 71 }, [119] = { 149, 126 }, [120] = { 157, 201 }, [130] = { 157, 202 }, [131] = { 157, 203 }, [135] = { 149, 182 }, [136] = { 155, 124 }, [137] = { 144, 196 }, [140] = { 149, 107 },
		[142] = { 141, 214 }, [144] = { 148, 227 }, [145] = { 148, 193 }, [151] = { 147, 108 }, [153] = { 151, 191 }, [155] = { 157, 205 }, [156] = { 142, 206 }, [159] = { 157, 206 }, [161] = { 136, 180 }, [164] = { 139, 210 }, [165] = { 144, 203 }, [167] = { 149, 128 }, [171] = { 157, 207 }, [172] = { 142, 97 }, [173] = { 146, 102 }, [175] = { 142, 122 }, [176] = { 144, 86 }, [183] = { 157, 208 }, [185] = { 149, 251 }, [188] = { 137, 151 }, [189] = { 142, 123 }, [193] = { 157, 211 }, [195] = { 157, 209 }, [196] = { 157, 212 }, [197] = { 151, 183 },
		[198] = { 157, 210 }, [203] = { 144, 249 }, [204] = { 157, 213 }, [207] = { 145, 176 }, [210] = { 157, 214 }, [215] = { 138, 248 }, [217] = { 157, 216 }, [219] = { 157, 215 }, [224] = { 157, 217 }, [225] = { 157, 218 }, [226] = { 138, 249 }, [229] = { 147, 250 }, [230] = { 146, 85 }, [231] = { 139, 140 }, [232] = { 142, 124 }, [233] = { 145, 129 }, [236] = { 143, 123 }, [237] = { 136, 174 }, [241] = { 157, 219 }, [250] = { 137, 160 }, [251] = { 157, 223 },
	},
	[102] = {
		[0] = { 250, 206 }, [2] = { 141, 86 }, [3] = { 157, 222 }, [6] = { 141, 169 }, [7] = { 143, 184 }, [9] = { 250, 209 }, [10] = { 157, 221 }, [12] = { 143, 185 }, [14] = { 150, 190 }, [15] = { 141, 168 }, [19] = { 136, 213 }, [20] = { 144, 204 }, [21] = { 250, 207 }, [28] = { 157, 228 }, [30] = { 250, 211 }, [31] = { 144, 175 }, [32] = { 137, 102 }, [36] = { 250, 212 }, [37] = { 143, 116 }, [39] = { 150, 134 }, [40] = { 141, 240 }, [45] = { 143, 186 }, [46] = { 250, 210 }, [47] = { 144, 165 },
		[49] = { 250, 99 }, [52] = { 157, 227 }, [53] = { 157, 225 }, [54] = { 157, 226 }, [59] = { 250, 208 }, [60] = { 146, 139 }, [63] = { 158, 69 }, [65] = { 157, 232 }, [66] = { 142, 158 }, [67] = { 141, 87 }, [68] = { 157, 230 }, [73] = { 157, 231 }, [75] = { 144, 87 }, [79] = { 157, 229 }, [82] = { 142, 78 }, [87] = { 250, 214 }, [89] = { 250, 215 }, [93] = { 157, 234 }, [94] = { 157, 233 }, [95] = { 157, 238 }, [98] = { 157, 239 }, [100] = { 157, 235 }, [101] = { 250, 213 }, [102] = { 138, 65 }, [103] = { 157, 236 },
		[104] = { 157, 237 }, [105] = { 148, 211 }, [110] = { 149, 129 }, [111] = { 140, 105 }, [112] = { 157, 240 }, [115] = { 250, 217 }, [116] = { 144, 176 }, [118] = { 143, 187 }, [122] = { 146, 113 }, [129] = { 139, 197 }, [131] = { 157, 241 }, [132] = { 157, 245 }, [135] = { 137, 201 }, [136] = { 157, 242 }, [137] = { 157, 244 }, [142] = { 157, 243 }, [145] = { 143, 139 }, [150] = { 146, 103 }, [151] = { 136, 195 }, [152] = { 157, 246 }, [153] = { 250, 218 }, [157] = { 157, 247 }, [160] = { 250, 219 }, [162] = { 146, 168 }, [166] = { 151, 239 },
		[171] = { 142, 98 }, [174] = { 149, 233 }, [178] = { 250, 220 }, [180] = { 150, 92 }, [184] = { 158, 65 }, [185] = { 157, 249 }, [188] = { 157, 252 }, [190] = { 157, 251 }, [191] = { 250, 221 }, [193] = { 157, 248 }, [196] = { 158, 64 }, [199] = { 147, 220 }, [201] = { 157, 250 }, [214] = { 158, 66 }, [217] = { 143, 140 }, [218] = { 158, 67 }, [220] = { 151, 106 }, [221] = { 148, 152 }, [224] = { 158, 68 }, [230] = { 158, 70 }, [233] = { 158, 71 }, [240] = { 158, 72 }, [242] = { 139, 200 }, [243] = { 137, 103 }, [244] = { 141, 88 },
		[245] = { 158, 73 }, [247] = { 158, 74 }, [248] = { 143, 145 }, [249] = { 145, 130 }, [250] = { 250, 222 }, [251] = { 250, 102 }, [252] = { 153, 214 }, [253] = { 145, 93 }, [254] = { 145, 92 }, [255] = { 145, 214 },
	},
	[103] = {
		[0] = { 141, 197 }, [3] = { 152, 240 }, [8] = { 140, 142 }, [9] = { 151, 76 }, [11] = { 149, 252 }, [13] = { 149, 158 }, [14] = { 250, 223 }, [15] = { 158, 75 }, [20] = { 141, 241 }, [21] = { 146, 189 }, [22] = { 158, 76 }, [23] = { 152, 78 }, [27] = { 150, 93 }, [29] = { 146, 169 }, [30] = { 158, 77 }, [31] = { 138, 250 }, [38] = { 158, 78 }, [39] = { 158, 79 }, [40] = { 150, 216 }, [42] = { 150, 162 }, [43] = { 150, 150 }, [44] = { 150, 123 }, [45] = { 142, 68 }, [46] = { 158, 81 },
		[49] = { 142, 233 }, [52] = { 150, 112 }, [54] = { 158, 83 }, [55] = { 158, 86 }, [56] = { 158, 85 }, [58] = { 138, 247 }, [61] = { 139, 128 }, [63] = { 158, 82 }, [65] = { 158, 84 }, [70] = { 158, 87 }, [73] = { 144, 153 }, [78] = { 151, 155 }, [79] = { 136, 199 }, [80] = { 141, 222 }, [81] = { 145, 186 }, [83] = { 142, 219 }, [86] = { 143, 241 }, [89] = { 158, 90 }, [92] = { 147, 109 }, [94] = { 158, 88 }, [95] = { 145, 169 }, [96] = { 158, 89 }, [97] = { 143, 240 }, [98] = { 150, 219 }, [99] = { 158, 91 },
		[100] = { 158, 92 }, [101] = { 151, 136 }, [102] = { 250, 225 }, [106] = { 158, 97 }, [109] = { 141, 89 }, [111] = { 148, 116 }, [112] = { 158, 94 }, [113] = { 147, 140 }, [114] = { 157, 220 }, [115] = { 157, 224 }, [117] = { 139, 110 }, [119] = { 148, 102 }, [124] = { 158, 96 }, [126] = { 143, 188 }, [127] = { 148, 194 }, [133] = { 158, 102 }, [135] = { 148, 248 }, [137] = { 158, 93 }, [139] = { 158, 99 }, [140] = { 158, 98 }, [144] = { 144, 205 }, [149] = { 150, 141 }, [151] = { 151, 209 }, [154] = { 150, 135 }, [156] = { 137, 202 },
		[157] = { 142, 125 }, [160] = { 152, 103 }, [161] = { 158, 101 }, [162] = { 144, 149 }, [166] = { 158, 100 }, [169] = { 158, 95 }, [175] = { 140, 205 }, [179] = { 158, 107 }, [180] = { 158, 105 }, [182] = { 137, 203 }, [183] = { 158, 103 }, [184] = { 158, 109 }, [185] = { 158, 115 }, [187] = { 250, 226 }, [192] = { 250, 228 }, [193] = { 145, 198 }, [196] = { 149, 191 }, [198] = { 158, 117 }, [202] = { 149, 65 }, [206] = { 158, 116 }, [207] = { 148, 144 }, [208] = { 150, 94 }, [209] = { 138, 185 }, [211] = { 144, 245 }, [212] = { 143, 95 },
		[216] = { 146, 209 }, [218] = { 151, 77 }, [221] = { 158, 112 }, [222] = { 158, 111 }, [226] = { 158, 113 }, [228] = { 158, 110 }, [231] = { 158, 118 }, [233] = { 158, 108 }, [236] = { 158, 106 }, [238] = { 158, 114 }, [239] = { 158, 104 }, [241] = { 146, 140 }, [243] = { 150, 246 }, [244] = { 142, 196 }, [245] = { 141, 242 }, [251] = { 141, 184 }, [254] = { 150, 143 }, [255] = { 138, 96 },
	},
	[104] = {
		[1] = { 250, 229 }, [2] = { 146, 204 }, [3] = { 147, 200 }, [4] = { 137, 104 }, [19] = { 144, 240 }, [22] = { 144, 178 }, [23] = { 140, 73 }, [30] = { 158, 120 }, [33] = { 141, 90 }, [34] = { 138, 156 }, [41] = { 158, 122 }, [42] = { 138, 148 }, [43] = { 158, 129 }, [50] = { 158, 125 }, [52] = { 144, 241 }, [56] = { 138, 106 }, [57] = { 141, 170 }, [60] = { 138, 105 }, [61] = { 141, 205 }, [64] = { 158, 123 }, [65] = { 140, 133 }, [66] = { 140, 106 }, [67] = { 147, 141 }, [68] = { 250, 230 },
		[70] = { 158, 121 }, [72] = { 136, 196 }, [77] = { 158, 124 }, [78] = { 158, 126 }, [80] = { 139, 203 }, [81] = { 140, 75 }, [82] = { 250, 227 }, [83] = { 138, 186 }, [84] = { 139, 106 }, [89] = { 158, 130 }, [92] = { 141, 247 }, [93] = { 150, 145 }, [95] = { 142, 86 }, [99] = { 158, 131 }, [103] = { 149, 79 }, [116] = { 158, 143 }, [118] = { 137, 177 }, [119] = { 158, 132 }, [126] = { 158, 149 }, [127] = { 158, 133 }, [129] = { 151, 192 }, [131] = { 158, 140 }, [133] = { 148, 126 }, [141] = { 158, 148 }, [143] = { 158, 135 },
		[147] = { 136, 178 }, [148] = { 158, 137 }, [151] = { 141, 91 }, [155] = { 158, 139 }, [157] = { 158, 138 }, [159] = { 158, 134 }, [160] = { 158, 145 }, [162] = { 143, 189 }, [166] = { 154, 235 }, [167] = { 140, 230 }, [168] = { 151, 156 }, [173] = { 158, 136 }, [175] = { 146, 242 }, [176] = { 138, 66 }, [177] = { 141, 171 }, [179] = { 158, 128 }, [181] = { 158, 144 }, [182] = { 138, 129 }, [185] = { 158, 142 }, [186] = { 158, 146 }, [188] = { 147, 142 }, [196] = { 138, 252 }, [198] = { 158, 176 }, [200] = { 250, 100 }, [201] = { 150, 199 },
		[202] = { 158, 151 }, [203] = { 138, 251 }, [205] = { 158, 158 }, [207] = { 250, 231 }, [210] = { 150, 95 }, [212] = { 158, 159 }, [213] = { 158, 161 }, [215] = { 158, 165 }, [216] = { 158, 153 }, [218] = { 146, 73 }, [223] = { 147, 143 }, [224] = { 158, 169 }, [225] = { 158, 156 }, [227] = { 158, 166 }, [231] = { 158, 160 }, [238] = { 144, 88 }, [239] = { 158, 170 }, [242] = { 144, 177 }, [249] = { 158, 168 }, [250] = { 138, 187 },
	},
	[105] = {
		[0] = { 152, 111 }, [1] = { 158, 150 }, [4] = { 158, 164 }, [5] = { 136, 214 }, [8] = { 158, 152 }, [11] = { 150, 184 }, [12] = { 158, 157 }, [13] = { 144, 65 }, [14] = { 146, 197 }, [15] = { 158, 147 }, [18] = { 158, 163 }, [25] = { 144, 154 }, [26] = { 158, 173 }, [27] = { 138, 145 }, [28] = { 140, 159 }, [33] = { 158, 175 }, [34] = { 158, 154 }, [35] = { 158, 174 }, [37] = { 158, 167 }, [38] = { 158, 155 }, [40] = { 158, 171 }, [42] = { 158, 172 }, [48] = { 158, 189 }, [52] = { 147, 204 },
		[54] = { 158, 162 }, [57] = { 158, 185 }, [61] = { 158, 187 }, [63] = { 146, 214 }, [74] = { 151, 107 }, [83] = { 149, 150 }, [84] = { 158, 182 }, [85] = { 145, 200 }, [89] = { 158, 188 }, [90] = { 145, 94 }, [92] = { 158, 179 }, [93] = { 158, 192 }, [94] = { 158, 191 }, [96] = { 147, 237 }, [97] = { 158, 190 }, [98] = { 147, 232 }, [104] = { 250, 233 }, [106] = { 158, 194 }, [107] = { 158, 181 }, [109] = { 139, 198 }, [110] = { 158, 184 }, [111] = { 143, 124 }, [115] = { 148, 128 }, [116] = { 158, 186 }, [117] = { 139, 201 },
		[119] = { 158, 178 }, [120] = { 158, 180 }, [121] = { 158, 177 }, [124] = { 152, 79 }, [125] = { 138, 121 }, [126] = { 158, 183 }, [129] = { 158, 193 }, [130] = { 138, 84 }, [138] = { 141, 229 }, [142] = { 137, 124 }, [145] = { 158, 210 }, [148] = { 152, 80 }, [149] = { 158, 213 }, [152] = { 250, 235 }, [155] = { 144, 89 }, [156] = { 158, 212 }, [160] = { 158, 211 }, [167] = { 158, 208 }, [174] = { 158, 196 }, [177] = { 158, 225 }, [178] = { 158, 195 }, [180] = { 158, 214 }, [187] = { 158, 206 }, [190] = { 158, 201 }, [191] = { 158, 198 },
		[193] = { 158, 199 }, [195] = { 158, 207 }, [199] = { 234, 160 }, [202] = { 158, 204 }, [203] = { 141, 92 }, [204] = { 146, 198 }, [205] = { 145, 132 }, [206] = { 158, 202 }, [208] = { 158, 197 }, [211] = { 158, 200 }, [216] = { 151, 108 }, [217] = { 150, 138 }, [221] = { 158, 205 }, [222] = { 158, 215 }, [226] = { 250, 236 }, [231] = { 158, 223 }, [232] = { 158, 216 }, [235] = { 158, 229 }, [237] = { 158, 227 }, [242] = { 158, 222 }, [249] = { 158, 221 }, [251] = { 146, 206 }, [253] = { 145, 133 }, [255] = { 158, 219 },
	},
	[106] = {
		[2] = { 158, 217 }, [5] = { 158, 224 }, [10] = { 158, 230 }, [11] = { 148, 243 }, [12] = { 158, 236 }, [18] = { 158, 231 }, [19] = { 158, 234 }, [20] = { 158, 228 }, [23] = { 146, 148 }, [25] = { 149, 87 }, [27] = { 158, 218 }, [30] = { 158, 226 }, [31] = { 143, 190 }, [33] = { 150, 205 }, [34] = { 158, 246 }, [35] = { 158, 233 }, [41] = { 140, 160 }, [42] = { 137, 161 }, [43] = { 138, 126 }, [46] = { 158, 209 }, [48] = { 250, 237 }, [53] = { 143, 191 }, [54] = { 158, 238 }, [56] = { 158, 245 },
		[57] = { 142, 247 }, [58] = { 138, 146 }, [61] = { 146, 77 }, [68] = { 158, 235 }, [70] = { 250, 239 }, [71] = { 158, 240 }, [72] = { 158, 244 }, [75] = { 139, 180 }, [88] = { 139, 107 }, [89] = { 158, 242 }, [95] = { 139, 64 }, [97] = { 147, 201 }, [98] = { 158, 241 }, [102] = { 158, 243 }, [107] = { 250, 238 }, [114] = { 158, 237 }, [115] = { 250, 240 }, [120] = { 158, 239 }, [126] = { 250, 241 }, [127] = { 138, 128 }, [128] = { 146, 104 }, [132] = { 158, 250 }, [141] = { 158, 248 }, [142] = { 140, 231 }, [144] = { 158, 247 },
		[151] = { 159, 64 }, [156] = { 158, 119 }, [160] = { 158, 249 }, [162] = { 158, 251 }, [163] = { 158, 252 }, [170] = { 159, 75 }, [172] = { 159, 71 }, [174] = { 158, 141 }, [179] = { 159, 70 }, [184] = { 159, 69 }, [187] = { 159, 66 }, [193] = { 158, 232 }, [194] = { 159, 68 }, [195] = { 159, 67 }, [209] = { 159, 73 }, [211] = { 152, 69 }, [218] = { 159, 76 }, [219] = { 139, 249 }, [222] = { 159, 72 }, [223] = { 159, 74 }, [226] = { 250, 242 }, [228] = { 250, 243 }, [232] = { 148, 165 }, [234] = { 159, 77 }, [250] = { 159, 81 },
		[251] = { 159, 78 },
	},
	[107] = {
		[4] = { 151, 147 }, [5] = { 159, 79 }, [10] = { 158, 220 }, [18] = { 159, 82 }, [22] = { 159, 83 }, [29] = { 137, 84 }, [31] = { 159, 85 }, [32] = { 140, 135 }, [33] = { 142, 159 }, [35] = { 139, 211 }, [39] = { 137, 162 }, [50] = { 151, 126 }, [55] = { 159, 87 }, [56] = { 159, 86 }, [57] = { 159, 89 }, [58] = { 139, 92 }, [61] = { 139, 212 }, [62] = { 138, 188 }, [67] = { 159, 92 }, [71] = { 159, 91 }, [73] = { 159, 93 }, [76] = { 137, 204 }, [78] = { 146, 86 }, [80] = { 159, 94 },
		[83] = { 138, 189 }, [84] = { 159, 96 }, [89] = { 159, 95 }, [91] = { 159, 97 }, [95] = { 159, 98 }, [97] = { 159, 99 }, [98] = { 142, 126 }, [99] = { 144, 179 }, [100] = { 141, 159 }, [102] = { 149, 144 }, [105] = { 149, 224 }, [106] = { 152, 99 }, [111] = { 142, 149 }, [115] = { 141, 206 }, [116] = { 151, 240 }, [120] = { 159, 100 }, [121] = { 159, 101 }, [123] = { 142, 128 }, [127] = { 159, 102 }, [128] = { 159, 103 }, [131] = { 159, 105 }, [132] = { 159, 104 }, [134] = { 150, 119 }, [137] = { 143, 125 }, [138] = { 142, 234 },
		[139] = { 142, 99 }, [141] = { 159, 106 }, [149] = { 159, 108 }, [150] = { 144, 66 }, [152] = { 159, 107 }, [158] = { 159, 109 }, [164] = { 159, 110 }, [170] = { 159, 111 }, [171] = { 159, 112 }, [175] = { 159, 113 }, [177] = { 159, 115 }, [178] = { 159, 114 }, [179] = { 159, 116 }, [180] = { 137, 163 }, [181] = { 146, 105 }, [183] = { 159, 117 }, [186] = { 142, 69 }, [187] = { 138, 107 }, [188] = { 159, 118 }, [191] = { 147, 97 }, [192] = { 154, 202 }, [197] = { 139, 66 }, [198] = { 159, 119 }, [203] = { 159, 120 }, [205] = { 149, 234 },
		[206] = { 150, 136 }, [210] = { 147, 197 }, [211] = { 159, 121 }, [212] = { 148, 228 }, [214] = { 250, 244 }, [216] = { 148, 249 }, [219] = { 150, 209 }, [223] = { 159, 122 }, [235] = { 159, 124 }, [236] = { 159, 123 }, [239] = { 159, 126 }, [243] = { 159, 125 },
	},
	[108] = {
		[8] = { 159, 129 }, [15] = { 142, 129 }, [17] = { 150, 175 }, [19] = { 159, 130 }, [20] = { 159, 131 }, [23] = { 139, 67 }, [27] = { 159, 132 }, [35] = { 159, 134 }, [36] = { 159, 133 }, [52] = { 144, 133 }, [55] = { 149, 88 }, [56] = { 137, 105 }, [62] = { 148, 195 }, [63] = { 250, 245 }, [64] = { 146, 243 }, [65] = { 143, 96 }, [66] = { 139, 129 }, [78] = { 148, 196 }, [80] = { 142, 172 }, [85] = { 159, 136 }, [87] = { 138, 190 }, [90] = { 137, 152 }, [92] = { 250, 246 }, [93] = { 147, 240 },
		[94] = { 159, 135 }, [95] = { 141, 93 }, [96] = { 146, 114 }, [98] = { 159, 137 }, [104] = { 159, 145 }, [106] = { 159, 138 }, [111] = { 250, 248 }, [112] = { 145, 191 }, [114] = { 139, 130 }, [115] = { 159, 146 }, [122] = { 140, 136 }, [125] = { 139, 68 }, [126] = { 159, 144 }, [129] = { 159, 142 }, [130] = { 159, 139 }, [131] = { 151, 128 }, [134] = { 250, 247 }, [136] = { 146, 190 }, [140] = { 147, 215 }, [141] = { 159, 140 }, [144] = { 159, 148 }, [146] = { 159, 147 }, [147] = { 140, 66 }, [150] = { 137, 171 }, [153] = { 141, 185 },
		[154] = { 159, 141 }, [155] = { 159, 143 }, [161] = { 150, 118 }, [162] = { 145, 242 }, [171] = { 150, 151 }, [174] = { 159, 156 }, [177] = { 159, 157 }, [179] = { 137, 205 }, [184] = { 149, 166 }, [185] = { 150, 251 }, [186] = { 159, 159 }, [187] = { 142, 161 }, [188] = { 143, 192 }, [189] = { 159, 152 }, [190] = { 159, 158 }, [191] = { 137, 136 }, [193] = { 139, 181 }, [196] = { 159, 149 }, [197] = { 159, 154 }, [201] = { 144, 242 }, [202] = { 148, 145 }, [204] = { 148, 229 }, [211] = { 159, 151 }, [213] = { 150, 64 }, [215] = { 159, 153 },
		[217] = { 159, 162 }, [218] = { 250, 249 }, [219] = { 159, 160 }, [221] = { 159, 155 }, [225] = { 150, 65 }, [226] = { 148, 103 }, [227] = { 139, 131 }, [229] = { 147, 68 }, [232] = { 146, 141 }, [234] = { 159, 163 }, [239] = { 159, 161 }, [240] = { 145, 215 }, [241] = { 159, 150 }, [243] = { 137, 106 },
	},
	[109] = {
		[4] = { 250, 250 }, [11] = { 151, 109 }, [12] = { 159, 174 }, [18] = { 159, 173 }, [23] = { 144, 244 }, [25] = { 159, 170 }, [27] = { 151, 140 }, [30] = { 147, 180 }, [31] = { 159, 164 }, [37] = { 146, 195 }, [41] = { 137, 107 }, [42] = { 141, 94 }, [43] = { 159, 167 }, [50] = { 143, 70 }, [51] = { 159, 172 }, [53] = { 159, 171 }, [54] = { 159, 166 }, [56] = { 159, 169 }, [59] = { 138, 136 }, [61] = { 159, 168 }, [62] = { 148, 104 }, [65] = { 151, 172 }, [68] = { 143, 242 }, [69] = { 144, 243 },
		[89] = { 159, 180 }, [90] = { 159, 178 }, [92] = { 149, 108 }, [99] = { 159, 175 }, [100] = { 159, 177 }, [102] = { 137, 89 }, [105] = { 141, 95 }, [106] = { 152, 81 }, [108] = { 138, 92 }, [110] = { 149, 130 }, [111] = { 250, 252 }, [116] = { 151, 129 }, [119] = { 138, 67 }, [120] = { 144, 90 }, [121] = { 159, 179 }, [133] = { 159, 184 }, [135] = { 250, 251 }, [136] = { 143, 193 }, [140] = { 151, 79 }, [142] = { 159, 181 }, [147] = { 159, 176 }, [149] = { 159, 182 }, [150] = { 251, 64 }, [153] = { 151, 220 }, [155] = { 147, 147 },
		[156] = { 147, 192 }, [172] = { 251, 65 }, [175] = { 138, 85 }, [178] = { 137, 116 }, [181] = { 159, 188 }, [184] = { 159, 191 }, [188] = { 151, 193 }, [192] = { 151, 132 }, [197] = { 159, 198 }, [198] = { 159, 192 }, [199] = { 159, 189 }, [203] = { 151, 210 }, [204] = { 159, 195 }, [207] = { 251, 66 }, [209] = { 143, 105 }, [210] = { 159, 197 }, [213] = { 159, 202 }, [216] = { 147, 145 }, [217] = { 159, 200 }, [222] = { 159, 194 }, [225] = { 146, 87 }, [228] = { 159, 201 }, [230] = { 159, 190 }, [232] = { 159, 196 }, [234] = { 159, 203 },
		[235] = { 136, 250 }, [236] = { 159, 193 }, [238] = { 159, 204 }, [241] = { 144, 91 }, [242] = { 251, 68 }, [243] = { 143, 126 }, [245] = { 149, 163 }, [247] = { 141, 172 }, [248] = { 251, 67 }, [249] = { 159, 185 }, [250] = { 159, 199 }, [251] = { 147, 89 }, [252] = { 251, 69 },
	},
	[110] = {
		[5] = { 144, 180 }, [7] = { 138, 137 }, [8] = { 141, 207 }, [9] = { 143, 194 }, [10] = { 159, 187 }, [11] = { 143, 97 }, [19] = { 140, 107 }, [21] = { 159, 186 }, [25] = { 159, 208 }, [26] = { 143, 141 }, [27] = { 140, 184 }, [29] = { 159, 223 }, [31] = { 159, 217 }, [32] = { 139, 148 }, [33] = { 147, 110 }, [35] = { 159, 212 }, [36] = { 159, 221 }, [37] = { 136, 173 }, [38] = { 137, 81 }, [39] = { 251, 72 }, [41] = { 137, 183 }, [43] = { 159, 214 }, [44] = { 145, 170 }, [45] = { 159, 205 },
		[46] = { 159, 207 }, [47] = { 141, 96 }, [56] = { 159, 224 }, [57] = { 251, 70 }, [58] = { 159, 219 }, [60] = { 251, 73 }, [62] = { 159, 211 }, [67] = { 159, 218 }, [74] = { 150, 169 }, [77] = { 159, 216 }, [78] = { 159, 220 }, [86] = { 140, 206 }, [88] = { 143, 195 }, [91] = { 146, 88 }, [92] = { 251, 71 }, [95] = { 159, 210 }, [103] = { 151, 78 }, [107] = { 159, 213 }, [110] = { 159, 206 }, [111] = { 147, 146 }, [114] = { 159, 209 }, [118] = { 159, 215 }, [126] = { 152, 112 }, [127] = { 142, 188 }, [128] = { 150, 158 },
		[130] = { 159, 225 }, [140] = { 148, 172 }, [143] = { 159, 237 }, [144] = { 140, 185 }, [150] = { 143, 128 }, [152] = { 159, 227 }, [156] = { 151, 173 }, [157] = { 141, 97 }, [159] = { 159, 240 }, [162] = { 136, 236 }, [165] = { 159, 238 }, [170] = { 159, 226 }, [175] = { 159, 232 }, [178] = { 159, 234 }, [182] = { 151, 110 }, [183] = { 159, 229 }, [186] = { 147, 77 }, [189] = { 159, 231 }, [191] = { 251, 74 }, [194] = { 159, 239 }, [196] = { 159, 233 }, [197] = { 150, 197 }, [201] = { 159, 228 }, [203] = { 142, 160 }, [204] = { 159, 252 },
		[209] = { 138, 138 }, [211] = { 159, 230 }, [212] = { 159, 235 }, [213] = { 159, 236 }, [221] = { 145, 234 }, [222] = { 145, 216 }, [236] = { 159, 244 }, [239] = { 159, 250 }, [242] = { 159, 248 }, [244] = { 147, 72 }, [247] = { 224, 66 }, [248] = { 159, 245 }, [254] = { 159, 246 }, [255] = { 159, 222 },
	},
	[111] = {
		[1] = { 139, 153 }, [2] = { 149, 89 }, [6] = { 142, 189 }, [9] = { 141, 151 }, [15] = { 152, 82 }, [17] = { 159, 242 }, [19] = { 224, 65 }, [20] = { 137, 137 }, [21] = { 145, 134 }, [32] = { 148, 153 }, [34] = { 138, 191 }, [35] = { 151, 248 }, [43] = { 150, 159 }, [44] = { 146, 208 }, [49] = { 159, 249 }, [50] = { 159, 251 }, [56] = { 145, 81 }, [62] = { 224, 64 }, [63] = { 159, 247 }, [65] = { 159, 241 }, [69] = { 138, 193 }, [84] = { 140, 137 }, [88] = { 224, 78 }, [91] = { 224, 73 },
		[92] = { 144, 246 }, [95] = { 138, 131 }, [100] = { 143, 129 }, [102] = { 224, 82 }, [109] = { 224, 75 }, [110] = { 146, 170 }, [111] = { 224, 72 }, [112] = { 146, 215 }, [116] = { 224, 107 }, [120] = { 224, 69 }, [122] = { 224, 68 }, [124] = { 224, 77 }, [128] = { 224, 71 }, [129] = { 224, 70 }, [130] = { 224, 76 }, [132] = { 144, 159 }, [134] = { 224, 67 }, [136] = { 251, 75 }, [142] = { 224, 79 }, [145] = { 224, 80 }, [151] = { 138, 192 }, [161] = { 224, 85 }, [163] = { 224, 84 }, [164] = { 224, 86 }, [170] = { 224, 89 },
		[177] = { 147, 98 }, [179] = { 224, 83 }, [181] = { 251, 76 }, [185] = { 224, 87 }, [192] = { 140, 131 }, [193] = { 145, 247 }, [194] = { 224, 81 }, [195] = { 148, 90 }, [198] = { 224, 88 }, [212] = { 224, 93 }, [213] = { 224, 91 }, [216] = { 224, 94 }, [219] = { 224, 97 }, [223] = { 224, 90 }, [224] = { 141, 138 }, [225] = { 148, 71 }, [228] = { 159, 183 }, [235] = { 151, 148 }, [236] = { 224, 92 }, [238] = { 224, 96 }, [239] = { 145, 243 }, [241] = { 224, 95 }, [243] = { 224, 74 }, [245] = { 251, 77 }, [246] = { 232, 137 },
		[250] = { 224, 100 }, [254] = { 224, 104 },
	},
	[112] = {
		[1] = { 224, 102 }, [5] = { 251, 78 }, [7] = { 251, 79 }, [9] = { 224, 98 }, [11] = { 224, 99 }, [15] = { 224, 103 }, [17] = { 224, 101 }, [21] = { 149, 109 }, [24] = { 224, 109 }, [26] = { 224, 106 }, [27] = { 224, 105 }, [29] = { 224, 108 }, [30] = { 147, 210 }, [31] = { 224, 110 }, [38] = { 146, 149 }, [39] = { 145, 235 }, [40] = { 251, 80 }, [44] = { 144, 163 }, [48] = { 224, 111 }, [50] = { 224, 113 }, [62] = { 224, 112 }, [76] = { 159, 243 }, [81] = { 224, 114 }, [88] = { 147, 229 },
		[99] = { 224, 115 }, [107] = { 137, 206 }, [111] = { 147, 148 }, [112] = { 138, 68 }, [120] = { 139, 132 }, [124] = { 142, 220 }, [125] = { 141, 208 }, [133] = { 251, 81 }, [137] = { 152, 70 }, [138] = { 144, 134 }, [142] = { 137, 138 }, [146] = { 224, 117 }, [153] = { 224, 116 }, [171] = { 251, 82 }, [172] = { 224, 120 }, [173] = { 146, 89 }, [174] = { 224, 123 }, [175] = { 224, 118 }, [179] = { 224, 122 }, [184] = { 224, 121 }, [185] = { 147, 95 }, [186] = { 136, 215 }, [187] = { 250, 98 }, [200] = { 151, 243 }, [203] = { 224, 125 },
		[207] = { 137, 71 }, [217] = { 224, 128 }, [221] = { 224, 126 }, [223] = { 224, 124 }, [241] = { 224, 119 }, [249] = { 150, 66 }, [253] = { 224, 130 },
	},
	[113] = {
		[4] = { 251, 84 }, [9] = { 224, 129 }, [15] = { 251, 83 }, [20] = { 137, 139 }, [25] = { 224, 132 }, [26] = { 149, 176 }, [28] = { 224, 131 }, [33] = { 150, 179 }, [38] = { 143, 197 }, [54] = { 145, 82 }, [60] = { 143, 196 }, [70] = { 251, 86 }, [71] = { 251, 87 }, [73] = { 151, 249 }, [76] = { 224, 138 }, [78] = { 144, 247 }, [85] = { 224, 134 }, [86] = { 224, 139 }, [89] = { 137, 140 }, [92] = { 251, 85 }, [98] = { 224, 137 }, [100] = { 148, 129 }, [101] = { 224, 133 }, [102] = { 224, 136 },
		[103] = { 143, 198 }, [105] = { 148, 207 }, [108] = { 224, 140 }, [110] = { 142, 207 }, [125] = { 144, 248 }, [132] = { 224, 143 }, [136] = { 224, 135 }, [138] = { 140, 70 }, [143] = { 224, 141 }, [148] = { 151, 111 }, [149] = { 224, 144 }, [153] = { 234, 164 }, [159] = { 143, 110 }, [168] = { 224, 145 }, [172] = { 224, 146 }, [177] = { 148, 77 }, [185] = { 224, 148 }, [190] = { 224, 149 }, [193] = { 251, 89 }, [195] = { 148, 82 }, [200] = { 147, 149 }, [201] = { 224, 151 }, [206] = { 224, 153 }, [208] = { 151, 211 }, [210] = { 224, 150 },
		[212] = { 224, 152 }, [213] = { 137, 141 }, [215] = { 224, 147 }, [223] = { 154, 122 }, [224] = { 224, 154 }, [229] = { 145, 135 }, [230] = { 142, 87 }, [231] = { 224, 156 }, [236] = { 224, 155 }, [237] = { 144, 67 }, [238] = { 153, 215 }, [245] = { 224, 157 }, [249] = { 224, 159 }, [251] = { 224, 142 }, [252] = { 224, 158 }, [254] = { 251, 90 }, [255] = { 224, 160 },
	},
	[114] = {
		[6] = { 148, 154 }, [13] = { 224, 161 }, [16] = { 224, 162 }, [27] = { 224, 163 }, [40] = { 224, 164 }, [42] = { 146, 220 }, [44] = { 224, 166 }, [45] = { 224, 165 }, [48] = { 224, 167 }, [50] = { 224, 168 }, [53] = { 142, 221 }, [54] = { 149, 131 }, [58] = { 150, 234 }, [59] = { 224, 169 }, [60] = { 224, 170 }, [61] = { 145, 117 }, [62] = { 142, 162 }, [63] = { 224, 171 }, [64] = { 224, 172 }, [70] = { 224, 173 }, [71] = { 149, 208 }, [72] = { 148, 197 }, [75] = { 224, 174 }, [76] = { 148, 118 },
		[82] = { 146, 171 }, [88] = { 224, 175 }, [89] = { 137, 229 }, [91] = { 139, 141 }, [93] = { 150, 196 }, [95] = { 150, 180 }, [97] = { 137, 178 }, [98] = { 152, 83 }, [103] = { 150, 113 }, [105] = { 149, 168 }, [114] = { 144, 181 }, [116] = { 224, 176 }, [121] = { 147, 193 }, [125] = { 140, 161 }, [126] = { 224, 177 }, [128] = { 141, 210 }, [129] = { 224, 179 }, [130] = { 224, 178 }, [135] = { 224, 180 }, [146] = { 224, 181 }, [150] = { 224, 182 }, [160] = { 139, 93 }, [162] = { 224, 183 }, [167] = { 224, 184 }, [172] = { 140, 162 },
		[175] = { 148, 198 }, [177] = { 251, 91 }, [178] = { 224, 186 }, [182] = { 143, 243 }, [185] = { 224, 185 }, [190] = { 251, 92 }, [194] = { 139, 182 }, [195] = { 224, 187 }, [196] = { 224, 189 }, [198] = { 224, 188 }, [206] = { 224, 190 }, [208] = { 140, 207 }, [210] = { 224, 191 }, [215] = { 139, 231 }, [217] = { 145, 95 }, [219] = { 141, 157 }, [224] = { 224, 193 }, [225] = { 224, 194 }, [226] = { 224, 192 }, [233] = { 142, 235 }, [236] = { 147, 198 }, [237] = { 139, 183 }, [247] = { 224, 196 }, [248] = { 146, 75 }, [249] = { 224, 195 },
		[252] = { 152, 84 }, [253] = { 148, 130 },
	},
	[115] = {
		[10] = { 224, 199 }, [22] = { 224, 201 }, [23] = { 224, 198 }, [27] = { 150, 210 }, [28] = { 224, 200 }, [29] = { 224, 202 }, [31] = { 151, 194 }, [36] = { 251, 93 }, [37] = { 224, 206 }, [41] = { 224, 205 }, [42] = { 146, 150 }, [43] = { 148, 76 }, [46] = { 140, 163 }, [47] = { 224, 204 }, [52] = { 224, 203 }, [54] = { 151, 80 }, [55] = { 151, 81 }, [62] = { 224, 207 }, [63] = { 137, 142 }, [68] = { 141, 150 }, [69] = { 142, 130 }, [78] = { 224, 208 }, [79] = { 224, 209 }, [87] = { 224, 211 },
		[99] = { 143, 98 }, [104] = { 224, 213 }, [106] = { 224, 212 }, [112] = { 224, 214 }, [114] = { 138, 108 }, [117] = { 224, 216 }, [119] = { 251, 95 }, [120] = { 224, 215 }, [122] = { 224, 218 }, [123] = { 224, 217 }, [132] = { 140, 186 }, [135] = { 151, 166 }, [137] = { 139, 202 }, [139] = { 137, 164 }, [150] = { 139, 232 }, [169] = { 138, 223 }, [178] = { 151, 230 }, [179] = { 224, 220 }, [187] = { 224, 222 }, [189] = { 251, 96 }, [192] = { 224, 223 }, [194] = { 137, 207 }, [200] = { 224, 219 }, [201] = { 251, 97 }, [202] = { 142, 88 },
		[205] = { 146, 191 }, [206] = { 224, 221 }, [210] = { 251, 100 }, [214] = { 251, 98 }, [222] = { 224, 226 }, [224] = { 142, 236 }, [227] = { 251, 99 }, [229] = { 224, 224 }, [234] = { 140, 93 }, [237] = { 148, 199 }, [238] = { 224, 225 }, [241] = { 224, 252 }, [245] = { 251, 102 }, [248] = { 224, 231 }, [254] = { 140, 187 },
	},
	[116] = {
		[3] = { 139, 133 }, [5] = { 224, 228 }, [6] = { 151, 157 }, [7] = { 251, 101 }, [9] = { 151, 174 }, [34] = { 145, 244 }, [37] = { 224, 230 }, [38] = { 251, 103 }, [41] = { 251, 105 }, [42] = { 251, 104 }, [46] = { 251, 106 }, [50] = { 224, 232 }, [51] = { 151, 212 }, [52] = { 139, 213 }, [53] = { 148, 250 }, [54] = { 148, 105 }, [58] = { 224, 233 }, [63] = { 224, 235 }, [65] = { 224, 238 }, [85] = { 224, 234 }, [89] = { 224, 237 }, [90] = { 140, 232 }, [91] = { 137, 108 }, [92] = { 224, 239 },
		[94] = { 144, 144 }, [95] = { 224, 236 }, [96] = { 151, 218 }, [98] = { 251, 107 }, [99] = { 224, 242 }, [100] = { 234, 162 }, [105] = { 224, 240 }, [106] = { 224, 243 }, [111] = { 224, 229 }, [112] = { 224, 241 }, [115] = { 141, 186 }, [118] = { 224, 244 }, [126] = { 224, 245 }, [131] = { 151, 158 }, [137] = { 251, 108 }, [139] = { 224, 246 }, [158] = { 224, 247 }, [159] = { 251, 109 }, [162] = { 224, 227 }, [167] = { 224, 248 }, [176] = { 138, 194 }, [189] = { 142, 163 }, [202] = { 224, 249 }, [207] = { 224, 250 }, [212] = { 224, 251 },
		[220] = { 137, 90 }, [224] = { 225, 64 }, [226] = { 149, 90 }, [227] = { 225, 65 }, [230] = { 138, 162 }, [231] = { 225, 66 }, [233] = { 225, 67 }, [238] = { 225, 68 }, [240] = { 225, 70 }, [241] = { 225, 71 }, [242] = { 225, 69 }, [246] = { 149, 114 }, [247] = { 225, 73 }, [248] = { 225, 72 },
	},
	[117] = {
		[1] = { 251, 110 }, [3] = { 225, 75 }, [4] = { 225, 74 }, [5] = { 225, 76 }, [12] = { 225, 77 }, [13] = { 225, 79 }, [14] = { 225, 78 }, [17] = { 141, 153 }, [19] = { 225, 81 }, [21] = { 225, 80 }, [24] = { 138, 195 }, [26] = { 144, 114 }, [28] = { 147, 91 }, [30] = { 225, 82 }, [31] = { 144, 182 }, [35] = { 142, 89 }, [37] = { 137, 153 }, [38] = { 225, 83 }, [40] = { 151, 112 }, [43] = { 149, 225 }, [44] = { 225, 84 }, [47] = { 250, 168 }, [48] = { 147, 99 }, [49] = { 151, 82 },
		[50] = { 141, 98 }, [51] = { 144, 92 }, [55] = { 146, 106 }, [56] = { 153, 178 }, [58] = { 146, 172 }, [59] = { 137, 230 }, [60] = { 225, 85 }, [68] = { 225, 86 }, [70] = { 225, 91 }, [73] = { 225, 89 }, [74] = { 225, 88 }, [75] = { 157, 192 }, [76] = { 138, 69 }, [77] = { 225, 87 }, [79] = { 136, 216 }, [81] = { 148, 168 }, [84] = { 148, 200 }, [89] = { 151, 175 }, [90] = { 225, 92 }, [91] = { 225, 90 }, [92] = { 146, 123 }, [93] = { 144, 164 }, [96] = { 148, 169 }, [98] = { 149, 76 }, [100] = { 225, 94 },
		[101] = { 151, 170 }, [102] = { 140, 108 }, [103] = { 225, 95 }, [105] = { 225, 93 }, [106] = { 148, 212 }, [107] = { 225, 96 }, [109] = { 225, 97 }, [111] = { 251, 111 }, [112] = { 136, 217 }, [115] = { 143, 244 }, [116] = { 225, 102 }, [118] = { 225, 99 }, [119] = { 147, 235 }, [120] = { 225, 98 }, [127] = { 139, 69 }, [130] = { 225, 105 }, [134] = { 225, 100 }, [135] = { 225, 101 }, [137] = { 225, 104 }, [138] = { 225, 103 }, [139] = { 149, 68 }, [142] = { 145, 97 }, [143] = { 145, 96 }, [145] = { 139, 94 }, [148] = { 225, 106 },
		[154] = { 225, 107 }, [157] = { 225, 108 }, [163] = { 225, 110 }, [165] = { 225, 109 }, [171] = { 137, 117 }, [177] = { 225, 118 }, [178] = { 148, 230 }, [179] = { 225, 112 }, [181] = { 225, 114 }, [184] = { 225, 116 }, [185] = { 144, 93 }, [188] = { 225, 117 }, [189] = { 225, 115 }, [190] = { 142, 190 }, [194] = { 225, 111 }, [195] = { 225, 113 }, [197] = { 149, 97 }, [199] = { 143, 199 }, [202] = { 225, 120 }, [205] = { 225, 119 }, [210] = { 225, 121 }, [212] = { 142, 164 }, [213] = { 141, 173 }, [216] = { 147, 151 }, [217] = { 225, 122 },
		[219] = { 146, 201 }, [222] = { 225, 124 }, [226] = { 151, 159 }, [227] = { 225, 123 }, [233] = { 145, 137 }, [240] = { 225, 130 }, [242] = { 225, 132 }, [243] = { 225, 133 }, [244] = { 146, 115 }, [250] = { 225, 131 }, [252] = { 225, 128 }, [254] = { 225, 125 }, [255] = { 225, 126 },
	},
	[118] = {
		[1] = { 225, 129 }, [9] = { 225, 136 }, [11] = { 225, 134 }, [13] = { 225, 135 }, [31] = { 225, 137 }, [32] = { 225, 139 }, [33] = { 225, 140 }, [34] = { 225, 141 }, [36] = { 225, 142 }, [39] = { 225, 138 }, [48] = { 225, 144 }, [52] = { 225, 143 }, [59] = { 225, 145 }, [66] = { 151, 195 }, [70] = { 225, 148 }, [71] = { 225, 146 }, [72] = { 225, 147 }, [76] = { 138, 224 }, [82] = { 150, 252 }, [86] = { 149, 200 }, [88] = { 225, 150 }, [92] = { 225, 149 }, [97] = { 225, 151 }, [98] = { 225, 152 },
		[103] = { 225, 156 }, [104] = { 225, 153 }, [105] = { 225, 154 }, [106] = { 225, 155 }, [108] = { 225, 157 }, [112] = { 225, 158 }, [114] = { 225, 159 }, [118] = { 225, 160 }, [120] = { 225, 161 }, [122] = { 148, 173 }, [123] = { 147, 111 }, [124] = { 225, 162 }, [125] = { 148, 146 }, [126] = { 149, 83 }, [128] = { 225, 163 }, [130] = { 251, 112 }, [131] = { 225, 164 }, [132] = { 147, 73 }, [134] = { 138, 70 }, [135] = { 141, 99 }, [136] = { 225, 165 }, [139] = { 225, 166 }, [142] = { 225, 167 }, [144] = { 142, 72 }, [147] = { 225, 169 },
		[150] = { 225, 168 }, [153] = { 225, 170 }, [154] = { 225, 171 }, [155] = { 251, 115 }, [156] = { 251, 113 }, [158] = { 251, 114 }, [166] = { 251, 116 }, [174] = { 148, 231 }, [176] = { 225, 172 }, [180] = { 225, 173 }, [183] = { 234, 137 }, [184] = { 225, 174 }, [185] = { 225, 175 }, [186] = { 225, 176 }, [191] = { 142, 77 }, [194] = { 225, 177 }, [195] = { 148, 117 }, [198] = { 150, 126 }, [200] = { 137, 109 }, [202] = { 137, 118 }, [205] = { 225, 178 }, [210] = { 225, 180 }, [214] = { 225, 179 }, [215] = { 147, 144 }, [219] = { 144, 183 },
		[220] = { 159, 88 }, [222] = { 225, 181 }, [223] = { 150, 191 }, [225] = { 225, 182 }, [227] = { 138, 196 }, [228] = { 148, 213 }, [229] = { 225, 183 }, [231] = { 225, 184 }, [234] = { 225, 185 }, [238] = { 150, 218 }, [242] = { 150, 211 }, [244] = { 146, 188 }, [248] = { 145, 138 }, [251] = { 225, 187 }, [254] = { 143, 130 },
	},
	[119] = {
		[1] = { 143, 200 }, [4] = { 225, 190 }, [7] = { 225, 189 }, [8] = { 225, 188 }, [9] = { 148, 251 }, [11] = { 138, 197 }, [12] = { 140, 167 }, [27] = { 225, 196 }, [30] = { 225, 193 }, [31] = { 144, 94 }, [32] = { 150, 176 }, [36] = { 225, 192 }, [37] = { 225, 194 }, [38] = { 225, 195 }, [41] = { 225, 191 }, [55] = { 225, 197 }, [56] = { 225, 198 }, [58] = { 146, 173 }, [60] = { 138, 225 }, [64] = { 146, 133 }, [70] = { 251, 118 }, [71] = { 225, 199 }, [90] = { 225, 200 }, [91] = { 225, 203 },
		[97] = { 144, 135 }, [99] = { 147, 194 }, [101] = { 225, 204 }, [102] = { 150, 114 }, [104] = { 225, 201 }, [107] = { 225, 202 }, [121] = { 225, 207 }, [126] = { 225, 206 }, [127] = { 225, 205 }, [139] = { 225, 209 }, [142] = { 225, 208 }, [145] = { 225, 210 }, [158] = { 225, 212 }, [160] = { 225, 211 }, [165] = { 149, 203 }, [172] = { 143, 117 }, [173] = { 151, 196 }, [176] = { 225, 213 }, [179] = { 147, 181 }, [182] = { 225, 214 }, [185] = { 225, 215 }, [187] = { 225, 219 }, [188] = { 225, 217 }, [189] = { 225, 218 }, [191] = { 225, 216 },
		[199] = { 225, 220 }, [205] = { 225, 221 }, [215] = { 225, 222 }, [218] = { 225, 223 }, [219] = { 150, 181 }, [220] = { 225, 224 }, [226] = { 150, 238 }, [227] = { 225, 225 }, [229] = { 146, 109 }, [231] = { 148, 138 }, [233] = { 139, 233 }, [237] = { 146, 90 }, [238] = { 225, 226 }, [239] = { 139, 184 }, [243] = { 144, 206 }, [252] = { 225, 227 },
	},
	[120] = {
		[2] = { 141, 187 }, [12] = { 225, 228 }, [18] = { 225, 229 }, [20] = { 140, 164 }, [21] = { 141, 211 }, [32] = { 225, 231 }, [33] = { 251, 120 }, [37] = { 147, 117 }, [38] = { 141, 212 }, [39] = { 139, 109 }, [50] = { 150, 67 }, [52] = { 148, 106 }, [58] = { 147, 118 }, [63] = { 141, 123 }, [69] = { 225, 233 }, [78] = { 251, 121 }, [93] = { 143, 201 }, [100] = { 251, 122 }, [107] = { 151, 176 }, [108] = { 141, 100 }, [111] = { 140, 165 }, [114] = { 148, 161 }, [116] = { 225, 235 }, [122] = { 251, 123 },
		[124] = { 225, 237 }, [129] = { 140, 233 }, [134] = { 225, 236 }, [135] = { 146, 244 }, [140] = { 225, 239 }, [141] = { 138, 86 }, [142] = { 225, 234 }, [145] = { 148, 232 }, [147] = { 137, 79 }, [149] = { 141, 234 }, [151] = { 152, 113 }, [154] = { 225, 238 }, [163] = { 225, 240 }, [167] = { 149, 201 }, [169] = { 144, 215 }, [170] = { 225, 242 }, [175] = { 225, 243 }, [181] = { 225, 241 }, [186] = { 138, 109 }, [188] = { 225, 249 }, [190] = { 225, 248 }, [193] = { 142, 165 }, [197] = { 225, 250 }, [198] = { 225, 245 }, [202] = { 225, 251 },
		[203] = { 225, 246 }, [208] = { 148, 214 }, [209] = { 225, 244 }, [212] = { 225, 247 }, [218] = { 226, 65 }, [231] = { 226, 64 }, [232] = { 150, 129 }, [236] = { 225, 252 }, [239] = { 136, 233 }, [244] = { 226, 67 }, [253] = { 226, 66 },
	},
	[121] = {
		[1] = { 143, 202 }, [7] = { 226, 68 }, [14] = { 145, 98 }, [17] = { 226, 70 }, [18] = { 226, 69 }, [25] = { 226, 71 }, [38] = { 225, 230 }, [42] = { 225, 232 }, [43] = { 226, 73 }, [44] = { 226, 72 }, [48] = { 251, 124 }, [58] = { 142, 166 }, [60] = { 151, 231 }, [62] = { 142, 208 }, [64] = { 226, 74 }, [65] = { 140, 86 }, [71] = { 139, 95 }, [72] = { 139, 70 }, [73] = { 142, 131 }, [80] = { 151, 83 }, [83] = { 226, 80 }, [85] = { 226, 79 }, [86] = { 145, 99 }, [87] = { 226, 76 },
		[90] = { 226, 78 }, [93] = { 143, 106 }, [94] = { 144, 95 }, [95] = { 226, 77 }, [96] = { 226, 75 }, [98] = { 148, 73 }, [101] = { 143, 203 }, [104] = { 149, 91 }, [109] = { 141, 213 }, [119] = { 147, 152 }, [122] = { 226, 81 }, [127] = { 226, 82 }, [128] = { 226, 104 }, [129] = { 139, 214 }, [132] = { 152, 92 }, [133] = { 145, 84 }, [138] = { 226, 83 }, [141] = { 137, 208 }, [142] = { 146, 245 }, [143] = { 149, 159 }, [148] = { 251, 129 }, [155] = { 251, 131 }, [157] = { 226, 84 }, [166] = { 139, 154 }, [167] = { 226, 85 },
		[170] = { 226, 87 }, [174] = { 226, 88 }, [176] = { 148, 72 }, [179] = { 226, 89 }, [185] = { 226, 90 }, [186] = { 226, 91 }, [189] = { 139, 215 }, [190] = { 137, 209 }, [191] = { 147, 195 }, [192] = { 143, 71 }, [193] = { 142, 132 }, [201] = { 226, 92 }, [203] = { 143, 72 }, [209] = { 137, 200 }, [210] = { 149, 98 }, [213] = { 226, 93 }, [216] = { 148, 233 }, [223] = { 145, 100 }, [225] = { 226, 96 }, [227] = { 226, 97 }, [228] = { 148, 137 }, [230] = { 144, 96 }, [231] = { 226, 94 }, [233] = { 146, 129 }, [236] = { 226, 95 },
		[240] = { 143, 204 }, [251] = { 136, 218 },
	},
	[122] = {
		[0] = { 139, 72 }, [8] = { 226, 98 }, [11] = { 146, 246 }, [13] = { 226, 99 }, [14] = { 144, 197 }, [20] = { 150, 171 }, [23] = { 149, 66 }, [24] = { 226, 100 }, [25] = { 226, 101 }, [26] = { 146, 116 }, [28] = { 151, 197 }, [31] = { 226, 103 }, [32] = { 226, 102 }, [46] = { 142, 237 }, [49] = { 226, 105 }, [50] = { 136, 238 }, [55] = { 226, 108 }, [59] = { 226, 106 }, [60] = { 137, 210 }, [61] = { 140, 109 }, [62] = { 226, 107 }, [63] = { 141, 101 }, [64] = { 141, 146 }, [66] = { 149, 228 },
		[67] = { 226, 109 }, [70] = { 150, 115 }, [73] = { 226, 111 }, [77] = { 144, 207 }, [78] = { 137, 110 }, [79] = { 137, 184 }, [80] = { 136, 170 }, [87] = { 226, 110 }, [97] = { 226, 112 }, [98] = { 226, 113 }, [99] = { 143, 245 }, [105] = { 226, 114 }, [107] = { 138, 110 }, [112] = { 226, 116 }, [116] = { 140, 138 }, [118] = { 139, 134 }, [121] = { 226, 117 }, [122] = { 139, 243 }, [125] = { 226, 118 }, [127] = { 144, 250 }, [129] = { 147, 203 }, [131] = { 144, 222 }, [132] = { 141, 243 }, [136] = { 226, 119 }, [146] = { 146, 130 },
		[147] = { 145, 139 }, [149] = { 226, 121 }, [150] = { 226, 123 }, [151] = { 226, 120 }, [152] = { 226, 122 }, [159] = { 140, 65 }, [169] = { 226, 124 }, [170] = { 140, 69 }, [174] = { 139, 135 }, [175] = { 151, 113 }, [176] = { 226, 126 }, [182] = { 226, 128 }, [186] = { 137, 77 }, [191] = { 226, 131 }, [195] = { 138, 150 }, [196] = { 226, 130 }, [197] = { 226, 129 }, [199] = { 226, 133 }, [200] = { 226, 125 }, [202] = { 226, 134 }, [203] = { 151, 167 }, [205] = { 226, 135 }, [207] = { 226, 136 }, [209] = { 251, 132 }, [210] = { 154, 242 },
		[211] = { 226, 138 }, [213] = { 226, 137 }, [217] = { 226, 139 }, [218] = { 226, 140 }, [220] = { 151, 179 }, [221] = { 226, 141 }, [223] = { 232, 237 }, [224] = { 143, 205 }, [225] = { 226, 142 }, [226] = { 226, 143 }, [227] = { 143, 118 }, [229] = { 147, 182 }, [230] = { 226, 144 }, [231] = { 251, 133 }, [234] = { 146, 71 }, [235] = { 251, 135 }, [237] = { 226, 145 }, [239] = { 146, 91 }, [240] = { 226, 146 }, [246] = { 139, 163 }, [248] = { 153, 94 }, [249] = { 146, 124 }, [250] = { 142, 177 }, [255] = { 138, 198 },
	},
	[123] = {
		[2] = { 226, 147 }, [4] = { 226, 160 }, [6] = { 226, 150 }, [8] = { 139, 136 }, [10] = { 226, 149 }, [11] = { 226, 162 }, [15] = { 226, 148 }, [17] = { 143, 206 }, [24] = { 226, 152 }, [25] = { 226, 153 }, [27] = { 147, 74 }, [30] = { 226, 154 }, [32] = { 138, 125 }, [37] = { 144, 121 }, [38] = { 149, 132 }, [40] = { 226, 156 }, [44] = { 145, 230 }, [51] = { 226, 151 }, [53] = { 226, 155 }, [54] = { 226, 157 }, [57] = { 141, 249 }, [69] = { 226, 164 }, [70] = { 149, 77 }, [72] = { 148, 164 },
		[73] = { 147, 153 }, [75] = { 139, 216 }, [76] = { 226, 163 }, [77] = { 226, 161 }, [79] = { 148, 179 }, [80] = { 226, 158 }, [81] = { 146, 125 }, [82] = { 147, 155 }, [84] = { 147, 154 }, [86] = { 141, 244 }, [93] = { 226, 182 }, [101] = { 226, 166 }, [103] = { 226, 168 }, [108] = { 226, 171 }, [110] = { 226, 172 }, [112] = { 226, 169 }, [113] = { 226, 170 }, [116] = { 226, 167 }, [117] = { 226, 165 }, [122] = { 226, 159 }, [134] = { 149, 205 }, [135] = { 137, 211 }, [139] = { 226, 179 }, [141] = { 226, 176 }, [143] = { 226, 181 },
		[146] = { 226, 180 }, [148] = { 148, 147 }, [149] = { 150, 165 }, [151] = { 142, 90 }, [152] = { 226, 174 }, [153] = { 226, 183 }, [154] = { 226, 178 }, [156] = { 226, 177 }, [157] = { 226, 173 }, [158] = { 251, 136 }, [159] = { 226, 175 }, [161] = { 138, 199 }, [170] = { 146, 92 }, [173] = { 144, 251 }, [177] = { 148, 160 }, [180] = { 226, 188 }, [184] = { 148, 162 }, [192] = { 144, 223 }, [193] = { 226, 185 }, [196] = { 148, 205 }, [198] = { 226, 189 }, [199] = { 149, 209 }, [201] = { 146, 122 }, [203] = { 226, 184 }, [204] = { 226, 186 },
		[207] = { 226, 187 }, [221] = { 226, 190 }, [224] = { 142, 194 }, [228] = { 147, 196 }, [229] = { 226, 195 }, [230] = { 226, 194 }, [233] = { 226, 191 }, [237] = { 152, 85 }, [243] = { 226, 200 }, [246] = { 226, 204 }, [247] = { 226, 201 },
	},
	[124] = {
		[0] = { 226, 197 }, [7] = { 226, 198 }, [13] = { 226, 203 }, [17] = { 226, 192 }, [18] = { 153, 211 }, [19] = { 226, 199 }, [20] = { 226, 193 }, [23] = { 226, 202 }, [31] = { 226, 208 }, [33] = { 138, 200 }, [35] = { 226, 205 }, [39] = { 226, 206 }, [42] = { 226, 207 }, [43] = { 226, 210 }, [55] = { 226, 209 }, [56] = { 148, 244 }, [61] = { 226, 211 }, [62] = { 151, 250 }, [63] = { 149, 235 }, [64] = { 226, 216 }, [67] = { 226, 213 }, [76] = { 226, 212 }, [77] = { 144, 208 }, [79] = { 226, 215 },
		[80] = { 226, 217 }, [84] = { 226, 214 }, [86] = { 226, 221 }, [88] = { 226, 218 }, [95] = { 226, 219 }, [96] = { 226, 196 }, [100] = { 226, 220 }, [101] = { 226, 222 }, [108] = { 226, 223 }, [115] = { 149, 196 }, [117] = { 226, 224 }, [126] = { 150, 224 }, [129] = { 139, 204 }, [130] = { 140, 72 }, [131] = { 226, 225 }, [137] = { 149, 178 }, [139] = { 144, 136 }, [141] = { 150, 174 }, [144] = { 226, 226 }, [146] = { 151, 177 }, [149] = { 148, 148 }, [151] = { 145, 101 }, [152] = { 148, 83 }, [155] = { 143, 108 }, [159] = { 136, 190 },
		[161] = { 226, 231 }, [162] = { 226, 229 }, [164] = { 226, 227 }, [165] = { 138, 159 }, [167] = { 143, 207 }, [168] = { 226, 232 }, [171] = { 226, 230 }, [173] = { 226, 228 }, [174] = { 226, 236 }, [177] = { 226, 235 }, [178] = { 226, 234 }, [179] = { 226, 233 }, [185] = { 226, 237 }, [189] = { 226, 238 }, [190] = { 144, 184 }, [192] = { 226, 239 }, [194] = { 226, 241 }, [197] = { 226, 240 }, [202] = { 140, 208 }, [206] = { 145, 87 }, [210] = { 226, 243 }, [214] = { 147, 156 }, [216] = { 226, 242 }, [220] = { 226, 244 }, [222] = { 149, 179 },
		[223] = { 145, 140 }, [224] = { 141, 102 }, [226] = { 226, 245 }, [231] = { 151, 198 }, [239] = { 226, 247 }, [242] = { 226, 248 }, [244] = { 226, 249 }, [246] = { 226, 250 }, [248] = { 142, 133 }, [250] = { 226, 251 }, [251] = { 140, 110 }, [254] = { 139, 138 },
	},
	[125] = {
		[0] = { 139, 73 }, [2] = { 227, 64 }, [4] = { 150, 241 }, [5] = { 141, 103 }, [6] = { 226, 252 }, [10] = { 227, 67 }, [11] = { 150, 228 }, [13] = { 148, 91 }, [16] = { 149, 82 }, [20] = { 143, 131 }, [21] = { 227, 66 }, [23] = { 142, 209 }, [24] = { 141, 104 }, [25] = { 142, 134 }, [26] = { 139, 137 }, [27] = { 149, 180 }, [28] = { 227, 65 }, [32] = { 145, 102 }, [33] = { 150, 97 }, [34] = { 141, 245 }, [43] = { 142, 135 }, [44] = { 146, 219 }, [46] = { 227, 70 }, [47] = { 151, 221 },
		[48] = { 141, 215 }, [50] = { 227, 71 }, [51] = { 144, 97 }, [53] = { 227, 73 }, [57] = { 143, 208 }, [58] = { 141, 174 }, [63] = { 227, 72 }, [66] = { 143, 73 }, [67] = { 140, 188 }, [68] = { 145, 103 }, [69] = { 227, 68 }, [70] = { 227, 74 }, [72] = { 251, 138 }, [75] = { 227, 69 }, [76] = { 140, 111 }, [78] = { 227, 77 }, [79] = { 227, 81 }, [80] = { 140, 139 }, [86] = { 227, 76 }, [91] = { 227, 85 }, [92] = { 251, 139 }, [94] = { 141, 105 }, [97] = { 151, 141 }, [98] = { 136, 186 }, [99] = { 227, 82 },
		[102] = { 139, 139 }, [104] = { 227, 79 }, [110] = { 227, 80 }, [113] = { 147, 157 }, [114] = { 227, 78 }, [115] = { 227, 75 }, [117] = { 138, 71 }, [118] = { 144, 226 }, [121] = { 140, 166 }, [125] = { 227, 87 }, [137] = { 227, 84 }, [143] = { 227, 86 }, [147] = { 227, 83 }, [153] = { 140, 112 }, [154] = { 145, 177 }, [155] = { 227, 88 }, [156] = { 145, 142 }, [159] = { 227, 101 }, [160] = { 251, 141 }, [162] = { 227, 97 }, [163] = { 227, 91 }, [171] = { 227, 95 }, [172] = { 142, 248 }, [173] = { 136, 219 }, [174] = { 227, 90 },
		[175] = { 227, 98 }, [176] = { 227, 102 }, [177] = { 141, 106 }, [178] = { 150, 212 }, [180] = { 146, 212 }, [181] = { 227, 92 }, [183] = { 251, 140 }, [184] = { 227, 100 }, [186] = { 227, 89 }, [187] = { 146, 93 }, [189] = { 227, 94 }, [190] = { 136, 187 }, [191] = { 150, 200 }, [199] = { 227, 93 }, [202] = { 139, 217 }, [203] = { 148, 234 }, [207] = { 145, 141 }, [209] = { 151, 206 }, [210] = { 143, 143 }, [213] = { 227, 142 }, [214] = { 251, 142 }, [216] = { 227, 103 }, [218] = { 144, 252 }, [220] = { 227, 99 }, [221] = { 227, 104 },
		[222] = { 227, 106 }, [224] = { 146, 247 }, [225] = { 227, 109 }, [228] = { 227, 105 }, [232] = { 149, 210 }, [233] = { 138, 201 }, [236] = { 150, 201 }, [239] = { 136, 220 }, [242] = { 227, 108 }, [244] = { 151, 251 }, [251] = { 227, 107 },
	},
	[126] = {
		[1] = { 137, 143 }, [4] = { 147, 234 }, [5] = { 227, 110 }, [9] = { 227, 117 }, [10] = { 227, 111 }, [11] = { 227, 118 }, [18] = { 227, 114 }, [27] = { 148, 155 }, [30] = { 142, 200 }, [31] = { 227, 116 }, [33] = { 227, 113 }, [34] = { 227, 119 }, [35] = { 227, 112 }, [38] = { 143, 99 }, [43] = { 150, 68 }, [46] = { 143, 107 }, [49] = { 227, 115 }, [50] = { 227, 128 }, [53] = { 227, 123 }, [55] = { 227, 126 }, [57] = { 227, 124 }, [58] = { 227, 129 }, [59] = { 227, 122 }, [61] = { 227, 96 },
		[62] = { 144, 209 }, [65] = { 148, 201 }, [67] = { 227, 125 }, [70] = { 227, 120 }, [74] = { 145, 64 }, [75] = { 140, 113 }, [77] = { 143, 74 }, [82] = { 251, 143 }, [84] = { 144, 68 }, [85] = { 145, 85 }, [86] = { 227, 132 }, [89] = { 227, 134 }, [90] = { 227, 135 }, [93] = { 227, 131 }, [94] = { 227, 133 }, [102] = { 227, 121 }, [103] = { 227, 130 }, [105] = { 227, 138 }, [106] = { 227, 137 }, [109] = { 150, 154 }, [112] = { 140, 74 }, [121] = { 227, 136 }, [123] = { 227, 140 }, [124] = { 227, 139 }, [125] = { 227, 143 },
		[127] = { 227, 145 }, [130] = { 142, 91 }, [131] = { 227, 141 }, [136] = { 227, 146 }, [137] = { 227, 147 }, [138] = { 250, 92 }, [140] = { 227, 148 }, [142] = { 227, 154 }, [143] = { 147, 90 }, [144] = { 227, 150 }, [146] = { 227, 149 }, [147] = { 227, 151 }, [148] = { 227, 152 }, [150] = { 227, 153 }, [155] = { 227, 155 }, [156] = { 227, 156 },
	},
	[127] = {
		[54] = { 138, 202 }, [56] = { 227, 157 }, [58] = { 227, 158 }, [69] = { 227, 159 }, [71] = { 251, 144 }, [76] = { 227, 160 }, [77] = { 227, 161 }, [78] = { 227, 162 }, [80] = { 227, 163 }, [81] = { 227, 164 }, [84] = { 227, 166 }, [85] = { 227, 165 }, [88] = { 227, 167 }, [95] = { 227, 168 }, [96] = { 227, 169 }, [103] = { 227, 172 }, [104] = { 227, 170 }, [105] = { 227, 171 }, [106] = { 141, 223 }, [107] = { 140, 114 }, [110] = { 146, 117 }, [112] = { 148, 177 }, [114] = { 143, 144 }, [117] = { 148, 108 },
		[119] = { 148, 235 }, [120] = { 227, 173 }, [121] = { 156, 235 }, [130] = { 227, 174 }, [131] = { 227, 176 }, [133] = { 151, 133 }, [134] = { 227, 175 }, [135] = { 227, 178 }, [136] = { 227, 177 }, [138] = { 151, 114 }, [140] = { 227, 179 }, [142] = { 148, 252 }, [148] = { 227, 180 }, [154] = { 227, 183 }, [157] = { 227, 182 }, [158] = { 227, 181 }, [161] = { 251, 145 }, [163] = { 227, 184 }, [164] = { 140, 81 }, [168] = { 145, 65 }, [169] = { 139, 96 }, [174] = { 227, 188 }, [175] = { 227, 185 }, [178] = { 227, 186 }, [182] = { 227, 189 },
		[184] = { 227, 190 }, [185] = { 227, 187 }, [189] = { 137, 72 }, [193] = { 137, 165 }, [197] = { 227, 192 }, [198] = { 227, 193 }, [202] = { 227, 194 }, [204] = { 151, 130 }, [210] = { 143, 75 }, [212] = { 227, 196 }, [213] = { 227, 195 }, [224] = { 144, 137 }, [225] = { 227, 197 }, [230] = { 227, 198 }, [233] = { 227, 199 }, [235] = { 138, 227 }, [240] = { 138, 203 }, [243] = { 227, 200 }, [249] = { 227, 201 }, [251] = { 150, 124 }, [252] = { 151, 131 },
	},
	[128] = {
		[0] = { 151, 115 }, [1] = { 152, 86 }, [3] = { 141, 108 }, [4] = { 227, 204 }, [5] = { 142, 210 }, [6] = { 227, 203 }, [11] = { 227, 205 }, [12] = { 142, 167 }, [16] = { 145, 207 }, [18] = { 227, 206 }, [21] = { 141, 107 }, [23] = { 150, 213 }, [24] = { 227, 207 }, [25] = { 227, 208 }, [28] = { 227, 209 }, [33] = { 227, 210 }, [40] = { 227, 211 }, [51] = { 142, 168 }, [54] = { 150, 235 }, [59] = { 227, 213 }, [61] = { 146, 94 }, [63] = { 227, 212 }, [70] = { 227, 215 }, [74] = { 227, 214 },
		[82] = { 227, 216 }, [86] = { 144, 185 }, [88] = { 227, 217 }, [90] = { 227, 218 }, [94] = { 149, 183 }, [95] = { 227, 219 }, [97] = { 145, 143 }, [98] = { 227, 220 }, [104] = { 227, 221 }, [111] = { 151, 252 }, [112] = { 227, 224 }, [114] = { 227, 223 }, [115] = { 227, 222 }, [116] = { 146, 174 }, [118] = { 227, 225 }, [119] = { 144, 69 }, [121] = { 227, 226 }, [125] = { 227, 227 }, [126] = { 152, 87 }, [127] = { 227, 228 }, [132] = { 227, 229 }, [133] = { 227, 231 }, [134] = { 227, 230 }, [135] = { 148, 163 }, [137] = { 147, 247 },
		[139] = { 152, 93 }, [140] = { 148, 167 }, [147] = { 227, 233 }, [150] = { 143, 209 }, [152] = { 149, 73 }, [154] = { 227, 234 }, [155] = { 227, 232 }, [157] = { 138, 204 }, [161] = { 140, 210 }, [162] = { 142, 136 }, [165] = { 148, 236 }, [169] = { 140, 168 }, [170] = { 150, 98 }, [172] = { 227, 237 }, [173] = { 227, 235 }, [175] = { 141, 109 }, [177] = { 141, 110 }, [178] = { 136, 231 }, [180] = { 141, 230 }, [186] = { 148, 120 }, [195] = { 136, 221 }, [196] = { 227, 242 }, [198] = { 146, 95 }, [204] = { 148, 119 }, [206] = { 145, 217 },
		[214] = { 227, 244 }, [217] = { 227, 240 }, [218] = { 227, 243 }, [219] = { 227, 238 }, [221] = { 227, 241 }, [222] = { 150, 69 }, [225] = { 140, 211 }, [228] = { 136, 251 }, [229] = { 227, 239 }, [239] = { 227, 246 }, [241] = { 227, 247 }, [244] = { 147, 183 }, [248] = { 139, 185 }, [252] = { 228, 69 }, [253] = { 148, 92 },
	},
	[129] = {
		[2] = { 142, 137 }, [5] = { 139, 186 }, [6] = { 144, 198 }, [7] = { 152, 101 }, [8] = { 150, 172 }, [9] = { 227, 245 }, [10] = { 144, 210 }, [26] = { 139, 114 }, [27] = { 227, 248 }, [35] = { 227, 250 }, [41] = { 227, 249 }, [47] = { 227, 251 }, [49] = { 146, 69 }, [51] = { 148, 93 }, [57] = { 146, 175 }, [62] = { 228, 66 }, [70] = { 228, 65 }, [75] = { 227, 252 }, [78] = { 144, 116 }, [80] = { 149, 133 }, [81] = { 228, 68 }, [83] = { 228, 67 }, [84] = { 141, 111 }, [85] = { 152, 114 },
		[95] = { 228, 84 }, [101] = { 228, 72 }, [102] = { 228, 73 }, [107] = { 142, 238 }, [110] = { 228, 71 }, [112] = { 141, 152 }, [113] = { 228, 70 }, [116] = { 228, 74 }, [120] = { 146, 176 }, [121] = { 149, 160 }, [122] = { 145, 66 }, [127] = { 145, 218 }, [128] = { 228, 78 }, [130] = { 228, 79 }, [131] = { 228, 75 }, [136] = { 228, 76 }, [138] = { 228, 77 }, [143] = { 141, 112 }, [147] = { 228, 85 }, [149] = { 228, 81 }, [154] = { 149, 134 }, [156] = { 150, 140 }, [157] = { 149, 71 }, [160] = { 228, 80 }, [163] = { 228, 83 },
		[164] = { 228, 82 }, [168] = { 150, 99 }, [169] = { 228, 86 }, [176] = { 228, 87 }, [179] = { 145, 86 }, [181] = { 228, 88 }, [184] = { 228, 90 }, [186] = { 228, 94 }, [189] = { 228, 91 }, [190] = { 228, 89 }, [191] = { 148, 94 }, [192] = { 228, 92 }, [194] = { 228, 93 }, [198] = { 137, 176 }, [200] = { 228, 100 }, [201] = { 228, 95 }, [205] = { 228, 96 }, [209] = { 228, 97 }, [211] = { 145, 159 }, [216] = { 228, 99 }, [217] = { 228, 98 }, [218] = { 228, 101 }, [223] = { 228, 102 }, [224] = { 228, 103 }, [227] = { 144, 98 },
		[229] = { 137, 231 }, [231] = { 228, 104 }, [232] = { 151, 213 }, [234] = { 142, 169 }, [237] = { 143, 76 }, [243] = { 142, 138 }, [244] = { 146, 118 }, [250] = { 228, 105 }, [251] = { 228, 106 }, [252] = { 137, 80 }, [254] = { 228, 107 },
	},
	[130] = {
		[1] = { 228, 108 }, [2] = { 228, 109 }, [5] = { 228, 110 }, [7] = { 228, 111 }, [8] = { 139, 187 }, [9] = { 157, 168 }, [10] = { 228, 112 }, [12] = { 144, 227 }, [13] = { 228, 113 }, [14] = { 142, 201 }, [16] = { 228, 114 }, [18] = { 152, 174 }, [22] = { 228, 115 }, [23] = { 149, 220 }, [24] = { 138, 218 }, [27] = { 145, 67 }, [28] = { 143, 119 }, [30] = { 149, 145 }, [31] = { 143, 77 }, [41] = { 228, 116 }, [42] = { 141, 113 }, [43] = { 228, 117 }, [44] = { 148, 202 }, [46] = { 228, 132 },
		[51] = { 228, 119 }, [53] = { 145, 199 }, [54] = { 148, 149 }, [55] = { 140, 189 }, [56] = { 228, 118 }, [57] = { 145, 68 }, [64] = { 228, 120 }, [71] = { 146, 248 }, [88] = { 228, 122 }, [89] = { 228, 121 }, [90] = { 228, 124 }, [93] = { 228, 123 }, [95] = { 228, 125 }, [98] = { 228, 128 }, [100] = { 228, 126 }, [102] = { 138, 205 }, [104] = { 228, 129 }, [106] = { 228, 130 }, [107] = { 228, 131 }, [110] = { 141, 175 }, [111] = { 151, 199 }, [113] = { 228, 133 }, [114] = { 144, 70 }, [118] = { 137, 144 }, [119] = { 228, 134 },
		[120] = { 228, 135 }, [126] = { 228, 136 }, [139] = { 136, 240 }, [141] = { 228, 137 }, [146] = { 228, 138 }, [153] = { 149, 135 }, [157] = { 142, 197 }, [159] = { 228, 140 }, [165] = { 138, 72 }, [166] = { 136, 176 }, [171] = { 228, 139 }, [172] = { 228, 142 }, [173] = { 148, 109 }, [175] = { 144, 99 }, [177] = { 137, 212 }, [179] = { 150, 70 }, [184] = { 140, 124 }, [185] = { 139, 218 }, [187] = { 228, 141 }, [189] = { 137, 232 }, [197] = { 138, 161 }, [209] = { 137, 145 }, [210] = { 228, 146 }, [211] = { 151, 232 }, [212] = { 145, 219 },
		[215] = { 149, 99 }, [217] = { 228, 158 }, [219] = { 137, 213 }, [220] = { 228, 156 }, [222] = { 228, 154 }, [223] = { 228, 145 }, [225] = { 228, 143 }, [227] = { 228, 144 }, [229] = { 142, 225 }, [230] = { 139, 234 }, [231] = { 146, 151 }, [235] = { 147, 207 }, [241] = { 137, 112 }, [243] = { 228, 148 }, [244] = { 228, 147 }, [249] = { 228, 153 }, [250] = { 228, 149 }, [251] = { 228, 152 },
	},
	[131] = {
		[1] = { 251, 147 }, [2] = { 150, 206 }, [3] = { 228, 151 }, [4] = { 137, 214 }, [5] = { 138, 157 }, [6] = { 228, 155 }, [9] = { 228, 157 }, [14] = { 140, 115 }, [22] = { 228, 161 }, [23] = { 228, 170 }, [24] = { 228, 171 }, [28] = { 136, 169 }, [35] = { 228, 178 }, [40] = { 136, 239 }, [43] = { 228, 169 }, [47] = { 228, 168 }, [49] = { 228, 163 }, [50] = { 228, 162 }, [52] = { 228, 160 }, [53] = { 228, 159 }, [54] = { 146, 131 }, [56] = { 145, 249 }, [57] = { 228, 165 }, [64] = { 228, 164 },
		[69] = { 228, 167 }, [73] = { 145, 144 }, [74] = { 140, 116 }, [79] = { 137, 96 }, [80] = { 228, 166 }, [82] = { 141, 114 }, [88] = { 145, 145 }, [98] = { 251, 148 }, [115] = { 228, 184 }, [117] = { 228, 185 }, [119] = { 137, 215 }, [123] = { 137, 172 }, [124] = { 228, 182 }, [127] = { 251, 149 }, [133] = { 228, 172 }, [135] = { 228, 180 }, [137] = { 228, 187 }, [138] = { 228, 181 }, [142] = { 228, 179 }, [147] = { 228, 150 }, [150] = { 228, 177 }, [154] = { 228, 173 }, [158] = { 138, 206 }, [159] = { 228, 175 }, [160] = { 228, 186 },
		[162] = { 228, 176 }, [168] = { 228, 188 }, [170] = { 228, 174 }, [171] = { 148, 156 }, [177] = { 151, 137 }, [181] = { 228, 183 }, [189] = { 228, 205 }, [193] = { 228, 197 }, [197] = { 144, 155 }, [199] = { 251, 150 }, [202] = { 139, 101 }, [204] = { 139, 219 }, [206] = { 228, 192 }, [211] = { 137, 217 }, [214] = { 143, 210 }, [216] = { 228, 195 }, [220] = { 141, 216 }, [223] = { 147, 112 }, [224] = { 228, 200 }, [233] = { 149, 236 }, [235] = { 228, 191 }, [239] = { 137, 216 }, [240] = { 140, 212 }, [241] = { 149, 72 }, [242] = { 228, 201 },
		[244] = { 228, 189 }, [246] = { 251, 151 }, [247] = { 228, 198 }, [251] = { 228, 208 }, [253] = { 228, 193 },
	},
	[132] = {
		[3] = { 228, 194 }, [4] = { 147, 184 }, [7] = { 228, 199 }, [11] = { 228, 196 }, [12] = { 150, 71 }, [13] = { 228, 202 }, [14] = { 136, 222 }, [19] = { 228, 190 }, [32] = { 228, 204 }, [34] = { 228, 203 }, [41] = { 148, 139 }, [42] = { 228, 210 }, [44] = { 228, 221 }, [49] = { 138, 158 }, [53] = { 228, 224 }, [56] = { 228, 206 }, [60] = { 228, 211 }, [61] = { 151, 142 }, [70] = { 228, 220 }, [72] = { 251, 152 }, [73] = { 151, 116 }, [78] = { 151, 168 }, [87] = { 146, 152 }, [91] = { 138, 139 },
		[97] = { 149, 146 }, [98] = { 228, 226 }, [99] = { 147, 159 }, [102] = { 136, 175 }, [105] = { 228, 219 }, [107] = { 228, 215 }, [108] = { 145, 146 }, [109] = { 228, 209 }, [110] = { 228, 217 }, [111] = { 228, 222 }, [113] = { 148, 75 }, [117] = { 136, 168 }, [119] = { 228, 214 }, [121] = { 228, 223 }, [122] = { 149, 152 }, [130] = { 228, 218 }, [132] = { 228, 213 }, [139] = { 143, 211 }, [144] = { 143, 78 }, [148] = { 142, 170 }, [153] = { 150, 214 }, [156] = { 149, 102 }, [159] = { 228, 229 }, [161] = { 228, 238 }, [173] = { 228, 216 },
		[178] = { 138, 151 }, [180] = { 251, 153 }, [184] = { 143, 246 }, [185] = { 228, 227 }, [187] = { 228, 232 }, [188] = { 145, 147 }, [191] = { 228, 228 }, [193] = { 228, 235 }, [196] = { 146, 126 }, [198] = { 228, 236 }, [201] = { 151, 117 }, [202] = { 228, 225 }, [203] = { 138, 87 }, [205] = { 228, 231 }, [208] = { 228, 234 }, [209] = { 150, 170 }, [214] = { 228, 237 }, [217] = { 228, 230 }, [218] = { 228, 233 }, [220] = { 250, 96 }, [236] = { 150, 72 }, [238] = { 152, 64 }, [244] = { 228, 241 }, [252] = { 228, 248 }, [255] = { 228, 240 },
	},
	[133] = {
		[0] = { 142, 193 }, [6] = { 228, 207 }, [17] = { 149, 204 }, [19] = { 150, 160 }, [20] = { 228, 247 }, [21] = { 228, 246 }, [23] = { 228, 242 }, [24] = { 228, 243 }, [26] = { 137, 85 }, [31] = { 228, 245 }, [33] = { 228, 239 }, [38] = { 146, 211 }, [44] = { 228, 244 }, [45] = { 136, 252 }, [53] = { 145, 160 }, [61] = { 149, 193 }, [64] = { 228, 249 }, [65] = { 229, 64 }, [67] = { 148, 215 }, [72] = { 228, 252 }, [73] = { 143, 212 }, [74] = { 142, 199 }, [75] = { 229, 66 }, [78] = { 139, 188 },
		[83] = { 251, 154 }, [85] = { 229, 67 }, [87] = { 149, 153 }, [88] = { 228, 251 }, [89] = { 251, 155 }, [90] = { 228, 212 }, [99] = { 228, 250 }, [104] = { 152, 110 }, [105] = { 147, 160 }, [106] = { 149, 147 }, [107] = { 251, 156 }, [109] = { 229, 74 }, [119] = { 229, 80 }, [126] = { 229, 81 }, [128] = { 229, 68 }, [132] = { 148, 150 }, [135] = { 229, 78 }, [136] = { 229, 70 }, [138] = { 229, 72 }, [144] = { 229, 82 }, [145] = { 229, 71 }, [148] = { 229, 75 }, [151] = { 137, 146 }, [153] = { 147, 227 }, [155] = { 229, 76 },
		[156] = { 229, 79 }, [164] = { 229, 69 }, [166] = { 145, 69 }, [168] = { 229, 73 }, [169] = { 142, 70 }, [170] = { 144, 100 }, [171] = { 140, 79 }, [172] = { 150, 242 }, [174] = { 150, 247 }, [175] = { 143, 146 }, [176] = { 251, 158 }, [185] = { 229, 86 }, [186] = { 229, 84 }, [193] = { 152, 109 }, [201] = { 229, 83 }, [205] = { 151, 149 }, [207] = { 229, 85 }, [208] = { 229, 87 }, [213] = { 229, 88 }, [220] = { 229, 91 }, [221] = { 229, 89 }, [228] = { 147, 161 }, [229] = { 229, 90 }, [233] = { 148, 203 }, [234] = { 229, 77 },
		[247] = { 143, 147 }, [249] = { 229, 92 }, [250] = { 229, 97 }, [251] = { 145, 148 }, [254] = { 229, 96 },
	},
	[134] = {
		[2] = { 229, 65 }, [6] = { 229, 98 }, [7] = { 145, 104 }, [10] = { 229, 93 }, [11] = { 229, 95 }, [19] = { 229, 94 }, [22] = { 159, 80 }, [23] = { 159, 65 }, [26] = { 229, 100 }, [34] = { 229, 99 }, [45] = { 151, 150 }, [47] = { 225, 186 }, [48] = { 229, 101 }, [63] = { 229, 102 }, [77] = { 229, 103 }, [78] = { 140, 213 }, [80] = { 139, 115 }, [84] = { 229, 105 }, [85] = { 153, 124 }, [90] = { 139, 149 }, [92] = { 151, 184 }, [94] = { 139, 241 }, [95] = { 229, 106 }, [103] = { 229, 107 },
		[107] = { 146, 142 }, [113] = { 229, 108 }, [121] = { 147, 248 }, [123] = { 136, 184 }, [138] = { 137, 225 }, [139] = { 229, 113 }, [140] = { 229, 114 }, [147] = { 229, 109 }, [149] = { 142, 92 }, [163] = { 229, 110 }, [164] = { 148, 97 }, [169] = { 229, 111 }, [170] = { 229, 112 }, [171] = { 229, 122 }, [175] = { 229, 116 }, [176] = { 229, 119 }, [182] = { 229, 115 }, [196] = { 229, 117 }, [198] = { 229, 118 }, [199] = { 142, 214 }, [201] = { 229, 120 }, [203] = { 146, 96 }, [205] = { 140, 117 }, [206] = { 138, 97 }, [212] = { 229, 123 },
		[217] = { 138, 94 }, [219] = { 229, 129 }, [222] = { 229, 124 }, [223] = { 229, 128 }, [228] = { 148, 184 }, [233] = { 229, 125 }, [236] = { 229, 126 }, [237] = { 149, 103 }, [238] = { 148, 216 }, [239] = { 229, 130 }, [248] = { 145, 251 }, [249] = { 229, 140 }, [251] = { 229, 136 }, [254] = { 137, 233 },
	},
	[135] = {
		[0] = { 229, 134 }, [2] = { 150, 73 }, [3] = { 229, 135 }, [6] = { 229, 132 }, [8] = { 229, 133 }, [9] = { 229, 138 }, [10] = { 229, 141 }, [13] = { 229, 139 }, [17] = { 229, 137 }, [18] = { 229, 131 }, [24] = { 146, 119 }, [26] = { 229, 148 }, [28] = { 150, 168 }, [37] = { 229, 146 }, [41] = { 229, 147 }, [52] = { 229, 142 }, [55] = { 229, 144 }, [59] = { 229, 145 }, [63] = { 229, 143 }, [73] = { 144, 228 }, [75] = { 152, 88 }, [76] = { 229, 152 }, [78] = { 229, 153 }, [83] = { 229, 159 },
		[85] = { 144, 73 }, [87] = { 229, 155 }, [89] = { 229, 158 }, [95] = { 229, 150 }, [96] = { 229, 149 }, [99] = { 229, 160 }, [102] = { 137, 218 }, [104] = { 229, 156 }, [106] = { 229, 161 }, [110] = { 229, 157 }, [116] = { 229, 154 }, [118] = { 146, 177 }, [120] = { 229, 151 }, [127] = { 148, 136 }, [130] = { 229, 165 }, [141] = { 151, 90 }, [159] = { 229, 164 }, [162] = { 229, 163 }, [171] = { 229, 172 }, [175] = { 229, 166 }, [179] = { 229, 174 }, [186] = { 151, 134 }, [187] = { 229, 177 }, [189] = { 229, 168 }, [192] = { 229, 169 },
		[196] = { 229, 173 }, [198] = { 229, 176 }, [199] = { 229, 175 }, [203] = { 229, 167 }, [208] = { 229, 170 }, [210] = { 229, 187 }, [224] = { 229, 180 }, [239] = { 229, 178 }, [242] = { 229, 179 }, [246] = { 229, 184 }, [247] = { 229, 185 }, [249] = { 138, 73 }, [251] = { 139, 97 }, [254] = { 229, 183 },
	},
	[136] = {
		[5] = { 229, 162 }, [7] = { 251, 161 }, [13] = { 229, 182 }, [14] = { 229, 186 }, [15] = { 229, 181 }, [17] = { 229, 188 }, [21] = { 229, 190 }, [22] = { 229, 189 }, [33] = { 229, 192 }, [34] = { 229, 191 }, [35] = { 229, 121 }, [39] = { 229, 196 }, [49] = { 229, 193 }, [54] = { 229, 194 }, [57] = { 229, 195 }, [59] = { 229, 197 }, [64] = { 140, 140 }, [66] = { 229, 199 }, [68] = { 229, 198 }, [70] = { 143, 79 }, [76] = { 141, 115 }, [77] = { 159, 165 }, [82] = { 229, 200 }, [83] = { 143, 112 },
		[87] = { 138, 88 }, [89] = { 229, 201 }, [91] = { 137, 113 }, [93] = { 143, 213 }, [94] = { 229, 202 }, [97] = { 141, 116 }, [98] = { 229, 203 }, [99] = { 136, 223 }, [104] = { 149, 92 }, [107] = { 229, 204 }, [112] = { 144, 138 }, [114] = { 229, 211 }, [117] = { 229, 208 }, [119] = { 146, 143 }, [125] = { 229, 209 }, [126] = { 229, 206 }, [127] = { 139, 220 }, [129] = { 229, 205 }, [130] = { 229, 212 }, [136] = { 140, 85 }, [139] = { 145, 220 }, [141] = { 229, 218 }, [146] = { 229, 214 }, [150] = { 145, 179 }, [151] = { 229, 213 },
		[153] = { 229, 216 }, [158] = { 229, 207 }, [162] = { 229, 217 }, [164] = { 229, 219 }, [171] = { 148, 237 }, [174] = { 229, 215 }, [176] = { 229, 220 }, [177] = { 229, 222 }, [180] = { 140, 209 }, [181] = { 229, 210 }, [183] = { 136, 191 }, [191] = { 229, 221 }, [193] = { 141, 217 }, [194] = { 151, 244 }, [195] = { 229, 223 }, [196] = { 229, 224 }, [197] = { 145, 149 }, [207] = { 151, 160 }, [212] = { 229, 225 }, [213] = { 151, 84 }, [216] = { 229, 226 }, [217] = { 229, 227 }, [220] = { 149, 226 }, [221] = { 229, 228 }, [223] = { 141, 190 },
		[225] = { 151, 161 }, [232] = { 229, 233 }, [242] = { 229, 234 }, [243] = { 143, 214 }, [244] = { 229, 232 }, [245] = { 251, 162 }, [248] = { 151, 135 }, [249] = { 229, 229 }, [252] = { 229, 231 }, [253] = { 144, 187 }, [254] = { 144, 158 },
	},
	[137] = {
		[2] = { 229, 230 }, [4] = { 229, 235 }, [7] = { 149, 161 }, [10] = { 229, 237 }, [12] = { 229, 236 }, [16] = { 138, 140 }, [18] = { 150, 74 }, [19] = { 229, 238 }, [28] = { 250, 93 }, [29] = { 229, 250 }, [30] = { 229, 240 }, [37] = { 229, 241 }, [42] = { 229, 242 }, [43] = { 229, 243 }, [54] = { 229, 247 }, [56] = { 229, 248 }, [59] = { 229, 246 }, [65] = { 229, 244 }, [67] = { 229, 239 }, [68] = { 229, 245 }, [76] = { 229, 249 }, [77] = { 232, 181 }, [86] = { 137, 166 }, [94] = { 229, 252 },
		[95] = { 139, 221 }, [96] = { 229, 251 }, [100] = { 230, 65 }, [102] = { 230, 64 }, [106] = { 230, 67 }, [109] = { 230, 66 }, [111] = { 230, 68 }, [114] = { 143, 80 }, [116] = { 230, 69 }, [119] = { 230, 70 }, [126] = { 230, 71 }, [127] = { 144, 188 }, [129] = { 151, 118 }, [131] = { 230, 72 }, [134] = { 149, 162 }, [135] = { 148, 101 }, [136] = { 230, 73 }, [138] = { 230, 74 }, [139] = { 140, 169 }, [143] = { 139, 75 }, [147] = { 230, 75 }, [150] = { 142, 139 }, [151] = { 148, 96 }, [152] = { 230, 76 }, [154] = { 138, 111 },
		[161] = { 230, 77 }, [166] = { 230, 79 }, [167] = { 151, 151 }, [169] = { 230, 78 }, [170] = { 144, 101 }, [172] = { 230, 80 }, [175] = { 230, 81 }, [178] = { 230, 82 }, [179] = { 138, 207 }, [186] = { 230, 83 }, [189] = { 230, 84 }, [191] = { 230, 85 }, [192] = { 230, 86 }, [210] = { 138, 112 }, [218] = { 230, 87 }, [220] = { 230, 88 }, [221] = { 230, 89 }, [227] = { 137, 240 }, [230] = { 144, 71 }, [231] = { 230, 90 }, [244] = { 230, 91 }, [248] = { 230, 92 },
	},
	[138] = {
		[0] = { 140, 190 }, [2] = { 146, 249 }, [3] = { 230, 93 }, [8] = { 140, 118 }, [10] = { 144, 117 }, [12] = { 230, 96 }, [14] = { 147, 162 }, [16] = { 230, 95 }, [18] = { 251, 163 }, [19] = { 140, 80 }, [22] = { 230, 94 }, [23] = { 145, 245 }, [24] = { 139, 76 }, [27] = { 230, 97 }, [29] = { 230, 98 }, [31] = { 143, 215 }, [35] = { 140, 141 }, [37] = { 230, 99 }, [42] = { 150, 75 }, [45] = { 144, 221 }, [49] = { 139, 150 }, [51] = { 150, 243 }, [52] = { 145, 105 }, [54] = { 230, 100 },
		[55] = { 251, 164 }, [58] = { 144, 102 }, [59] = { 146, 144 }, [60] = { 143, 216 }, [65] = { 230, 101 }, [70] = { 230, 104 }, [72] = { 230, 105 }, [80] = { 141, 188 }, [81] = { 145, 192 }, [82] = { 230, 103 }, [84] = { 143, 217 }, [85] = { 149, 93 }, [91] = { 230, 102 }, [94] = { 142, 140 }, [96] = { 137, 114 }, [98] = { 230, 109 }, [99] = { 140, 119 }, [102] = { 142, 142 }, [105] = { 142, 141 }, [107] = { 152, 108 }, [108] = { 230, 108 }, [109] = { 230, 107 }, [110] = { 145, 70 }, [112] = { 139, 108 }, [113] = { 152, 98 },
		[114] = { 138, 89 }, [115] = { 143, 218 }, [121] = { 251, 165 }, [124] = { 230, 106 }, [130] = { 230, 111 }, [132] = { 230, 112 }, [133] = { 230, 110 }, [135] = { 140, 214 }, [137] = { 151, 95 }, [140] = { 142, 143 }, [141] = { 148, 70 }, [145] = { 230, 115 }, [147] = { 144, 190 }, [149] = { 146, 97 }, [152] = { 151, 85 }, [154] = { 230, 118 }, [158] = { 140, 234 }, [160] = { 144, 189 }, [161] = { 230, 114 }, [163] = { 230, 119 }, [164] = { 140, 235 }, [165] = { 230, 116 }, [166] = { 230, 117 }, [167] = { 251, 166 }, [168] = { 230, 113 },
		[172] = { 144, 224 }, [173] = { 147, 199 }, [176] = { 146, 78 }, [178] = { 137, 219 }, [185] = { 148, 238 }, [188] = { 139, 98 }, [190] = { 251, 167 }, [191] = { 146, 178 }, [194] = { 230, 122 }, [196] = { 230, 120 }, [199] = { 146, 107 }, [203] = { 144, 191 }, [204] = { 138, 208 }, [205] = { 230, 121 }, [207] = { 144, 122 }, [210] = { 151, 200 }, [214] = { 152, 95 }, [218] = { 230, 123 }, [219] = { 230, 135 }, [220] = { 146, 179 }, [222] = { 230, 134 }, [223] = { 251, 168 }, [224] = { 230, 131 }, [225] = { 230, 139 }, [226] = { 230, 132 },
		[228] = { 230, 128 }, [230] = { 146, 250 }, [231] = { 230, 126 }, [235] = { 230, 124 }, [237] = { 151, 64 }, [238] = { 142, 144 }, [241] = { 230, 129 }, [243] = { 230, 125 }, [246] = { 251, 170 }, [247] = { 230, 133 }, [248] = { 143, 148 }, [250] = { 140, 191 }, [254] = { 145, 248 },
	},
	[139] = {
		[0] = { 150, 100 }, [1] = { 137, 121 }, [2] = { 136, 224 }, [4] = { 147, 163 }, [7] = { 230, 137 }, [12] = { 230, 136 }, [14] = { 147, 228 }, [16] = { 230, 141 }, [20] = { 230, 130 }, [22] = { 230, 140 }, [23] = { 230, 142 }, [25] = { 140, 170 }, [26] = { 230, 138 }, [27] = { 141, 117 }, [29] = { 142, 211 }, [32] = { 230, 143 }, [33] = { 151, 119 }, [38] = { 230, 146 }, [40] = { 230, 149 }, [43] = { 230, 147 }, [44] = { 149, 84 }, [51] = { 230, 144 }, [57] = { 139, 222 }, [62] = { 230, 148 },
		[65] = { 230, 150 }, [73] = { 230, 154 }, [76] = { 230, 151 }, [78] = { 230, 153 }, [79] = { 230, 152 }, [83] = { 251, 171 }, [86] = { 230, 155 }, [88] = { 142, 175 }, [90] = { 230, 157 }, [91] = { 230, 156 }, [92] = { 149, 136 }, [95] = { 230, 159 }, [102] = { 140, 120 }, [107] = { 230, 158 }, [108] = { 230, 160 }, [111] = { 230, 161 }, [112] = { 139, 99 }, [113] = { 227, 191 }, [114] = { 143, 247 }, [116] = { 230, 162 }, [119] = { 140, 236 }, [125] = { 230, 163 }, [127] = { 251, 172 }, [128] = { 230, 164 }, [131] = { 142, 93 },
		[138] = { 157, 204 }, [140] = { 230, 165 }, [142] = { 230, 166 }, [144] = { 143, 81 }, [146] = { 230, 167 }, [147] = { 230, 168 }, [150] = { 230, 169 }, [153] = { 230, 170 }, [154] = { 230, 171 },
	},
	[140] = {
		[55] = { 146, 74 }, [58] = { 230, 172 }, [63] = { 230, 174 }, [65] = { 230, 173 }, [70] = { 147, 164 }, [72] = { 230, 175 }, [74] = { 150, 76 }, [76] = { 230, 176 }, [78] = { 230, 177 }, [80] = { 230, 178 }, [85] = { 230, 179 }, [90] = { 147, 216 }, [97] = { 143, 219 }, [98] = { 230, 180 }, [106] = { 141, 139 }, [107] = { 152, 172 }, [108] = { 230, 181 }, [120] = { 230, 182 }, [121] = { 149, 94 }, [122] = { 230, 183 }, [124] = { 230, 191 }, [130] = { 230, 184 }, [133] = { 230, 186 }, [137] = { 230, 185 },
		[138] = { 230, 187 }, [140] = { 150, 101 }, [141] = { 230, 188 }, [142] = { 230, 189 }, [148] = { 230, 190 }, [152] = { 230, 192 }, [157] = { 138, 76 }, [158] = { 146, 229 }, [160] = { 149, 137 }, [161] = { 141, 224 }, [162] = { 141, 118 }, [167] = { 149, 110 }, [168] = { 137, 221 }, [169] = { 148, 204 }, [170] = { 230, 195 }, [171] = { 138, 209 }, [172] = { 144, 211 }, [173] = { 230, 194 }, [174] = { 230, 199 }, [175] = { 146, 153 }, [176] = { 150, 225 }, [178] = { 230, 197 }, [179] = { 230, 198 }, [180] = { 139, 77 }, [182] = { 230, 200 },
		[183] = { 148, 131 }, [184] = { 145, 221 }, [187] = { 148, 239 }, [188] = { 147, 92 }, [189] = { 230, 196 }, [191] = { 150, 102 }, [192] = { 137, 234 }, [193] = { 230, 202 }, [194] = { 152, 71 }, [195] = { 146, 192 }, [196] = { 152, 100 }, [199] = { 142, 145 }, [200] = { 230, 201 }, [202] = { 145, 175 }, [205] = { 230, 218 }, [206] = { 145, 71 }, [209] = { 147, 246 }, [211] = { 149, 111 }, [218] = { 230, 205 }, [219] = { 142, 94 }, [220] = { 142, 146 }, [222] = { 143, 220 }, [224] = { 148, 133 }, [226] = { 140, 171 }, [227] = { 230, 204 },
		[228] = { 230, 203 }, [230] = { 149, 138 }, [234] = { 142, 191 }, [237] = { 147, 113 }, [240] = { 251, 173 }, [244] = { 251, 174 }, [250] = { 230, 207 }, [251] = { 230, 208 }, [252] = { 141, 119 }, [253] = { 230, 206 },
	},
	[141] = {
		[4] = { 230, 209 }, [5] = { 230, 210 }, [7] = { 230, 212 }, [8] = { 145, 161 }, [10] = { 230, 211 }, [11] = { 138, 228 }, [13] = { 230, 214 }, [15] = { 230, 213 }, [16] = { 230, 215 }, [18] = { 251, 175 }, [19] = { 230, 217 }, [20] = { 230, 219 }, [22] = { 230, 220 }, [100] = { 144, 212 }, [102] = { 142, 205 }, [103] = { 230, 221 }, [107] = { 138, 113 }, [109] = { 230, 222 }, [112] = { 145, 150 }, [113] = { 230, 223 }, [115] = { 230, 224 }, [116] = { 149, 139 }, [118] = { 251, 176 }, [119] = { 139, 78 },
		[129] = { 230, 225 }, [133] = { 146, 180 }, [138] = { 137, 122 }, [153] = { 230, 226 }, [163] = { 142, 239 }, [168] = { 144, 150 }, [179] = { 145, 171 }, [186] = { 230, 229 }, [190] = { 230, 228 }, [194] = { 230, 227 }, [203] = { 230, 235 }, [204] = { 230, 233 }, [207] = { 230, 230 }, [214] = { 230, 232 }, [218] = { 230, 231 }, [219] = { 230, 234 }, [221] = { 139, 151 }, [223] = { 230, 238 }, [225] = { 144, 213 }, [227] = { 230, 239 }, [232] = { 140, 215 }, [234] = { 230, 236 }, [235] = { 230, 237 }, [239] = { 152, 72 }, [243] = { 146, 181 },
		[245] = { 145, 72 }, [252] = { 230, 240 }, [255] = { 230, 243 },
	},
	[142] = {
		[8] = { 230, 241 }, [9] = { 230, 242 }, [10] = { 151, 120 }, [15] = { 147, 165 }, [16] = { 230, 246 }, [29] = { 230, 244 }, [30] = { 230, 245 }, [31] = { 230, 247 }, [42] = { 231, 72 }, [48] = { 230, 250 }, [52] = { 230, 251 }, [53] = { 230, 249 }, [66] = { 230, 248 }, [68] = { 146, 251 }, [71] = { 231, 64 }, [72] = { 231, 68 }, [73] = { 231, 65 }, [74] = { 230, 252 }, [76] = { 231, 66 }, [80] = { 231, 67 }, [85] = { 231, 74 }, [89] = { 231, 69 }, [95] = { 144, 214 }, [96] = { 231, 71 },
		[99] = { 231, 73 }, [100] = { 231, 70 }, [114] = { 231, 76 }, [116] = { 143, 82 }, [118] = { 231, 75 }, [124] = { 231, 77 }, [129] = { 231, 78 }, [132] = { 231, 81 }, [133] = { 231, 80 }, [135] = { 231, 79 }, [138] = { 231, 83 }, [139] = { 231, 82 }, [141] = { 150, 244 }, [145] = { 231, 85 }, [147] = { 231, 84 }, [148] = { 231, 86 }, [153] = { 231, 87 }, [161] = { 231, 89 }, [170] = { 231, 88 }, [171] = { 144, 103 }, [172] = { 231, 90 }, [175] = { 139, 235 }, [176] = { 231, 91 }, [177] = { 231, 93 }, [190] = { 231, 94 },
		[197] = { 231, 95 }, [198] = { 231, 92 }, [200] = { 231, 96 }, [202] = { 142, 212 }, [203] = { 231, 97 }, [204] = { 139, 79 }, [205] = { 140, 82 }, [207] = { 251, 178 }, [210] = { 140, 172 }, [219] = { 231, 98 }, [223] = { 147, 238 }, [226] = { 147, 93 }, [227] = { 231, 99 }, [235] = { 231, 102 }, [248] = { 142, 178 }, [251] = { 231, 101 }, [252] = { 231, 100 }, [253] = { 140, 121 }, [254] = { 231, 103 },
	},
	[143] = {
		[3] = { 138, 114 }, [5] = { 231, 105 }, [9] = { 141, 218 }, [10] = { 231, 104 }, [12] = { 231, 113 }, [18] = { 231, 107 }, [19] = { 231, 109 }, [20] = { 149, 227 }, [21] = { 231, 106 }, [25] = { 231, 108 }, [27] = { 231, 112 }, [28] = { 231, 110 }, [29] = { 139, 80 }, [31] = { 231, 111 }, [38] = { 231, 114 }, [41] = { 148, 121 }, [42] = { 151, 214 }, [47] = { 143, 83 }, [51] = { 231, 115 }, [56] = { 151, 65 }, [57] = { 231, 117 }, [59] = { 231, 116 }, [62] = { 231, 120 }, [63] = { 151, 96 },
		[66] = { 231, 119 }, [68] = { 138, 141 }, [69] = { 231, 118 }, [70] = { 231, 123 }, [73] = { 231, 122 }, [76] = { 231, 121 }, [77] = { 147, 81 }, [78] = { 231, 124 }, [87] = { 231, 125 }, [92] = { 231, 126 }, [95] = { 141, 140 }, [97] = { 140, 68 }, [98] = { 231, 128 }, [99] = { 231, 129 }, [100] = { 231, 130 }, [155] = { 144, 104 }, [156] = { 231, 131 }, [158] = { 142, 171 }, [159] = { 231, 132 }, [163] = { 231, 133 }, [167] = { 153, 159 }, [168] = { 153, 158 }, [173] = { 231, 134 }, [174] = { 227, 144 }, [175] = { 231, 135 },
		[176] = { 146, 67 }, [177] = { 144, 74 }, [178] = { 148, 95 }, [183] = { 231, 136 }, [186] = { 149, 211 }, [187] = { 146, 210 }, [188] = { 141, 158 }, [191] = { 146, 72 }, [194] = { 137, 73 }, [196] = { 150, 152 }, [197] = { 144, 118 }, [206] = { 140, 125 }, [209] = { 139, 223 }, [212] = { 149, 212 }, [218] = { 231, 137 }, [226] = { 231, 139 }, [229] = { 231, 138 }, [230] = { 137, 222 }, [233] = { 147, 244 }, [234] = { 231, 140 }, [235] = { 148, 151 }, [237] = { 147, 82 }, [239] = { 231, 141 }, [240] = { 143, 113 }, [244] = { 231, 143 },
		[247] = { 150, 192 }, [248] = { 231, 158 }, [249] = { 231, 145 }, [250] = { 231, 146 }, [253] = { 146, 199 },
	},
	[144] = {
		[0] = { 145, 222 }, [1] = { 145, 151 }, [3] = { 147, 166 }, [5] = { 231, 144 }, [6] = { 139, 116 }, [11] = { 231, 153 }, [13] = { 231, 150 }, [14] = { 231, 163 }, [15] = { 147, 167 }, [16] = { 146, 128 }, [17] = { 231, 147 }, [19] = { 146, 252 }, [20] = { 147, 114 }, [21] = { 231, 148 }, [22] = { 231, 152 }, [23] = { 144, 128 }, [25] = { 148, 135 }, [26] = { 146, 202 }, [29] = { 144, 192 }, [30] = { 231, 151 }, [31] = { 145, 172 }, [32] = { 145, 162 }, [33] = { 231, 149 }, [34] = { 136, 167 },
		[35] = { 152, 65 }, [39] = { 231, 154 }, [46] = { 145, 223 }, [49] = { 143, 84 }, [50] = { 144, 105 }, [53] = { 231, 156 }, [54] = { 231, 155 }, [56] = { 136, 237 }, [57] = { 231, 157 }, [60] = { 149, 78 }, [62] = { 231, 165 }, [65] = { 147, 217 }, [66] = { 144, 139 }, [69] = { 146, 120 }, [71] = { 139, 246 }, [73] = { 231, 164 }, [74] = { 151, 86 }, [75] = { 137, 94 }, [77] = { 149, 213 }, [78] = { 137, 223 }, [79] = { 231, 159 }, [80] = { 231, 160 }, [81] = { 231, 161 }, [82] = { 231, 162 }, [83] = { 147, 185 },
		[84] = { 146, 66 }, [85] = { 136, 225 }, [86] = { 231, 166 }, [88] = { 231, 167 }, [89] = { 234, 161 }, [92] = { 145, 187 }, [94] = { 231, 168 }, [96] = { 137, 147 }, [97] = { 145, 107 }, [99] = { 140, 173 }, [101] = { 151, 121 }, [103] = { 251, 181 }, [104] = { 231, 169 }, [105] = { 147, 75 }, [109] = { 145, 152 }, [110] = { 142, 213 }, [111] = { 231, 170 }, [114] = { 231, 173 }, [117] = { 143, 133 }, [118] = { 231, 171 }, [119] = { 145, 74 }, [120] = { 145, 73 }, [122] = { 136, 226 }, [124] = { 151, 201 }, [125] = { 231, 175 },
		[127] = { 148, 240 }, [128] = { 231, 177 }, [129] = { 231, 176 }, [130] = { 231, 174 }, [131] = { 226, 132 }, [132] = { 138, 210 }, [135] = { 231, 142 }, [137] = { 231, 179 }, [138] = { 231, 178 }, [143] = { 231, 180 }, [145] = { 151, 87 }, [163] = { 147, 223 }, [166] = { 150, 77 }, [168] = { 231, 181 }, [170] = { 142, 215 }, [175] = { 231, 182 }, [177] = { 231, 183 }, [181] = { 231, 184 }, [184] = { 147, 64 }, [193] = { 136, 232 }, [202] = { 141, 120 }, [206] = { 152, 89 }, [219] = { 231, 188 }, [222] = { 251, 182 }, [225] = { 140, 83 },
		[226] = { 231, 185 }, [228] = { 231, 186 }, [232] = { 149, 148 }, [237] = { 138, 115 }, [245] = { 151, 88 }, [247] = { 139, 189 }, [253] = { 147, 115 },
	},
	[145] = {
		[2] = { 231, 189 }, [18] = { 231, 190 }, [21] = { 251, 184 }, [25] = { 231, 191 }, [39] = { 251, 185 }, [45] = { 147, 65 }, [48] = { 231, 193 }, [50] = { 231, 192 }, [73] = { 147, 209 }, [74] = { 231, 194 }, [75] = { 143, 85 }, [76] = { 142, 222 }, [77] = { 148, 122 }, [78] = { 146, 145 }, [82] = { 142, 240 }, [84] = { 144, 140 }, [86] = { 231, 195 }, [88] = { 231, 196 }, [98] = { 144, 124 }, [99] = { 231, 197 }, [101] = { 231, 198 }, [105] = { 231, 199 }, [106] = { 151, 143 }, [108] = { 143, 86 },
		[114] = { 231, 201 }, [115] = { 231, 200 }, [117] = { 141, 121 }, [119] = { 141, 147 }, [120] = { 142, 95 }, [130] = { 231, 204 }, [135] = { 143, 134 }, [137] = { 231, 203 }, [139] = { 231, 202 }, [141] = { 145, 231 }, [144] = { 140, 237 }, [146] = { 144, 193 }, [151] = { 148, 174 }, [156] = { 143, 88 }, [162] = { 231, 205 }, [164] = { 143, 221 }, [170] = { 231, 208 }, [171] = { 231, 206 }, [175] = { 231, 207 }, [180] = { 231, 210 }, [181] = { 231, 209 }, [184] = { 143, 248 }, [186] = { 231, 211 }, [192] = { 231, 212 }, [193] = { 231, 213 },
		[198] = { 148, 206 }, [199] = { 141, 209 }, [200] = { 142, 223 }, [201] = { 231, 214 }, [203] = { 231, 215 }, [204] = { 151, 162 }, [205] = { 143, 100 }, [206] = { 150, 236 }, [207] = { 151, 202 }, [208] = { 231, 216 }, [209] = { 139, 224 }, [214] = { 231, 217 }, [215] = { 251, 187 }, [216] = { 147, 66 }, [218] = { 251, 186 }, [219] = { 231, 220 }, [220] = { 138, 152 }, [221] = { 144, 106 }, [222] = { 251, 188 }, [223] = { 231, 218 }, [225] = { 231, 219 }, [227] = { 146, 222 }, [228] = { 251, 191 }, [229] = { 251, 192 }, [230] = { 150, 116 },
		[231] = { 139, 250 }, [237] = { 251, 189 }, [238] = { 251, 190 }, [245] = { 231, 222 }, [246] = { 231, 223 }, [252] = { 231, 221 }, [255] = { 231, 225 },
	},
	[146] = {
		[6] = { 251, 193 }, [10] = { 251, 195 }, [13] = { 147, 221 }, [14] = { 138, 98 }, [16] = { 251, 194 }, [17] = { 231, 229 }, [20] = { 231, 226 }, [21] = { 231, 228 }, [30] = { 231, 224 }, [41] = { 232, 110 }, [44] = { 231, 227 }, [52] = { 151, 233 }, [55] = { 140, 216 }, [57] = { 251, 202 }, [58] = { 251, 196 }, [60] = { 251, 198 }, [63] = { 231, 237 }, [64] = { 251, 197 }, [68] = { 147, 83 }, [69] = { 231, 232 }, [72] = { 231, 235 }, [73] = { 231, 233 }, [75] = { 231, 238 }, [78] = { 251, 199 },
		[80] = { 231, 239 }, [81] = { 251, 201 }, [87] = { 231, 231 }, [89] = { 251, 200 }, [90] = { 231, 244 }, [91] = { 137, 148 }, [94] = { 231, 230 }, [98] = { 148, 171 }, [100] = { 231, 234 }, [102] = { 143, 222 }, [103] = { 251, 203 }, [113] = { 141, 122 }, [119] = { 251, 205 }, [120] = { 251, 206 }, [126] = { 150, 103 }, [128] = { 139, 226 }, [131] = { 143, 101 }, [133] = { 147, 186 }, [136] = { 250, 95 }, [145] = { 145, 76 }, [147] = { 231, 242 }, [149] = { 231, 236 }, [150] = { 231, 241 }, [152] = { 150, 193 }, [154] = { 146, 182 },
		[155] = { 231, 243 }, [156] = { 231, 240 }, [167] = { 251, 204 }, [173] = { 145, 75 }, [183] = { 231, 247 }, [185] = { 231, 246 }, [207] = { 231, 245 }, [208] = { 251, 210 }, [210] = { 150, 78 }, [211] = { 251, 214 }, [213] = { 251, 212 }, [215] = { 251, 208 }, [217] = { 251, 209 }, [224] = { 251, 213 }, [228] = { 143, 155 }, [231] = { 251, 207 }, [233] = { 231, 248 }, [234] = { 149, 221 }, [237] = { 137, 115 }, [242] = { 149, 101 }, [243] = { 146, 146 }, [248] = { 139, 152 }, [249] = { 250, 101 }, [250] = { 231, 250 }, [251] = { 251, 217 },
		[252] = { 141, 124 }, [255] = { 251, 220 },
	},
	[147] = {
		[2] = { 251, 222 }, [6] = { 142, 75 }, [15] = { 231, 249 }, [16] = { 144, 141 }, [24] = { 144, 142 }, [25] = { 232, 64 }, [26] = { 232, 66 }, [29] = { 251, 221 }, [30] = { 251, 219 }, [32] = { 143, 249 }, [33] = { 251, 216 }, [34] = { 232, 65 }, [35] = { 232, 67 }, [37] = { 251, 215 }, [38] = { 139, 209 }, [40] = { 149, 100 }, [43] = { 142, 224 }, [44] = { 152, 66 }, [46] = { 231, 252 }, [47] = { 141, 246 }, [50] = { 152, 94 }, [53] = { 232, 69 }, [58] = { 232, 68 }, [59] = { 232, 70 },
		[68] = { 231, 251 }, [72] = { 250, 94 }, [75] = { 147, 231 }, [77] = { 147, 116 }, [84] = { 146, 213 }, [86] = { 232, 75 }, [87] = { 251, 224 }, [91] = { 146, 98 }, [92] = { 232, 71 }, [96] = { 232, 72 }, [108] = { 140, 76 }, [110] = { 232, 74 }, [112] = { 251, 223 }, [117] = { 140, 174 }, [124] = { 232, 73 }, [126] = { 143, 223 }, [140] = { 138, 153 }, [148] = { 232, 79 }, [150] = { 141, 189 }, [151] = { 145, 153 }, [154] = { 146, 200 }, [164] = { 251, 225 }, [167] = { 138, 90 }, [172] = { 232, 77 }, [173] = { 232, 78 },
		[174] = { 146, 193 }, [176] = { 232, 76 }, [185] = { 232, 80 }, [195] = { 232, 86 }, [198] = { 251, 226 }, [200] = { 232, 89 }, [208] = { 232, 88 }, [209] = { 147, 76 }, [214] = { 232, 81 }, [215] = { 232, 82 }, [216] = { 232, 85 }, [221] = { 232, 87 }, [222] = { 251, 227 }, [225] = { 139, 190 }, [228] = { 232, 90 }, [229] = { 232, 84 }, [232] = { 232, 83 }, [248] = { 251, 228 },
	},
	[148] = {
		[3] = { 232, 94 }, [7] = { 232, 95 }, [16] = { 232, 96 }, [19] = { 232, 93 }, [20] = { 232, 92 }, [24] = { 143, 224 }, [25] = { 147, 168 }, [26] = { 232, 91 }, [33] = { 232, 100 }, [43] = { 232, 98 }, [49] = { 251, 229 }, [53] = { 232, 99 }, [54] = { 232, 97 }, [56] = { 145, 246 }, [58] = { 232, 101 }, [65] = { 232, 102 }, [68] = { 232, 104 }, [69] = { 251, 230 }, [72] = { 251, 231 }, [81] = { 138, 211 }, [82] = { 232, 103 }, [83] = { 150, 248 }, [90] = { 232, 115 }, [91] = { 232, 105 },
		[94] = { 232, 108 }, [96] = { 232, 106 }, [98] = { 232, 107 }, [106] = { 232, 109 }, [112] = { 232, 111 }, [117] = { 232, 112 }, [119] = { 232, 113 }, [124] = { 232, 116 }, [125] = { 232, 114 }, [126] = { 232, 117 }, [127] = { 232, 119 }, [129] = { 232, 118 },
	},
	[149] = {
		[119] = { 146, 183 }, [128] = { 150, 229 }, [130] = { 232, 120 }, [131] = { 145, 77 }, [135] = { 232, 121 }, [137] = { 149, 194 }, [138] = { 232, 122 }, [139] = { 138, 74 }, [143] = { 137, 91 }, [145] = { 138, 213 }, [146] = { 251, 232 }, [147] = { 138, 212 }, [148] = { 232, 123 }, [150] = { 232, 124 }, [152] = { 232, 125 }, [153] = { 232, 126 }, [160] = { 232, 128 }, [162] = { 138, 214 }, [163] = { 138, 116 }, [164] = { 141, 125 }, [165] = { 148, 180 }, [167] = { 232, 130 }, [168] = { 232, 129 }, [173] = { 232, 131 },
		[178] = { 137, 123 }, [185] = { 232, 134 }, [187] = { 232, 133 }, [188] = { 232, 132 }, [190] = { 232, 135 }, [195] = { 232, 138 }, [199] = { 136, 197 }, [202] = { 232, 136 }, [204] = { 232, 140 }, [205] = { 232, 139 }, [212] = { 232, 142 }, [213] = { 232, 141 }, [214] = { 232, 143 }, [216] = { 147, 172 }, [220] = { 232, 144 }, [225] = { 232, 145 }, [226] = { 232, 147 }, [229] = { 232, 146 },
	},
	[150] = {
		[28] = { 149, 140 }, [33] = { 232, 148 }, [40] = { 232, 149 }, [42] = { 141, 227 }, [46] = { 232, 150 }, [47] = { 232, 151 }, [50] = { 150, 104 }, [59] = { 145, 106 }, [63] = { 136, 162 }, [64] = { 145, 201 }, [66] = { 232, 152 }, [68] = { 149, 141 }, [75] = { 232, 155 }, [76] = { 232, 153 }, [77] = { 141, 126 }, [79] = { 232, 154 }, [80] = { 140, 192 }, [91] = { 149, 195 }, [92] = { 232, 157 }, [93] = { 232, 159 }, [94] = { 232, 158 }, [95] = { 232, 160 }, [98] = { 137, 64 }, [99] = { 144, 119 },
		[100] = { 143, 156 }, [101] = { 138, 215 }, [102] = { 232, 161 }, [106] = { 148, 134 }, [108] = { 232, 163 }, [112] = { 137, 65 }, [114] = { 232, 162 }, [115] = { 146, 194 }, [117] = { 151, 203 }, [118] = { 147, 169 }, [119] = { 232, 156 }, [120] = { 151, 164 }, [122] = { 140, 175 }, [125] = { 151, 122 }, [133] = { 139, 247 }, [134] = { 151, 178 }, [136] = { 140, 71 }, [138] = { 145, 224 }, [139] = { 228, 64 }, [141] = { 232, 164 }, [142] = { 138, 75 }, [143] = { 144, 143 }, [148] = { 138, 117 }, [149] = { 232, 166 }, [151] = { 232, 167 },
		[152] = { 232, 165 }, [153] = { 140, 132 }, [155] = { 141, 219 }, [156] = { 143, 225 }, [157] = { 251, 235 }, [160] = { 137, 66 }, [163] = { 151, 215 }, [167] = { 232, 169 }, [168] = { 231, 172 }, [170] = { 232, 168 }, [175] = { 251, 236 }, [176] = { 232, 172 }, [177] = { 232, 170 }, [178] = { 232, 171 }, [180] = { 232, 173 }, [182] = { 232, 174 }, [183] = { 151, 234 }, [184] = { 232, 175 }, [185] = { 232, 176 }, [187] = { 144, 199 }, [188] = { 148, 185 }, [192] = { 144, 157 }, [193] = { 138, 229 }, [196] = { 151, 89 }, [197] = { 137, 235 },
		[198] = { 143, 87 }, [199] = { 140, 217 }, [201] = { 232, 179 }, [203] = { 232, 178 }, [204] = { 142, 147 }, [205] = { 232, 180 }, [206] = { 232, 177 }, [209] = { 142, 71 }, [213] = { 232, 184 }, [214] = { 229, 171 }, [217] = { 153, 212 }, [219] = { 144, 151 }, [220] = { 232, 182 }, [226] = { 151, 163 }, [227] = { 147, 239 }, [232] = { 137, 74 }, [234] = { 144, 225 }, [235] = { 142, 180 }, [240] = { 149, 181 }, [242] = { 137, 95 }, [246] = { 151, 235 }, [247] = { 151, 139 }, [249] = { 232, 185 }, [251] = { 147, 100 },
	},
	[151] = {
		[0] = { 142, 249 }, [4] = { 232, 186 }, [6] = { 232, 187 }, [7] = { 144, 107 }, [8] = { 232, 188 }, [10] = { 151, 236 }, [13] = { 232, 183 }, [14] = { 232, 190 }, [15] = { 232, 192 }, [17] = { 232, 191 }, [19] = { 232, 189 }, [22] = { 232, 193 }, [25] = { 232, 194 }, [28] = { 145, 154 }, [30] = { 137, 224 }, [36] = { 232, 195 }, [39] = { 150, 182 }, [42] = { 232, 196 }, [48] = { 232, 197 }, [50] = { 152, 73 }, [51] = { 251, 237 }, [56] = { 158, 80 }, [57] = { 232, 198 }, [59] = { 251, 238 },
		[61] = { 232, 199 }, [62] = { 232, 200 }, [66] = { 232, 204 }, [67] = { 251, 239 }, [68] = { 232, 201 }, [70] = { 232, 202 }, [72] = { 232, 203 }, [73] = { 232, 205 }, [77] = { 251, 240 }, [79] = { 251, 241 }, [81] = { 251, 242 }, [82] = { 144, 194 }, [85] = { 251, 243 }, [86] = { 150, 245 }, [89] = { 144, 195 }, [92] = { 232, 206 }, [94] = { 148, 241 }, [96] = { 232, 207 }, [97] = { 234, 114 }, [98] = { 150, 202 }, [100] = { 232, 208 }, [102] = { 232, 209 }, [104] = { 232, 210 }, [105] = { 138, 118 }, [107] = { 232, 212 },
		[109] = { 144, 120 }, [113] = { 232, 213 }, [116] = { 140, 67 }, [121] = { 232, 214 }, [122] = { 232, 218 }, [124] = { 232, 216 }, [129] = { 232, 217 }, [132] = { 138, 147 }, [133] = { 232, 215 }, [134] = { 232, 219 }, [139] = { 232, 220 }, [141] = { 136, 198 }, [143] = { 232, 221 }, [144] = { 232, 222 }, [152] = { 143, 226 }, [156] = { 232, 223 }, [160] = { 139, 102 }, [163] = { 232, 226 }, [166] = { 232, 225 }, [168] = { 232, 224 }, [171] = { 230, 145 }, [173] = { 149, 218 }, [179] = { 232, 227 }, [180] = { 232, 228 }, [195] = { 232, 229 },
		[198] = { 232, 230 }, [200] = { 232, 231 }, [203] = { 232, 232 }, [211] = { 138, 216 }, [220] = { 232, 233 }, [237] = { 232, 234 }, [238] = { 148, 66 }, [242] = { 232, 236 }, [243] = { 137, 185 }, [245] = { 232, 239 }, [246] = { 232, 238 }, [251] = { 137, 67 }, [255] = { 139, 191 },
	},
	[152] = {
		[1] = { 149, 197 }, [2] = { 146, 184 }, [3] = { 141, 160 }, [5] = { 141, 128 }, [6] = { 143, 135 }, [8] = { 144, 123 }, [12] = { 232, 241 }, [15] = { 232, 240 }, [16] = { 151, 97 }, [17] = { 138, 230 }, [18] = { 148, 208 }, [19] = { 147, 218 }, [23] = { 144, 156 }, [24] = { 151, 204 }, [26] = { 140, 122 }, [33] = { 232, 244 }, [36] = { 232, 243 }, [44] = { 150, 106 }, [45] = { 147, 170 }, [52] = { 137, 111 }, [55] = { 232, 245 }, [56] = { 232, 242 }, [59] = { 149, 112 }, [60] = { 151, 138 },
		[61] = { 232, 246 }, [70] = { 232, 247 }, [75] = { 232, 249 }, [76] = { 145, 232 }, [77] = { 138, 122 }, [78] = { 138, 123 }, [79] = { 232, 248 }, [84] = { 138, 231 }, [85] = { 140, 176 }, [87] = { 251, 244 }, [88] = { 138, 232 }, [91] = { 147, 94 }, [94] = { 151, 222 }, [101] = { 251, 245 }, [103] = { 140, 218 }, [107] = { 232, 250 }, [111] = { 232, 251 }, [112] = { 232, 252 }, [113] = { 233, 64 }, [115] = { 233, 66 }, [116] = { 233, 65 }, [168] = { 149, 151 }, [170] = { 233, 67 }, [175] = { 233, 68 }, [177] = { 233, 69 },
		[182] = { 233, 70 }, [195] = { 233, 72 }, [196] = { 233, 71 }, [198] = { 233, 73 }, [219] = { 148, 242 }, [220] = { 227, 202 }, [223] = { 144, 72 }, [226] = { 139, 81 }, [233] = { 233, 74 }, [235] = { 233, 75 }, [237] = { 153, 170 }, [238] = { 159, 90 }, [239] = { 148, 209 }, [242] = { 136, 249 }, [244] = { 136, 185 }, [252] = { 142, 148 }, [253] = { 150, 79 }, [254] = { 143, 252 },
	},
	[153] = {
		[3] = { 233, 76 }, [5] = { 150, 221 }, [9] = { 233, 77 }, [10] = { 151, 123 }, [12] = { 137, 97 }, [16] = { 142, 96 }, [18] = { 233, 78 }, [19] = { 137, 236 }, [20] = { 233, 79 }, [24] = { 233, 80 }, [29] = { 233, 82 }, [30] = { 233, 83 }, [32] = { 233, 85 }, [33] = { 233, 81 }, [36] = { 233, 84 }, [39] = { 251, 248 }, [40] = { 138, 217 }, [44] = { 233, 86 }, [46] = { 233, 87 }, [61] = { 233, 88 }, [62] = { 233, 89 }, [66] = { 233, 90 }, [69] = { 233, 92 }, [73] = { 233, 91 },
		[75] = { 233, 94 }, [76] = { 233, 97 }, [80] = { 233, 93 }, [81] = { 233, 95 }, [82] = { 233, 96 }, [85] = { 233, 98 }, [87] = { 139, 192 }, [150] = { 142, 241 }, [151] = { 233, 99 }, [152] = { 233, 100 }, [153] = { 141, 129 }, [158] = { 251, 250 }, [165] = { 233, 101 }, [168] = { 138, 93 }, [172] = { 148, 110 }, [173] = { 233, 102 }, [174] = { 233, 103 }, [179] = { 146, 121 }, [180] = { 147, 233 }, [188] = { 233, 104 }, [193] = { 148, 157 }, [196] = { 145, 202 }, [197] = { 137, 119 }, [198] = { 139, 236 }, [200] = { 139, 237 },
		[208] = { 146, 147 }, [209] = { 233, 109 }, [210] = { 139, 238 }, [213] = { 137, 237 }, [216] = { 233, 108 }, [219] = { 233, 106 }, [221] = { 233, 107 }, [223] = { 233, 105 }, [226] = { 233, 119 }, [237] = { 233, 110 }, [238] = { 233, 111 }, [241] = { 233, 112 }, [242] = { 233, 113 }, [248] = { 233, 115 }, [251] = { 233, 114 }, [255] = { 143, 120 },
	},
	[154] = {
		[1] = { 233, 116 }, [5] = { 233, 118 }, [14] = { 139, 82 }, [15] = { 233, 117 }, [18] = { 145, 155 }, [19] = { 140, 177 }, [25] = { 233, 120 }, [40] = { 145, 203 }, [43] = { 233, 121 }, [48] = { 147, 171 }, [55] = { 233, 122 }, [62] = { 233, 128 }, [64] = { 233, 125 }, [66] = { 233, 124 }, [67] = { 233, 126 }, [69] = { 233, 123 }, [77] = { 233, 130 }, [78] = { 251, 251 }, [85] = { 233, 129 }, [87] = { 233, 132 }, [90] = { 139, 193 }, [91] = { 233, 131 }, [95] = { 233, 133 }, [98] = { 233, 134 },
		[100] = { 233, 136 }, [101] = { 233, 135 }, [105] = { 233, 137 }, [106] = { 233, 139 }, [107] = { 233, 138 }, [168] = { 141, 156 }, [173] = { 233, 140 }, [176] = { 233, 141 }, [184] = { 138, 91 }, [188] = { 233, 142 }, [192] = { 233, 143 }, [196] = { 144, 145 }, [207] = { 233, 144 }, [209] = { 233, 145 }, [211] = { 233, 146 }, [212] = { 233, 147 }, [216] = { 141, 130 }, [217] = { 251, 252 }, [220] = { 252, 64 }, [222] = { 233, 148 }, [223] = { 233, 149 }, [226] = { 233, 150 }, [227] = { 233, 151 }, [230] = { 233, 152 }, [234] = { 148, 175 },
		[235] = { 233, 154 }, [237] = { 149, 69 }, [238] = { 233, 155 }, [239] = { 233, 153 }, [241] = { 233, 157 }, [244] = { 233, 156 }, [247] = { 233, 158 }, [251] = { 233, 159 },
	},
	[155] = {
		[6] = { 233, 160 }, [24] = { 233, 161 }, [26] = { 233, 162 }, [31] = { 233, 163 }, [34] = { 233, 164 }, [35] = { 233, 165 }, [37] = { 233, 166 }, [39] = { 233, 167 }, [40] = { 233, 168 }, [41] = { 233, 169 }, [42] = { 233, 170 }, [46] = { 233, 171 }, [47] = { 233, 172 }, [49] = { 159, 84 }, [50] = { 233, 173 }, [59] = { 226, 246 }, [60] = { 139, 83 }, [65] = { 138, 64 }, [66] = { 141, 176 }, [67] = { 233, 175 }, [68] = { 233, 174 }, [69] = { 150, 163 }, [77] = { 233, 177 }, [78] = { 233, 178 },
		[79] = { 233, 176 }, [81] = { 233, 179 }, [84] = { 150, 130 }, [88] = { 233, 180 }, [90] = { 139, 155 }, [111] = { 152, 68 }, [114] = { 252, 66 }, [116] = { 233, 181 }, [117] = { 252, 65 }, [131] = { 233, 183 }, [142] = { 136, 188 }, [143] = { 252, 67 }, [145] = { 233, 184 }, [146] = { 149, 169 }, [147] = { 233, 182 }, [150] = { 233, 185 }, [151] = { 233, 186 }, [159] = { 233, 187 }, [160] = { 233, 188 }, [168] = { 233, 189 }, [170] = { 150, 142 }, [171] = { 142, 76 }, [173] = { 141, 248 }, [174] = { 145, 78 }, [177] = { 252, 68 },
		[180] = { 233, 190 }, [185] = { 233, 193 }, [187] = { 252, 69 }, [192] = { 233, 191 }, [198] = { 233, 194 }, [201] = { 140, 239 }, [202] = { 233, 192 }, [207] = { 233, 195 }, [209] = { 233, 196 }, [210] = { 233, 197 }, [212] = { 233, 201 }, [214] = { 142, 73 }, [219] = { 145, 226 }, [225] = { 233, 202 }, [226] = { 233, 199 }, [227] = { 233, 198 }, [228] = { 233, 200 }, [232] = { 140, 126 }, [240] = { 233, 206 }, [241] = { 233, 205 }, [242] = { 233, 204 }, [245] = { 136, 177 },
	},
	[156] = {
		[0] = { 252, 70 }, [4] = { 233, 216 }, [6] = { 233, 212 }, [8] = { 233, 213 }, [9] = { 233, 209 }, [10] = { 233, 215 }, [12] = { 233, 211 }, [13] = { 138, 130 }, [16] = { 152, 107 }, [18] = { 233, 214 }, [19] = { 233, 210 }, [20] = { 233, 208 }, [21] = { 233, 207 }, [27] = { 233, 218 }, [33] = { 233, 221 }, [36] = { 233, 220 }, [37] = { 233, 219 }, [45] = { 149, 104 }, [46] = { 233, 217 }, [47] = { 136, 241 }, [48] = { 233, 222 }, [50] = { 233, 224 }, [57] = { 138, 143 }, [58] = { 233, 203 },
		[59] = { 137, 86 }, [62] = { 233, 226 }, [70] = { 233, 225 }, [71] = { 233, 223 }, [72] = { 146, 76 }, [82] = { 150, 144 }, [87] = { 151, 216 }, [90] = { 233, 227 }, [96] = { 233, 228 }, [103] = { 233, 229 }, [118] = { 233, 230 }, [120] = { 233, 231 }, [229] = { 146, 185 }, [231] = { 233, 232 }, [233] = { 148, 181 }, [235] = { 233, 237 }, [236] = { 233, 233 }, [240] = { 233, 234 }, [243] = { 150, 80 }, [244] = { 150, 194 }, [246] = { 147, 206 },
	},
	[157] = {
		[3] = { 233, 238 }, [6] = { 233, 239 }, [7] = { 147, 188 }, [8] = { 233, 236 }, [9] = { 233, 235 }, [14] = { 137, 168 }, [18] = { 233, 247 }, [21] = { 233, 246 }, [27] = { 137, 149 }, [31] = { 233, 244 }, [35] = { 233, 243 }, [38] = { 233, 241 }, [40] = { 138, 155 }, [42] = { 233, 240 }, [43] = { 142, 176 }, [44] = { 137, 167 }, [59] = { 141, 131 }, [62] = { 233, 250 }, [63] = { 233, 249 }, [65] = { 233, 248 }, [68] = { 233, 245 }, [70] = { 233, 251 }, [72] = { 233, 252 }, [80] = { 234, 68 },
		[81] = { 234, 67 }, [89] = { 234, 69 }, [92] = { 137, 76 }, [93] = { 234, 64 }, [94] = { 234, 65 }, [96] = { 141, 148 }, [97] = { 150, 183 }, [100] = { 234, 66 }, [107] = { 252, 72 }, [108] = { 150, 81 }, [111] = { 234, 74 }, [112] = { 252, 71 }, [114] = { 234, 70 }, [122] = { 234, 75 }, [135] = { 234, 72 }, [137] = { 234, 71 }, [143] = { 140, 123 }, [154] = { 234, 76 }, [164] = { 234, 77 }, [169] = { 234, 78 }, [171] = { 234, 73 }, [175] = { 233, 242 }, [178] = { 234, 79 }, [180] = { 146, 223 }, [184] = { 234, 83 },
		[186] = { 234, 84 }, [187] = { 234, 82 }, [193] = { 234, 81 }, [194] = { 234, 87 }, [196] = { 234, 80 }, [198] = { 234, 85 }, [207] = { 234, 86 }, [211] = { 234, 89 }, [217] = { 234, 88 }, [230] = { 234, 91 }, [237] = { 234, 92 }, [239] = { 234, 93 }, [242] = { 152, 104 }, [248] = { 234, 90 }, [249] = { 145, 233 }, [250] = { 141, 235 }, [253] = { 234, 94 },
	},
	[158] = {
		[25] = { 252, 74 }, [26] = { 234, 95 }, [27] = { 234, 96 }, [30] = { 234, 97 }, [117] = { 234, 98 }, [120] = { 140, 178 }, [121] = { 234, 99 }, [125] = { 234, 100 }, [127] = { 142, 173 }, [129] = { 234, 101 }, [136] = { 234, 102 }, [139] = { 234, 103 }, [140] = { 234, 104 }, [145] = { 234, 107 }, [146] = { 234, 105 }, [147] = { 152, 91 }, [149] = { 234, 106 }, [151] = { 151, 237 }, [157] = { 234, 108 }, [159] = { 151, 217 }, [165] = { 234, 109 }, [166] = { 148, 158 }, [169] = { 234, 110 }, [170] = { 234, 112 },
		[173] = { 234, 113 }, [184] = { 234, 111 }, [185] = { 141, 141 }, [186] = { 150, 203 }, [187] = { 150, 131 }, [188] = { 155, 245 }, [190] = { 159, 128 }, [191] = { 150, 155 }, [196] = { 137, 169 }, [204] = { 234, 115 }, [205] = { 139, 111 }, [206] = { 234, 116 }, [207] = { 234, 117 }, [208] = { 234, 118 }, [209] = { 252, 75 }, [210] = { 141, 149 }, [212] = { 234, 119 }, [216] = { 224, 210 }, [217] = { 150, 217 }, [219] = { 145, 225 }, [220] = { 234, 120 }, [221] = { 234, 122 }, [222] = { 234, 121 }, [224] = { 234, 123 }, [229] = { 234, 124 },
		[232] = { 234, 125 }, [239] = { 234, 126 }, [244] = { 234, 128 }, [246] = { 234, 129 }, [247] = { 234, 130 }, [249] = { 234, 131 }, [251] = { 234, 132 }, [252] = { 234, 133 }, [253] = { 234, 134 },
	},
	[159] = {
		[7] = { 234, 135 }, [8] = { 234, 136 }, [14] = { 147, 67 }, [19] = { 140, 219 }, [21] = { 234, 138 }, [32] = { 145, 108 }, [33] = { 234, 139 }, [44] = { 234, 140 }, [59] = { 149, 64 }, [62] = { 234, 141 }, [74] = { 234, 142 }, [75] = { 226, 86 }, [78] = { 230, 216 }, [79] = { 232, 235 }, [82] = { 234, 143 }, [84] = { 234, 144 }, [95] = { 234, 146 }, [96] = { 234, 147 }, [97] = { 234, 148 }, [98] = { 151, 238 }, [99] = { 234, 145 }, [102] = { 234, 149 }, [103] = { 234, 150 }, [106] = { 234, 152 },
		[108] = { 234, 151 }, [114] = { 234, 154 }, [118] = { 234, 155 }, [119] = { 234, 153 }, [141] = { 151, 180 }, [149] = { 234, 156 }, [156] = { 234, 157 }, [157] = { 226, 115 }, [160] = { 234, 158 },
	},
	[249] = {
		[41] = { 250, 224 }, [220] = { 251, 233 },
	},
	[250] = {
		[14] = { 250, 144 }, [15] = { 250, 155 }, [16] = { 250, 156 }, [17] = { 250, 177 }, [18] = { 250, 216 }, [19] = { 250, 232 }, [20] = { 250, 234 }, [21] = { 251, 88 }, [22] = { 251, 94 }, [23] = { 251, 117 }, [24] = { 251, 125 }, [25] = { 251, 126 }, [26] = { 251, 128 }, [27] = { 251, 130 }, [28] = { 251, 134 }, [29] = { 251, 137 }, [30] = { 251, 146 }, [31] = { 251, 157 }, [32] = { 251, 159 }, [33] = { 251, 160 }, [34] = { 251, 169 }, [35] = { 251, 177 }, [36] = { 251, 179 }, [37] = { 251, 180 },
		[38] = { 251, 183 }, [39] = { 251, 211 }, [40] = { 251, 218 }, [41] = { 251, 234 }, [42] = { 251, 246 }, [43] = { 251, 247 }, [44] = { 251, 249 }, [45] = { 252, 73 },
	},
	[255] = {
		[1] = { 129, 73 }, [2] = { 250, 87 }, [3] = { 129, 148 }, [4] = { 129, 144 }, [5] = { 129, 147 }, [6] = { 129, 149 }, [7] = { 250, 86 }, [8] = { 129, 105 }, [9] = { 129, 106 }, [10] = { 129, 150 }, [11] = { 129, 123 }, [12] = { 129, 67 }, [13] = { 129, 124 }, [14] = { 129, 68 }, [15] = { 129, 94 }, [16] = { 130, 79 }, [17] = { 130, 80 }, [18] = { 130, 81 }, [19] = { 130, 82 }, [20] = { 130, 83 }, [21] = { 130, 84 }, [22] = { 130, 85 }, [23] = { 130, 86 }, [24] = { 130, 87 },
		[25] = { 130, 88 }, [26] = { 129, 70 }, [27] = { 129, 71 }, [28] = { 129, 131 }, [29] = { 129, 129 }, [30] = { 129, 132 }, [31] = { 129, 72 }, [32] = { 129, 151 }, [33] = { 130, 96 }, [34] = { 130, 97 }, [35] = { 130, 98 }, [36] = { 130, 99 }, [37] = { 130, 100 }, [38] = { 130, 101 }, [39] = { 130, 102 }, [40] = { 130, 103 }, [41] = { 130, 104 }, [42] = { 130, 105 }, [43] = { 130, 106 }, [44] = { 130, 107 }, [45] = { 130, 108 }, [46] = { 130, 109 }, [47] = { 130, 110 }, [48] = { 130, 111 }, [49] = { 130, 112 },
		[50] = { 130, 113 }, [51] = { 130, 114 }, [52] = { 130, 115 }, [53] = { 130, 116 }, [54] = { 130, 117 }, [55] = { 130, 118 }, [56] = { 130, 119 }, [57] = { 130, 120 }, [58] = { 130, 121 }, [59] = { 129, 109 }, [60] = { 129, 95 }, [61] = { 129, 110 }, [62] = { 129, 79 }, [63] = { 129, 81 }, [64] = { 129, 77 }, [65] = { 130, 129 }, [66] = { 130, 130 }, [67] = { 130, 131 }, [68] = { 130, 132 }, [69] = { 130, 133 }, [70] = { 130, 134 }, [71] = { 130, 135 }, [72] = { 130, 136 }, [73] = { 130, 137 }, [74] = { 130, 138 },
		[75] = { 130, 139 }, [76] = { 130, 140 }, [77] = { 130, 141 }, [78] = { 130, 142 }, [79] = { 130, 143 }, [80] = { 130, 144 }, [81] = { 130, 145 }, [82] = { 130, 146 }, [83] = { 130, 147 }, [84] = { 130, 148 }, [85] = { 130, 149 }, [86] = { 130, 150 }, [87] = { 130, 151 }, [88] = { 130, 152 }, [89] = { 130, 153 }, [90] = { 130, 154 }, [91] = { 129, 111 }, [92] = { 129, 98 }, [93] = { 129, 112 }, [94] = { 129, 96 }, [97] = { 161 }, [98] = { 162 }, [99] = { 163 }, [100] = { 164 }, [101] = { 165 },
		[102] = { 166 }, [103] = { 167 }, [104] = { 168 }, [105] = { 169 }, [106] = { 170 }, [107] = { 171 }, [108] = { 172 }, [109] = { 173 }, [110] = { 174 }, [111] = { 175 }, [112] = { 176 }, [113] = { 177 }, [114] = { 178 }, [115] = { 179 }, [116] = { 180 }, [117] = { 181 }, [118] = { 182 }, [119] = { 183 }, [120] = { 184 }, [121] = { 185 }, [122] = { 186 }, [123] = { 187 }, [124] = { 188 }, [125] = { 189 }, [126] = { 190 },
		[127] = { 191 }, [128] = { 192 }, [129] = { 193 }, [130] = { 194 }, [131] = { 195 }, [132] = { 196 }, [133] = { 197 }, [134] = { 198 }, [135] = { 199 }, [136] = { 200 }, [137] = { 201 }, [138] = { 202 }, [139] = { 203 }, [140] = { 204 }, [141] = { 205 }, [142] = { 206 }, [143] = { 207 }, [144] = { 208 }, [145] = { 209 }, [146] = { 210 }, [147] = { 211 }, [148] = { 212 }, [149] = { 213 }, [150] = { 214 }, [151] = { 215 },
		[152] = { 216 }, [153] = { 217 }, [154] = { 218 }, [155] = { 219 }, [156] = { 220 }, [157] = { 221 }, [158] = { 222 }, [159] = { 223 }, [224] = { 129, 145 }, [225] = { 129, 146 }, [226] = { 250, 84 }, [227] = { 129, 80 }, [228] = { 250, 85 }, [229] = { 129, 143 },
	},
};
function CP932Converter.convertFromUTF8( utf8 )
	local utf8codes = CP932Converter._getUnicodeBytesFromUTF8String( utf8 );
	local result = "";
	local i;
	for i = 1, #utf8codes, 1 do
		local r = utf8codes[i];
		if( #r == 1 )then
			result = result .. string.char( r[1] );
		elseif( #r == 2 )then
			local firstByte = r[1];
			if( CP932Converter._unicode_to_cp932[firstByte] ~= nil )then
				local secondByte = r[2];
				if( CP932Converter._unicode_to_cp932[firstByte][secondByte] ~= nil )then
					local cp932bytes = CP932Converter._unicode_to_cp932[firstByte][secondByte];
					local j;
					for j = 1, #cp932bytes, 1 do
						result = result .. string.char( cp932bytes[j] );
					end
				end
			end
		end
	end
	return result;
end
function CP932Converter._getUnicodeBytesFromUTF8String( s )
	local result = {};
	local i = 1;
	while( i <= s:len() )do
		local b = string.byte( s, i );
		local byteCount = 1;
		local utf8bytes = { b };
		if( b <= 0x7f )then
			byteCount = 1;
		elseif( b <= 0xdf )then
			byteCount = 2;
		elseif( b <= 0xef )then
			byteCount = 3;
		elseif( b <= 0xf7 )then
			byteCount = 4;
		elseif( b <= 0xfb )then
			byteCount = 5;
		else
			byteCount = 6;
		end
		local j;
		for j = 2, byteCount, 1 do
			local a = string.byte( s, i + j - 1 );
			table.insert( utf8bytes, a );
		end
		local r = CP932Converter._getUnicodeBytesFromUTF8Bytes( utf8bytes );
		table.insert( result, r );
		i = i + byteCount;
	end
	return result;
end
function CP932Converter._getUnicodeBytesFromUTF8Bytes( utf8 )
	if( #utf8 == 1 )then
		return { Util.band( utf8[1], 0x7f ) };
	elseif( #utf8 == 2 )then
		local result = {
			Util.band( Util.rshift( utf8[1], 2 ), 0x7 ),
			Util.bor( Util.lshift( Util.band( utf8[1], 0x3 ), 6 ), Util.band( utf8[2], 0x3f ) )
		};
		if( result[1] == 0 )then
			return { result[2] };
		else
			return result;
		end
	elseif( #utf8 == 3 )then
		return {
			Util.bor( Util.lshift( Util.band( utf8[1], 0xf ), 4 ), Util.band( Util.rshift( utf8[2], 2 ), 0xf ) ),
			Util.bor( Util.lshift( Util.band( utf8[2], 0x3 ), 6 ), Util.band( utf8[3], 0x3f ) )
		};
	elseif( #utf8 == 4 )then
		return {
			Util.bor( Util.lshift( Util.band( utf8[1], 0x7 ), 2 ), Util.rshift( Util.band( utf8[2], 0x30 ), 4 ) ),
			Util.bor( Util.lshift( Util.band( utf8[2], 0xf ), 4 ), Util.rshift( Util.band( utf8[3], 0x3c ), 2 ) ),
			Util.bor( Util.lshift( Util.band( utf8[3], 0x3 ), 6 ), Util.band( utf8[4], 0x3f ) )
		}
	elseif( #utf8 == 5 )then
		local result = {
			Util.band( utf8[1], 0x3 ),
			Util.bor( Util.lshift( Util.band( utf8[2], 0x3f ), 2 ), Util.rshift( Util.band( utf8[3], 0x30 ), 4 ) ),
			Util.bor( Util.lshift( Util.band( utf8[3], 0xf ), 4 ), Util.rshift( Util.band( utf8[4], 0x3c ), 2 ) ),
			Util.bor( Util.lshift( Util.band( utf8[4], 0x3 ), 6 ), Util.band( utf8[5], 0x3f ) )
		};
		if( result[1] == 0 )then
			return { result[2], result[3], result[4] };
		else
			return result;
		end
	elseif( #utf8 == 6 )then
		return {
			Util.bor( Util.lshift( Util.band( utf8[1], 0x1 ), 6 ), Util.band( utf8[2], 0x3f ) ),
			Util.bor( Util.lshift( Util.band( utf8[3], 0x3f ), 2 ), Util.rshift( Util.band( utf8[4], 0x30 ), 4 ) ),
			Util.bor( Util.lshift( Util.band( utf8[4], 0xf ), 4 ), Util.rshift( Util.band( utf8[5], 0x3c ), 2 ) ),
			Util.bor( Util.lshift( Util.band( utf8[5], 0x3 ), 6 ), Util.band( utf8[6], 0x3f ) )
		};
	else
		return {};
	end
end

Common = {};
function Common.new( ... )
	local this = {};
	local arguments = { ... };
	this.version = "DSB301";
	this.name = "Miku";
	this.color = "179,181,123";
	this.dynamicsMode = DynamicsModeEnum.EXPERT;
	this.playMode = PlayModeEnum.PLAY_WITH_SYNTH;
	this._lastPlayMode = PlayModeEnum.PLAY_WITH_SYNTH;
	function this:_init_2( stream, lastLine )
		self.version = "";
		self.name = "";
		self.color = "0,0,0";
		self.dynamicsMode = 0;
		self.playMode = 1;
		lastLine.value = stream:readLine();
		while( lastLine.value:sub( 1, 1 ) ~= "[" )do
			local spl = Util.split( lastLine.value, "=" );
			local search = spl[1];
			if( search == "Version" )then
				self.version = spl[2];
			elseif( search == "Name" )then
				self.name = spl[2];
			elseif( search == "Color" )then
				self.color = spl[2];
			elseif( search == "DynamicsMode" )then
				self.dynamicsMode = tonumber( spl[2], 10 );
			elseif( search == "PlayMode" )then
				self.playMode = tonumber( spl[2], 10 );
			end
			if( not stream:ready() )then
				break;
			end
			lastLine.value = stream:readLine();
		end
	end
	function this:_init_6( name, r, g, b, dynamicsMode, playMode )
		self.version = "DSB301";
		self.name = name;
		self.color = r .. "," .. g .. "," .. b;
		self.dynamicsMode = dynamicsMode;
		self.playMode = playMode;
	end
	function this:clone()
		local spl = Util.split( self.color, "," );
		local r = tonumber( spl[1], 10 );
		local g = tonumber( spl[2], 10 );
		local b = tonumber( spl[3], 10 );
		local res = Common.new( self.name, r, g, b, self.dynamicsMode, self.playMode );
		res.version = self.version;
		res._lastPlayMode = self._lastPlayMode;
		return res;
	end
	function this:write( stream )
		stream:writeLine( "[Common]" );
		stream:writeLine( "Version=" .. self.version );
		stream:writeLine( "Name=" .. self.name );
		stream:writeLine( "Color=" .. self.color );
		stream:writeLine( "DynamicsMode=" .. self.dynamicsMode );
		stream:writeLine( "PlayMode=" .. self.playMode );
	end
	if( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	elseif( #arguments == 6 )then
		this:_init_6( arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6] );
	end
	return this;
end
DynamicsModeEnum = {
	STANDARD = 0,
	EXPERT = 1
};
Event = {};
function Event.new( ... )
	local arguments = { ... };
	local this = {};
	this.tag = "";
	this.id = -1;
	this.clock = 0;
	this.index = -1;
	this.type = EventTypeEnum.Note;
	this.singerHandle = nil;
	this._length = 0;
	this.note = 0;
	this.dynamics = 0;
	this.pmBendDepth = 0;
	this.pmBendLength = 0;
	this.pmbPortamentoUse = 0;
	this.demDecGainRate = 0;
	this.demAccent = 0;
	this.lyricHandle = nil;
	this.vibratoHandle = nil;
	this.vibratoDelay = 0;
	this.noteHeadHandle = nil;
	this.pMeanOnsetFirstNote = 10;
	this.vMeanNoteTransition = 12;
	this.d4mean = 24;
	this.pMeanEndingNote = 12;
	this.iconDynamicsHandle = nil;
	this.ustEvent = nil;
	function this:_init_1( line )
		local spl = Util.split( line, '=' );
		self.clock = tonumber( spl[1], 10 );
		if( spl[2] == "EOS" )then
			self.index = -1;
		end
	end
	function this:_init_0()
		self.clock = 0;
		self.index = -1;
		self.id = 0;
	end
	function this:_init_2( clock, eventType )
		self.clock = clock;
		self.type = eventType;
		if( eventType == EventTypeEnum.SINGER )then
			self.singerHandle = Handle.new( HandleTypeEnum.SINGER );
		elseif( eventType == EventTypeEnum.NOTE )then
			self.lyricHandle = Handle.new( HandleTypeEnum.LYRIC );
			self.lyricHandle:setLyricAt( 0, Lyric.new( "a", "a" ) );
		end
		self.id = 0;
	end
	function this:getLength()
		return self._length;
	end
	function this:setLength( value )
		self._length = value;
	end
	function this:write( ... )
		local arguments = { ... };
		if( #arguments == 1 )then
			self:_write_1( arguments[1] );
		elseif( #arguments == 2 )then
			self:_write_2( arguments[1], arguments[2] );
		end
	end
	function this:_write_1( stream )
		local def = { "Length",
					"Note#",
					"Dynamics",
					"PMBendDepth",
					"PMBendLength",
					"PMbPortamentoUse",
					"DEMdecGainRate",
					"DEMaccent" };
		self:_write_2( stream, def );
	end
	function this:_write_2( stream, printTargets )
		stream:writeLine( "[ID#" .. string.format( "%04d", self.index ) .. "]" );
		stream:writeLine( "Type=" .. EventTypeEnum.toString( self.type ) );
		if( self.type == EventTypeEnum.NOTE )then
			if( Util.searchArray( printTargets, "Length" ) >= 1 )then
				stream:writeLine( "Length=" .. self:getLength() );
			end
			if( Util.searchArray( printTargets, "Note#" ) >= 1 )then
				stream:writeLine( "Note#=" .. self.note );
			end
			if( Util.searchArray( printTargets, "Dynamics" ) >= 1 )then
				stream:writeLine( "Dynamics=" .. self.dynamics );
			end
			if( Util.searchArray( printTargets, "PMBendDepth" ) >= 1 )then
				stream:writeLine( "PMBendDepth=" .. self.pmBendDepth );
			end
			if( Util.searchArray( printTargets, "PMBendLength" ) >= 1 )then
				stream:writeLine( "PMBendLength=" .. self.pmBendLength );
			end
			if( Util.searchArray( printTargets, "PMbPortamentoUse" ) >= 1 )then
				stream:writeLine( "PMbPortamentoUse=" .. self.pmbPortamentoUse );
			end
			if( Util.searchArray( printTargets, "DEMdecGainRate" ) >= 1 )then
				stream:writeLine( "DEMdecGainRate=" .. self.demDecGainRate );
			end
			if( Util.searchArray( printTargets, "DEMaccent" ) >= 1 )then
				stream:writeLine( "DEMaccent=" .. self.demAccent );
			end
			if( Util.searchArray( printTargets, "PreUtterance" ) >= 1 )then
				stream:writeLine( "PreUtterance=" .. self.ustEvent.preUtterance );
			end
			if( Util.searchArray( printTargets, "VoiceOverlap" ) >= 1 )then
				stream:writeLine( "VoiceOverlap=" .. self.ustEvent.voiceOverlap );
			end
			if( self.lyricHandle ~= nil )then
				stream:writeLine( "LyricHandle=h#" .. string.format( "%04d", self.lyricHandle.index ) );
			end
			if( self.vibratoHandle ~= nil )then
				stream:writeLine( "VibratoHandle=h#" .. string.format( "%04d", self.vibratoHandle.index ) );
				stream:writeLine( "VibratoDelay=" .. self.vibratoDelay );
			end
			if( self.noteHeadHandle ~= nil )then
				stream:writeLine( "NoteHeadHandle=h#" .. string.format( "%04d", self.noteHeadHandle.index ) );
			end
		elseif( self.type == EventTypeEnum.SINGER )then
			stream:writeLine( "IconHandle=h#" .. string.format( "%04d", self.singerHandle.index ) );
		elseif( self.type == EventTypeEnum.ICON )then
			stream:writeLine( "IconHandle=h#" .. string.format( "%04d", self.iconDynamicsHandle.index ) );
			stream:writeLine( "Note#=" .. self.note );
		end
	end
	function this:clone()
		local result = Event.new( self.clock, self.type );
		result.type = self.type;
		if( self.singerHandle ~= nil )then
			result.singerHandle = self.singerHandle:clone();
		end
		result:setLength( self:getLength() );
		result.note = self.note;
		result.dynamics = self.dynamics;
		result.pmBendDepth = self.pmBendDepth;
		result.pmBendLength = self.pmBendLength;
		result.pmbPortamentoUse = self.pmbPortamentoUse;
		result.demDecGainRate = self.demDecGainRate;
		result.demAccent = self.demAccent;
		result.d4mean = self.d4mean;
		result.pMeanOnsetFirstNote = self.pMeanOnsetFirstNote;
		result.vMeanNoteTransition = self.vMeanNoteTransition;
		result.pMeanEndingNote = self.pMeanEndingNote;
		if( self.lyricHandle ~= nil )then
			result.lyricHandle = self.lyricHandle:clone();
		end
		if( self.vibratoHandle ~= nil )then
			result.vibratoHandle = self.vibratoHandle:clone();
		end
		result.vibratoDelay = self.vibratoDelay;
		if( self.noteHeadHandle ~= nil )then
			result.noteHeadHandle = self.noteHeadHandle:clone();
		end
		if( self.iconDynamicsHandle ~= nil )then
			result.iconDynamicsHandle = self.iconDynamicsHandle:clone();
		end
		result.index = self.index;
		result.id = self.id;
		if( self.ustEvent ~= nil )then
			result.ustEvent = self.ustEvent:clone();
		end
		result.tag = self.tag;
		return result;
	end
	function this:isEOS()
		if( self.index == -1 )then
			return true;
		else
			return false;
		end
	end
	function this:compareTo( item )
		local ret = self.clock - item.clock;
		if( ret == 0 )then
			return self.type - item.type;
		else
			return ret;
		end
	end
	if( #arguments == 0 )then
		this:_init_0();
	elseif( #arguments == 1 )then
		this:_init_1( arguments[1] );
	elseif( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	end
	return this;
end
function Event.compare( a, b )
	return (a:compareTo( b ) < 0);
end
function Event.getEOS()
	return Event.new();
end
Event.MAX_NOTE_MILLISEC_LENGTH = 16383;
if( nil == EventList )then
	EventList = {};
end
function EventList.new()
	local this = {};
	this._events = {};
	this._ids = {};
	function this:findIndexFromId( internalId )
		local c = #self._events;
		local i;
		for i = 1, c, 1 do
			local item = self._events[i];
			if( item.id == internalId )then
				return i - 1;
			end
		end
		return -1;
	end
	function this:findFromId( internalId )
		local index = self:findIndexFromId( internalId );
		if( 0 <= index and index < #self._events )then
			return self._events[index + 1];
		else
			return nil;
		end
	end
	function this:setForId( internalId, value )
		local c = #self._events;
		local i;
		for i = 1, c, 1 do
			if( self._events[i].id == internalId )then
				value.id = internalId;
				self._events[i] = value;
				break;
			end
		end
	end
	function this:sort()
		table.sort( self._events, Event.compare );
		self:updateIdList();
	end
	function this:clear()
		self._events = {};
		self._ids = {};
	end
	function this:iterator()
		self:updateIdList();
		return EventList.Iterator.new( self );
	end
	function this:add( ... )
		local arguments = { ... };
		if( #arguments == 1 )then
			return self:_add_1( arguments[1] );
		elseif( #arguments == 2 )then
			return self:_add_2( arguments[1], arguments[2] );
		end
		return -1;
	end
	function this:_add_1( item )
		local id = self:_getNextId( 0 );
		self:_addCor( item, id );
		table.sort( self._events, Event.compare );
		local count = #self._events;
		local i;
		for i = 1, count, 1 do
			self._ids[i] = self._events[i].id;
		end
		return id;
	end
	function this:_add_2( item, internalId )
		self:_addCor( item, internalId );
		table.sort( self._events, Event.compare );
		return internalId;
	end
	function this:_addCor( item, internalId )
		self:updateIdList();
		item.id = internalId;
		table.insert( self._events, item );
		table.insert( self._ids, internalId );
	end
	function this:removeAt( index )
		self:updateIdList();
		table.remove( self._events, index + 1 );
		table.remove( self._ids, index + 1 );
	end
	function this:_getNextId( next )
		self:updateIdList();
		local max = -1;
		local i;
		for i = 1, #self._ids, 1 do
			max = math.max( max, self._ids[i] );
		end
		return max + 1 + next;
	end
	function this:size()
		return #self._events;
	end
	function this:get( index )
		return self._events[index + 1];
	end
	function this:set( index, value )
		value.id = self._events[index + 1].id;
		self._events[index + 1] = value;
	end
	function this:updateIdList()
		if( #self._ids ~= #self._events )then
			self._ids = {};
		end
		local count = #self._events;
		local i;
		for i = 1, count, 1 do
			self._ids[i] = self._events[i].id;
		end
	end
	function this:write( stream, eos )
		local handles = self:_buildHandleList();
		stream:writeLine( "[EventList]" );
		local temp = {};
		local itr = self:iterator();
		while( itr:hasNext() )do
			table.insert( temp, itr:next() );
		end
		table.sort( temp, Event.compare );
		local i = 1;
		while( i <= #temp )do
			local item = temp[i];
			if( not item:isEOS() )then
				local ids = "ID#" .. string.format( "%04d", item.index );
				local clock = temp[i].clock;
				while( i + 1 <= #temp and clock == temp[i + 1].clock )do
					i = i + 1;
					ids = ids .. ",ID#" .. string.format( "%04d", temp[i].index );
				end
				stream:writeLine( clock .. "=" .. ids );
			end
			i = i + 1;
		end
		stream:writeLine( eos .. "=EOS" );
		return handles;
	end
	function this:_buildHandleList()
		local handle = {};
		local current_id = -1;
		local current_handle = -1;
		local add_quotation_mark = true;
		local itr = self:iterator();
		while( itr:hasNext() )do
			local item = itr:next();
			current_id = current_id + 1;
			item.index = current_id;
			if( item.singerHandle ~= nil )then
				current_handle = current_handle + 1;
				item.singerHandle.index = current_handle;
				table.insert( handle, item.singerHandle );
				item._singerHandleIndex = current_handle;
				local lang = VoiceLanguageEnum.valueFromSingerName( item.singerHandle.ids );
				add_quotation_mark = lang == VoiceLanguageEnum.JAPANESE;
			end
			if( item.lyricHandle ~= nil )then
				current_handle = current_handle + 1;
				item.lyricHandle.index = current_handle;
				item.lyricHandle.addQuotationMark = add_quotation_mark;
				table.insert( handle, item.lyricHandle );
				item._lyricHandleIndex = current_handle;
			end
			if( item.vibratoHandle ~= nil )then
				current_handle = current_handle + 1;
				item.vibratoHandle.index = current_handle;
				table.insert( handle, item.vibratoHandle );
				item._vibratoHandleIndex = current_handle;
			end
			if( item.noteHeadHandle ~= nil )then
				current_handle = current_handle + 1;
				item.noteHeadHandle.index = current_handle;
				table.insert( handle, item.noteHeadHandle );
				item._noteHeadHandleIndex = current_handle;
			end
			if( item.iconDynamicsHandle ~= nil )then
				current_handle = current_handle + 1;
				item.iconDynamicsHandle.index = current_handle;
				item.iconDynamicsHandle:setLength( item:getLength() );
				table.insert( handle, item.iconDynamicsHandle );
				item._singerHandleIndex = current_handle;
			end
		end
		return handle;
	end
	return this;
end
if( nil == EventList )then
	EventList = {};
end
EventList.IndexIterator = {};
function EventList.IndexIterator.new( list, iteratorKind )
	local this = {};
	this._list = list;
	this._pos = 0;
	this._kindSinger =
		Util.band(
			iteratorKind,
			EventList.IndexIteratorKindEnum.SINGER
		) == EventList.IndexIteratorKindEnum.SINGER;
	this._kindNote =
		Util.band(
			iteratorKind,
			EventList.IndexIteratorKindEnum.NOTE
		) == EventList.IndexIteratorKindEnum.NOTE;
	this._kindCrescend =
		Util.band(
			iteratorKind,
			EventList.IndexIteratorKindEnum.CRESCENDO
		) == EventList.IndexIteratorKindEnum.CRESCENDO;
	this._kindDecrescend =
		Util.band(
			iteratorKind,
			EventList.IndexIteratorKindEnum.DECRESCENDO
		) == EventList.IndexIteratorKindEnum.DECRESCENDO;
	this._kindDynaff =
		Util.band(
			iteratorKind,
			EventList.IndexIteratorKindEnum.DYNAFF
		) == EventList.IndexIteratorKindEnum.DYNAFF;
	function this:next()
		local nextPosition = self:_nextPosition();
		if( nextPosition > 0 )then
			this._pos = nextPosition;
			return nextPosition - 1;
		else
			return -1;
		end
	end
	function this:hasNext()
		return (self:_nextPosition() > 0);
	end
	function this:_nextPosition()
		local count = self._list:size();
		local i;
		for i = self._pos + 1, count, 1 do
			local item = self._list:get( i - 1 );
			if( self._kindSinger )then
				if( item.type == EventTypeEnum.SINGER )then
					return i;
				end
			end
			if( self._kindNote )then
				if( item.type == EventTypeEnum.NOTE )then
					return i;
				end
			end
			if( self._kindDynaff or self._kindCrescend or self._kindDecrescend )then
				if( item.type == EventTypeEnum.ICON and item.iconDynamicsHandle ~= nil and item.iconDynamicsHandle.iconId ~= nil )then
					local iconid = item.iconDynamicsHandle.iconId;
					if( self._kindDynaff )then
						if( iconid:find( Handle.ICONID_HEAD_DYNAFF ) == 1 )then
							return i;
						end
					end
					if( self._kindCrescend )then
						if( iconid:find( Handle.ICONID_HEAD_CRESCEND ) == 1 )then
							return i;
						end
					end
					if( self._kindDecrescend )then
						if( iconid:find( Handle.ICONID_HEAD_DECRESCEND ) == 1 )then
							return i;
						end
					end
				end
			end
		end
		return 0;
	end
	function this:remove()
		if( 0 < self._pos and self._pos <= self._list:size() )then
			self._list:removeAt( self._pos - 1 );
			self._pos = self._pos - 1;
		end
	end
	return this;
end
if( nil == EventList )then
	EventList = {};
end
EventList.IndexIteratorKindEnum = {
	ALL = 0xffff,
	SINGER = 1,
	NOTE = 2,
	CRESCENDO = 4,
	DECRESCENDO = 8,
	DYNAFF = 16,
}
if( nil == EventList )then
	EventList = {};
end
EventList.Iterator = {};
function EventList.Iterator.new( list )
	local this = {};
	this._list = list;
	this._pos = -1;
	function this:hasNext()
		if( 0 <= self._pos + 1 and self._pos + 1 < self._list:size() )then
			return true;
		end
		return false;
	end
	function this:next()
		self._pos = self._pos + 1;
		return self._list:get( self._pos );
	end
	function this:remove()
		if( 0 <= self._pos and self._pos < self._list:size() )then
			self._list:removeAt( self._pos );
			self._pos = self._pos - 1;
		end
	end
	return this;
end
EventTypeEnum = {
	SINGER = 0,
	NOTE = 1,
	ICON = 2,
	UNKNOWN = -1
};
function EventTypeEnum.toString( value )
	if( value == EventTypeEnum.SINGER )then
		return "Singer";
	elseif( value == EventTypeEnum.NOTE )then
		return "Anote";
	elseif( value == EventTypeEnum.ICON )then
		return "Aicon";
	else
		return "Unknown";
	end
end
FileOutputStream = {};
function FileOutputStream.new( path )
	local this = {};
	this._fileHandle = io.open( path, "wb" );
	function this:write( ... )
		local arguments = { ... };
		if( #arguments == 1 )then
			self:_write_1( arguments[1] );
		elseif( #arguments == 3 )then
			self:_write_3( arguments[1], arguments[2], arguments[3] );
		end
	end
	function this:_write_3( array, startIndex, length )
		local i;
		for i = 1, length, 1 do
			self:_write_1( array[startIndex + i - 1] );
		end
	end
	function this:_write_1( byte )
		if( nil == byte )then
			byte = 0;
		end
		self._fileHandle:write( string.char( byte ) );
	end
	function this:getPointer()
		return self._fileHandle:seek();
	end
	function this:seek( position )
		self._fileHandle:seek( "set", position );
	end
	function this:close()
		self._fileHandle:flush();
		self._fileHandle:close();
	end
	return this;
end
Handle = {};
Handle.ICONID_HEAD_DYNAFF = "$0501";
Handle.ICONID_HEAD_CRESCEND = "$0502";
Handle.ICONID_HEAD_DECRESCEND = "$0503";
function Handle.new( ... )
	local arguments = { ... };
	local this = {};
	this._type = HandleTypeEnum.LYRIC;
	this._articulation = nil;
	this.index = 0;
	this.iconId = "";
	this.ids = "";
	this._lyrics = {};
	this.original = 0;
	this._caption = "";
	this._length = 0;
	this._startDepth = 0;
	this._depthBP = nil;
	this._startRate = 0;
	this._rateBP = nil;
	this.language = 0;
	this.program = 0;
	this._duration = 0;
	this._depth = 0;
	this._startDyn = 0;
	this._endDyn = 0;
	this._dynBP = nil;
	this.addQuotationMark = true;
	function this:_init_1( type )
		self._type = type;
		if( type == HandleTypeEnum.DYNAMICS )then
			self:_init_icon_dynamics();
		elseif( type == HandleTypeEnum.NOTE_HEAD )then
			self._articulation = ArticulationTypeEnum.NOTE_ATTACK;
		elseif( type == HandleTypeEnum.VIBRATO )then
			self:_init_vibrato();
		elseif( type == HandleTypeEnum.LYRIC )then
			self:_init_lyric();
		end
	end
	function this:_init_3( stream, index, lastLine )
		self.index = index;
		local spl;
		local spl2;
		self._type = HandleTypeEnum.VIBRATO;
		self.iconId = "";
		self.ids = "normal";
		self._lyrics = { Lyric.new( "" ) };
		self.original = 0;
		self._caption = "";
		self._length = 0;
		self._startDepth = 0;
		self._depthBP = null;
		self._startRate = 0;
		self._rateBP = null;
		self.language = 0;
		self.program = 0;
		self._duration = 0;
		self._depth = 64;
		local tmpDepthBPX = "";
		local tmpDepthBPY = "";
		local tmpDepthBPNum = "";
		local tmpRateBPX = "";
		local tmpRateBPY = "";
		local tmpRateBPNum = "";
		local tmpDynBPX = "";
		local tmpDynBPY = "";
		local tmpDynBPNum = "";
		lastLine.value = stream:readLine();
		while( lastLine.value:find( "[", 1, true ) ~= 1 )do
			spl = Util.split( lastLine.value, '=' );
			local search = spl[1];
			if( search == "Language" )then
				self._type = HandleTypeEnum.SINGER;
				self.language = tonumber( spl[2], 10 );
			elseif( search == "Program" )then
				self.program = tonumber( spl[2], 10 );
			elseif( search == "IconID" )then
				self.iconId = spl[2];
			elseif( search == "IDS" )then
				self.ids = spl[2];
				for i = 3, #spl, 1 do
					self.ids = self.ids .. "=" .. spl[i];
				end
			elseif( search == "Original" )then
				self.original = tonumber( spl[2], 10 );
			elseif( search == "Caption" )then
				self._caption = spl[2];
				for i = 3, #spl, 1 do
					self._caption = self._caption .. "=" .. spl[i];
				end
			elseif( search == "Length" )then
				self._length = tonumber( spl[2], 10 );
			elseif( search == "StartDepth" )then
				self._startDepth = tonumber( spl[2], 10 );
			elseif( search == "DepthBPNum" )then
				tmpDepthBPNum = spl[2];
			elseif( search == "DepthBPX" )then
				tmpDepthBPX = spl[2];
			elseif( search == "DepthBPY" )then
				tmpDepthBPY = spl[2];
			elseif( search == "StartRate" )then
				self._type = HandleTypeEnum.VIBRATO;
				self._startRate = tonumber( spl[2], 10 );
			elseif( search == "RateBPNum" )then
				tmpRateBPNum = spl[2];
			elseif( search == "RateBPX" )then
				tmpRateBPX = spl[2];
			elseif( search == "RateBPY" )then
				tmpRateBPY = spl[2];
			elseif( search == "Duration" )then
				self._type = HandleTypeEnum.NOTE_HEAD;
				self._duration = tonumber( spl[2], 10 );
			elseif( search == "Depth" )then
				self._depth = tonumber( spl[2], 10 );
			elseif( search == "StartDyn" )then
				self._type = HandleTypeEnum.DYNAMICS;
				self._startDyn = tonumber( spl[2], 10 );
			elseif( search == "EndDyn" )then
				self._type = HandleTypeEnum.DYNAMICS;
				self._endDyn = tonumber( spl[2], 10 );
			elseif( search == "DynBPNum" )then
				tmpDynBPNum = spl[2];
			elseif( search == "DynBPX" )then
				tmpDynBPX = spl[2];
			elseif( search == "DynBPY" )then
				tmpDynBPY = spl[2];
			elseif( search:find( "L" ) == 1 and search:len() >= 2 )then
				local num = search:sub( 2, 2 );
				if( nil ~= tonumber( num ) )then
					local lyric = Lyric.new( spl[2] );
					self._type = HandleTypeEnum.LYRIC;
					local index = tonumber( num );
					self._lyrics[index + 1] = lyric;
				end
			end
			if( not stream:ready() )then
				break;
			end
			lastLine.value = stream:readLine();
		end
		if( self._type == HandleTypeEnum.VIBRATO )then
			if( tmpRateBPNum ~= "" )then
				self._rateBP = VibratoBPList.new( tmpRateBPNum, tmpRateBPX, tmpRateBPY );
			else
				self._rateBP = VibratoBPList.new();
			end
			if( tmpDepthBPNum ~= "" )then
				self._depthBP = VibratoBPList.new( tmpDepthBPNum, tmpDepthBPX, tmpDepthBPY );
			else
				self._depthBP = VibratoBPList.new();
			end
		else
			self._depthBP = VibratoBPList.new();
			self._rateBP = VibratoBPList.new();
		end
		if( tmpDynBPNum ~= "" )then
			self._dynBP = VibratoBPList.new( tmpDynBPNum, tmpDynBPX, tmpDynBPY );
		else
			self._dynBP = VibratoBPList.new();
		end
	end
	function this:_init_vibrato()
		self._articulation = ArticulationTypeEnum.VIBRATO;
		self.index = 0;
		self.iconId = "$04040000";
		self.ids = "";
		self.original = 0;
		self._startRate = 64;
		self._startDepth = 64;
		self._rateBP = VibratoBPList.new();
		self._depthBP = VibratoBPList.new();
	end
	function this:_init_icon_dynamics()
		self._articulation = ArticulationTypeEnum.DYNAFF;
		self.iconId = "";
		self.ids = "";
		self.original = 0;
	end
	function this:_init_lyric()
		self.index = 0;
		self._lyrics = {};
	end
	function this:getArticulation()
		return self._articulation;
	end
	function this:isDynaffType()
		if( nil ~= self.iconId )then
			return self.iconId:find( Handle.ICONID_HEAD_DYNAFF ) == 1;
		else
			return false;
		end
	end
	function this:isCrescendType()
		if( nil ~= self.iconId )then
			return self.iconId:find( Handle.ICONID_HEAD_CRESCEND ) == 1;
		else
			return false;
		end
	end
	function this:isDecrescendType()
		if( nil ~= self.iconId )then
			return self.iconId:find( Handle.ICONID_HEAD_DECRESCEND ) == 1;
		else
			return false;
		end
	end
	function this:getLength()
		return self._length;
	end
	function this:setLength( value )
		self._length = value;
	end
	function this:getCaption()
		return self._caption;
	end
	function this:setCaption( value )
		self._caption = value;
	end
	function this:getStartDyn()
		return self._startDyn;
	end
	function this:setStartDyn( value )
		self._startDyn = value;
	end
	function this:getEndDyn()
		return self._endDyn;
	end
	function this:setEndDyn( value )
		self._endDyn = value;
	end
	function this:getDynBP()
		return self._dynBP;
	end
	function this:setDynBP( value )
		self._dynBP = value;
	end
	function this:getDepth()
		return self._depth;
	end
	function this:setDepth( value )
		self._depth = value;
	end
	function this:getDuration()
		return self._duration;
	end
	function this:setDuration( value )
		self._duration = value;
	end
	function this:getRateBP()
		return self._rateBP;
	end
	function this:setRateBP( value )
		self._rateBP = value;
	end
	function this:getDepthBP()
		return self._depthBP;
	end
	function this:setDepthBP( value )
		self._depthBP = value;
	end
	function this:getStartRate()
		return self._startRate;
	end
	function this:setStartRate( value )
		self._startRate = value;
	end
	function this:getStartDepth()
		return self._startDepth;
	end
	function this:setStartDepth( value )
		self._startDepth = value;
	end
	function this:getLyricAt( index )
		return self._lyrics[index + 1];
	end
	function this:setLyricAt( index, value )
		if( index + 1 >= #self._lyrics )then
			local remain = index + 1 - #self._lyrics;
			local i;
			for i = 1, remain, 1 do
				table.insert( self._lyrics, false );
			end
		end
		self._lyrics[index + 1] = value;
	end
	function this:getLyricCount()
		return #self._lyrics;
	end
	function this:getDisplayString()
		return self.ids .. self._caption;
	end
	function this:getHandleType()
		return self._type;
	end
	function this:write( stream )
		stream:writeLine( self:toString() );
	end
	function this:toString()
		local result = "";
		result = result .. "[h#" .. string.format( "%04d", self.index ) .. "]";
		if( self._type == HandleTypeEnum.LYRIC )then
			for i = 1, #self._lyrics, 1 do
				result = result .. "\n" .. "L" .. (i - 1) .. "=" .. self._lyrics[i]:toString( self.addQuotationMark );
			end
		elseif( self._type == HandleTypeEnum.VIBRATO )then
			result = result .. "\n" .. "IconID=" .. self.iconId .. "\n";
			result = result .. "IDS=" .. self.ids .. "\n";
			result = result .. "Original=" .. self.original .. "\n";
			result = result .. "Caption=" .. self._caption .. "\n";
			result = result .. "Length=" .. self._length .. "\n";
			result = result .. "StartDepth=" .. self._startDepth .. "\n";
			result = result .. "DepthBPNum=" .. self._depthBP:size() .. "\n";
			if( self._depthBP:size() > 0 )then
				result = result .. "DepthBPX=" .. string.format( "%.6f", self._depthBP:get( 0 ).x );
				for i = 1, self._depthBP:size() - 1, 1 do
					result = result .. "," .. string.format( "%.6f", self._depthBP:get( i ).x );
				end
				result = result .. "\n" .. "DepthBPY=" .. self._depthBP:get( 0 ).y;
				for i = 1, self._depthBP:size() - 1, 1 do
					result = result .. "," .. self._depthBP:get( i ).y;
				end
				result = result .. "\n";
			end
			result = result .. "StartRate=" .. self._startRate .. "\n";
			result = result .. "RateBPNum=" .. self._rateBP:size();
			if( self._rateBP:size() > 0 )then
				result = result .. "\n" .. "RateBPX=" .. string.format( "%.6f", self._rateBP:get( 0 ).x );
				for i = 1, self._rateBP:size() - 1, 1 do
					result = result .. "," .. string.format( "%.6f", self._rateBP:get( i ).x );
				end
				result = result .. "\n" .. "RateBPY=" .. self._rateBP:get( 0 ).y;
				for i = 1, self._rateBP:size() - 1, 1 do
					result = result .. "," .. self._rateBP:get( i ).y;
				end
			end
		elseif( self._type == HandleTypeEnum.SINGER )then
			result = result .. "\n" .. "IconID=" .. self.iconId .. "\n";
			result = result .. "IDS=" .. self.ids .. "\n";
			result = result .. "Original=" .. self.original .. "\n";
			result = result .. "Caption=" .. self._caption .. "\n";
			result = result .. "Length=" .. self._length .. "\n";
			result = result .. "Language=" .. self.language .. "\n";
			result = result .. "Program=" .. self.program;
		elseif( self._type == HandleTypeEnum.NOTE_HEAD )then
			result = result .. "\n" .. "IconID=" .. self.iconId .. "\n";
			result = result .. "IDS=" .. self.ids .. "\n";
			result = result .. "Original=" .. self.original .. "\n";
			result = result .. "Caption=" .. self._caption .. "\n";
			result = result .. "Length=" .. self._length .. "\n";
			result = result .. "Duration=" .. self._duration .. "\n";
			result = result .. "Depth=" .. self._depth;
		elseif( self._type == HandleTypeEnum.DYNAMICS )then
			result = result .. "\n" .. "IconID=" .. self.iconId .. "\n";
			result = result .. "IDS=" .. self.ids .. "\n";
			result = result .. "Original=" .. self.original .. "\n";
			result = result .. "Caption=" .. self._caption .. "\n";
			result = result .. "StartDyn=" .. self._startDyn .. "\n";
			result = result .. "EndDyn=" .. self._endDyn .. "\n";
			result = result .. "Length=" .. self:getLength() .. "\n";
			if( nil ~= self._dynBP )then
				if( self._dynBP:size() <= 0 )then
					result = result .. "DynBPNum=0";
				else
					local c = self._dynBP:size();
					result = result .. "DynBPNum=" .. c .. "\n";
					result = result .. "DynBPX=" .. string.format( "%.6f", self._dynBP:get( 0 ).x );
					for i = 1, c - 1, 1 do
						result = result .. "," .. string.format( "%.6f", self._dynBP:get( i ).x );
					end
					result = result .. "\n" .. "DynBPY=" .. self._dynBP:get( 0 ).y;
					for i = 1, c - 1, 1 do
						result = result .. "," .. self._dynBP:get( i ).y;
					end
				end
			else
				result = result .. "DynBPNum=0";
			end
		end
		return result;
	end
	function this:clone()
		if( self._type == HandleTypeEnum.DYNAMICS )then
			local ret = Handle.new( HandleTypeEnum.DYNAMICS );
			ret.iconId = self.iconId;
			ret.ids = self.ids;
			ret.original = self.original;
			ret:setCaption( self:getCaption() );
			ret:setStartDyn( self:getStartDyn() );
			ret:setEndDyn( self:getEndDyn() );
			if( nil ~= self._dynBP )then
				ret:setDynBP( self._dynBP:clone() );
			end
			ret:setLength( self:getLength() );
			return ret;
		elseif( self._type == HandleTypeEnum.LYRIC )then
			local result = Handle.new( HandleTypeEnum.LYRIC );
			result.index = self.index;
			result._lyrics = {};
			for i = 1, #self._lyrics, 1 do
				local buf = self._lyrics[i]:clone();
				table.insert( result._lyrics, buf );
			end
			return result;
		elseif( self._type == HandleTypeEnum.NOTE_HEAD )then
			local result = Handle.new( HandleTypeEnum.NOTE_HEAD );
			result.index = self.index;
			result.iconId = self.iconId;
			result.ids = self.ids;
			result.original = self.original;
			result:setCaption( self:getCaption() );
			result:setLength( self:getLength() );
			result:setDuration( self:getDuration() );
			result:setDepth( self:getDepth() );
			return result;
		elseif( self._type == HandleTypeEnum.SINGER )then
			local ret = Handle.new( HandleTypeEnum.SINGER );
			ret._caption = self._caption;
			ret.iconId = self.iconId;
			ret.ids = self.ids;
			ret.index = self.index;
			ret.language = self.language;
			ret:setLength( self._length );
			ret.original = self.original;
			ret.program = self.program;
			return ret;
		elseif( self._type == HandleTypeEnum.VIBRATO )then
			local result = Handle.new( HandleTypeEnum.VIBRATO );
			result.index = self.index;
			result.iconId = self.iconId;
			result.ids = self.ids;
			result.original = self.original;
			result:setCaption( self._caption );
			result:setLength( self:getLength() );
			result:setStartDepth( self._startDepth );
			if( nil ~= self._depthBP )then
				result:setDepthBP( self._depthBP:clone() );
			end
			result:setStartRate( self._startRate );
			if( nil ~= self._rateBP )then
				result:setRateBP( self._rateBP:clone() );
			end
			return result;
		end
	end
	if( #arguments == 0 )then
		assert( false, "too few argument" );
		print( "Handle.new; #arguments=0" );
	elseif( #arguments == 1 )then
		this:_init_1( arguments[1] );
	elseif( #arguments == 3 )then
		this:_init_3( arguments[1], arguments[2], arguments[3] );
	end
	return this;
end
function Handle.getHandleIndexFromString( s )
	local spl = Util.split( s, "#" );
	return tonumber( spl[2], 10 );
end
HandleTypeEnum = {
	LYRIC = 0,
	VIBRATO = 1,
	SINGER = 2,
	NOTE_HEAD = 3,
	DYNAMICS = 4
};
if( nil == List )then
	List = {};
end
function List.new( ... )
	local this = {};
	local arguments = { ... };
	this._array = {};
	function this:_init_0()
	end
	function this:_init_1( count )
	end
	function this:get( index )
		return self[index];
	end
	function this:set( index, value )
		self[index] = value;
	end
	function this:iterator()
		return List.Iterator.new( self );
	end
	function this:_sort_1( comparator )
		local wrappedComparator = function( a, b )
			local actualA = a["value"];
			local actualB = b["value"];
			return comparator( actualA, actualB );
		end
		table.sort( self._array, wrappedComparator );
	end
	function this:_sort_0()
		local wrappedComparator = function( a, b )
			local actualA = a["value"];
			local actualB = b["value"];
			return actualA < actualB;
		end
		table.sort( self._array, wrappedComparator );
	end
	function this:sort( ... )
		local arguments = { ... };
		local wrappedComparator = nil;
		if( #arguments > 0 )then
			self:_sort_1( arguments[1] );
		else
			self:_sort_0();
		end
	end
	function this:push( value )
		table.insert( self._array, { ["value"] = value } );
	end
	function this:size()
		return #self._array;
	end
	function this:_setupMetaTable()
		local metaTable = {};
		metaTable.__index = function( _table, _key )
			return _table._array[_key + 1]["value"];
		end
		metaTable.__newindex = function( _table, _key, _value )
			_table._array[_key + 1] = { ["value"] = _value };
		end
		setmetatable( self, metaTable );
	end
	this:_setupMetaTable();
	if( #arguments > 0 )then
		local count = arguments[1];
		local i;
		for i = 1, count, 1 do
			this:push( nil );
		end
	end
	return this;
end
function List.fromTable( array )
	local list = List.new();
	local i;
	for i = 1, #array, 1 do
		table.insert( list._array, { ["value"] = array[i] } );
	end
	return list;
end
if( nil == List )then
	List = {};
end
List.Iterator = {};
function List.Iterator.new( list )
	local this = {};
	this._list = list;
	this._pos = -1;
	function this:hasNext()
		return (0 <= self._pos + 1 and self._pos + 1 < self._list:size())
	end
	function this:next()
		self._pos = self._pos + 1;
		return self._list[self._pos];
	end
	return this;
end
Log = {};
Log._level = 0;
Log._fileHandle = nil;
function Log.setLevel( level )
	Log._level = level;
end
function Log.print( message )
	if( Log._level > 0 )then
		local fp = Log._getFileHandle();
		fp:write( message );
		fp:flush();
	end
end
function Log.println( message )
	if( Log._level > 0 )then
		local fp = Log._getFileHandle();
		fp:write( message .. "\n" );
		fp:flush();
	end
end
function Log._getFileHandle()
	if( Log._fileHandle == nil )then
		Log._fileHandle = io.open( "..\\luavsq.log", "a" );
		Log._fileHandle:write( "========================================================================\n" );
		Log._fileHandle:write( "Log start: " .. os.date() .. "\n" );
	end
	return Log._fileHandle;
end
Lyric = {};
function Lyric.new( ... )
	local arguments = { ... }
	local this = {};
	this.phrase = "a";
	this.lengthRatio = 1.0;
	this.isProtected = false;
	this._phoneticSymbol = { "a" };
	this._consonantAdjustment = { 0 };
	function this:_init_1( line )
		if( line == nil or (line ~= nil and line:len() == 0) )then
			self.phrase = "a";
			self:setPhoneticSymbol( "a" );
			self.lengthRatio = 1.0;
			self.isProtected = false;
			self:setConsonantAdjustment( "0" );
			return;
		end
		local len = line:len();
		local indx = 0;
		local dquote_count = 0;
		local work = "";
		local consonantAdjustment = "";
		for i = 1, len, 1 do
			local c = line:sub( i, i );
			if( c == ',' or i == len )then
				if( i == len )then
					work = work .. c;
				end
				if( dquote_count % 2 == 0 )then
					indx = indx + 1;
					local search = "\"";
					if( indx == 1 )then
						work = work:gsub( "\"\"", "\"" );  
						if( work:find( search ) == 0 and work.lastIndexOf( search ) == (work:len() - search:len()) )then
							local l = work:len();
							if( l > 2 )then
								self.phrase = work:sub( 1, l - 3 );
							else
								self.phrase = "a";
							end
						else
							self.phrase = work;
						end
						work = "";
					elseif( indx == 2 )then
						local symbols = "";
						if( (work:find( search ) == 0) and (work.lastIndexOf( search ) == (work:len() - search:len())) )then
							local l = work:len();
							if( l > 2 )then
								symbols = work:sub( 1, l - 3 );
							else
								symbols = "a";
							end
						else
							symbols = work;
						end
						self:setPhoneticSymbol( symbols );
						work = "";
					elseif( indx == 3 )then
						self.lengthRatio = work + 0.0;
						work = "";
					else
						if( indx - 3 <= #self._phoneticSymbol )then
							if( indx - 3 == 1 )then
								consonantAdjustment = consonantAdjustment .. work;
							else
								consonantAdjustment = consonantAdjustment .. "," .. work;
							end
						else
							self.isProtected = (work == "1");
						end
						work = "";
					end
				else
					work = work .. "" .. c;
				end
			else
				work = work .. "" .. c;
				if( c == '"' )then
					dquote_count = dquote_count + 1;
				end
			end
		end
		self:setConsonantAdjustment( consonantAdjustment );
	end
	function this:_init_2( phrase, phoneticSymbol )
		self.phrase = phrase;
		self._consonantAdjustment = nil;
		self:setPhoneticSymbol( phoneticSymbol );
		self.lengthRatio = 1.0;
		self.isProtected = false;
	end
	function this:equalsForSynth( item )
		if( self:getPhoneticSymbol() ~= item:getPhoneticSymbol() )then
			return false;
		end
		if( self:getConsonantAdjustment() ~= item:getConsonantAdjustment() )then
			return false;
		end
		return true;
	end
	function this:equals( item )
		if( not self:equalsForSynth( item ) )then
			return false;
		end
		if( self.isProtected ~= item.isProtected )then
			return false;
		end
		if( self.phrase ~= item.phrase )then
			return false;
		end
		if( self.lengthRatio ~= item.lengthRatio )then
			return false;
		end
		return true;
	end
	function this:getConsonantAdjustment()
		local arr = self:getConsonantAdjustmentList();
		if( #arr == 0 )then
			return "";
		end
		local ret = arr[1];
		for i = 2, #arr, 1 do
			ret = ret .. " " .. arr[i];
		end
		return "" .. ret;
	end
	function this:setConsonantAdjustment( value )
		local spl = Util.split( value, "," );
		local arr = Util.array( #spl );
		for i = 1, #spl, 1 do
			arr[i] = tonumber( spl[i] );
		end
		self:setConsonantAdjustmentList( arr );
	end
	function this:getConsonantAdjustmentList()
		if( self._consonantAdjustment == nil )then
			if( self._phoneticSymbol == nil )then
				self._consonantAdjustment = {};
			else
				self._consonantAdjustment = Util.array( #self._phoneticSymbol );
				for i = 1, #self._phoneticSymbol, 1 do
					local consonantAdjustment;
					if( PhoneticSymbol.isConsonant( self._phoneticSymbol[i] ) )then
						consonantAdjustment = 64;
					else
						consonantAdjustment = 0;
					end
					self._consonantAdjustment[i] = consonantAdjustment;
				end
			end
		end
		return self._consonantAdjustment;
	end
	function this:setConsonantAdjustmentList( value )
		if( value == nil )then
			return;
		end
		self._consonantAdjustment = Util.array( #value );
		for i = 1, #value, 1 do
			self._consonantAdjustment[i] = value[i];
		end
	end
	function this:clone()
		local result = Lyric.new();
		result.phrase = self.phrase;
		result._phoneticSymbol = Util.array( #self._phoneticSymbol );
		for i = 1, #self._phoneticSymbol, 1 do
			result._phoneticSymbol[i] = self._phoneticSymbol[i];
		end
		result.lengthRatio = self.lengthRatio;
		if( nil == self._consonantAdjustment )then
			result._consonantAdjustment = nil;
		else
			result._consonantAdjustment = Util.array( #self._consonantAdjustment );
			for i = 1, #self._consonantAdjustment, 1 do
				result._consonantAdjustment[i] = self._consonantAdjustment[i];
			end
		end
		result.isProtected = self.isProtected;
		return result;
	end
	function this:getPhoneticSymbol()
		local symbol = self:getPhoneticSymbolList();
		if( #symbol == 0 )then
			return "";
		end
		local result = symbol[1];
		for i = 2, #symbol, 1 do
			result = result .. " " .. symbol[i];
		end
		return result;
	end
	function this:setPhoneticSymbol( value )
		local s = value:gsub( "  ", " " );
		self._phoneticSymbol = Util.split( s, " " );
		for i = 1, #self._phoneticSymbol, 1 do
			self._phoneticSymbol[i] = self._phoneticSymbol[i]:gsub( "\\" .. "\\", "\\" );
		end
	end
	function this:getPhoneticSymbolList()
		local ret = Util.array( #self._phoneticSymbol );
		for i = 1, #self._phoneticSymbol, 1 do
			ret[i] = self._phoneticSymbol[i];
		end
		return ret;
	end
	function this:toString( addQuateMark )
		local quot;
		if( addQuateMark )then
			quot = "\"";
		else
			quot = "";
		end
		local result;
		result = quot .. self.phrase .. quot .. ",";
		local symbol = self:getPhoneticSymbolList();
		local strSymbol = self:getPhoneticSymbol();
		if( not addQuateMark )then
			if( (strSymbol == nil) or (strSymbol ~= nil and strSymbol == "" ) )then
				strSymbol = "u:";
			end
		end
		result = result .. quot .. strSymbol .. quot .. "," .. self.lengthRatio;
		result = result:gsub( "\\" .. "\\", "\\" );
		if( self._consonantAdjustment == nil )then
			self._consonantAdjustment = Util.array( #symbol );
			for i = 1, #symbol, 1 do
				local consonantAdjustment;
				if( PhoneticSymbol.isConsonant( symbol[i] ) )then
					consonantAdjustment = 64;
				else
					consonantAdjustment = 0;
				end
				self._consonantAdjustment[i] = consonantAdjustment;
			end
		end
		for i = 1, #self._consonantAdjustment, 1 do
			result = result .. "," .. self._consonantAdjustment[i];
		end
		if( self.isProtected )then
			result = result .. ",1";
		else
			result = result .. ",0";
		end
		return result;
	end
	if( #arguments == 1 )then
		this:_init_1( arguments[1] );
	elseif( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	end
	return this;
end
Master = {};
function Master.new( ... )
	local this = {};
	local arguments = { ... };
	this.preMeasure = 1;
	function this:_init_1( preMeasure )
		self.preMeasure = preMeasure;
	end
	function this:_init_2( stream, lastLine )
		self.preMeasure = 0;
		local spl;
		lastLine.value = stream:readLine();
		while( lastLine.value:find( "[", 1, true ) ~= 1 )do
			spl = Util.split( lastLine.value, "=" );
			if( spl[1] == "PreMeasure" )then
				self.preMeasure = tonumber( spl[2], 10 );
			end
			if( not stream:ready() )then
				break;
			end
			lastLine.value = stream:readLine();
		end
	end
	function this:clone()
		return Master.new( self.preMeasure );
	end
	function this:write( stream )
		stream:writeLine( "[Master]" );
		stream:writeLine( "PreMeasure=" .. self.preMeasure );
	end
	if( #arguments == 1 )then
		this:_init_1( arguments[1] );
	elseif( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	end
	return this;
end
MidiEvent = {};
function MidiEvent.new()
	local this = {};
	this.clock = 0;
	this.firstByte = 0;
	this.data = {};
	function this:writeData( stream )
		stream:write( self.firstByte );
		if( self.firstByte == 0xff )then
			stream:write( self.data[1] );
			MidiEvent.writeDeltaClock( stream, #self.data - 1 );
			stream:write( self.data, 2, #self.data - 1 );
		else
			stream:write( self.data, 1, #self.data );
		end
	end
	function this:compareTo( item )
		if( self.clock ~= item.clock )then
			return self.clock - item.clock;
		else
			local first_this = Util.band( self.firstByte, 0xf0 );
			local first_item = Util.band( item.firstByte, 0xf0 );
			if( (first_this == 0x80 or first_this == 0x90) and (first_item == 0x80 or first_item == 0x90) )then
				if( self.data ~= nil and #self.data >= 2 and item.data ~= nil and #item.data >= 2 )then
					if( first_item == 0x90 and item.data[2] == 0 )then
						first_item = 0x80;
					end
					if( first_this == 0x90 and self.data[2] == 0 )then
						first_this = 0x80;
					end
					if( self.data[1] == item.data[1] )then
						if( first_this == 0x90 )then
							if( first_item == 0x80 )then
								return 1;
							else
								return 0;
							end
						else
							if( first_item == 0x80 )then
								return 0;
							else
								return -1;
							end
						end
					end
				end
			end
			return self.clock - item.clock;
		end
	end
	return this;
end
function MidiEvent.generateTimeSigEvent( clock, numerator, denominator )
	local ret = MidiEvent.new();
	ret.clock = clock;
	ret.firstByte = 0xff;
	local b_numer = math.floor( math.log( denominator ) / math.log( 2 ) + 0.1 );
	ret.data = { 0x58, numerator, b_numer, 0x18, 0x08 };
	return ret;
end
function MidiEvent.generateTempoChangeEvent( clock, tempo )
	local ret = MidiEvent.new();
	ret.clock = clock;
	ret.firstByte = 0xff;
	local b1 = Util.band( tempo, 0xff );
	tempo = Util.rshift( tempo, 8 );
	local b2 = Util.band( tempo, 0xff );
	tempo = Util.rshift( tempo, 8 );
	local b3 = Util.band( tempo, 0xff );
	ret.data = { 0x51, b3, b2, b1 };
	return ret;
end
MidiEvent._x = {};
local i;
for i = 0, 64, 1 do
	MidiEvent._x[i + 1] = math.pow( 2, i );
end
function MidiEvent.writeDeltaClock( stream, number )
	local bits = {};
	local p = MidiEvent._x[1];
	local p2;
	local first = 0;
	local p2 = MidiEvent._x[65];
	for i = 63, 0, -1 do
		p = MidiEvent._x[i + 1];
		local b = (number % p2 >= p);
		p2 = p;
		bits[i + 1] = b;
		if( first == 0 and b )then
			first = i;
		end
	end
	local bytes = math.floor( first / 7 ) + 1;
	for i = 1, bytes, 1 do
		local num = 0;
		local count = 0x80;
		local j;
		local startJ = (bytes - i + 1) * 7 - 1;
		for j = startJ, startJ - 6, -1 do
			count = count / 2;
			if( bits[j + 1] )then
				num = num + count;
			end
		end
		if( i ~= bytes )then
			num = num + 0x80;
		end
		stream:write( num );
	end
end
function MidiEvent.compare( a, b )
	return (a:compareTo( b ) < 0);
end
MidiParameterEnum = {
	CVM_NM_VERSION_AND_DEVICE = 0x5000,
	CVM_NM_DELAY = 0x5001,
	CVM_NM_NOTE_NUMBER = 0x5002,
	CVM_NM_VELOCITY = 0x5003,
	CVM_NM_NOTE_DURATION = 0x5004,
	CVM_NM_NOTE_LOCATION = 0x5005,
	CVM_NM_ATTACK_TYPE = 0x5006,
	CVM_NM_ATTACK_DURATION = 0x5007,
	CVM_NM_ATTACK_DEPTH = 0x5008,
	CVM_NM_INDEX_OF_VIBRATO_DB = 0x500c,
	CVM_NM_VIBRATO_CONFIG = 0x500d,
	CVM_NM_VIBRATO_DELAY = 0x500e,
	CVM_NM_UNKNOWN1 = 0x5011,
	CVM_NM_PHONETIC_SYMBOL_BYTES = 0x5012,
	CVM_NM_PHONETIC_SYMBOL1 = 0x5013,
	CVM_NM_PHONETIC_SYMBOL2 = 0x5014,
	CVM_NM_PHONETIC_SYMBOL3 = 0x5015,
	CVM_NM_PHONETIC_SYMBOL4 = 0x5016,
	CVM_NM_PHONETIC_SYMBOL5 = 0x5017,
	CVM_NM_PHONETIC_SYMBOL6 = 0x5018,
	CVM_NM_PHONETIC_SYMBOL7 = 0x5019,
	CVM_NM_PHONETIC_SYMBOL8 = 0x501a,
	CVM_NM_PHONETIC_SYMBOL9 = 0x501b,
	CVM_NM_PHONETIC_SYMBOL10 = 0x501c,
	CVM_NM_PHONETIC_SYMBOL11 = 0x501d,
	CVM_NM_PHONETIC_SYMBOL12 = 0x501e,
	CVM_NM_PHONETIC_SYMBOL13 = 0x501f,
	CVM_NM_PHONETIC_SYMBOL14 = 0x5020,
	CVM_NM_PHONETIC_SYMBOL15 = 0x5021,
	CVM_NM_PHONETIC_SYMBOL16 = 0x5022,
	CVM_NM_PHONETIC_SYMBOL17 = 0x5023,
	CVM_NM_PHONETIC_SYMBOL18 = 0x5024,
	CVM_NM_PHONETIC_SYMBOL19 = 0x5025,
	CVM_NM_PHONETIC_SYMBOL20 = 0x5026,
	CVM_NM_PHONETIC_SYMBOL21 = 0x5027,
	CVM_NM_PHONETIC_SYMBOL22 = 0x5028,
	CVM_NM_PHONETIC_SYMBOL23 = 0x5029,
	CVM_NM_PHONETIC_SYMBOL24 = 0x502a,
	CVM_NM_PHONETIC_SYMBOL25 = 0x502b,
	CVM_NM_PHONETIC_SYMBOL26 = 0x502c,
	CVM_NM_PHONETIC_SYMBOL27 = 0x502d,
	CVM_NM_PHONETIC_SYMBOL28 = 0x502e,
	CVM_NM_PHONETIC_SYMBOL29 = 0x502f,
	CVM_NM_PHONETIC_SYMBOL30 = 0x5030,
	CVM_NM_PHONETIC_SYMBOL31 = 0x5031,
	CVM_NM_PHONETIC_SYMBOL32 = 0x5032,
	CVM_NM_PHONETIC_SYMBOL33 = 0x5033,
	CVM_NM_PHONETIC_SYMBOL34 = 0x5034,
	CVM_NM_PHONETIC_SYMBOL35 = 0x5035,
	CVM_NM_PHONETIC_SYMBOL36 = 0x5036,
	CVM_NM_PHONETIC_SYMBOL37 = 0x5037,
	CVM_NM_PHONETIC_SYMBOL38 = 0x5038,
	CVM_NM_PHONETIC_SYMBOL39 = 0x5039,
	CVM_NM_PHONETIC_SYMBOL40 = 0x503a,
	CVM_NM_PHONETIC_SYMBOL41 = 0x503b,
	CVM_NM_PHONETIC_SYMBOL42 = 0x503c,
	CVM_NM_PHONETIC_SYMBOL43 = 0x503d,
	CVM_NM_PHONETIC_SYMBOL44 = 0x503e,
	CVM_NM_PHONETIC_SYMBOL45 = 0x503f,
	CVM_NM_PHONETIC_SYMBOL46 = 0x5040,
	CVM_NM_PHONETIC_SYMBOL47 = 0x5041,
	CVM_NM_PHONETIC_SYMBOL48 = 0x5042,
	CVM_NM_PHONETIC_SYMBOL49 = 0x5043,
	CVM_NM_PHONETIC_SYMBOL50 = 0x5044,
	CVM_NM_PHONETIC_SYMBOL51 = 0x5045,
	CVM_NM_PHONETIC_SYMBOL52 = 0x5046,
	CVM_NM_PHONETIC_SYMBOL53 = 0x5047,
	CVM_NM_PHONETIC_SYMBOL54 = 0x5048,
	CVM_NM_PHONETIC_SYMBOL55 = 0x5049,
	CVM_NM_PHONETIC_SYMBOL56 = 0x504a,
	CVM_NM_PHONETIC_SYMBOL57 = 0x504b,
	CVM_NM_PHONETIC_SYMBOL58 = 0x504c,
	CVM_NM_PHONETIC_SYMBOL59 = 0x504d,
	CVM_NM_PHONETIC_SYMBOL60 = 0x504e,
	CVM_NM_PHONETIC_SYMBOL_CONTINUATION = 0x504f,
	CVM_NM_V1MEAN = 0x5050,
	CVM_NM_D1MEAN = 0x5051,
	CVM_NM_D1MEAN_FIRST_NOTE = 0x5052,
	CVM_NM_D2MEAN = 0x5053,
	CVM_NM_D4MEAN = 0x5054,
	CVM_NM_PMEAN_ONSET_FIRST_NOTE = 0x5055,
	CVM_NM_VMEAN_NOTE_TRNSITION = 0x5056,
	CVM_NM_PMEAN_ENDING_NOTE = 0x5057,
	CVM_NM_ADD_PORTAMENTO = 0x5058,
	CVM_NM_CHANGE_AFTER_PEAK = 0x5059,
	CVM_NM_ACCENT = 0x505a,
	CVM_NM_NOTE_MESSAGE_CONTINUATION = 0x507f,
	CVM_EXNM_VOICE_OVERLAP = 0x5075,
	CVM_EXNM_FLAGS_BYTES = 0x5076,
	CVM_EXNM_FLAGS = 0x5077,
	CVM_EXNM_FLAGS_CONINUATION = 0x5078,
	CVM_EXNM_MODURATION = 0x5079,
	CVM_EXNM_PRE_UTTERANCE = 0x507a,
	CVM_EXNM_ENV_DATA1 = 0x507e,
	CVM_EXNM_ENV_DATA2 = 0x507d,
	CVM_EXNM_ENV_DATA3 = 0x507c,
	CVM_EXNM_ENV_DATA_CONTINUATION = 0x507b,
	CC_BS_VERSION_AND_DEVICE = 0x6000,
	CC_BS_DELAY = 0x6001,
	CC_BS_LANGUAGE_TYPE = 0x6002,
	CC_CV_VERSION_AND_DEVICE = 0x6100,
	CC_CV_DELAY = 0x6101,
	CC_CV_VOLUME = 0x6102,
	CC_P_VERSION_AND_DEVICE = 0x6200,
	CC_P_DELAY = 0x6201,
	CC_PAN = 0x6202,
	CC_E_VESION_AND_DEVICE = 0x6300,
	CC_E_DELAY = 0x6301,
	CC_E_EXPRESSION = 0x6302,
	CC_VR_VERSION_AND_DEVICE = 0x6400,
	CC_VR_DELAY = 0x6401,
	CC_VR_VIBRATO_RATE = 0x6402,
	CC_VD_VERSION_AND_DEVICE = 0x6500,
	CC_VD_DELAY = 0x6501,
	CC_VD_VIBRATO_DEPTH = 0x6502,
	CC_FX2_VERSION_AND_DEVICE = 0x6600,
	CC_FX2_DELAY = 0x6601,
	CC_FX2_EFFECT2_DEPTH = 0x6602,
	CC_PBS_VERSION_AND_DEVICE = 0x6700,
	CC_PBS_DELAY = 0x6701,
	CC_PBS_PITCH_BEND_SENSITIVITY = 0x6702,
	PC_VERSION_AND_DEVICE = 0x5300,
	PC_DELAY = 0x5301,
	PC_VOICE_TYPE = 0x5302,
	PB_VERSION_AND_DEVICE = 0x5400,
	PB_DELAY = 0x5401,
	PB_PITCH_BEND = 0x5402,
	VCP_VERSION_AND_DEVICE = 0x5500,
	VCP_DELAY = 0x5501,
	VCP_VOICE_CHANGE_PARAMETER_ID = 0x5502,
	VCP_VOICE_CHANGE_PARAMETER = 0x5503,
};
function MidiParameterEnum.getVoiceChangeParameterId( curveName )
	local lsb = 0x31;
	if( nil == curveName )then
		return nil;
	end
	curveName = curveName:lower();
	if( curveName == "harmonics" )then
		lsb = 0x30;
	elseif( curveName == "bre" )then
		lsb = 0x31;
	elseif( curveName == "bri" )then
		lsb = 0x32;
	elseif( curveName == "cle" )then
		lsb = 0x33;
	elseif( curveName == "por" )then
		lsb = 0x34;
	elseif( curveName == "ope" )then
		lsb = 0x35;
	elseif( curveName == "reso1freq" )then
		lsb = 0x40;
	elseif( curveName == "reso2freq" )then
		lsb = 0x41;
	elseif( curveName == "reso3freq" )then
		lsb = 0x42;
	elseif( curveName == "reso4freq" )then
		lsb = 0x43;
	elseif( curveName == "reso1bw" )then
		lsb = 0x50;
	elseif( curveName == "reso2bw" )then
		lsb = 0x51;
	elseif( curveName == "reso3bw" )then
		lsb = 0x52;
	elseif( curveName == "reso4bw" )then
		lsb = 0x53;
	elseif( curveName == "reso1amp" )then
		lsb = 0x60;
	elseif( curveName == "reso2amp" )then
		lsb = 0x61;
	elseif( curveName == "reso3amp" )then
		lsb = 0x62;
	elseif( curveName == "reso4amp" )then
		lsb = 0x63;
	elseif( curveName == "gen" )then
		lsb = 0x70;
	end
	return lsb;
end
function MidiParameterEnum.isDataLsbRequire( nrpn )
	if( nrpn == MidiParameterEnum.CVM_NM_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CVM_NM_DELAY or
		nrpn == MidiParameterEnum.CVM_NM_NOTE_DURATION or
		nrpn == MidiParameterEnum.CVM_NM_INDEX_OF_VIBRATO_DB or
		nrpn == MidiParameterEnum.CVM_NM_VIBRATO_CONFIG or
		nrpn == MidiParameterEnum.CVM_NM_PHONETIC_SYMBOL1 or
		nrpn == MidiParameterEnum.CC_BS_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_BS_DELAY or
		nrpn == MidiParameterEnum.CC_BS_LANGUAGE_TYPE or
		nrpn == MidiParameterEnum.CC_CV_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_CV_DELAY or
		nrpn == MidiParameterEnum.CC_P_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_P_DELAY or
		nrpn == MidiParameterEnum.CC_E_VESION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_E_DELAY or
		nrpn == MidiParameterEnum.CC_VR_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_VR_DELAY or
		nrpn == MidiParameterEnum.CC_VD_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_VD_DELAY or
		nrpn == MidiParameterEnum.CC_FX2_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_FX2_DELAY or
		nrpn == MidiParameterEnum.CC_PBS_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.CC_PBS_DELAY or
		nrpn == MidiParameterEnum.CC_PBS_PITCH_BEND_SENSITIVITY or
		nrpn == MidiParameterEnum.PC_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.PC_DELAY or
		nrpn == MidiParameterEnum.PB_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.PB_DELAY or
		nrpn == MidiParameterEnum.PB_PITCH_BEND or
		nrpn == MidiParameterEnum.VCP_VERSION_AND_DEVICE or
		nrpn == MidiParameterEnum.VCP_DELAY or
		nrpn == MidiParameterEnum.CVM_EXNM_ENV_DATA1 or
		nrpn == MidiParameterEnum.CVM_EXNM_ENV_DATA2 )then
		return true;
	elseif( nrpn == MidiParameterEnum.CVM_NM_NOTE_NUMBER or
		nrpn == MidiParameterEnum.CVM_NM_VELOCITY or
		nrpn == MidiParameterEnum.CVM_NM_NOTE_LOCATION or
		nrpn == MidiParameterEnum.CVM_NM_VIBRATO_DELAY or
		nrpn == MidiParameterEnum.CVM_NM_PHONETIC_SYMBOL_BYTES or
		nrpn == MidiParameterEnum.CVM_NM_PHONETIC_SYMBOL_CONTINUATION or
		nrpn == MidiParameterEnum.CVM_NM_V1MEAN or
		nrpn == MidiParameterEnum.CVM_NM_D1MEAN or
		nrpn == MidiParameterEnum.CVM_NM_D1MEAN_FIRST_NOTE or
		nrpn == MidiParameterEnum.CVM_NM_D2MEAN or
		nrpn == MidiParameterEnum.CVM_NM_D4MEAN or
		nrpn == MidiParameterEnum.CVM_NM_PMEAN_ONSET_FIRST_NOTE or
		nrpn == MidiParameterEnum.CVM_NM_VMEAN_NOTE_TRNSITION or
		nrpn == MidiParameterEnum.CVM_NM_PMEAN_ENDING_NOTE or
		nrpn == MidiParameterEnum.CVM_NM_ADD_PORTAMENTO or
		nrpn == MidiParameterEnum.CVM_NM_CHANGE_AFTER_PEAK or
		nrpn == MidiParameterEnum.CVM_NM_ACCENT or
		nrpn == MidiParameterEnum.CVM_NM_NOTE_MESSAGE_CONTINUATION or
		nrpn == MidiParameterEnum.CC_CV_VOLUME or
		nrpn == MidiParameterEnum.CC_PAN or
		nrpn == MidiParameterEnum.CC_E_EXPRESSION or
		nrpn == MidiParameterEnum.CC_VR_VIBRATO_RATE or
		nrpn == MidiParameterEnum.CC_VD_VIBRATO_DEPTH or
		nrpn == MidiParameterEnum.CC_FX2_EFFECT2_DEPTH or
		nrpn == MidiParameterEnum.PC_VOICE_TYPE or
		nrpn == MidiParameterEnum.VCP_VOICE_CHANGE_PARAMETER_ID or
		nrpn == MidiParameterEnum.VCP_VOICE_CHANGE_PARAMETER or
		nrpn == MidiParameterEnum.CVM_EXNM_ENV_DATA3 or
		nrpn == MidiParameterEnum.CVM_EXNM_ENV_DATA_CONTINUATION )then
		return false;
	end
	return false;
end
Mixer = {};
function Mixer.new( ... )
	local this = {};
	local arguments = { ... };
	this.masterFeder = 0;
	this.masterMute = 0;
	this.masterPanpot = 0;
	this.outputMode = 0;
	this.slave = {};
	function this:_init_4( masterFeder, masterPanpot, masterMute, outputMode )
		self.masterFeder = masterFeder;
		self.masterMute = masterMute;
		self.masterPanpot = masterPanpot;
		self.outputMode = outputMode;
		self.slave = {};
	end
	function this:_init_2( stream, lastLine )
		self.masterFeder = 0;
		self.masterPanpot = 0;
		self.masterMute = 0;
		self.outputMode = 0;
		local tracks = 0;
		local spl;
		local buffer = "";
		lastLine.value = stream:readLine();
		while( lastLine.value:sub( 1, 1 ) ~= "[" )do
			spl = Util.split( lastLine.value, "=" );
			if( spl[1] == "MasterFeder" )then
				self.masterFeder = tonumber( spl[2], 10 );
			elseif( spl[1] == "MasterPanpot" )then
				self.masterPanpot = tonumber( spl[2], 10 );
			elseif( spl[1] == "MasterMute" )then
				self.masterMute = tonumber( spl[2], 10 );
			elseif( spl[1] == "OutputMode" )then
				self.outputMode = tonumber( spl[2], 10 );
			elseif( spl[1] == "Tracks" )then
				tracks = tonumber( spl[2], 10 );
			else
				if( spl[1]:find( "Feder" ) == 1 or
					 spl[1]:find( "Panpot" ) == 1 or
					 spl[1]:find( "Mute" ) == 1 or
					 spl[1]:find( "Solo" ) == 1 )then
					buffer = buffer .. spl[1] .. "=" .. spl[2] .. "\n";
				end
			end
			if( not stream:ready() )then
				break;
			end
			lastLine.value = stream:readLine();
		end
		self.slave = {};
		local i;
		for i = 1, tracks, 1 do
			self.slave[i] = MixerItem.new( 0, 0, 0, 0 );
		end
		spl = Util.split( buffer, "\n" );
		local spl2;
		for i = 1, #spl, 1 do
			local ind = "";
			local index;
			spl2 = Util.split( spl[i], "=" );
			if( spl2[1]:find( "Feder" ) == 1 )then
				ind = spl2[1]:gsub( "Feder", "" );
				index = tonumber( ind, 10 );
				self.slave[index + 1].feder = tonumber( spl2[2], 10 );
			elseif( spl2[1]:find( "Panpot" ) == 1 )then
				ind = spl2[1]:gsub( "Panpot", "" );
				index = tonumber( ind, 10 );
				self.slave[index + 1].panpot = tonumber( spl2[2], 10 );
			elseif( spl2[1]:find( "Mute" ) == 1 )then
				ind = spl2[1]:gsub( "Mute", "" );
				index = tonumber( ind, 10 );
				self.slave[index + 1].mute = tonumber( spl2[2], 10 );
			elseif( spl2[1]:find( "Solo" ) == 1 )then
				ind = spl2[1]:gsub( "Solo", "" );
				index = tonumber( ind, 10 );
				self.slave[index + 1].solo = tonumber( spl2[2], 10 );
			end
		end
	end
	function this:clone()
		local res = Mixer.new( self.masterFeder, self.masterPanpot, self.masterMute, self.outputMode );
		res.slave = {};
		local i;
		for i = 1, #self.slave, 1 do
			local item = self.slave[i];
			res.slave[i] = item:clone();
		end
		return res;
	end
	function this:write( stream )
		stream:writeLine( "[Mixer]" );
		stream:writeLine( "MasterFeder=" .. self.masterFeder );
		stream:writeLine( "MasterPanpot=" .. self.masterPanpot );
		stream:writeLine( "MasterMute=" .. self.masterMute );
		stream:writeLine( "OutputMode=" .. self.outputMode );
		local count = #self.slave;
		stream:writeLine( "Tracks=" .. count );
		local i;
		for i = 1, count, 1 do
			local item = self.slave[i];
			stream:writeLine( "Feder" .. (i - 1) .. "=" .. item.feder );
			stream:writeLine( "Panpot" .. (i - 1) .. "=" .. item.panpot );
			stream:writeLine( "Mute" .. (i - 1) .. "=" .. item.mute );
			stream:writeLine( "Solo" .. (i - 1) .. "=" .. item.solo );
		end
	end
	if( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	elseif( #arguments == 4 )then
		this:_init_4( arguments[1], arguments[2], arguments[3], arguments[4] );
	end
	return this;
end
MixerItem = {};
function MixerItem.new( feder, panpot, mute, solo )
	local this = {};
	this.feder = feder;
	this.panpot = panpot;
	this.mute = mute;
	this.solo = solo;
	function this:_init_4( feder, panpot, mute, solo )
		self.feder = feder;
		self.panpot = panpot;
		self.mute = mute;
		self.solo = solo;
	end
	function this:clone()
		return MixerItem.new( self.feder, self.panpot, self.mute, self.solo );
	end
	return this;
end
NrpnEvent = {};
function NrpnEvent.new( ... )
	local this = {};
	local arguments = { ... };
	this.clock = 0;
	this.nrpn = 0;
	this.dataMSB = 0;
	this.dataLSB = 0;
	this.hasLSB = false;
	this.isMSBOmittingRequired = false;
	this._list = nil;
	function this:_init_3( clock, nrpn, dataMsb )
		self.clock = clock;
		self.nrpn = nrpn;
		self.dataMSB = dataMsb;
		self.dataLSB = 0x0;
		self.hasLSB = false;
		self.isMSBOmittingRequired = false;
		self._list = {};
	end
	function this:_init_4( clock, nrpn, dataMsb, dataLsb )
		self.clock = clock;
		self.nrpn = nrpn;
		self.dataMSB = dataMsb;
		self.dataLSB = dataLsb;
		self.hasLSB = true;
		self.isMSBOmittingRequired = false;
		self._list = {};
	end
	function this:expand()
		local ret = {};
		if( self.hasLSB )then
			local v = NrpnEvent.new( self.clock, self.nrpn, self.dataMSB, self.dataLSB );
			v.isMSBOmittingRequired = self.isMSBOmittingRequired;
			table.insert( ret, v );
		else
			local v = NrpnEvent.new( self.clock, self.nrpn, self.dataMSB );
			v.isMSBOmittingRequired = self.isMSBOmittingRequired;
			table.insert( ret, v );
		end
		local i;
		if( self._list ~= nil )then
			for i = 1, #self._list, 1 do
				local add = self._list[i]:expand();
				local j;
				for j = 1, #add, 1 do
					table.insert( ret, add[j] );
				end
			end
		end
		return ret;
	end
	function this:compareTo( item )
		if( self.clock == item.clock )then
			local thisNrpnMsb = (this.nrpn - (this.nrpn % 0x100)) / 0x100;
			local itemNrpnMsb = (item.nrpn - (item.nrpn % 0x100)) / 0x100;
			return itemNrpnMsb - thisNrpnMsb;
		else
			return self.clock - item.clock;
		end
	end
	function this:append( ... )
		local arguments = { ... };
		if( #arguments == 2 )then
			self:_append_2( arguments[1], arguments[2] );
		elseif( #arguments == 3 )then
			local t = type( arguments[3] );
			if( t == "boolean" )then
				self:_append_3_int_byte_bool( arguments[1], arguments[2], arguments[3] );
			else
				self:_append_3_int_byte_byte( arguments[1], arguments[2], arguments[3] );
			end
		elseif( #arguments == 4 )then
			self:_append_4( arguments[1], arguments[2], arguments[3], arguments[4] );
		end
	end
	function this:_append_2( nrpn, dataMsb )
		table.insert( self._list, NrpnEvent.new( self.clock, nrpn, dataMsb ) );
	end
	function this:_append_3_int_byte_byte( nrpn, dataMsb, dataLsb )
		table.insert( self._list, NrpnEvent.new( self.clock, nrpn, dataMsb, dataLsb ) );
	end
	function this:_append_3_int_byte_bool( nrpn, dataMsb, isMsbOmittingRequired )
		local v = NrpnEvent.new( self.clock, nrpn, dataMsb );
		v.isMSBOmittingRequired = isMsbOmittingRequired;
		table.insert( self._list, v );
	end
	function this:_append_4( nrpn, dataMsb, dataLsb, isMsbOmittingRequired )
		local v = NrpnEvent.new( self.clock, nrpn, dataMsb, dataLsb );
		v.isMSBOmittingRequired = isMsbOmittingRequired;
		table.insert( self._list, v );
	end
	if( #arguments == 3 )then
		this:_init_3( arguments[1], arguments[2], arguments[3] );
	elseif( #arguments == 4 )then
		this:_init_4( arguments[1], arguments[2], arguments[3], arguments[4] );
	end
	return this;
end
function NrpnEvent.compare( a, b )
	if( a:compareTo( b ) < 0 )then
		return true;
	else
		return false;
	end
end
function NrpnEvent.convert( source )
	local nrpn = source[1].nrpn;
	local msb = Util.rshift( nrpn, 8 );
	local lsb = nrpn - Util.lshift( msb, 8 );
	local ret = {};
	local e = nil;
	e = MidiEvent.new();
	e.clock = source[1].clock;
	e.firstByte = 0xb0;
	e.data = { 0x63, msb };
	table.insert( ret, e );
	e = MidiEvent.new();
	e.clock = source[1].clock;
	e.firstByte = 0xb0;
	e.data = { 0x62, lsb };
	table.insert( ret, e );
	e = MidiEvent.new();
	e.clock = source[1].clock;
	e.firstByte = 0xb0;
	e.data = { 0x06, source[1].dataMSB };
	table.insert( ret, e );
	if( source[1].hasLSB )then
		e = MidiEvent.new();
		e.clock = source[1].clock;
		e.firstByte = 0xb0;
		e.data = { 0x26, source[1].dataLSB };
		table.insert( ret, e );
	end
	local i;
	for i = 2, #source, 1 do
		local item = source[i];
		local tnrpn = item.nrpn;
		msb = Util.rshift( tnrpn, 8 );
		lsb = (tnrpn - Util.lshift( msb, 8 ));
		if( false == item.isMSBOmittingRequired )then
			e = MidiEvent.new();
			e.clock = item.clock;
			e.firstByte = 0xb0;
			e.data = { 0x63, msb };
			table.insert( ret, e );
		end
		e = MidiEvent.new();
		e.clock = item.clock;
		e.firstByte = 0xb0;
		e.data = { 0x62, lsb };
		table.insert( ret, e );
		e = MidiEvent.new();
		e.clock = item.clock;
		e.firstByte = 0xb0;
		e.data = { 0x06, item.dataMSB };
		table.insert( ret, e );
		if( item.hasLSB )then
			e = MidiEvent.new();
			e.clock = item.clock;
			e.firstByte = 0xb0;
			e.data = { 0x26, item.dataLSB };
			table.insert( ret, e );
		end
	end
	return ret;
end
PhoneticSymbol = {};
PhoneticSymbol._SYMBOL_VOWEL_JP = "\ta\ti\tM\te\to\t";
PhoneticSymbol._SYMBOL_CONSONANT_JP = "\tk\tk'\tg\tg'\tN\tN'\ts\tS\tz\tZ\tdz\tdZ\tt\tt'\tts\ttS\td\td'\tn\tJ\th\th\\\tC\tp\\\tp\\'\tb\tb'\tp\tp'\tm\tm'\tj\t4\t4'\tw\tN\\\t";
PhoneticSymbol._SYMBOL_VOWEL_EN = "\t@\tV\te\te\tI\ti:\t{\tO:\tQ\tU\tu:\t@r\teI\taI\tOI\t@U\taU\tI@\te@\tU@\tO@\tQ@\t";
PhoneticSymbol._SYMBOL_CONSONANT_EN = "\tw\tj\tb\td\tg\tbh\tdh\tgh\tdZ\tv\tD\tz\tZ\tm\tn\tN\tr\tl\tl0\tp\tt\tk\tph\tth\tkh\ttS\tf\tT\ts\tS\th\tSil\tAsp\t";
function PhoneticSymbol.isConsonant( symbol )
	local search = "\t" .. symbol .. "\t";
	local startIndex, endIndex = PhoneticSymbol._SYMBOL_CONSONANT_JP:find( search );
	if( startIndex ~= nil )then
		return true;
	else
		startIndex, endIndex = PhoneticSymbol._SYMBOL_CONSONANT_EN:find( search );
		if( startIndex ~= nil )then
			return true;
		end
	end
	return false;
end
function PhoneticSymbol.isVowel( symbol )
	local search = "\t" .. symbol .. "\t";
	local startIndex, endIndex = PhoneticSymbol._SYMBOL_VOWEL_JP:find( search );
	if( startIndex ~= nil )then
		return true;
	else
		startIndex, endIndex = PhoneticSymbol._SYMBOL_VOWEL_EN:find( search );
		if( startIndex ~= nil )then
			return true;
		end
	end
	return false;
end
function PhoneticSymbol.isValidSymbol( symbol )
	local isVowel = PhoneticSymbol.isVowel( symbol );
	local isConsonant = PhoneticSymbol.isConsonant( symbol );
	if( isVowel or isConsonant )then
		return true;
	end
	local symbolCharacterCount = symbol:len();
	if( symbol:find( "br" ) == 1 and symbolCharacterCount > 2 )then
		local s = symbol:sub( 3, symbolCharacterCount );
		if( nil == tonumber( s ) )then
			return false;
		else
			return true;
		end
	end
	return false;
end
PlayModeEnum = {
	OFF = -1,
	PLAY_AFTER_SYNTH = 0,
	PLAY_WITH_SYNTH = 1,
};
Sequence = {};
Sequence.baseTempo = 500000;
Sequence._MTRK = { 0x4d, 0x54, 0x72, 0x6b };
Sequence._MTHD = { 0x4d, 0x54, 0x68, 0x64 };
Sequence._MASTER_TRACK = { 0x4D, 0x61, 0x73, 0x74, 0x65, 0x72, 0x20, 0x54, 0x72, 0x61, 0x63, 0x6B };
Sequence._CURVES = { "VEL", "DYN", "BRE", "BRI", "CLE", "OPE", "GEN", "POR", "PIT", "PBS" };
Sequence._WRITE_NRPN = false;
function Sequence.new( ... )
	local this = {};
	local arguments = { ... };
	this._tickPerQuarter = 480;
	this.track = nil;
	this.tempoList = nil;
	this.timesigList = nil;
	this._totalClocks = 0;
	this.master = nil;
	this.mixer = nil;
	this.tag = nil;
	function this:_init_5( singer, preMeasure, numerator, denominator, tempo )
		self._totalClocks = preMeasure * 480 * 4 / denominator * numerator;
		self.track = List.new();
		self.track:push( Track.new() );
		self.track:push( Track.new( "Voice1", singer ) );
		self.master = Master.new( preMeasure );
		self.mixer = Mixer.new( 0, 0, 0, 0 );
		self.mixer.slave[1] = MixerItem.new( 0, 0, 0, 0 );
		self.timesigList = TimesigList.new();
		self.timesigList:push( Timesig.new( numerator, denominator, 0 ) );
		self.tempoList = TempoList.new();
		self.tempoList:push( Tempo.new( 0, tempo ) );
	end
	function this:clone()
		local ret = Sequence.new();
		ret.track = List.new();
		local i;
		for i = 0, self.track:size() - 1, 1 do
			ret.track:push( self.track[i]:clone() );
		end
		ret.tempoList = TempoList.new();
		for i = 0, self.tempoList:size() - 1, 1 do
			ret.tempoList:push( self.tempoList:get( i ):clone() );
		end
		ret.timesigList = TimesigList.new();
		for i = 0, self.timesigList:size() - 1, 1 do
			ret.timesigList:push( self.timesigList:get( i ):clone() );
		end
		ret._totalClocks = self._totalClocks;
		ret.master = self.master:clone();
		ret.mixer = self.mixer:clone();
		return ret;
	end
	function this:getBaseTempo()
		return Sequence.baseTempo;
	end
	function this:getTotalClocks()
		return self._totalClocks;
	end
	function this:getPreMeasure()
		return self.master.preMeasure;
	end
	function this:getPreMeasureClocks()
		return self:_calculatePreMeasureInClock();
	end
	function this:_calculatePreMeasureInClock()
		local pre_measure = self.master.preMeasure;
		local last_bar_count = self.timesigList:get( 0 ).barCount;
		local last_clock = self.timesigList:get( 0 ):getTick();
		local last_denominator = self.timesigList:get( 0 ).denominator;
		local last_numerator = self.timesigList:get( 0 ).numerator;
		for i = 1, self.timesigList:size() - 1, 1 do
			if( self.timesigList:get( i ).barCount >= pre_measure )then
				break;
			else
				last_bar_count = self.timesigList:get( i ).barCount;
				last_clock = self.timesigList:get( i ):getTick();
				last_denominator = self.timesigList:get( i ).denominator;
				last_numerator = self.timesigList:get( i ).numerator;
			end
		end
		local remained = pre_measure - last_bar_count;
		return last_clock + math.floor( remained * last_numerator * 480 * 4 / last_denominator );
	end
	function this:getTickPerQuarter()
		return self._tickPerQuarter;
	end
	function this:updateTotalClocks()
		local max = self:getPreMeasureClocks();
		for i = 1, self.track:size() - 1, 1 do
			local track = self.track:get( i );
			local numEvents = track.events:size();
			if( numEvents > 0 )then
				local lastItem = track.events:get( numEvents - 1 );
				max = math.max( max, lastItem.clock + lastItem:getLength() );
			end
			local j;
			for j = 1, #Sequence._CURVES, 1 do
				local vct = Sequence._CURVES[j];
				local list = track:getCurve( vct );
				if( list ~= nil )then
					local keys = list:size();
					if( keys > 0 )then
						local last_key = list:getKeyClock( keys - 1 );
						max = math.max( max, last_key );
					end
				end
			end
		end
		self._totalClocks = max;
	end
	function this:_getActualClockAndDelay( clock, msPreSend )
		local clock_msec = self.tempoList:getSecFromClock( clock ) * 1000.0;
		local actualClock;
		if( clock_msec - msPreSend <= 0 )then
			actualClock = 0;
		else
			local draft_clock_sec = (clock_msec - msPreSend) / 1000.0;
			actualClock = math.floor( self.tempoList:getClockFromSec( draft_clock_sec ) );
		end
		local delay = math.floor( clock_msec - self.tempoList:getSecFromClock( actualClock ) * 1000.0 );
		return actualClock, delay;
	end
	function this:write( ... )
		local arguments = { ... };
		if( #arguments == 3 )then
			return self:_write_3( arguments[1], arguments[2], arguments[3] );
		elseif( #arguments == 4 )then
			return self:_write_4( arguments[1], arguments[2], arguments[3], arguments[4] );
		end
	end
	function this:_write_3( stream, msPreSend, encoding )
		self:_write_4( stream, msPreSend, encoding, false );
	end
	function this:_write_4( stream, msPreSend, encoding, printPitch )
		self:updateTotalClocks();
		local first_position;
		stream:write( Sequence._MTHD, 1, 4 );
		stream:write( 0x00 );
		stream:write( 0x00 );
		stream:write( 0x00 );
		stream:write( 0x06 );
		stream:write( 0x00 );
		stream:write( 0x01 );
		Sequence._writeUnsignedShort( stream, self.track:size() );
		stream:write( 0x01 );
		stream:write( 0xe0 );
		stream:write( Sequence._MTRK, 1, 4 );
		stream:write( { 0x00, 0x00, 0x00, 0x00 }, 1, 4 );
		first_position = stream:getPointer();
		MidiEvent.writeDeltaClock( stream, 0 );
		stream:write( 0xff );
		stream:write( 0x03 );
		stream:write( #Sequence._MASTER_TRACK );
		stream:write( Sequence._MASTER_TRACK, 1, #Sequence._MASTER_TRACK );
		local events = {};
		local itr = self.timesigList:iterator();
		while( itr:hasNext() )do
			local entry = itr:next();
			table.insert( events, MidiEvent.generateTimeSigEvent( entry:getTick(), entry.numerator, entry.denominator ) );
		end
		itr = self.tempoList.iterator();
		while( itr:hasNext() )do
			local entry = itr:next();
			table.insert( events, MidiEvent.generateTempoChangeEvent( entry.clock, entry.tempo ) );
		end
		table.sort( events, MidiEvent.compare );
		local last = 0;
		local itr = List.fromTable( events ):iterator();
		while( itr:hasNext() )do
			local midiEvent = itr:next();
			MidiEvent.writeDeltaClock( stream, midiEvent.clock - last );
			midiEvent:writeData( stream );
			last = midiEvent.clock;
		end
		MidiEvent.writeDeltaClock( stream, 0 );
		stream:write( 0xff );
		stream:write( 0x2f );
		stream:write( 0x00 );
		local pos = stream:getPointer();
		stream:seek( first_position - 4 );
		Sequence._writeUnsignedInt( stream, pos - first_position );
		stream:seek( pos );
		local temp = self:clone();
		temp.track:get( 1 ).master = self.master:clone();
		temp.track:get( 1 ).mixer = self.mixer:clone();
		Sequence._printTrack( temp, 1, stream, msPreSend, encoding, printPitch );
		local count = self.track:size();
		local track;
		for track = 2, count - 1, 1 do
			Sequence._printTrack( self, track, stream, msPreSend, encoding, printPitch );
		end
	end
	if( #arguments == 1 )then
		this:_init_1( arguments[1] );
	elseif( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	elseif( #arguments == 5 )then
		this:_init_5( arguments[1], arguments[2], arguments[3], arguments[4], arguments[5] );
	end
	return this;
end
function Sequence._getMidiEventsFromMetaText( sr, encoding )
	local _NL = string.char( 0x0a );
	local ret = {};
	sr:setPointer( -1 );
	local line_count = -1;
	local tmp = "";
	if( sr:ready() )then
		local buffer = {};
		local first = true;
		while( sr:ready() )do
			if( first )then
				tmp = sr:readLine();
				first = false;
			else
				tmp = _NL .. sr:readLine();
			end
			local line = CP932Converter.convertFromUTF8( tmp );
			local linebytes = Util.stringToArray( line );
			Sequence._array_add_all( buffer, linebytes );
			local prefix = Sequence._getLinePrefixBytes( line_count + 1 );
			while( #prefix + #buffer >= 127 )do
				line_count = line_count + 1;
				local prefix = Sequence._getLinePrefixBytes( line_count );
				local add = MidiEvent.new();
				add.clock = 0;
				add.firstByte = 0xff;
				add.data = {};
				add.data[1] = 0x01;
				local remain = 127;
				local i;
				for i = 1, #prefix, 1 do
					add.data[i + 1] = prefix[i];
				end
				for i = #prefix + 1, remain, 1 do
					local d = buffer[1];
					add.data[i + 1] = d;
					table.remove( buffer, 1 );
				end
				table.insert( ret, add );
				prefix = Sequence._getLinePrefixBytes( line_count + 1 );
			end
		end
		if( #buffer > 0 )then
			local prefix = Sequence._getLinePrefixBytes( line_count + 1 );
			while( #prefix + #buffer >= 127 )do
				line_count = line_count + 1;
				prefix = Sequence._getLinePrefixBytes( line_count );
				local add = MidiEvent.new();
				add.clock = 0;
				add.firstByte = 0xff;
				add.data = {};
				add.data[1] = 0x01;
				local remain = 127;
				local i;
				for i = 1, #prefix, 1 do
					add.data[i + 1] = prefix[i];
				end
				for i = #prefix + 1, remain, 1 do
					add.data[i + 1] = buffer[1];
					table.remove( buffer, 1 );
				end
				table.insert( ret, add );
				prefix = Sequence._getLinePrefixBytes( line_count + 1 );
			end
			if( #buffer > 0 )then
				line_count = line_count + 1;
				local prefix = Sequence._getLinePrefixBytes( line_count );
				local add = MidiEvent.new();
				add.clock = 0;
				add.firstByte = 0xff;
				local remain = #prefix + #buffer;
				add.data = {};
				add.data[1] = 0x01;
				local i;
				for i = 1, #prefix, 1 do
					add.data[i + 1] = prefix[i];
				end
				for i = #prefix + 1, remain, 1 do
					add.data[i + 1] = buffer[1];
					table.remove( buffer, 1 );
				end
				table.insert( ret, add );
			end
		end
	end
	return ret;
end
function Sequence._printTrack( sequence, track, stream, msPreSend, encoding, printPitch )
	local _NL = string.char( 0x0a );
	stream:write( Sequence._MTRK, 1, 4 );
	stream:write( { 0x00, 0x00, 0x00, 0x00 }, 1, 4 );
	local first_position = stream:getPointer();
	MidiEvent.writeDeltaClock( stream, 0x00 );
	stream:write( 0xff );
	stream:write( 0x03 );
	local seq_name = CP932Converter.convertFromUTF8( sequence.track:get( track ):getName() );
	MidiEvent.writeDeltaClock( stream, #seq_name );
	stream:write( seq_name, 1, #seq_name );
	local textStream = TextStream.new();
	sequence.track:get( track ):printMetaText( textStream, sequence:getTotalClocks() + 120, 0, printPitch );
	local meta = Sequence._getMidiEventsFromMetaText( textStream, encoding );
	local lastClock = 0;
	local i;
	for i = 1, #meta, 1 do
		MidiEvent.writeDeltaClock( stream, meta[i].clock - lastClock );
		meta[i]:writeData( stream );
		lastClock = meta[i].clock;
	end
	local maxClock = lastClock;
	if( Sequence._WRITE_NRPN )then
		lastClock = 0;
		local data = Sequence.generateNRPN( sequence, track, msPreSend );
		local nrpns = NrpnEvent.convert( data );
		for i = 1, #nrpns, 1 do
			local item = nrpns[i];
			MidiEvent.writeDeltaClock( stream, item.clock - lastClock );
			item:writeData( stream );
			lastClock = item.clock;
		end
		maxClock = math.max( maxClock, lastClock );
	end
	lastClock = maxClock;
	local last_event = sequence.track:get( track ).events:get( sequence.track:get( track ).events:size() - 1 );
	maxClock = math.max( maxClock, last_event.clock + last_event:getLength() );
	local lastDeltaClock = maxClock - lastClock;
	if( lastDeltaClock < 0 )then
		lastDeltaClock = 0;
	end
	MidiEvent.writeDeltaClock( stream, lastDeltaClock );
	stream:write( 0xff );
	stream:write( 0x2f );
	stream:write( 0x00 );
	local pos = stream:getPointer();
	stream:seek( first_position - 4 );
	Sequence._writeUnsignedInt( stream, pos - first_position );
	stream:seek( pos );
end
function Sequence._generateExpressionNRPN( sequence, track, msPreSend )
	local ret = {};
	local dyn = sequence.track:get( track ):getCurve( "DYN" );
	local count = dyn:size();
	local i;
	local lastDelay = 0;
	for i = 0, count - 1, 1 do
		local clock = dyn:getKeyClock( i );
		local c, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
		if( c >= 0 )then
			if( lastDelay ~= delay )then
				local delayMsb, delayLsb;
				delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
				local delayNrpn = NrpnEvent.new( c, MidiParameterEnum.CC_E_DELAY, delayMsb, delayLsb );
				table.insert( ret, delayNrpn );
			end
			lastDelay = delay;
			local add = NrpnEvent.new(
				c,
				MidiParameterEnum.CC_E_EXPRESSION,
				dyn:getValue( i )
			);
			table.insert( ret, add );
		end
	end
	return ret;
end
function Sequence._generateHeaderNRPN()
	local ret = NrpnEvent.new( 0, MidiParameterEnum.CC_BS_VERSION_AND_DEVICE, 0x00, 0x00 );
	ret:append( MidiParameterEnum.CC_BS_DELAY, 0x00, 0x00 );
	ret:append( MidiParameterEnum.CC_BS_LANGUAGE_TYPE, 0x00 );
	return ret;
end
function Sequence._generateSingerNRPN( sequence, singerEvent, msPreSend )
	local clock = singerEvent.clock;
	local singer_handle = nil;
	if( singerEvent.singerHandle ~= nil )then
		singer_handle = singerEvent.singerHandle;
	end
	if( singer_handle == nil )then
		return {};
	end
	local clock_msec = sequence.tempoList:getSecFromClock( clock ) * 1000.0;
	local msEnd = sequence.tempoList:getSecFromClock( singerEvent.clock + singerEvent:getLength() ) * 1000.0;
	local duration = math.floor( math.ceil( msEnd - clock_msec ) );
	local duration0, duration1 = Sequence._getMsbAndLsb( duration );
	local actualClock, delay;
	actualClock, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
	local delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
	local ret = {};
	local add = NrpnEvent.new( actualClock, MidiParameterEnum.CC_BS_VERSION_AND_DEVICE, 0x00, 0x00 );
	add:append( MidiParameterEnum.CC_BS_DELAY, delayMsb, delayLsb, true );
	add:append( MidiParameterEnum.CC_BS_LANGUAGE_TYPE, singer_handle.language, true );
	add:append( MidiParameterEnum.PC_VOICE_TYPE, singer_handle.program );
	local arr = {};
	table.insert( arr, add );
	return arr;
end
function Sequence._generateNoteNRPN( sequence, track, noteEvent, msPreSend, noteLocation, lastDelay )
	local clock = noteEvent.clock;
	local add = nil;
	local actualClock, delay;
	actualClock, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
	if( lastDelay == nil )then
		add = NrpnEvent.new(
			actualClock,
			MidiParameterEnum.CVM_NM_VERSION_AND_DEVICE,
			0x00, 0x00
		);
		lastDelay = 0;
	end
	if( lastDelay ~= delay )then
		local delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
		if( add == nil )then
			add = NrpnEvent.new( actualClock, MidiParameterEnum.CVM_NM_DELAY, delayMsb, delayLsb );
		else
			add:append( MidiParameterEnum.CVM_NM_DELAY, delayMsb, delayLsb, true );
		end
	end
	if( add == nil )then
		add = NrpnEvent.new( actualClock, MidiParameterEnum.CVM_NM_NOTE_NUMBER, noteEvent.note );
	else
		add:append( MidiParameterEnum.CVM_NM_NOTE_NUMBER, noteEvent.note, true );
	end
	add:append( MidiParameterEnum.CVM_NM_VELOCITY, noteEvent.dynamics, true );
	local msEnd = sequence.tempoList:getSecFromClock( clock + noteEvent:getLength() ) * 1000.0;
	local clock_msec = sequence.tempoList:getSecFromClock( clock ) * 1000.0;
	local duration = math.floor( msEnd - clock_msec );
	local duration0, duration1 = Sequence._getMsbAndLsb( duration );
	add:append( MidiParameterEnum.CVM_NM_NOTE_DURATION, duration0, duration1, true );
	add:append( MidiParameterEnum.CVM_NM_NOTE_LOCATION, noteLocation, true );
	if( noteEvent.vibratoHandle ~= nil )then
		add:append( MidiParameterEnum.CVM_NM_INDEX_OF_VIBRATO_DB, 0x00, 0x00, true );
		local icon_id = noteEvent.vibratoHandle.iconId;
		local num = icon_id:sub( icon_id:len() - 3 );
		local vibrato_type = math.floor( tonumber( num, 16 ) );
		local note_length = noteEvent:getLength();
		local vibrato_delay = noteEvent.vibratoDelay;
		local bVibratoDuration = math.floor( (note_length - vibrato_delay) / note_length * 127.0 );
		local bVibratoDelay = 0x7f - bVibratoDuration;
		add:append( MidiParameterEnum.CVM_NM_VIBRATO_CONFIG, vibrato_type, bVibratoDuration, true );
		add:append( MidiParameterEnum.CVM_NM_VIBRATO_DELAY, bVibratoDelay, true );
	end
	local spl = noteEvent.lyricHandle:getLyricAt( 0 ):getPhoneticSymbolList();
	local s = "";
	local j;
	for j = 1, #spl, 1 do
		s = s .. spl[j];
	end
	local symbols = {};
	local i;
	for i = 1, s:len(), 1 do
		symbols[i] = s:sub( i, i );
	end
	local renderer = sequence.track:get( track ).common.version;
	if( renderer:sub( 1, 4 ) == "DSB2" )then
		add:append( 0x5011, 0x01, true );
	end
	add:append( MidiParameterEnum.CVM_NM_PHONETIC_SYMBOL_BYTES, #symbols, true );
	local count = -1;
	local consonantAdjustment = noteEvent.lyricHandle:getLyricAt( 0 ):getConsonantAdjustmentList();
	for j = 1, #spl, 1 do
		local chars = Util.stringToArray( spl[j] );
		local k;
		for k = 1, #chars, 1 do
			count = count + 1;
			if( k == 1 )then
				add:append( Util.bor( Util.lshift( 0x50, 8 ), (0x13 + count) ), chars[k], consonantAdjustment[j], true ); 
			else
				add:append( Util.bor( Util.lshift( 0x50, 8 ), (0x13 + count) ), chars[k], true ); 
			end
		end
	end
	if( renderer:sub( 1, 4 ) ~= "DSB2" )then
		add:append( MidiParameterEnum.CVM_NM_PHONETIC_SYMBOL_CONTINUATION, 0x7f, true ); 
	end
	if( renderer:sub( 1, 4 ) == "DSB3" )then
		local v1mean = math.floor( noteEvent.pmBendDepth * 60 / 100 );
		if( v1mean < 0 )then
			v1mean = 0;
		end
		if( 60 < v1mean )then
			v1mean = 60;
		end
		local d1mean = math.floor( 0.3196 * noteEvent.pmBendLength + 8.0 );
		local d2mean = math.floor( 0.92 * noteEvent.pmBendLength + 28.0 );
		add:append( MidiParameterEnum.CVM_NM_V1MEAN, v1mean, true );
		add:append( MidiParameterEnum.CVM_NM_D1MEAN, d1mean, true );
		add:append( MidiParameterEnum.CVM_NM_D1MEAN_FIRST_NOTE, 0x14, true );
		add:append( MidiParameterEnum.CVM_NM_D2MEAN, d2mean, true );
		add:append( MidiParameterEnum.CVM_NM_D4MEAN, noteEvent.d4mean, true );
		add:append( MidiParameterEnum.CVM_NM_PMEAN_ONSET_FIRST_NOTE, noteEvent.pMeanOnsetFirstNote, true ); 
		add:append( MidiParameterEnum.CVM_NM_VMEAN_NOTE_TRNSITION, noteEvent.vMeanNoteTransition, true ); 
		add:append( MidiParameterEnum.CVM_NM_PMEAN_ENDING_NOTE, noteEvent.pMeanEndingNote, true );
		add:append( MidiParameterEnum.CVM_NM_ADD_PORTAMENTO, noteEvent.pmbPortamentoUse, true );
		local decay = math.floor( noteEvent.demDecGainRate / 100.0 * 0x64 );
		add:append( MidiParameterEnum.CVM_NM_CHANGE_AFTER_PEAK, decay, true );
		local accent = math.floor( 0x64 * noteEvent.demAccent / 100.0 );
		add:append( MidiParameterEnum.CVM_NM_ACCENT, accent, true );
	end
	add:append( MidiParameterEnum.CVM_NM_NOTE_MESSAGE_CONTINUATION, 0x7f, true );
	return add, delay;
end
function Sequence.generateNRPN( ... )
	local arguments = { ... };
	if( #arguments == 3 )then
		return Sequence._generateNRPN_3( arguments[1], arguments[2], arguments[3] );
	elseif( #arguments == 5 )then
		return Sequence._generateNRPN_5( arguments[1], arguments[2], arguments[3], arguments[4], arguments[5] );
	end
end
function Sequence._generateNRPN_3( sequence, track, msPreSend )
	local list = {};
	local target = sequence.track:get( track );
	local version = target.common.version;
	local count = target.events:size();
	local note_start = 0;
	local note_end = target.events:size() - 1;
	local i;
	for i = 0, count - 1, 1 do
		if( 0 <= target.events:get( i ).clock )then
			note_start = i;
			break;
		end
		note_start = i;
	end
	for i = target.events:size() - 1, 0, -1 do
		if( target.events:get( i ).clock <= sequence._totalClocks )then
			note_end = i;
			break;
		end
	end
	local singer_event = -1;
	for i = note_start, 0, -1 do
		if( target.events:get( i ).type == EventTypeEnum.SINGER )then
			singer_event = i;
			break;
		end
	end
	if( singer_event >= 0 )then 
		Sequence._array_add_all( list, Sequence._generateSingerNRPN( sequence, target.events:get( singer_event ), 0 ) );
	else                   
		table.insert( list, NrpnEvent.new( 0, MidiParameterEnum.CC_BS_LANGUAGE_TYPE, 0x0 ) );
		table.insert( list, NrpnEvent.new( 0, MidiParameterEnum.PC_VOICE_TYPE, 0x0 ) );
	end
	Sequence._array_add_all( list, Sequence._generateVoiceChangeParameterNRPN( sequence, track, msPreSend ) );
	if( version:sub( 1, 4 ) == "DSB2" )then
		Sequence._array_add_all( list, Sequence.generateFx2DepthNRPN( sequence, track, msPreSend ) );
	end
	local ms_presend = msPreSend;
	local dyn = target:getCurve( "dyn" );
	if( dyn:size() > 0 )then
		local listdyn = Sequence._generateExpressionNRPN( sequence, track, ms_presend );
		if( #listdyn > 0 )then
			Sequence._array_add_all( list, listdyn );
		end
	end
	local pbs = target:getCurve( "pbs" );
	if( pbs:size() > 0 )then
		local listpbs = Sequence._generatePitchBendSensitivityNRPN( sequence, track, ms_presend );
		if( #listpbs > 0 )then
			Sequence._array_add_all( list, listpbs );
		end
	end
	local pit = target:getCurve( "pit" );
	if( pit:size() > 0 )then
		local listpit = Sequence._generatePitchBendNRPN( sequence, track, ms_presend );
		if( #listpit > 0 )then
			Sequence._array_add_all( list, listpit );
		end
	end
	local lastDelay = nil;
	local last_note_end = 0;
	for i = note_start, note_end, 1 do
		local item = target.events:get( i );
		if( item.type == EventTypeEnum.NOTE )then
			local note_loc = 0x03;
			if( item.clock == last_note_end )then
				note_loc = note_loc - 0x02;
			end
			local nextclock = item.clock + item:getLength() + 1;
			local event_count = target.events:size();
			local j;
			for j = i + 1, event_count - 1, 1 do
				local itemj = target.events:get( j );
				if( itemj.type == EventTypeEnum.NOTE )then
					nextclock = itemj.clock;
					break;
				end
			end
			if( item.clock + item:getLength() == nextclock )then
				note_loc = note_loc - 0x01;
			end
			local noteNrpn;
			noteNrpn, lastDelay = Sequence._generateNoteNRPN(
				sequence,
				track,
				item,
				msPreSend,
				note_loc,
				lastDelay
			);
			table.insert( list, noteNrpn );
			Sequence._array_add_all(
				list,
				Sequence._generateVibratoNRPN( sequence, item, msPreSend )
			);
			last_note_end = item.clock + item:getLength();
		elseif( item.type == EventTypeEnum.SINGER )then
			if( i > note_start and i ~= singer_event )then
				Sequence._array_add_all(
					list,
					Sequence._generateSingerNRPN( sequence, item, msPreSend )
				);
			end
		end
	end
	table.sort( list, NrpnEvent.compare );
	local merged = {};
	for i = 1, #list, 1 do
		Sequence._array_add_all( merged, list[i]:expand() );
	end
	return merged;
end
function Sequence._generatePitchBendNRPN( sequence, track, msPreSend )
	local ret = {};
	local pit = sequence.track:get( track ):getCurve( "PIT" );
	local count = pit:size();
	local i, lastDelay;
	for i = 0, count - 1, 1 do
		local clock = pit:getKeyClock( i );
		local actualClock, delay;
		actualClock, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
		if( actualClock >= 0 )then
			if( lastDelay ~= delay )then
				local delayMsb, delayLsb;
				delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
				table.insert(
					ret,
					NrpnEvent.new( actualClock, MidiParameterEnum.PB_DELAY, delayMsb, delayLsb )
				);
			end
			lastDelay = delay;
			local value = pit:getValue( i ) + 0x2000;
			local msb, lsb = Sequence._getMsbAndLsb( value );
			table.insert(
				ret,
				NrpnEvent.new( actualClock, MidiParameterEnum.PB_PITCH_BEND, msb, lsb )
			);
		end
	end
	return ret;
end
function Sequence._array_add_all( src_array, add_array )
	local i;
	for i = 1, #add_array, 1 do
		table.insert( src_array, add_array[i] );
	end
	return src_array;
end
function Sequence._generatePitchBendSensitivityNRPN( sequence, track, msPreSend )
	local ret = {};
	local pbs = sequence.track:get( track ):getCurve( "PBS" );
	local count = pbs:size();
	local i;
	local lastDelay = 0;
	for i = 0, count - 1, 1 do
		local clock = pbs:getKeyClock( i );
		local actualClock, delay;
		actualClock, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
		if( actualClock >= 0 )then
			if( lastDelay ~= delay )then
				local delayMsb, delayLsb;
				delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
				table.insert(
					ret,
					NrpnEvent.new( actualClock, MidiParameterEnum.CC_PBS_DELAY, delayMsb, delayLsb )
				);
			end
			lastDelay = delay;
			local add = NrpnEvent.new(
				actualClock,
				MidiParameterEnum.CC_PBS_PITCH_BEND_SENSITIVITY,
				pbs:getValue( i ),
				0x00
			);
			table.insert( ret, add );
		end
	end
	return ret;
end
function Sequence._generateVibratoNRPN( sequence, noteEvent, msPreSend )
	local ret = {};
	if( noteEvent.vibratoHandle ~= nil )then
		local vclock = noteEvent.clock + noteEvent.vibratoDelay;
		local actualClock, delay;
		actualClock, delay = sequence:_getActualClockAndDelay( vclock, msPreSend );
		local delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
		local add2 = NrpnEvent.new( actualClock, MidiParameterEnum.CC_VD_VERSION_AND_DEVICE, 0x00, 0x00 );
		add2:append( MidiParameterEnum.CC_VR_VERSION_AND_DEVICE, 0x00, 0x00 );
		add2:append( MidiParameterEnum.CC_VD_DELAY, delayMsb, delayLsb );
		add2:append( MidiParameterEnum.CC_VR_DELAY, delayMsb, delayLsb );
		add2:append( MidiParameterEnum.CC_VD_VIBRATO_DEPTH, noteEvent.vibratoHandle:getStartDepth() );
		add2:append( MidiParameterEnum.CC_VR_VIBRATO_RATE, noteEvent.vibratoHandle:getStartRate() );
		table.insert( ret, add2 );
		local vlength = noteEvent:getLength() - noteEvent.vibratoDelay;
		local depthBP = noteEvent.vibratoHandle:getDepthBP();
		local count = depthBP:size();
		if( count > 0 )then
			local i, lastDelay;
			lastDelay = 0;
			for i = 0, count - 1, 1 do
				local itemi = depthBP:get( i );
				local percent = itemi.x;
				local cl = vclock + math.floor( percent * vlength );
				actualClock, delay = sequence:_getActualClockAndDelay( cl, msPreSend );
				local nrpnEvent = nil;
				if( lastDelay ~= delay )then
					delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
					nrpnEvent = NrpnEvent.new( actualClock, MidiParameterEnum.CC_VD_DELAY, delayMsb, delayLsb );
					nrpnEvent:append( MidiParameterEnum.CC_VD_VIBRATO_DEPTH, itemi.y );
				else
					nrpnEvent = NrpnEvent.new( actualClock, MidiParameterEnum.CC_VD_VIBRATO_DEPTH, itemi.y );
				end
				lastDelay = delay;
				table.insert( ret, nrpnEvent );
			end
		end
		local rateBP = noteEvent.vibratoHandle:getRateBP();
		count = rateBP:size();
		if( count > 0 )then
			local i, lastDelay;
			lastDelay = 0;
			for i = 0, count - 1, 1 do
				local itemi = rateBP:get( i );
				local percent = itemi.x;
				local cl = vclock + math.floor( percent * vlength );
				actualClock, delay = sequence:_getActualClockAndDelay( cl, msPreSend );
				local nrpnEvent = nil;
				if( lastDelay ~= delay )then
					delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
					nrpnEvent = NrpnEvent.new( actualClock, MidiParameterEnum.CC_VR_DELAY, delayMsb, delayLsb );
					nrpnEvent:append( MidiParameterEnum.CC_VR_VIBRATO_RATE, itemi.y );
				else
					nrpnEvent = NrpnEvent.new( actualClock, MidiParameterEnum.CC_VR_VIBRATO_RATE, itemi.y );
				end
				lastDelay = delay;
				table.insert( ret, nrpnEvent );
			end
		end
	end
	table.sort( ret, NrpnEvent.compare );
	return ret;
end
function Sequence._generateVoiceChangeParameterNRPN( sequence, track, msPreSend )
	local premeasure_clock = sequence:getPreMeasureClocks();
	local renderer = sequence.track:get( track ).common.version;
	local res = {};
	local curves;
	if( renderer:sub( 1, 4 ) == "DSB3" )then
		curves = { "BRE", "BRI", "CLE", "POR", "OPE", "GEN" };
	elseif( renderer:sub( 1, 4 ) == "DSB2" )then
		curves = { "BRE", "BRI", "CLE", "POR", "GEN", "harmonics",
				   "reso1amp", "reso1bw", "reso1freq",
				   "reso2amp", "reso2bw", "reso2freq",
				   "reso3amp", "reso3bw", "reso3freq",
				   "reso4amp", "reso4bw", "reso4freq" };
	else
		curves = { "BRE", "BRI", "CLE", "POR", "GEN" };
	end
	local i, lastDelay;
	lastDelay = 0;
	for i = 1, #curves, 1 do
		local list = sequence.track:get( track ):getCurve( curves[i] );
		if( list:size() > 0 )then
			lastDelay = Sequence._addVoiceChangeParameters( res, list, sequence, msPreSend, lastDelay );
		end
	end
	table.sort( res, NrpnEvent.compare );
	return res;
end
function Sequence._addVoiceChangeParameters( dest, list, sequence, msPreSend, lastDelay )
	local id = MidiParameterEnum.getVoiceChangeParameterId( list:getName() );
	local count = list:size();
	local j;
	for j = 0, count - 1, 1 do
		local clock = list:getKeyClock( j );
		local value = list:getValue( j );
		local actualClock, delay;
		actualClock, delay = sequence:_getActualClockAndDelay( clock, msPreSend );
		if( actualClock >= 0 )then
			local add = nil;
			if( lastDelay ~= delay )then
				local delayMsb, delayLsb;
				delayMsb, delayLsb = Sequence._getMsbAndLsb( delay );
				add = NrpnEvent.new( actualClock, MidiParameterEnum.VCP_DELAY, delayMsb, delayLsb );
			end
			lastDelay = delay;
			if( add == nil )then
				add = NrpnEvent.new( actualClock, MidiParameterEnum.VCP_VOICE_CHANGE_PARAMETER_ID, id );
			else
				add:append( MidiParameterEnum.VCP_VOICE_CHANGE_PARAMETER_ID, id );
			end
			add:append( MidiParameterEnum.VCP_VOICE_CHANGE_PARAMETER, value, true );
			table.insert( dest, add );
		end
	end
	return lastDelay;
end
function Sequence._getMsbAndLsb( value )
	if( 0x3fff < value )then
		return 0x7f, 0x7f;
	else
		local msb = Util.rshift( value, 7 );
		return msb, value - Util.lshift( msb, 7 );
	end
end
function Sequence._getLinePrefixBytes( count )
	local digits = Sequence._getHowManyDigits( count );
	local c = math.floor( (digits - 1) / 4 ) + 1;
	local format = "";
	local i;
	for i = 1, c, 1 do
		format = format .. "0000";
	end
	local str = "DM:" .. string.format( "%0" .. (c * 4) .. "d", count ) .. ":";
	local count = str:len();
	local result = {};
	for i = 1, count, 1 do
		table.insert( result, string.byte( str:sub( i, i ) ) );
	end
	return result;
end
function Sequence._getHowManyDigits( number )
	number = math.abs( number );
	if( number == 0 )then
		return 1;
	else
		return math.floor( math.log10( number ) ) + 1;
	end
end
function Sequence._writeUnsignedShort( stream, data )
	local dat = Util.getBytesUInt16BE( data );
	stream:write( dat, 1, #dat );
end
function Sequence._writeUnsignedInt( stream, data )
	local dat = Util.getBytesUInt32BE( data );
	stream:write( dat, 1, #dat );
end
Tempo = {};
function Tempo.new( ... )
	local this = {};
	local arguments = { ... };
	this.clock = 0;
	this.tempo = 0;
	this._time = 0.0;
	function this:toString()
		return "{Clock=" .. self.clock .. ", Tempo=" .. self.tempo .. ", Time=" .. self._time .. "}";
	end
	function this:clone()
		local result = Tempo.new( self.clock, self.tempo );
		result._time = self._time;
		return result;
	end
	function this:_init_2( clock, tempo )
		self.clock = clock;
		self.tempo = tempo;
	end
	function this:compareTo( entry )
		return self.clock - entry.clock;
	end
	function this:equals( entry )
		if( self.clock == entry.clock )then
			return true;
		else
			return false;
		end
	end
	function this:getTime()
		return self._time;
	end
	if( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	end
	return this;
end
function Tempo.compare( a, b )
	if( a:compareTo( b ) < 0 )then
		return true;
	else
		return false;
	end
end
TempoList = {};
function TempoList.new()
	local this = {};
	this._array = List.new();
	function this:iterator()
		return this._array:iterator();
	end
	function this:sort()
		self._array:sort( Tempo.compare );
	end
	function this:push( value )
		self._array:push( value );
	end
	function this:size()
		return self._array:size();
	end
	function this:get( index )
		return self._array[index];
	end
	function this:set( index, value )
		self._array[index] = value;
	end
	function this:getClockFromSec( time )
		local tempo = TempoList.baseTempo;
		local base_clock = 0;
		local base_time = 0.0;
		local c = self._array:size();
		if( c == 0 )then
			tempo = TempoList.baseTempo;
			base_clock = 0;
			base_time = 0.0;
		elseif( c == 1 )then
			tempo = self._array[0].tempo;
			base_clock = self._array[0].clock;
			base_time = self._array[0]._time;
		else
			local i;
			for i = c - 1, 0, -1 do
				local item = self._array[i];
				if( item._time < time )then
					return item.clock + (time - item._time) * TempoList.gatetimePerQuater * 1000000.0 / item.tempo;
				end
			end
		end
		local dt = time - base_time;
		return base_clock + dt * TempoList.gatetimePerQuater * 1000000.0 / tempo;
	end
	function this:updateTempoInfo()
		local c = self._array:size();
		if( c == 0 )then
			self._array:push( Tempo.new( 0, TempoList.baseTempo ) );
		end
		self._array:sort( Tempo.compare );
		local item0 = self._array[0];
		if( item0.clock ~= 0 )then
			item0._time = TempoList.baseTempo * item0.clock / (TempoList.gatetimePerQuater * 1000000.0);
		else
			item0._time = 0.0;
		end
		local prev_time = item0._time;
		local prev_clock = item0.clock;
		local prev_tempo = item0.tempo;
		local inv_tpq_sec = 1.0 / (TempoList.gatetimePerQuater * 1000000.0);
		local i;
		for i = 1, c - 1, 1 do
			local itemi = self._array[i];
			itemi._time = prev_time + prev_tempo * (itemi.clock - prev_clock) * inv_tpq_sec;
			prev_time = itemi._time;
			prev_tempo = itemi.tempo;
			prev_clock = itemi.clock;
		end
	end
	function this:getSecFromClock( clock )
		local c = self._array:size();
		local i;
		for i = c - 1, 0, -1 do
			local item = self._array[i];
			if( item.clock < clock )then
				local init = item:getTime();
				local dclock = clock - item.clock;
				local sec_per_clock1 = item.tempo * 1e-6 / 480.0;
				return init + dclock * sec_per_clock1;
			end
		end
		local sec_per_clock = TempoList.baseTempo * 1e-6 / 480.0;
		return clock * sec_per_clock;
	end
	function this:getTempoAt( clock )
		local index = 0;
		local c = self:size();
		local i;
		for i = c - 1, 0, -1 do
			index = i;
			if( self:get( i ).clock <= clock )then
				break;
			end
		end
		return self:get( index ).tempo;
	end
	return this;
end
TempoList.gatetimePerQuater = 480;
TempoList.baseTempo = 500000;
TextStream = {};
function TextStream.new()
	local this = {};
	this._array = {};
	this._length = 0;
	this._position = -1;
	function this:getPointer()
		return self._position;
	end
	function this:setPointer( value )
		self._position = value;
	end
	function this:get()
		self._position = self._position + 1;
		return self._array[self._position + 1];
	end
	function this:readLine()
		local sb = "";
		while( self._position + 1 < self._length )do
			self._position = self._position + 1;
			local c = self._array[self._position + 1];
			if( c == "\n" )then
				break;
			end
			sb = sb .. c;
		end
		return sb;
	end
	function this:ready()
		if( 0 <= self._position + 1 and self._position + 1 < self._length )then
			return true;
		else
			return false;
		end
	end
	function this:_ensureCapacity( _length )
		if( _length > #self._array )then
			local add = _length - #self._array;
			for i = 1, add, 1 do
				table.insert( self._array, " " );
			end
		end
	end
	function this:write( str )
		local len = str:len();
		local newSize = self._position + 1 + len;
		local offset = self._position + 1;
		self:_ensureCapacity( newSize );
		for i = 1, len, 1 do
			self._array[offset + i] = str:sub( i, i );
		end
		self._position = self._position + len;
		self._length = math.max( self._length, newSize );
	end
	function this:writeLine( str )
		local len = str:len();
		local offset = self._position + 1;
		local newSize = offset + len + 1;
		self:_ensureCapacity( newSize );
		for i = 1, len, 1 do
			self._array[offset + i] = str:sub( i, i );
		end
		self._array[offset + len + 1] = "\n";
		self._position = self._position + len + 1;
		self._length = math.max( self._length, newSize );
	end
	function this:close()
		self._array = nil;
		self._length = 0;
	end
	function this:toString()
		local ret = "";
		for i = 1, self._length, 1 do
			ret = ret .. self._array[i];
		end
		return ret;
	end
	return this;
end
Timesig = {};
function Timesig.new( ... )
	local this = {};
	local arguments = { ... };
	this._clock = 0;
	this.numerator = 4;
	this.denominator = 4;
	this.barCount = 0;
	function this:_init_3( numerator, denominator, barCount )
		self.numerator = numerator;
		self.denominator = denominator;
		self.barCount = barCount;
	end
	function this:getTick()
		return self._clock;
	end
	function this:toString()
		return "{Clock=" .. self._clock .. ", Numerator=" .. self.numerator .. ", Denominator=" .. self.denominator .. ", BarCount=" .. self.barCount .. "}";
	end
	function this:clone()
		local result = Timesig.new( self.numerator, self.denominator, self.barCount );
		result._clock = self._clock;
		return result;
	end
	function this:compareTo( item )
		return self.barCount - item.barCount;
	end
	if( #arguments == 3 )then
		this:_init_3( arguments[1], arguments[2], arguments[3] );
	end
	return this;
end
function Timesig.compare( a, b )
	return (a:compareTo( b ) < 0);
end
TimesigList = {};
function TimesigList.new()
	local this = {};
	this._list = List.new();
	function this:size()
		return self._list:size();
	end
	function this:iterator()
		return self._list:iterator();
	end
	function this:push( item )
		self._list:push( item );
	end
	function this:get( index )
		return self._list[index];
	end
	function this:set( index, value )
		self._list[index] = value;
	end
	function this:updateTimesigInfo()
		if( self:get( 0 )._clock ~= 0 )then
			return;
		end
		self:get( 0 )._clock = 0;
		self._list:sort( Timesig.compare );
		local count = self:size();
		local j;
		for j = 1, count - 1, 1 do
			local item = self:get( j - 1 );
			local numerator = item.numerator;
			local denominator = item.denominator;
			local clock = item._clock;
			local bar_count = item.barCount;
			local dif = math.floor( 480 * 4 / denominator * numerator );
			clock = clock + (self:get( j ).barCount - bar_count) * dif;
			self:get( j )._clock = clock;
		end
	end
	function this:getTimesigAt( clock )
		local ret = Timesig.new();
		ret.numerator = 4;
		ret.denominator = 4;
		local index = 0;
		local c = self._list:size();
		local i;
		for i = c - 1, 0, -1 do
			index = i;
			if( self._list[i]._clock <= clock )then
				break;
			end
		end
		ret.numerator = self._list[index].numerator;
		ret.denominator = self._list[index].denominator;
		return ret;
	end
	function this:findTimesigAt( clock )
		local index = 0;
		local c = self._list:size();
		local i;
		for i = c - 1, 0, -1 do
			index = i;
			if( self._list[i]._clock <= clock )then
				break;
			end
		end
		local item = self._list[index];
		local ret = item:clone();
		local diff = clock - item._clock;
		local clockPerBar = math.floor( 480 * 4 / ret.denominator * ret.numerator );
		ret.barCount = item.barCount + math.floor( diff / clockPerBar );
		return ret;
	end
	function this:getClockFromBarCount( barCount )
		local index = 0;
		local c = self._list:size();
		local i;
		for i = c - 1, 0, -1 do
			index = i;
			if( self._list[i].barCount <= barCount )then
				break;
			end
		end
		local item = self._list[index];
		local numerator = item.numerator;
		local denominator = item.denominator;
		local initClock = item._clock;
		local initBarCount = item.barCount;
		local clockPerBar = numerator * 480 * 4 / denominator;
		return initClock + (barCount - initBarCount) * clockPerBar;
	end
	function this:getBarCountFromClock( clock )
		local index = 0;
		local c = self._list:size();
		local i;
		for i = c - 1, 0, -1 do
			index = i;
			if( self._list[i]._clock <= clock )then
				break;
			end
		end
		local bar_count = 0;
		if( index >= 0 )then
			local item = self._list[index];
			local last_clock = item._clock;
			local t_bar_count = item.barCount;
			local numerator = item.numerator;
			local denominator = item.denominator;
			local clock_per_bar = numerator * 480 * 4 / denominator;
			bar_count = t_bar_count + math.floor( (clock - last_clock) / clock_per_bar );
		end
		return bar_count;
	end
	return this;
end
Track = {};
function Track.new( ... )
	local this = {};
	local arguments = { ... };
	this.tag = "";
	this.common = nil;
	this.master = nil;
	this.mixer = nil;
	this.events = nil;
	this._pit = nil;
	this._pbs = nil;
	this._dyn = nil;
	this._bre = nil;
	this._bri = nil;
	this._cle = nil;
	this._reso1FreqBPList = nil;
	this._reso2FreqBPList = nil;
	this._reso3FreqBPList = nil;
	this._reso4FreqBPList = nil;
	this._reso1BWBPList = nil;
	this._reso2BWBPList = nil;
	this._reso3BWBPList = nil;
	this._reso4BWBPList = nil;
	this._reso1AmpBPList = nil;
	this._reso2AmpBPList = nil;
	this._reso3AmpBPList = nil;
	this._reso4AmpBPList = nil;
	this._harmonics = nil;
	this._fx2depth = nil;
	this._gen = nil;
	this._por = nil;
	this._ope = nil;
	this._pitch = nil;
	function this:_init_0()
	end
	function this:_init_2a( name, singer )
		self:_initCor( name, singer );
	end
	function this:_initCor( name, singer )
		self.common = Common.new( name, 179, 181, 123, 1, 1 );
		self._pit = BPList.new( "pit", 0, -8192, 8191 );
		self._pbs = BPList.new( "pbs", 2, 0, 24 );
		self._dyn = BPList.new( "dyn", 64, 0, 127 );
		self._bre = BPList.new( "bre", 0, 0, 127 );
		self._bri = BPList.new( "bri", 64, 0, 127 );
		self._cle = BPList.new( "cle", 0, 0, 127 );
		self._reso1FreqBPList = BPList.new( "reso1freq", 64, 0, 127 );
		self._reso2FreqBPList = BPList.new( "reso2freq", 64, 0, 127 );
		self._reso3FreqBPList = BPList.new( "reso3freq", 64, 0, 127 );
		self._reso4FreqBPList = BPList.new( "reso4freq", 64, 0, 127 );
		self._reso1BWBPList = BPList.new( "reso1bw", 64, 0, 127 );
		self._reso2BWBPList = BPList.new( "reso2bw", 64, 0, 127 );
		self._reso3BWBPList = BPList.new( "reso3bw", 64, 0, 127 );
		self._reso4BWBPList = BPList.new( "reso4bw", 64, 0, 127 );
		self._reso1AmpBPList = BPList.new( "reso1amp", 64, 0, 127 );
		self._reso2AmpBPList = BPList.new( "reso2amp", 64, 0, 127 );
		self._reso3AmpBPList = BPList.new( "reso3amp", 64, 0, 127 );
		self._reso4AmpBPList = BPList.new( "reso4amp", 64, 0, 127 );
		self._harmonics = BPList.new( "harmonics", 64, 0, 127 );
		self._fx2depth = BPList.new( "fx2depth", 64, 0, 127 );
		self._gen = BPList.new( "gen", 64, 0, 127 );
		self._por = BPList.new( "por", 64, 0, 127 );
		self._ope = BPList.new( "ope", 127, 0, 127 );
		self._pitch = BPList.new( "pitch", 0, -15000, 15000 );
		self.events = EventList.new();
		local event = Event.new( 0, EventTypeEnum.SINGER );
		local ish = Handle.new( HandleTypeEnum.SINGER );
		ish.iconId = "$07010000";
		ish.ids = singer;
		ish.original = 0;
		ish.caption = "";
		ish:setLength( 1 );
		ish.language = 0;
		ish.program = 0;
		event.singerHandle = ish;
		self.events:add( event );
	end
	function this:getIndexIterator( iteratorKind )
		return EventList.IndexIterator.new( self.events, iteratorKind );
	end
	function this:getName()
		if( self.common == nil )then
			return "Master Track";
		else
			return self.common.name;
		end
	end
	function this:setName( value )
		if( self.common ~= nil )then
			self.common.name = value;
		end
	end
	function this:printMetaText( ... )
		local arguments = { ... };
		if( #arguments == 3 )then
			self:_printMetaText_3( arguments[1], arguments[2], arguments[3] );
		elseif( #arguments == 4 )then
			self:_printMetaText_4( arguments[1], arguments[2], arguments[3], arguments[4] );
		end
	end
	function this:_printMetaText_3( stream, eos, start )
		self:_printMetaText_4( stream, eos, start, false );
	end
	function this:_printMetaText_4( stream, eos, start, printPitch )
		if( self.common ~= nil )then
			self.common:write( stream );
		end
		if( self.master ~= nil )then
			self.master:write( stream );
		end
		if( self.mixer ~= nil )then
			self.mixer:write( stream );
		end
		local handle = self.events:write( stream, eos );
		local itr = self.events:iterator()
		while( itr:hasNext() )do
			local item = itr:next();
			item:write( stream );
		end
		local i;
		for i = 1, #handle, 1 do
			handle[i]:write( stream );
		end
		local version = self.common.version;
		if( self._pit:size() > 0 )then
			self._pit:print( stream, start, "[PitchBendBPList]" );
		end
		if( self._pbs:size() > 0 )then
			self._pbs:print( stream, start, "[PitchBendSensBPList]" );
		end
		if( self._dyn:size() > 0 )then
			self._dyn:print( stream, start, "[DynamicsBPList]" );
		end
		if( self._bre:size() > 0 )then
			self._bre:print( stream, start, "[EpRResidualBPList]" );
		end
		if( self._bri:size() > 0 )then
			self._bri:print( stream, start, "[EpRESlopeBPList]" );
		end
		if( self._cle:size() > 0 )then
			self._cle:print( stream, start, "[EpRESlopeDepthBPList]" );
		end
		if( version:sub( 1, 4 ) == "DSB2" )then
			if( self._harmonics:size() > 0 )then
				self._harmonics:print( stream, start, "[EpRSineBPList]" );
			end
			if( self._fx2depth:size() > 0 )then
				self._fx2depth:print( stream, start, "[VibTremDepthBPList]" );
			end
			if( self._reso1FreqBPList:size() > 0 )then
				self._reso1FreqBPList:print( stream, start, "[Reso1FreqBPList]" );
			end
			if( self._reso2FreqBPList:size() > 0 )then
				self._reso2FreqBPList:print( stream, start, "[Reso2FreqBPList]" );
			end
			if( self._reso3FreqBPList:size() > 0 )then
				self._reso3FreqBPList:print( stream, start, "[Reso3FreqBPList]" );
			end
			if( self._reso4FreqBPList:size() > 0 )then
				self._reso4FreqBPList:print( stream, start, "[Reso4FreqBPList]" );
			end
			if( self._reso1BWBPList:size() > 0 )then
				self._reso1BWBPList:print( stream, start, "[Reso1BWBPList]" );
			end
			if( self._reso2BWBPList:size() > 0 )then
				self._reso2BWBPList:print( stream, start, "[Reso2BWBPList]" );
			end
			if( self._reso3BWBPList:size() > 0 )then
				self._reso3BWBPList:print( stream, start, "[Reso3BWBPList]" );
			end
			if( self._reso4BWBPList:size() > 0 )then
				self._reso4BWBPList:print( stream, start, "[Reso4BWBPList]" );
			end
			if( self._reso1AmpBPList:size() > 0 )then
				self._reso1AmpBPList:print( stream, start, "[Reso1AmpBPList]" );
			end
			if( self._reso2AmpBPList:size() > 0 )then
				self._reso2AmpBPList:print( stream, start, "[Reso2AmpBPList]" );
			end
			if( self._reso3AmpBPList:size() > 0 )then
				self._reso3AmpBPList:print( stream, start, "[Reso3AmpBPList]" );
			end
			if( self._reso4AmpBPList:size() > 0 )then
				self._reso4AmpBPList:print( stream, start, "[Reso4AmpBPList]" );
			end
		end
		if( self._gen:size() > 0 )then
			self._gen:print( stream, start, "[GenderFactorBPList]" );
		end
		if( self._por:size() > 0 )then
			self._por:print( stream, start, "[PortamentoTimingBPList]" );
		end
		if( version:sub( 1, 4 ) == "DSB3" )then
			if( self._ope:size() > 0 )then
				self._ope:print( stream, start, "[OpeningBPList]" );
			end
		end
	end
	function this:getCurve( curve )
		local search = curve:lower();
		if( search == "bre" )then
			return self._bre;
		elseif( search == "bri" )then
			return self._bri;
		elseif( search == "cle" )then
			return self._cle;
		elseif( search == "dyn" )then
			return self._dyn;
		elseif( search == "gen" )then
			return self._gen;
		elseif( search == "ope" )then
			return self._ope;
		elseif( search == "pbs" )then
			return self._pbs;
		elseif( search == "pit" )then
			return self._pit;
		elseif( search == "por" )then
			return self._por;
		elseif( search == "harmonics" )then
			return self._harmonics;
		elseif( search == "fx2depth" )then
			return self._fx2depth;
		elseif( search == "reso1amp" )then
			return self._reso1AmpBPList;
		elseif( search == "reso1bw" )then
			return self._reso1BWBPList;
		elseif( search == "reso1freq" )then
			return self._reso1FreqBPList;
		elseif( search == "reso2amp" )then
			return self._reso2AmpBPList;
		elseif( search == "reso2bw" )then
			return self._reso2BWBPList;
		elseif( search == "reso2freq" )then
			return self._reso2FreqBPList;
		elseif( search == "reso3amp" )then
			return self._reso3AmpBPList;
		elseif( search == "reso3bw" )then
			return self._reso3BWBPList;
		elseif( search == "reso3freq" )then
			return self._reso3FreqBPList;
		elseif( search == "reso4amp" )then
			return self._reso4AmpBPList;
		elseif( search == "reso4bw" )then
			return self._reso4BWBPList;
		elseif( search == "reso4freq" )then
			return self._reso4FreqBPList;
		elseif( search == "pitch" )then
			return self._pitch;
		else
			return nil;
		end
	end
	function this:setCurve( curve, value )
		local search = curve:lower();
		if( search == "bre" )then
			self._bre = value;
		elseif( search == "bri" )then
			self._bri = value;
		elseif( search == "cle" )then
			self._cle = value;
		elseif( search == "dyn" )then
			self._dyn = value;
		elseif( search == "gen" )then
			self._gen = value;
		elseif( search == "ope" )then
			self._ope = value;
		elseif( search == "pbs" )then
			self._pbs = value;
		elseif( search == "pit" )then
			self._pit = value;
		elseif( search == "por" )then
			self._por = value;
		elseif( search == "harmonics" )then
			self._harmonics = value;
		elseif( search == "fx2depth" )then
			self._fx2depth = value;
		elseif( search == "reso1amp" )then
			self._reso1AmpBPList = value;
		elseif( search == "reso1bw" )then
			self._reso1BWBPList = value;
		elseif( search == "reso1freq" )then
			self._reso1FreqBPList = value;
		elseif( search == "reso2amp" )then
			self._reso2AmpBPList = value;
		elseif( search == "reso2bw" )then
			self._reso2BWBPList = value;
		elseif( search == "reso2freq" )then
			self._reso2FreqBPList = value;
		elseif( search == "reso3amp" )then
			self._reso3AmpBPList = value;
		elseif( search == "reso3bw" )then
			self._reso3BWBPList = value;
		elseif( search == "reso3freq" )then
			self._reso3FreqBPList = value;
		elseif( search == "reso4amp" )then
			self._reso4AmpBPList = value;
		elseif( search == "reso4bw" )then
			self._reso4BWBPList = value;
		elseif( search == "reso4freq" )then
			self._reso4FreqBPList = value;
		elseif( search == "pitch" )then
			self._pitch = value;
		end
	end
	function this:clone()
		local res = Track.new();
		res:setName( self:getName() );
		if( self.common ~= nil )then
			res.common = self.common:clone();
		end
		if( self.master ~= nil )then
			res.master = self.master:clone();
		end
		if( self.mixer ~= nil )then
			res.mixer = self.mixer:clone();
		end
		if( self.events ~= nil )then
			res.events = EventList.new();
			local i;
			for i = 0, self.events:size() - 1, 1 do
				local item = self.events:get( i );
				res.events:add( item:clone(), item.internalID );
			end
		end
		if( self._pit ~= nil )then
			res._pit = self._pit:clone();
		end
		if( self._pbs ~= nil )then
			res._pbs = self._pbs:clone();
		end
		if( self._dyn ~= nil )then
			res._dyn = self._dyn:clone();
		end
		if( self._bre ~= nil )then
			res._bre = self._bre:clone();
		end
		if( self._bri ~= nil )then
			res._bri = self._bri:clone();
		end
		if( self._cle ~= nil )then
			res._cle = self._cle:clone();
		end
		if( self._reso1FreqBPList ~= nil )then
			res._reso1FreqBPList = self._reso1FreqBPList:clone();
		end
		if( self._reso2FreqBPList ~= nil )then
			res._reso2FreqBPList = self._reso2FreqBPList:clone();
		end
		if( self._reso3FreqBPList ~= nil )then
			res._reso3FreqBPList = self._reso3FreqBPList:clone();
		end
		if( self._reso4FreqBPList ~= nil )then
			res._reso4FreqBPList = self._reso4FreqBPList:clone();
		end
		if( self._reso1BWBPList ~= nil )then
			res._reso1BWBPList = self._reso1BWBPList:clone();
		end
		if( self._reso2BWBPList ~= nil )then
			res._reso2BWBPList = self._reso2BWBPList:clone();
		end
		if( self._reso3BWBPList ~= nil )then
			res._reso3BWBPList = self._reso3BWBPList:clone();
		end
		if( self._reso4BWBPList ~= nil )then
			res._reso4BWBPList = self._reso4BWBPList:clone();
		end
		if( self._reso1AmpBPList ~= nil )then
			res._reso1AmpBPList = self._reso1AmpBPList:clone();
		end
		if( self._reso2AmpBPList ~= nil )then
			res._reso2AmpBPList = self._reso2AmpBPList:clone();
		end
		if( self._reso3AmpBPList ~= nil )then
			res._reso3AmpBPList = self._reso3AmpBPList:clone();
		end
		if( self._reso4AmpBPList ~= nil )then
			res._reso4AmpBPList = self._reso4AmpBPList:clone();
		end
		if( self._harmonics ~= nil )then
			res._harmonics = self._harmonics:clone();
		end
		if( self._fx2depth ~= nil )then
			res._fx2depth = self._fx2depth:clone();
		end
		if( self._gen ~= nil )then
			res._gen = self._gen:clone();
		end
		if( self._por ~= nil )then
			res._por = self._por:clone();
		end
		if( self._ope ~= nil )then
			res._ope = self._ope:clone();
		end
		if( self._pitch ~= nil )then
			res._pitch = self._pitch:clone();
		end
		res.tag = self.tag;
		return res;
	end
	if( #arguments == 0 )then
		this:_init_0();
	elseif( #arguments == 2 )then
		if( type( arguments[1] ) == "string" )then
			this:_init_2a( arguments[1], arguments[2] );
		else
			this:_init_2b( arguments[1], arguments[2] );
		end
	end
	return this;
end
Util = {};
function Util.split( value, splitter )
	local init = 1;
	local result = {};
	local token = "";
	while true do
		local startIndex, endIndex = value:find( splitter, init, true );
		if( startIndex == nil )then
			break;
		end
		token = value:sub( init, startIndex - 1 );
		table.insert( result, token );
		init = startIndex + splitter:len();
	end
	token = value:sub( init, value:len() );
	table.insert( result, token );
	return result;
end
function Util.array( count )
	local result = {};
	local i;
	for i = 1, count, 1 do
		result[i] = false
	end
	return result;
end
function Util.searchArray( array, value )
	if( nil == array )then
		return -1;
	end
	local i;
	for i = 1, #array, 1 do
		if( value == array[i] )then
			return i;
		end
	end
	return -1;
end
function Util.makeUInt16BE( bytes )
	return bytes[1] * 0x100 + bytes[2];
end
function Util.makeUInt32BE( bytes )
	return bytes[1] * 0x1000000 + bytes[2] * 0x10000 + bytes[3] * 0x100 + bytes[4];
end
function Util.getBytesUInt16BE( value )
	local result = {};
	result[2] = Util.band( value, 0xff );
	value = Util.rshift( value, 8 );
	result[1] = Util.band( value, 0xff );
	return result;
end
function Util.getBytesUInt32BE( data )
	local dat = {};
	data = Util.band( 0xffffffff, data );
	dat[4] = Util.band( data, 0xff );
	data = Util.rshift( data, 8 );
	dat[3] = Util.band( data, 0xff );
	data = Util.rshift( data, 8 );
	dat[2] = Util.band( data, 0xff );
	data = Util.rshift( data, 8 );
	dat[1] = Util.band( data, 0xff );
	return dat;
end
function Util.sort( array, startIndex, length )
	local spliced = {};
	local i;
	for i = startIndex + 1, startIndex + length, 1 do
		table.insert( spliced, array[i] );
	end
	table.sort( spliced );
	local j;
	for j = startIndex + 1, startIndex + length, 1 do
		array[j] = spliced[j - startIndex];
	end
end
function Util.band( ... )
	local arguments = { ... };
	if( #arguments == 0 )then
		return nil;
	end
	local j;
	for j = 1, #arguments, 1 do
		if( type( arguments[j] ) ~= "number" )then
			return nil;
		end
		arguments[j] = math.floor( arguments[j] );
	end
	local result = 0;
	local i = 0;
	while( true )do
		local p = 2 ^ i;
		local exitHere = true;
		for j = 1, #arguments, 1 do
			if( arguments[j] >= p )then
				exitHere = false;
				break;
			end
		end
		if( exitHere )then
			break;
		end
		local p2 = p + p;
		local add = true;
		for j = 1, #arguments, 1 do
			if( arguments[j] % p2 < p )then
				add = false;
				break;
			end
		end
		if( add )then
			result = result + p;
		end
		i = i + 1;
	end
	return result;
end
function Util.bor( ... )
	local arguments = { ... };
	if( #arguments == 0 )then
		return nil;
	end
	local j;
	for j = 1, #arguments, 1 do
		if( type( arguments[j] ) ~= "number" )then
			return nil;
		end
		arguments[j] = math.floor( arguments[j] );
	end
	local result = 0;
	local i = 0;
	while( true )do
		local p = 2 ^ i;
		local exitHere = true;
		for j = 1, #arguments, 1 do
			if( arguments[j] >= p )then
				exitHere = false;
				break;
			end
		end
		if( exitHere )then
			break;
		end
		local p2 = p + p;
		local add = false;
		for j = 1, #arguments, 1 do
			if( arguments[j] % p2 >= p )then
				add = true;
				break;
			end
		end
		if( add )then
			result = result + p;
		end
		i = i + 1;
	end
	return result;
end
function Util.lshift( n, shift )
	n = math.floor( n );
	local i;
	for i = 0, shift - 1, 1 do
		if( n >= 0x8000000000000000 )then
			n = n % 0x8000000000000000;
		end
		n = n * 2;
	end
	return n;
end
function Util.rshift( n, shift )
	n = math.floor( n );
	local i;
	for i = 0, shift - 1, 1 do
		n = math.floor( n / 2 );
	end
	return n;
end
function Util.stringToArray( s )
	local count = s:len();
	local result = {};
	local i;
	for i = 1, count, 1 do
		table.insert( result, string.byte( s:sub( i, i ) ) );
	end
	return result;
end
function Util.dump( value, option )
	if( option == nil )then
		option = {};
	end
	if( type( option.hex ) == "nil" )then
		option.hex = false;
	end
	if( type( option.func ) == "nil" )then
		option.func = false;
	end
	return Util._dump( value, 0, {}, option );
end
function Util._dump( value, depth, state, option )
	local hex = option.hex;
	if( hex == nil )then
		hex = false;
	end
	local func = option.func
	if( func == nil )then
		func = true;
	end
	local indent = string.rep( " ", 4 * depth );
	if( value == nil )then
		return indent .. "nil,";
	elseif( type( value ) == "boolean" )then
		if( value )then
			return indent .. "true,";
		else
			return indent .. "false,";
		end
	elseif( type( value ) == "string" )then
		return indent .. "'" .. value .. "',";
	elseif( type( value ) == "function" )then
		return indent .. "function,";
	elseif( type( value ) == "userdata" )then
		return indent .. "userdata,";
	elseif( type( value ) == "number" )then
		if( hex == false or value < 0 or value ~= math.floor( value ) )then
			return indent .. value .. ",";
		else
			return indent .. string.format( "0x%X", value ) .. ",";
		end
	elseif( type( value ) ~= "table" )then
		return indent .. value .. ",";
	else
		local i, s;
		local found = false;
		for i, s in pairs( state ) do
			if( s == value )then
				found = true;
				break;
			end
		end
		if( found )then
			return indent .. "(cycromatic reference),";
		else
			table.insert( state, value );
			local nextDepth = depth + 1;
			local str = "";
			local count = 0;
			for k, v in pairs( value ) do
				if( (func and type( v ) == "function") or type( v ) ~= "function" )then
					local dumped = Util._dump( v, nextDepth, state, option );
					while( dumped:len() > 0 and dumped:sub( 1, 1 ) == " " )do
						dumped = dumped:sub( 2 );
					end
					local key;
					if( type( k ) == "string" )then
						key = "'" .. k .. "'";
					else
						key = "" .. k;
					end
					str = str .. indent .. "    " .. key .. " => " .. dumped .. "\n";
					count = count + 1;
				end
			end
			if( count > 0 )then
				local result = indent .. "table(" .. count .. "){\n";
				result = result .. str;
				return result .. indent .. "},";
			else
				return indent .. "table(0){},";
			end
		end
	end
end
function Util.explodeUTF8String( utf8 )
	if( nil == utf8 )then
		return {};
	end
	local result = {};
	local count = utf8:len();
	local i = 1;
	while( i <= count )do
		local codeBytes = {};
		local code = string.byte( utf8:sub( i, i ) );
		table.insert( codeBytes, code );
		local remain = 1;
		if( code <= 0x7F )then
			remain = 0;
		elseif( code <= 0xDF )then
			remain = 1;
		elseif( code <= 0xEF )then
			remain = 2;
		elseif( code <= 0xF7 )then
			remain = 3;
		elseif( code <= 0xFB )then
			remain = 4;
		else
			remain = 5;
		end
		local j;
		for j = 1, remain, 1 do
			table.insert( codeBytes, string.byte( utf8:sub( i + j, i + j ) ) );
		end
		table.insert( result, codeBytes );
		i = i + remain + 1;
	end
	return result;
end
VibratoBP = {};
function VibratoBP.new( ... )
	local arguments = { ... };
	local this = {};
	this.x = 0.0;
	this.y = 0;
	function this:_init_0()
	end
	function this:_init_2( x, y )
		self.x = x;
		self.y = y;
	end
	function this:compareTo( item )
		local v = self.x - item.x;
		if( v > 0.0 )then
			return 1;
		elseif( v < 0.0 )then
			return -1;
		end
		return 0;
	end
	if( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	else
		this:_init_0();
	end
	return this;
end
function VibratoBP.compare( a, b )
	return (a:compareTo( b ) < 0);
end
VibratoBPList = {};
function VibratoBPList.new( ... )
	local arguments = { ... };
	local this = {};
	this._list = {};
	function this:_init_3( textNum, textBPX, textBPY )
		local num = tonumber( textNum );
		if( nil == num )then
			num = 0;
		end
		local bpx = Util.split( textBPX, ',' );
		local bpy = Util.split( textBPY, ',' );
		local actNum = math.min( num, math.min( #bpx, #bpy ) );
		if( actNum > 0 )then
			local x = Util.array( actNum );
			local y = Util.array( actNum );
			for i = 1, actNum, 1 do
				x[i] = tonumber( bpx[i] );
				y[i] = tonumber( bpy[i] );
			end
			local len = math.min( #x, #y );
			for i = 1, len, 1 do
				self._list[i] = VibratoBP.new( x[i], y[i] );
			end
			table.sort( self._list, VibratoBP.compare );
		end
	end
	function this:_init_2( x, y )
		local len = math.min( #x, #y );
		for i = 1, len, 1 do
			self._list[i] = VibratoBP.new( x[i], y[i] );
		end
		local comparator = function( a, b )
			if( a:compareTo( b ) < 0 )then
				return true;
			else
				return false;
			end
		end
		table.sort( self._list, VibratoBP.compare );
	end
	function this:getValueAt( x, defaultValue )
		if( #self._list <= 0 )then
			return defaultValue;
		end
		local index = -1;
		for i = 1, #self._list, 1 do
			if( x < self._list[i].x )then
				break;
			end
			index = i;
		end
		if( index == -1 )then
			return defaultValue;
		else
			return self._list[index].y;
		end
	end
	function this:clone()
		local ret = VibratoBPList.new();
		for i = 1, #self._list, 1 do
			ret._list[i] = VibratoBP.new( self._list[i].x, self._list[i].y );
		end
		return ret;
	end
	function this:size()
		return #self._list;
	end
	function this:get( index )
		return self._list[index + 1];
	end
	function this:set( index, value )
		self._list[index + 1] = value;
	end
	function this:getData()
		local ret = "";
		for i = 1, #self._list, 1 do
			if( i > 1 )then
				ret = ret .. ",";
			end
			ret = ret .. self._list[i].x .. "=" .. self._list[i].y;
		end
		return ret;
	end
	function this:setData( value )
		self._list = {};
		local spl = Util.split( value, ',' );
		local j = 1
		for i = 1, #spl, 1 do
			local spl2 = Util.split( spl[i], '=' );
			if( #spl2 >= 2 )then
				self._list[j] = VibratoBP.new( tonumber( spl2[1] ), tonumber( spl2[2] ) );
				j = j + 1
			end
		end
		table.sort( self._list, VibratoBP.compare );
	end
	if( #arguments == 3 )then
		this:_init_3( arguments[1], arguments[2], arguments[3] );
	elseif( #arguments == 2 )then
		this:_init_2( arguments[1], arguments[2] );
	end
	return this;
end
VoiceLanguageEnum = {
	JAPANESE = 0,
	ENGLISH = 1,
};
function VoiceLanguageEnum.valueFromSingerName( name )
	local search = name:lower();
	if( search == "meiko" or
		search == "kaito" or
		search == "miku" or
		search == "rin" or
		search == "len" or
		search == "rin_act2" or
		search == "len_act2" or
		search == "gackpoid" or
		search == "luka_jpn" or
		search == "megpoid" or
		search == "sfa2_miki" or
		search == "yuki" or
		search == "kiyoteru" or
		search == "miku_sweet" or
		search == "miku_dark" or
		search == "miku_soft" or
		search == "miku_light" or
		search == "miku_vivid" or
		search == "miku_solid" )then
		return VoiceLanguageEnum.JAPANESE;
	elseif( search == "sweet_ann" or
		search == "prima" or
		search == "luka_eng" or
		search == "sonika" or
		search == "lola" or
		search == "leon" or
		search == "miriam" or
		search == "big_al" )then
		return VoiceLanguageEnum.ENGLISH;
	end
	return VoiceLanguageEnum.JAPANESE;
end