#define _FILE_OFFSET_BITS 64
#define _FORTIFY_SOURCE 2
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "answers.h"

#define QUIZ_TOTAL (sizeof(answers) / sizeof(answers[0]))

int main(int argc, char *argv[])
{
	int score = 0;
	int i;
	const char *ans[QUIZ_TOTAL] = { };
	const char *method = getenv("REQUEST_METHOD");
        if (!method || (strcmp(method, "GET") && strcmp(method, "POST"))) {
		printf("Status: 400 Bad Request\r\n");
		printf("Cache-Control: no-store\r\n");
		printf("Pragma: no-cache\r\n");
		printf("Content-Type: text/plain\r\n\r\n");
		printf("Only GET or POST request is allowed.\n");
		return 0;
	} else if (!strcmp(method, "POST")) {
		static char buffer[1048576] = { };
		char *cp = buffer;
		char *line;
		i = fread(buffer, 1, sizeof(buffer) - 1, stdin);
		while ((line = strsep(&cp, "&")) != NULL) {
			if (*line++ != 'A' || (i = strtoul(line, &line, 10)) < 1 ||
			    i > QUIZ_TOTAL || *line++ != '=' || strlen(line) != 40 ||
			    strspn(line, "0123456789abcdef") != 40)
				continue;
			ans[i - 1] = line;
		}
	}
	for (i = 0; i < QUIZ_TOTAL; i++)
		if (!ans[i])
			ans[i] = "";
	for (i = 0; i < QUIZ_TOTAL; i++)
		if (!strcmp(ans[i], answers[i]))
			score++;
	printf("Status: 200 OK\r\n");
	printf("Cache-Control: no-store\r\n");
	printf("Pragma: no-cache\r\n");
	printf("Content-Type: text/html; charset=UTF-8\r\n\r\n");
	printf("<!DOCTYPE html><html lang=\"en-US\"><head><title>The answer form for attack points</title></head><body>\n");
	if (score == QUIZ_TOTAL)
		printf("<p>Congraturations! You passed all quizzes.<br>The keyword for attack points is:</p><h3>SECCON{%s}</h3>\n",
		       KEYWORD_FOR_ATTACK_POINT);
	else
		printf("<p>You passed %u out of %u quizzes.</p>\n", score, (unsigned int) QUIZ_TOTAL);
	printf("<hr><form method='POST'>\n");
	for (i = 0; i < QUIZ_TOTAL; i++)
		printf("A%u: <input type='text' name='A%u' maxlength='40' value='%s'><br>\n", i + 1, i + 1, ans[i]);
	printf("<input type='submit' value='Submit'></form>\n");
	printf("</body></html>");
	return 0;
}
