#define _FILE_OFFSET_BITS 64
#define _FORTIFY_SOURCE 2
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "answers.h"

#define QUIZ_TOTAL (sizeof(answers) / sizeof(answers[0]))
#define TEAM_TOTAL 21

int main(int argc, char *argv[])
{
	unsigned int score[TEAM_TOTAL] = { };
	unsigned int highest_score = 0;
	unsigned int team;
	unsigned int quiz;
	char buffer[256] = { };
	printf("Status: 200 OK\r\n");
	printf("Cache-Control: no-store\r\n");
	printf("Pragma: no-cache\r\n");
	printf("Content-Type: text/plain; charset=UTF-8\r\n\r\n");
	for (quiz = 0; quiz < QUIZ_TOTAL; quiz++) {
		unsigned char mask = 0; 
		unsigned char choice[TEAM_TOTAL] = { };
		for (team = 0; team < TEAM_TOTAL; team++) {
			int len;
			snprintf(buffer, sizeof(buffer) - 1, "/home/team%02u/%s", team, answers[quiz]);
			len = readlink(buffer, buffer, sizeof(buffer) - 1);
			if (len < 5)
				continue;
			buffer[len] = '\0';
			if (!strcmp(buffer, "stone"))
				choice[team] = 1;
			else if (!strcmp(buffer, "scissors"))
				choice[team] = 2;
			else if (!strcmp(buffer, "paper"))
				choice[team] = 4;
			else
				continue;
			mask |= choice[team];
		}
		switch (mask) {
		case 7:
			for (team = 0; team < TEAM_TOTAL; team++)
				if (choice[team])
					score[team]++;
			break;
		case 6:
			for (team = 0; team < TEAM_TOTAL; team++)
				if (choice[team] == 2)
					score[team] += 3;
			break;
		case 5:
			for (team = 0; team < TEAM_TOTAL; team++)
				if (choice[team] == 4)
					score[team] += 3;
			break;
		case 3:
			for (team = 0; team < TEAM_TOTAL; team++)
				if (choice[team] == 1)
					score[team] += 3;
			break;
		case 4:
		case 2:
		case 1:
			for (team = 0; team < TEAM_TOTAL; team++)
				if (choice[team])
					score[team] += 3;
			break;
		}
	}
	for (team = 0; team < TEAM_TOTAL; team++)
		if (highest_score < score[team])
			highest_score = score[team];
	if (!highest_score) {
		printf("# No current king.\n");
		return 0;
	}
	printf("# Current king: ");
	for (team = 0; team < TEAM_TOTAL; team++)
		if (highest_score == score[team])
			printf("team%02u ", team);
	printf("\n");
	return 0;
}
