#!/bin/sh
set -v
set -e

RANDOM_DATA1=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA2=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA3=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA4=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA5=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA6=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`
RANDOM_DATA7=`dd if=/dev/urandom bs=1024 count=1 2>/dev/null | sha1sum | awk '{ print $1 }'`

( echo 'static const char *answers[] = { '
echo '"'$RANDOM_DATA1'",'
echo '"'$RANDOM_DATA2'",'
echo '"'$RANDOM_DATA3'",'
echo '"'$RANDOM_DATA4'",'
echo '"'$RANDOM_DATA5'",'
echo '"'$RANDOM_DATA6'",'
echo '"'$RANDOM_DATA7'"'
echo '};' ) > answers.h

gcc -Wall -O3 -o defense.cgi defense.c
chown apache:apache defense.cgi
chmod 700 defense.cgi
mv defense.cgi /var/www/cgi-bin/

gcc -Wall -O3 -DKEYWORD_FOR_ATTACK_POINT='"Server5@HeySayFinalCTF"' -o attack.cgi attack.c
chown apache:apache attack.cgi
chmod 700 attack.cgi
mv attack.cgi /var/www/cgi-bin/

(
cat << "EOF"
<!DOCTYPE html><html lang="en-US"><head><title>Welcome To Go.Pwn.Intl.Seccon !</title></head><body>
<h1>Welcome To Go.Pwn.Intl.Seccon !</h1>
<ul>
<li>There are 7 quizzes in /seccon2018/ directory of this server.<br>
Please login via SSH with username 'seccon' and password 'seccon' and solve all quizzes.<br>
Please be sure to check the <a href="#source">source code of all quizzes</a>, for there is no tutorial for what/how to do after you login via SSH.</li>
<li>Two kernel modules for access restriction are used on this server.<br>
If you can't solve using one approach, try different approaches.</li>
<li>When you solved one quiz, you will get one SHA1 value in ANSWER{...} format.<br>
You need to do one thing for <a href="#attack">attack points</a> and one more thing for <a href="#defense">defense points</a> using that SHA1 value.</li>
</ul>

<h2><a name="attack">About Attack Points For This Server</a></h2>
<ul>
<li>After you solved all quizzes, please post the SHA1 values using <a href="/cgi-bin/attack.cgi">this CGI form</a>.
<li>Then, you will get the keyword for the attack points in SECCON{...} format. Please post the keyword to the score server.</li>
<li>If you have any questions, please check the source code of the CGI form shown below.</li>
</ul>
<table border="1"><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < attack.c
cat << "EOF"
</pre></td></tr></table>

<h2><a name="defense">About Defense Points For This Server</a></h2>
<ul>
<li>After you solved each quiz, please create a symlink containing one of "stone", "scissors" or "paper" with the SHA1 value in the home directory.<br>
(e.g. "ln -s stone ~/0123456789abcdef0123456789abcdef01234567" if the SHA1 value is 0123456789abcdef0123456789abcdef01234567.)<br>
This symlink is used for calculating defense points using the stone-scissors-paper rule, and you may delete/recreate the symlink if you want.</li>
</ul>

<h2><a name="source">About Source Code Of Each Quiz</a></h2>
<h3>Quiz 1: Get an exception message.</h3>

<table border="1">
<tr><th>/seccon2018/Q1</th><th>/seccon2018/q1.py</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q1.c
echo '</pre></td><td><pre>'
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q1.py.orig
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 2: Read the readable file.</h3>
<table border="1">
<tr><th>/seccon2018/Q2</th><th>/seccon2018/q2.py</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q2.c
echo '</pre></td><td><pre>'
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q2.py
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 3: Read the standard output message.</h3>
<table border="1">
<tr><th>/seccon2018/Q3</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q3.c
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 4: Is this a bug?</h3>
<table border="1">
<tr><th>/seccon2018/Q4</th><th>/seccon2018/q4.pl</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q4.c
echo '</pre></td><td><pre>'
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q4.pl.orig
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 5: A limitation as of this Linux kernel version.</h3>
<table border="1">
<tr><th>/seccon2018/Q5</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q5.c
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 6: Get the signal handler message.</h3>
<table border="1">
<tr><th>/seccon2018/Q6</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q6.c
cat << "EOF"
</pre></td></tr></table>
<h3>Quiz 7: Keep winning the stone-scissors-paper games.</h3>
<table border="1">
<tr><th>/seccon2018/Q7</th></tr><tr><td><pre>
EOF
sed -e 's/\&/&amp;/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/"/\&quot;/g' < q7.c
cat << "EOF"
</pre></td></tr></table>
<hr>
</body></html>
EOF
) > /var/www/html/index.html

gcc -Wall -O3 -o Q1 q1.c
gcc -Wall -O3 -o Q2 q2.c
gcc -Wall -O3 -DANSWER_COMES_HERE='"'$RANDOM_DATA3'"' -o Q3 q3.c
gcc -Wall -O3 -o Q4 q4.c
gcc -Wall -O3 -DANSWER_COMES_HERE='"'$RANDOM_DATA5'"' -o Q5 q5.c
gcc -Wall -O3 -DANSWER_COMES_HERE='"'$RANDOM_DATA6'"' -o Q6 q6.c
gcc -Wall -O3 -DANSWER_COMES_HERE='"'$RANDOM_DATA7'"' -o Q7 q7.c

chgrp 1001 Q1
chmod 2111 Q1
sed -e 's/ANSWER_COMES_HERE/'$RANDOM_DATA1'/' < q1.py.orig > q1.py
chgrp 1001 q1.py
chmod 0050 q1.py

chgrp 1002 Q2
chmod 2111 Q2
chgrp 1002 q2.py
chmod 0050 q2.py
echo 'ANSWER{'$RANDOM_DATA2'}' > q2.txt
chgrp 1002 q2.txt
chmod 0040 q2.txt

chmod 0750 Q3
chgrp 1003 Q3
cp -p /lib64/ld-linux-x86-64.so.2 /usr/local/lib64/
chgrp 1003 /usr/local/lib64/ld-linux-x86-64.so.2
chmod 2755 /usr/local/lib64/ld-linux-x86-64.so.2

chgrp 1004 Q4
chmod 2111 Q4
sed -e 's/ANSWER_COMES_HERE/'$RANDOM_DATA4'/' < q4.pl.orig > q4.pl
chgrp 1004 q4.pl
chmod 0050 q4.pl

chgrp 1005 Q5
chmod 2111 Q5

chgrp 1006 Q6
chmod 2111 Q6

chgrp 1007 Q7
chmod 2111 Q7

mkdir -p /seccon2018
/bin/mv Q? /seccon2018/
/bin/cp -p q2.txt q?.p? /seccon2018/
