/*
useradd seccon
passwd seccon
gcc -Wall -O3 seccon_login.c -o /bin/seccon_login
chown root:seccon /bin/seccon_login
chmod 4710 /bin/seccon_login
echo 'Match User seccon' >> /etc/ssh/sshd_config
echo '      ForceCommand /bin/seccon_login' >> /etc/ssh/sshd_config
systemctl restart sshd
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <grp.h>

int main(int argc, char *argv[])
{
	int len;
	int fd;
	char buffer[128] = { };
	gid_t gid;
	char *env = getenv("SSH_CONNECTION");
	int team = 0;

	if (!env || sscanf(env, "192.168.%u", &team) != 1 || team < 128 || team > 142) {
		fprintf(stderr, "Bad environment variable SSH_CONNECTION. Forcing team20.\n");
		team = 128 + 20;
	}
	team -= 128;
	fd = open("/proc/self/oom_score_adj", O_WRONLY | O_CLOEXEC);
	if (write(fd, "1000\n", 5) != 5) {
		fprintf(stderr, "Can't adjust /proc/self/oom_score_adj\n");
		return 1;
	}
	if (chdir("/sys/fs/cgroup")) {
		fprintf(stderr, "Can't change directory to /sys/fs/cgroup\n");
		return 1;
	}
	if (setuid(0) || setgid(0)) {
		fprintf(stderr, "Can't change uid or gid to 0\n");
		return 1;
	}
	snprintf(buffer, sizeof(buffer) - 1, "memory/team%u", team);
	mkdir(buffer, 0755);
	snprintf(buffer, sizeof(buffer) - 1, "cpu/team%u", team);
	mkdir(buffer, 0755);
	snprintf(buffer, sizeof(buffer) - 1, "memory/team%u/memory.limit_in_bytes", team);
	fd = open(buffer, O_WRONLY | O_CLOEXEC);
	if (write(fd, "536870912\n", 10) != 10) {
		fprintf(stderr, "Can't adjust memory.limit_in_bytes\n");
		return 1;
	}
	snprintf(buffer, sizeof(buffer) - 1, "cpu/team%u/cpu.shares", team);
	fd = open(buffer, O_WRONLY | O_CLOEXEC);
	if (write(fd, "64\n", 3) != 3) {
		fprintf(stderr, "Can't adjust cpu.shares\n");
 		return 1;
	}
	snprintf(buffer, sizeof(buffer) - 1, "memory/team%u/tasks", team);
	fd = open(buffer, O_WRONLY | O_CLOEXEC);
	len = snprintf(buffer, sizeof(buffer) - 1, "%u\n", getpid());
	if (write(fd, buffer, len) != len) {
		fprintf(stderr, "Can't change memory cgroup\n");
		return 1;
	}
	snprintf(buffer, sizeof(buffer) - 1, "cpu/team%u/tasks", team);
	fd = open(buffer, O_WRONLY | O_CLOEXEC);
	len = snprintf(buffer, sizeof(buffer) - 1, "%u\n", getpid());
	if (write(fd, buffer, len) != len) {
		fprintf(stderr, "Can't change cpu cgroup\n");
		return 1;
	}
	gid = 10000 + team;
	if (setgroups(1, &gid) || setgid(gid) || setuid(10000 + team)) {
		fprintf(stderr, "Can't change uid or gid or groups\n");
		return 1;
	}
	snprintf(buffer, sizeof(buffer) - 1, "/home/team%02u", team);
	if (chdir(buffer)) {
		fprintf(stderr, "Can't change directory to %s\n", buffer);
		return 1;
	}
	if (setenv("HOME", buffer, 1) || setenv("USER", buffer + 6, 1) ||
	    setenv("LOGNAME", buffer + 6, 1)) {
		fprintf(stderr, "Can't update environment variables\n");
		return 1;
	}
	env = getenv("SSH_ORIGINAL_COMMAND");
	if (env)
		return system(env);
	execl("/bin/bash", "bash", NULL);
	fprintf(stderr, "Can't start /bin/bash\n");
	return 1;
}
