#!/bin/sh
set -v
set -e

yum -y update

if ! grep -qF rootflags=quota /etc/default/grub
then
    sed -i -e 's/GRUB_CMDLINE_\(.*\)"/GRUB_CMDLINE_\1 rootflags=quota"/' /etc/default/grub
    grub2-mkconfig -o /boot/grub2/grub.cfg
fi

if grep -qF =enforcing /etc/selinux/config
then
    sed -i -e 's@=enforcing@=disabled@' /etc/selinux/config
    reboot
fi

yum -y install kernel-devel-`uname -r`
yum -y groupinstall compat-libraries core debugging development
yum -y install emacs-nox httpd wget psmisc epel-release
yum -y install python34

make -sC /usr/src/kernels/`uname -r`/ SUBDIRS=$PWD/noptrace modules modules_install clean
make -sC /usr/src/kernels/`uname -r`/ SUBDIRS=$PWD/caitsith modules modules_install clean
gcc -Wall -O3 -o /usr/local/bin/watchdog watchdog.c

if ! id seccon >/dev/null 2>&1
then
    groupadd -g 1000 seccon
    useradd -u 1000 -g 1000 seccon
    echo seccon | passwd --stdin seccon
fi

if ! grep -qF seccon_login /etc/ssh/sshd_config
then
    gcc -Wall -O3 seccon_login.c -o /bin/seccon_login
    chown root:seccon /bin/seccon_login
    chmod 4710 /bin/seccon_login
    echo '' >> /etc/ssh/sshd_config
    echo 'Match User seccon' >> /etc/ssh/sshd_config
    echo '      ForceCommand /bin/seccon_login' >> /etc/ssh/sshd_config
    systemctl restart sshd
fi

for i in `seq -w 0 20`
do
    if ! id team$i >/dev/null 2>&1
    then
	groupadd -g 100$i team$i
	useradd -u 100$i -g 100$i team$i
	xfs_quota -x -c "limit bhard=100m team$i" /
    fi
done
chgrp apache /home/team*
chmod 710 /home/team*

systemctl enable httpd
systemctl start httpd
firewall-cmd --add-service=http --permanent
firewall-cmd --add-service=http

grep -qF watchdog /etc/rc.d/rc.local || echo '/usr/local/bin/watchdog &' >> /etc/rc.d/rc.local
grep -qF noptrace /etc/rc.d/rc.local || echo '/sbin/modprobe noptrace' >> /etc/rc.d/rc.local
grep -qF caitsith /etc/rc.d/rc.local || echo '/sbin/modprobe caitsith' >> /etc/rc.d/rc.local
chmod 755 /etc/rc.d/rc.local

cd quiz/
chmod 755 make.sh
./make.sh
/etc/rc.d/rc.local
