/* gcc -Wall -O3 -o watchdog watchdog.c */
#define _FILE_OFFSET_BITS 64
#define _FORTIFY_SOURCE 2
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <time.h>

int main(int argc, char *argv[])
{
	struct sockaddr_in addr = { .sin_family = AF_INET,
			      .sin_port = htons(80),
			      .sin_addr.s_addr = inet_addr("127.0.0.1") };
	int watchdog_fd = EOF;
	int fd = open("/proc/self/oom_score_adj", O_WRONLY);
	if (write(fd, "-1000\n", 6) != 6 || close(fd))
		return 1;
	fd = open("/proc/self/exe", O_RDONLY);
	if (flock(fd, LOCK_EX | LOCK_NB))
		return 0;
	if (system("/sbin/modprobe softdog"))
		return 1;
	while (1) {
		static const char request[] = "GET / HTTP/1.1\r\n"
			 "User-Agent: watchdog\r\n"
			 "Host: 127.0.0.1:80\r\n"
			 "Connection: close\r\n"
			 "\r\n";
		static char buffer[1024] = { };
		time_t now = time(NULL);
		fd = socket(PF_INET, SOCK_STREAM, 0);
		if (connect(fd, (struct sockaddr *) &addr, sizeof(addr)) ||
		    write(fd, request, sizeof(request) - 1) != sizeof(request) - 1 ||
		    shutdown(fd, SHUT_WR)) {
			if (watchdog_fd != EOF)
				break;
			close(fd);
			sleep(1);
			continue;
		}
		while (read(fd, buffer, sizeof(buffer)) > 0);
		close(fd);
		now = time(NULL) - now;
		if (now < 30)
			sleep(30 - now);
		if (watchdog_fd == EOF)
			watchdog_fd = open("/dev/watchdog", O_WRONLY);
		if (write(watchdog_fd, "", 1) != 1)
			break;
	}
	return 0;
}
