/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaComponent;

public class VmComponent
extends SedaComponent {
    protected static final Map<String, BlockingQueue<Exchange>> QUEUES = new HashMap<String, BlockingQueue<Exchange>>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    @Override
    public synchronized BlockingQueue<Exchange> createQueue(String uri, Map<String, Object> parameters) {
        String key = this.getQueueKey(uri);
        if (QUEUES.containsKey(key)) {
            return QUEUES.get(key);
        }
        Integer size = this.getAndRemoveParameter(parameters, "size", Integer.class);
        LinkedBlockingQueue<Object> queue = size != null && size > 0 ? new LinkedBlockingQueue(size) : (this.getQueueSize() > 0 ? new LinkedBlockingQueue(this.getQueueSize()) : new LinkedBlockingQueue<Exchange>());
        QUEUES.put(key, queue);
        return queue;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (START_COUNTER.decrementAndGet() == 0) {
            Map<String, BlockingQueue<Exchange>> map = QUEUES;
            synchronized (map) {
                for (BlockingQueue<Exchange> q : QUEUES.values()) {
                    q.clear();
                }
                QUEUES.clear();
            }
        }
    }
}

