/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleBackwardsCompatibleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.spi.Language;

public class SimpleLanguage
implements Language,
IsSingleton {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    private Class<?> resultType;

    public SimpleLanguage() {
    }

    public SimpleLanguage(String functionStartToken, String functionEndToken) {
        SimpleLanguage.changeFunctionStartToken(functionStartToken);
        SimpleLanguage.changeFunctionEndToken(functionEndToken);
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Predicate createPredicate(String expression) {
        Predicate answer = SimpleBackwardsCompatibleParser.parsePredicate(expression);
        if (answer == null) {
            SimplePredicateParser parser = new SimplePredicateParser(expression);
            answer = parser.parsePredicate();
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer = SimpleBackwardsCompatibleParser.parseExpression(expression);
        if (answer == null) {
            SimpleExpressionParser parser = new SimpleExpressionParser(expression);
            answer = parser.parseExpression();
        }
        if (this.resultType != null) {
            answer = ExpressionBuilder.convertToExpression(answer, this.resultType);
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        SimpleLanguage answer = new SimpleLanguage();
        answer.setResultType(resultType);
        return answer.createExpression(expression);
    }

    public static void changeFunctionStartToken(String ... startToken) {
        SimpleTokenizer.changeFunctionStartToken(startToken);
    }

    public static void changeFunctionEndToken(String ... endToken) {
        SimpleTokenizer.changeFunctionEndToken(endToken);
    }
}

