package example2.camel;

import org.apache.camel.builder.RouteBuilder;

/**
 * @author Japan Apache Camel Users Group
 * 
 * data/inboxにあるファイルを取得し、data/outboxに出力する</p>
 * 処理後、data/inboxのファイルは削除しない
 */
public class FileToFileRoute extends RouteBuilder {
	
	@Override
	public void configure() throws Exception {
		from("file:inbox?noop=true&delay=5000")   //noop=true:処理後、ファイルの削除をしない
//		from("file:inbox")   //noop=false(デフォルト):ファイルの削除をする。ファイルは.camelに退避
				.to("file:outbox?fileName=${file:onlyname.noext}.${date:now:yyyyMMdd-HH.mm.ss}");
	}
}
