/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.DocumentEndEvent;
import com.esotericsoftware.yamlbeans.parser.DocumentStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlWriter {
    private final YamlConfig config;
    private final Emitter emitter;
    private boolean started;
    private Map<Class, Object> defaultValuePrototypes = new IdentityHashMap<Class, Object>();
    private final List queuedObjects = new ArrayList();
    private final Map<Object, Integer> referenceCount = new IdentityHashMap<Object, Integer>();
    private final Map<Object, String> anchoredObjects = new HashMap<Object, String>();
    private int nextAnchor = 1;
    private boolean isRoot;

    public YamlWriter(Writer writer) {
        this(writer, new YamlConfig());
    }

    public YamlWriter(Writer writer, YamlConfig config) {
        this.config = config;
        this.emitter = new Emitter(writer, config.writeConfig.emitterConfig);
    }

    public void setAlias(Object object, String alias) {
        this.anchoredObjects.put(object, alias);
    }

    public void write(Object object) throws YamlException {
        if (this.config.writeConfig.autoAnchor) {
            this.countObjectReferences(object);
            this.queuedObjects.add(object);
            return;
        }
        this.writeInternal(object);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    private void writeInternal(Object object) throws YamlException {
        try {
            if (!this.started) {
                this.emitter.emit(Event.STREAM_START);
                this.started = true;
            }
            this.emitter.emit(new DocumentStartEvent(this.config.writeConfig.explicitFirstDocument, null, null));
            this.isRoot = true;
            this.writeValue(object, this.config.writeConfig.writeRootTags ? null : object.getClass(), null, null);
            this.emitter.emit(new DocumentEndEvent(this.config.writeConfig.explicitEndDocument));
        }
        catch (EmitterException ex) {
            throw new YamlException("Error writing YAML.", ex);
        }
        catch (IOException ex) {
            throw new YamlException("Error writing YAML.", ex);
        }
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void clearAnchors() throws YamlException {
        for (Object object : this.queuedObjects) {
            this.writeInternal(object);
        }
        this.queuedObjects.clear();
        this.referenceCount.clear();
        this.nextAnchor = 1;
    }

    public void close() throws YamlException {
        this.clearAnchors();
        this.defaultValuePrototypes.clear();
        try {
            this.emitter.emit(Event.STREAM_END);
            this.emitter.close();
        }
        catch (EmitterException ex) {
            throw new YamlException(ex);
        }
        catch (IOException ex) {
            throw new YamlException(ex);
        }
    }

    private void writeValue(Object object, Class fieldClass, Class elementType, Class defaultType) throws EmitterException, IOException, YamlException {
        boolean unknownType;
        boolean isRoot = this.isRoot;
        this.isRoot = false;
        if (object == null) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, null, '\u0000'));
            return;
        }
        Class<?> valueClass = object.getClass();
        boolean bl = unknownType = fieldClass == null;
        if (unknownType) {
            fieldClass = valueClass;
        }
        if (object instanceof Enum) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, ((Enum)object).name(), '\u0000'));
            return;
        }
        String anchor = null;
        if (!Beans.isScalar(valueClass)) {
            anchor = this.anchoredObjects.get(object);
            if (this.config.writeConfig.autoAnchor) {
                Integer count = this.referenceCount.get(object);
                if (count == null) {
                    this.emitter.emit(new AliasEvent(this.anchoredObjects.get(object)));
                    return;
                }
                if (count > 1) {
                    this.referenceCount.remove(object);
                    if (anchor == null) {
                        anchor = String.valueOf(this.nextAnchor++);
                        this.anchoredObjects.put(object, anchor);
                    }
                }
            }
        }
        String tag = null;
        boolean showTag = false;
        if ((unknownType || valueClass != fieldClass || this.config.writeConfig.writeClassName == YamlConfig.WriteClassName.ALWAYS) && this.config.writeConfig.writeClassName != YamlConfig.WriteClassName.NEVER) {
            showTag = true;
            if ((unknownType || fieldClass == List.class) && valueClass == ArrayList.class) {
                showTag = false;
            }
            if ((unknownType || fieldClass == Map.class) && valueClass == HashMap.class) {
                showTag = false;
            }
            if (fieldClass == Set.class && valueClass == HashSet.class) {
                showTag = false;
            }
            if (valueClass == defaultType) {
                showTag = false;
            }
            if (showTag && (tag = this.config.classNameToTag.get(valueClass.getName())) == null) {
                tag = valueClass.getName();
            }
        }
        for (Map.Entry<Class, ScalarSerializer> entry : this.config.scalarSerializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(valueClass)) continue;
            ScalarSerializer serializer = entry.getValue();
            this.emitter.emit(new ScalarEvent(null, tag, new boolean[]{tag == null, tag == null}, serializer.write(object), '\u0000'));
            return;
        }
        if (Beans.isScalar(valueClass)) {
            char style = '\u0000';
            String string = String.valueOf(object);
            if (valueClass == String.class) {
                try {
                    Float.parseFloat(string);
                    style = '\'';
                }
                catch (NumberFormatException serializer) {
                    // empty catch block
                }
            }
            this.emitter.emit(new ScalarEvent(null, tag, new boolean[]{true, true}, string, style));
            return;
        }
        if (object instanceof Collection) {
            this.emitter.emit(new SequenceStartEvent(anchor, tag, !showTag, false));
            for (Object e : (Collection)object) {
                if (isRoot && !this.config.writeConfig.writeRootElementTags) {
                    elementType = e.getClass();
                }
                this.writeValue(e, elementType, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        if (object instanceof Map) {
            this.emitter.emit(new MappingStartEvent(anchor, tag, !showTag, false));
            for (Object object2 : ((Map)object).entrySet()) {
                Map.Entry entry = (Map.Entry)object2;
                this.writeValue(entry.getKey(), null, null, null);
                if (isRoot && !this.config.writeConfig.writeRootElementTags) {
                    elementType = entry.getValue().getClass();
                }
                this.writeValue(entry.getValue(), elementType, null, null);
            }
            this.emitter.emit(Event.MAPPING_END);
            return;
        }
        if (fieldClass.isArray()) {
            elementType = fieldClass.getComponentType();
            this.emitter.emit(new SequenceStartEvent(anchor, null, true, false));
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.writeValue(Array.get(object, i), elementType, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        Object prototype = null;
        if (!this.config.writeConfig.writeDefaultValues && valueClass != Class.class && (prototype = this.defaultValuePrototypes.get(valueClass)) == null && Beans.getDeferredConstruction(valueClass, this.config) == null) {
            try {
                prototype = Beans.createObject(valueClass, this.config.privateConstructors);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new YamlException("Error creating object prototype to determine default values.", invocationTargetException);
            }
            this.defaultValuePrototypes.put(valueClass, prototype);
        }
        Set<Beans.Property> set = Beans.getProperties(valueClass, this.config.beanProperties, this.config.privateFields, this.config);
        this.emitter.emit(new MappingStartEvent(anchor, tag, !showTag, false));
        for (Beans.Property property : set) {
            try {
                Object propertyValue = property.get(object);
                if (prototype != null) {
                    Object prototypeValue = property.get(prototype);
                    if (propertyValue == null && prototypeValue == null || propertyValue != null && prototypeValue != null && prototypeValue.equals(propertyValue)) continue;
                }
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, property.getName(), '\u0000'));
                Class propertyElementType = this.config.propertyToElementType.get(property);
                Class propertyDefaultType = this.config.propertyToDefaultType.get(property);
                this.writeValue(propertyValue, property.getType(), propertyElementType, propertyDefaultType);
            }
            catch (Exception ex) {
                throw new YamlException("Error getting property '" + property + "' on class: " + valueClass.getName(), ex);
            }
        }
        this.emitter.emit(Event.MAPPING_END);
    }

    private void countObjectReferences(Object object) throws YamlException {
        if (object == null || Beans.isScalar(object.getClass())) {
            return;
        }
        Integer count = this.referenceCount.get(object);
        if (count != null) {
            this.referenceCount.put(object, count + 1);
            return;
        }
        this.referenceCount.put(object, 1);
        if (object instanceof Collection) {
            for (Object item : (Collection)object) {
                this.countObjectReferences(item);
            }
            return;
        }
        if (object instanceof Map) {
            for (Object value : ((Map)object).values()) {
                this.countObjectReferences(value);
            }
            return;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.countObjectReferences(Array.get(object, i));
            }
            return;
        }
        Set<Beans.Property> properties = Beans.getProperties(object.getClass(), this.config.beanProperties, this.config.privateFields, this.config);
        for (Beans.Property property : properties) {
            Object propertyValue;
            if (Beans.isScalar(property.getType())) continue;
            try {
                propertyValue = property.get(object);
            }
            catch (Exception ex) {
                throw new YamlException("Error getting property '" + property + "' on class: " + object.getClass().getName(), ex);
            }
            this.countObjectReferences(propertyValue);
        }
    }
}

