/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.HighlightParser;
import com.codewaves.codehighlight.core.Language;
import com.codewaves.codehighlight.core.StyleRenderer;
import com.codewaves.codehighlight.core.StyleRendererFactory;
import com.codewaves.codehighlight.languages.ApacheLanguage;
import com.codewaves.codehighlight.languages.BashLanguage;
import com.codewaves.codehighlight.languages.CppLanguage;
import com.codewaves.codehighlight.languages.CsLanguage;
import com.codewaves.codehighlight.languages.CssLanguage;
import com.codewaves.codehighlight.languages.DiffLanguage;
import com.codewaves.codehighlight.languages.GroovyLanguage;
import com.codewaves.codehighlight.languages.HttpLanguage;
import com.codewaves.codehighlight.languages.IniLanguage;
import com.codewaves.codehighlight.languages.JavaLanguage;
import com.codewaves.codehighlight.languages.JsLanguage;
import com.codewaves.codehighlight.languages.JsonLanguage;
import com.codewaves.codehighlight.languages.MakefileLanguage;
import com.codewaves.codehighlight.languages.ObjCLanguage;
import com.codewaves.codehighlight.languages.PerlLanguage;
import com.codewaves.codehighlight.languages.PhpLanguage;
import com.codewaves.codehighlight.languages.PythonLanguage;
import com.codewaves.codehighlight.languages.RubyLanguage;
import com.codewaves.codehighlight.languages.ScalaLanguage;
import com.codewaves.codehighlight.languages.ShellLanguage;
import com.codewaves.codehighlight.languages.XmlLanguage;
import com.codewaves.codehighlight.languages.YamlLanguage;
import java.util.HashMap;
import java.util.Map;

public class Highlighter {
    private static final Map<String, Language> mLanguageMap;
    private static final String[] mLanguages;
    private StyleRendererFactory mRendererFactory;

    private static void registerLanguage(String string, Map<String, Language> map, Language language) {
        map.put(string, language);
        if (language.aliases != null) {
            for (String string2 : language.aliases) {
                map.put(string2, language);
            }
        }
    }

    public static Language findLanguage(String string) {
        return mLanguageMap.get(string);
    }

    public Highlighter(StyleRendererFactory styleRendererFactory) {
        this.mRendererFactory = styleRendererFactory;
    }

    public HighlightResult highlight(String string, String string2) {
        Language language = mLanguageMap.get(string);
        if (language == null) {
            return new HighlightResult(0, null, string2);
        }
        StyleRenderer styleRenderer = this.mRendererFactory.create(string);
        HighlightParser highlightParser = new HighlightParser(language, this.mRendererFactory, styleRenderer);
        int n = highlightParser.highlight(string2, false, null);
        return new HighlightResult(n, string, styleRenderer.getResult());
    }

    public HighlightResult highlightAuto(String string, String[] stringArray) {
        String[] stringArray2 = stringArray == null || stringArray.length == 0 ? mLanguages : stringArray;
        int n = 0;
        String string2 = null;
        CharSequence charSequence = null;
        for (String string3 : stringArray2) {
            StyleRenderer styleRenderer;
            HighlightParser highlightParser;
            int n2;
            Language language = mLanguageMap.get(string3);
            if (language == null || (n2 = (highlightParser = new HighlightParser(language, this.mRendererFactory, styleRenderer = this.mRendererFactory.create(string3))).highlight(string, false, null)) <= n) continue;
            n = n2;
            string2 = string3;
            charSequence = styleRenderer.getResult();
        }
        return new HighlightResult(n, string2, charSequence);
    }

    static {
        HashMap<String, Language> hashMap = new HashMap<String, Language>();
        Highlighter.registerLanguage("apache", hashMap, new ApacheLanguage().build());
        Highlighter.registerLanguage("bash", hashMap, new BashLanguage().build());
        Highlighter.registerLanguage("cpp", hashMap, new CppLanguage().build());
        Highlighter.registerLanguage("cs", hashMap, new CsLanguage().build());
        Highlighter.registerLanguage("css", hashMap, new CssLanguage().build());
        Highlighter.registerLanguage("diff", hashMap, new DiffLanguage().build());
        Highlighter.registerLanguage("groovy", hashMap, new GroovyLanguage().build());
        Highlighter.registerLanguage("http", hashMap, new HttpLanguage().build());
        Highlighter.registerLanguage("ini", hashMap, new IniLanguage().build());
        Highlighter.registerLanguage("java", hashMap, new JavaLanguage().build());
        Highlighter.registerLanguage("javascript", hashMap, new JsLanguage().build());
        Highlighter.registerLanguage("json", hashMap, new JsonLanguage().build());
        Highlighter.registerLanguage("makefile", hashMap, new MakefileLanguage().build());
        Highlighter.registerLanguage("objectivec", hashMap, new ObjCLanguage().build());
        Highlighter.registerLanguage("perl", hashMap, new PerlLanguage().build());
        Highlighter.registerLanguage("php", hashMap, new PhpLanguage().build());
        Highlighter.registerLanguage("python", hashMap, new PythonLanguage().build());
        Highlighter.registerLanguage("ruby", hashMap, new RubyLanguage().build());
        Highlighter.registerLanguage("scala", hashMap, new ScalaLanguage().build());
        Highlighter.registerLanguage("shell", hashMap, new ShellLanguage().build());
        Highlighter.registerLanguage("xml", hashMap, new XmlLanguage().build());
        Highlighter.registerLanguage("yaml", hashMap, new YamlLanguage().build());
        mLanguageMap = hashMap;
        mLanguages = new String[]{"apache", "bash", "cpp", "cs", "css", "diff", "groovy", "http", "ini", "java", "javascript", "json", "makefile", "objectivec", "perl", "php", "python", "ruby", "scala", "shell", "xml", "yaml"};
    }

    public static class HighlightResult {
        private int relevance;
        private String language;
        private CharSequence result;

        HighlightResult(int n, String string, CharSequence charSequence) {
            this.relevance = n;
            this.language = string;
            this.result = charSequence;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public String getLanguage() {
            return this.language;
        }

        public CharSequence getResult() {
            return this.result;
        }
    }
}

