/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import com.vladsch.flexmark.util.collection.iteration.SparseIndexIterator;
import java.util.BitSet;

public class SparseIndexIterable
implements ReversibleIterable<Integer> {
    private final int[] myStarts;
    private final int[] myEnds;
    private final boolean myIsReversed;

    public SparseIndexIterable(BitSet bitSet) {
        this(bitSet, false);
    }

    public SparseIndexIterable(BitSet bitSet, boolean reversed) {
        int end;
        int start;
        int i = 0;
        int lastIndex = 0;
        while ((start = bitSet.nextSetBit(lastIndex)) >= 0) {
            end = bitSet.nextClearBit(start);
            ++i;
            lastIndex = end;
        }
        this.myStarts = new int[i];
        this.myEnds = new int[i];
        lastIndex = 0;
        i = 0;
        while ((start = bitSet.nextSetBit(lastIndex)) >= 0) {
            end = bitSet.nextClearBit(start);
            this.myStarts[i] = start;
            this.myEnds[i] = end - 1;
            ++i;
            lastIndex = end;
        }
        this.myIsReversed = reversed;
    }

    public SparseIndexIterable(int[] starts, int[] ends, boolean reversed) {
        this.myStarts = starts;
        this.myEnds = ends;
        this.myIsReversed = reversed;
        if (starts.length != ends.length) {
            throw new IllegalArgumentException("starts and ends arrays must be the same size");
        }
    }

    @Override
    public boolean isReversed() {
        return this.myIsReversed;
    }

    @Override
    public ReversibleIterator<Integer> iterator() {
        return new SparseIndexIterator(this.myStarts, this.myEnds, this.myIsReversed);
    }

    @Override
    public ReversibleIterable<Integer> reversed() {
        return new SparseIndexIterable(this.myStarts, this.myEnds, !this.myIsReversed);
    }

    @Override
    public ReversibleIterator<Integer> reversedIterator() {
        return new SparseIndexIterator(this.myStarts, this.myEnds, !this.myIsReversed);
    }
}

