/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: runTestFixture.c,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#include <ccunit/CCUnit.h>

extern void setUp_complex_test();
extern void tearDown_complex_test();
extern void test_complex_equals();
extern void test_complex_add();

int main ()
{
  CCUnitTestFixture* fixture;
  CCUnitTestResult* result;
  bool success;
  fixture = ccunit_newTestFixture ("complex test",
                                   CCUNIT_NEWTESTFUNC(setUp_complex_test),
                                   CCUNIT_NEWTESTFUNC(tearDown_complex_test));
  ccunit_addNewTestCase (fixture, 
                         "test_complex_equals",
                         "complex equals test",
                         test_complex_equals);
  ccunit_addNewTestCase (fixture,
                         "test_complex_add",
                         "complex add test",
                         test_complex_add);
  result = ccunit_runTestFixture (fixture);
  success = ccunit_wasSuccessful (result);
  return success ? 0 : -1;
}
