/* -*- mode: C; -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestListener.h,v 1.6 2003/09/24 11:14:21 tsutsumi Exp $
 */
/**@file
 * TestListener Interface module.
 */

#ifndef CCUNITTESTLISTENER_H
#define CCUNITTESTLISTENER_H

#include <ccunit/CCUnitConfig.h>
#include <ccunit/CCUnitTestFailure.h>
#include <ccunit/CCUnitTestFixture.h>

/**
 * @ingroup ModuleHierarchy
 * @defgroup CCUnitTestListener TestListener
 * A Listener for test progress.
 *
 * Implementing the Observer pattern a CCUnitTestListener may be
 * registered to a CCUnitTestResult to obtain information on the
 * testing progress. Use specialized sub classes of CCUnitTestListener
 * for text output.
 *
 * @see CCUnitTestResult
 *
 * @{
 */

struct CCUnitTestListener;

/**
 * A Listener for test progress.
 *
 * Implementing the Observer pattern a CCUnitTestListener may be
 * registered to a CCUnitTestResult to obtain information on the
 * testing progress. Use specialized sub classes of CCUnitTestListener
 * for text output.
 *
 * @see CCUnitTestResult
 * @ingroup TrackingTestExecution
 */
typedef struct CCUnitTestListener CCUnitTestListener;

/**
 * A Listener for test progress.
 * @ingroup TrackingTestExecution
 */
struct CCUnitTestListener
{
  /**
   * A failure occurred.
   */
  void (*addFailure) (CCUnitTestListener* listener, CCUnitTestFailure* failure);

  /**
   * A test started.
   */
  void (*startTest) (CCUnitTestListener* listener, CCUnitTestCase* testCase);

  /**
   * A test ended.
   */
  void (*endTest) (CCUnitTestListener* listener, CCUnitTestCase* testCase);
};

/** @} */

#endif
