/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: runFailure.c,v 1.6 2003/10/01 20:57:32 tsutsumi Exp $
 */
#include <ccunit/CCUnitTestRunner.h>

extern CCUnitTestSuite* failAssert_suite (const char* name);

int main ()
{
  CCUnitTestRunner* runner;
  CCUnitTestSuite* suite;
  size_t fails;
  size_t runs;
#if CCUNIT_WITH_DMALLOC
  dmalloc_debug_setup ("log-stats,"
		       "log-non-free,"
		       "log-bad-space,"
		       "log-elapsed-time,"
		       "check-fence,"
		       "free-blank,"
		       "error-abort,"
		       "alloc-blank,"
		       "catch-null,"
		       "inter=100,"
		       "log=dm-runFailure.log");
#endif	/* CCUNIT_WITH_DMALLOC */
  runner = ccunit_newTestRunner (NULL);
  suite = failAssert_suite ("failure");
  ccunit_runTestRunner (runner, suite);
  runs = ccunit_runCount (runner->result);
  fails = ccunit_failureCount (runner->result);
  ccunit_deleteTestRunner (runner);
  ccunit_deleteTestSuite (suite);
#if CCUNIT_WITH_DMALLOC && !CCUNIT_HAVE_ATEXIT && !CCUNIT_HAVE_ONEXIT
  dmalloc_shutdown ();
#endif
  return fails == runs + 2 ? -1 : 0;
}
