/* -*- C -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: complex.h,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#ifndef COMPLEX_H
#define COMPLEX_H

typedef struct complex_t
{
  double real;
  double imaginary;
} complex_t;

extern complex_t* complex_new (double real, double imaginary);
extern inline void complex_delete (const complex_t* cp);
extern char* complex_to_string (const complex_t* cp);
extern complex_t* complex_add (complex_t* z, const complex_t* x, const complex_t* y);
extern complex_t* complex_sub (complex_t* z, const complex_t* x, const complex_t* y);
extern complex_t* complex_mul (complex_t* z, const complex_t* x, const complex_t* y);
extern complex_t* complex_div (complex_t* z, const complex_t* x, const complex_t* y);
extern inline int complex_equals (const complex_t*x, const complex_t* y);

#endif	/* COMPLEX_H */
