/* -*- C -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitLogMessage.h,v 1.4 2003/09/14 18:56:16 tsutsumi Exp $
 */

/** @file
 * Log message output module.
 */
#ifndef CCUNITLOGMASSAGE_H
#define CCUNITLOGMASSAGE_H

#include <ccunit/CCUnitConfig.h>

/**
 * @ingroup ModuleHierarchy
 * @defgroup CCUnitLogMessage LogMessage
 * Output messages.
 * @{
 */

/**
 * flag for print debug message.
 */
extern bool _ccunit_debug_message;

/**
 * flag for print log message.
 */
extern bool _ccunit_verbose_message;

/**
 * print debug message.
 * @param fmt message format string.
 * @param ... message arguments.
 */
extern inline void ccunit_dbg (const char* fmt, ...)
  __attribute__ ((format (printf, 1, 2)));

/**
 * print log message.
 * @param fmt message format string.
 * @param ... message arguments.
 */
extern inline void ccunit_log (const char* fmt, ...)
  __attribute__ ((format (printf, 1, 2)));

/**
 * print error message.
 * @param fmt message format string.
 * @param ... message arguments.
 */
extern inline void ccunit_err (const char* fmt, ...)
  __attribute__ ((format (printf, 1, 2)));

/**
 * print message.
 * @param fmt message format string.
 * @param ... message arguments.
 */
extern inline void ccunit_msg (const char* fmt, ...)
  __attribute__ ((format (printf, 1, 2)));

/** @} */
#endif
