#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static void
shuffle (const int size, int array[])
{
	int		i;
	for (i = 0; i < size; i++) {
		int		j = i + rand () % (size - i);
		int		tmp = array[j];
		array[j] = array[i];
		array[i] = tmp;
	}
	return;
}

static int *
random_sequence (const int size)
{
	int		i;
	int		*array = (int *) malloc (size * sizeof (int));
	for (i = 0; i < size; i++) array[i] = i;
	shuffle (size, array);
	return array;
}

void
count_results (int n, int *a, int *c)
{
	int		j = 0;
	if (a[0] == 0 && a[1] == 1 && a[2] == 2) {
		c[j]++;
		return;
	}

	j++;
	if (a[0] == 0 && a[1] == 2 && a[2] == 1) {
		c[j]++;
		return;
	}

	j++;
	if (a[0] == 1 && a[1] == 0 && a[2] == 2) {
		c[j]++;
		return;
	}

	j++;
	if (a[0] == 1 && a[1] == 2 && a[2] == 0) {
		c[j]++;
		return;
	}

	j++;
	if (a[0] == 2 && a[1] == 0 && a[2] == 1) {
		c[j]++;
		return;
	}

	j++;
	if (a[0] == 2 && a[1] == 1 && a[2] == 0) {
		c[j]++;
		return;
	}
	return;
}


int
main (void)
{
	int		i;
	int		n = 3;
	int		sum = 0;
	int		c[] = {0, 0, 0, 0, 0, 0};

	srand (time (NULL));

	for (i = 0; i < 100000; i++) {
		int	*a = random_sequence (n);
		count_results (n, a, c);
		free (a);
	}
	for (i = 0; i < 6; i++) {
		fprintf (stdout, "c[%d] = %d\n", i, c[i]);
		sum += c[i];
	}
	fprintf (stderr, "sum = %d\n", sum);
	return 0;
}
