/*
 * Decompiled with CFR 0.152.
 */
package cfdoc.parser;

import cfdoc.parser.CfComment;
import cfdoc.parser.CfElement;
import cfdoc.parser.CfFile;
import cfdoc.parser.CfHtmlComment;
import cfdoc.parser.CfNode;
import cfdoc.parser.CfParserException;
import cfdoc.parser.CfText;
import cfdoc.parser.CharReader;
import cfdoc.parser.ScannerPosition;
import cfdoc.util.FileUtil;
import cfdoc.util.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class CfScanner {
    private static Logger logger;
    static final String[] TAG_NAMES;
    CharReader reader = new CharReader();
    int ch = -1;
    String defaultEncoding = Charset.defaultCharset().name();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CfFile parse(File file, File basedir) throws CfParserException {
        String source;
        String encoding = this.findEncoding(file);
        logger.debug("encoding=" + encoding);
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        try {
            source = CharReader.readFile(file, encoding);
        }
        catch (IOException e) {
            throw new CfParserException("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + file, e);
        }
        this.reader.setSource(source, file);
        logger.debug(source);
        this.ch = this.reader.getChar();
        ArrayList<CfNode> taglist = new ArrayList<CfNode>();
        do {
            CfNode t = this.getToken();
            logger.debug(t);
            taglist.add(t);
        } while (this.ch != -1);
        return new CfFile(file, basedir, source, encoding, taglist);
    }

    CfNode getToken() throws CfParserException {
        ScannerPosition srcpos = this.reader.getScannerPosition();
        if (this.ch == 60) {
            String type = "OPEN";
            this.ch = this.reader.getChar();
            if (this.ch == 33) {
                this.ch = this.reader.getChar();
                if (this.ch != 45) {
                    String sval = "";
                    while (this.ch != 62) {
                        sval = sval + this.ch;
                        this.ch = this.reader.getChar();
                    }
                    this.ch = this.reader.getChar();
                    return new CfElement("SINGLE", sval, srcpos);
                }
                this.ch = this.reader.getChar();
                if (this.ch != 45) {
                    this.reader.throwException("'-' \u304c\u3042\u308a\u307e\u305b\u3093:" + (char)this.ch);
                }
                this.ch = this.reader.getChar();
                if (this.ch == 45) {
                    this.ch = this.reader.getChar();
                    return new CfComment(this.getCfComment(srcpos), srcpos);
                }
                this.ch = this.reader.getChar();
                return new CfHtmlComment(this.getHttpComment(srcpos), srcpos);
            }
            if (this.ch == 47) {
                type = "CLOSE";
                this.ch = this.reader.getChar();
            }
            this.ch = this.skipWhiteSpace();
            String tagname = this.getIdentifier();
            this.ch = this.skipWhiteSpace();
            CfElement tag = new CfElement(type, tagname, srcpos);
            if (this.isOneOf(tagname, TAG_NAMES)) {
                while (this.ch != 62 && this.ch != 47) {
                    this.ch = this.skipWhiteSpace();
                    String attrname = this.getAttributeLeft();
                    this.ch = this.skipWhiteSpace();
                    if (this.ch == 61) {
                        this.ch = this.reader.getChar();
                        this.ch = this.skipWhiteSpace();
                        String attrvalue = this.getAttributeLeft();
                        logger.debug("name=" + attrname + " value=" + attrvalue + " ch=" + (char)this.ch);
                        if (attrvalue.charAt(0) == '\"') {
                            attrvalue = attrvalue.substring(1);
                        }
                        if (attrvalue.endsWith("\"")) {
                            attrvalue = attrvalue.substring(0, attrvalue.length() - 1);
                        }
                        tag.addAttribute(attrname.toLowerCase(), attrvalue);
                        continue;
                    }
                    logger.debug("name=" + null + " value=" + attrname + " ch=" + (char)this.ch);
                    tag.addExpression(attrname);
                }
            } else {
                while (this.ch != 62) {
                    this.ch = this.reader.getChar();
                }
            }
            if (this.ch == 47) {
                tag.type = "SINGLE";
                this.ch = this.reader.getChar();
            }
            if (this.ch != 62) {
                this.reader.throwException("'>' \u304c\u3042\u308a\u307e\u305b\u3093 ch=" + (char)this.ch);
            }
            this.ch = this.reader.getChar();
            return tag;
        }
        String text = "";
        do {
            text = text + (char)this.ch;
            this.ch = this.reader.getChar();
        } while (this.ch != 60 && this.ch != -1);
        return new CfText(text, srcpos);
    }

    int skipWhiteSpace() throws CfParserException {
        while (Character.isWhitespace((char)this.ch)) {
            this.ch = this.reader.getChar();
        }
        return this.ch;
    }

    String getIdentifier() throws CfParserException {
        if (!$assertionsDisabled && !Character.isJavaIdentifierStart((char)this.ch)) {
            throw new AssertionError(this.ch);
        }
        String sval = "";
        do {
            sval = sval + (char)this.ch;
            this.ch = this.reader.getChar();
        } while (Character.isJavaIdentifierPart((char)this.ch));
        return sval;
    }

    String getAttributeLeft() throws CfParserException {
        if (!$assertionsDisabled && !Character.isJavaIdentifierStart((char)this.ch)) {
            throw new AssertionError(this.ch);
        }
        String sval = "";
        while (this.ch != 61 && this.ch != 47 && this.ch != 62) {
            if (this.ch == 34) {
                sval = sval + this.getString();
                break;
            }
            sval = sval + (char)this.ch;
            this.ch = this.reader.getChar();
        }
        logger.debug("getAttributeLeft()=[" + sval + "] ch=" + (char)this.ch);
        return sval;
    }

    String getString() throws CfParserException {
        if (!$assertionsDisabled && this.ch != 34) {
            throw new AssertionError(this.ch);
        }
        String str = "\"";
        this.ch = this.reader.getChar();
        while (this.ch != 34) {
            if (this.ch == 35) {
                str = str + this.getQuotedString('#');
                continue;
            }
            str = str + (char)this.ch;
            this.ch = this.reader.getChar();
        }
        this.ch = this.reader.getChar();
        return str + "\"";
    }

    String getQuotedString(char q) throws CfParserException {
        if (!$assertionsDisabled && this.ch != q) {
            throw new AssertionError(this.ch);
        }
        String str = "" + q;
        this.ch = this.reader.getChar();
        while (this.ch != q) {
            str = str + (char)this.ch;
            this.ch = this.reader.getChar();
        }
        this.ch = this.reader.getChar();
        return str + q;
    }

    String getCfComment(ScannerPosition start) throws CfParserException {
        ScannerPosition pos;
        do {
            this.ch = this.reader.getChar();
            pos = this.reader.getScannerPosition();
        } while (!this.reader.source.startsWith("--->", pos.pos));
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        return this.reader.source.substring(start.pos - 1, pos.pos + 4);
    }

    String getHttpComment(ScannerPosition start) throws CfParserException {
        ScannerPosition pos;
        do {
            this.ch = this.reader.getChar();
            pos = this.reader.getScannerPosition();
        } while (!this.reader.source.startsWith("-->", pos.pos));
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        this.ch = this.reader.getChar();
        return this.reader.source.substring(start.pos - 1, pos.pos + 3);
    }

    String findEncoding(File file) throws CfParserException {
        String source;
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        try {
            source = CharReader.readFile(file);
        }
        catch (IOException e) {
            throw new CfParserException("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + file, e);
        }
        this.reader.setSource(source, file);
        this.ch = this.reader.getChar();
        do {
            CfNode t;
            if (!((t = this.getToken()) instanceof CfElement)) continue;
            CfElement elem = (CfElement)t;
            if (!elem.tagname.equalsIgnoreCase("cfprocessingdirective")) continue;
            String encoding = elem.getAttributeValue("pageencoding");
            if (encoding == null) {
                return null;
            }
            if (encoding.charAt(0) == '\"') {
                encoding = encoding.substring(1, encoding.length() - 1);
            }
            return encoding;
        } while (this.ch != -1);
        return null;
    }

    boolean isOneOf(String name, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("CfScanner.main()");
        System.out.println("defaultCharset=" + Charset.defaultCharset().name());
        Logger.threshold = Integer.MIN_VALUE;
        if (args.length == 0) {
            System.out.println("usage:java CfScanner <ColdFusion sourcefile>");
            return;
        }
        String fname = "sample/pr01/Application.cfc";
        File basedir = new File("sample/pr01");
        try {
            CfScanner scanner = new CfScanner();
            File file = new File(fname);
            if (file.isDirectory()) {
                ArrayList files = FileUtil.collectFiles(new File("sample"));
                for (int i = 0; i < files.size(); ++i) {
                    file = (File)files.get(i);
                    if (file.isDirectory() || !file.getPath().endsWith(".cfc") && !file.getPath().endsWith(".cfm")) continue;
                    fname = file.getAbsolutePath();
                    System.out.println("fname=" + fname);
                    scanner.parse(basedir, file);
                }
            } else {
                fname = file.getAbsolutePath();
                System.out.println("fname=" + fname);
                scanner.parse(basedir, file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !CfScanner.class.desiredAssertionStatus();
        logger = Logger.getLogger(CfScanner.class);
        TAG_NAMES = new String[]{"cfprocessingdirective", "cffunction", "cfargument", "cfcomponent"};
    }
}

