/*
 * 쐬: 2008/08/03
 */
package cfdoc.parser;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

import cfdoc.util.TextUtil;

public class CfFile implements Serializable {
	public final File file;
	public final File basedir;
	public final String source;
	public final String encoding;
	final ArrayList taglist;
	/** R|[lgXg. cfc̏ꍇ͂PBcfm̏ꍇ͋(vfO)ɂȂB */
	ArrayList compList = new ArrayList();
	/** ֐Xg. Ɨ֐̂݁BR|[lg̊֐͊܂܂ȂB */
	ArrayList funcList = new ArrayList();
	
	public CfFile(File file, File basedir, String source, String encoding, ArrayList taglist) {
		this.file = file;
		this.basedir = basedir;
		this.source = source;
		this.encoding = encoding;
		this.taglist = taglist;
	}
	public void addComponent(CfComponent comp) {
		compList.add(comp);
	}
	public int getComponentCount() {
		return compList.size();
	}
	public CfComponent getComponent(int index) {
		return (CfComponent) compList.get(index);
	}
	public void addFunction(CfFunction func) {
		funcList.add(func);
	}
	public int getFunctionCount() {
		return funcList.size();
	}
	public CfFunction getFunction(int index) {
		return (CfFunction) funcList.get(index);
	}
	public String getRelativePath() {
		return file.getAbsolutePath().substring(basedir.getAbsolutePath().length()+1);
	}
}
