/*
 * 쐬: 2008/05/25
 */
package cfdoc.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class CfFunction implements Serializable {
	public final String name;
	HashMap attrMap;	// Map<String,String>	key͏Ŋi[Ă
	ArrayList args = new ArrayList();
	/** not null */
	public final CfFile file;
	/** nillable */
	public final CfComponent comp;
	public CfComment comment;

	CfFunction(String name, HashMap attrMap, CfFile file, CfComponent comp, CfComment comment) {
		this.name = name;
		this.attrMap = attrMap;
		this.file = file;
		this.comp = comp;
		this.comment = comment;
	}
	public String getAttribute(String name, String def) {
		String value = (String) attrMap.get(name.toLowerCase());
		if (value == null) value = def;
		return value;
	}
	public void addArgument(CfArgument arg) {
		args.add(arg);
	}
	public int getArgumentCount() {
		return args.size();
	}
	public CfArgument getArgument(int index) {
		return (CfArgument) args.get(index);
	}
	public CfComment getComment() {
		return comment;
	}
	public String toString() {
		String result = "";
		if (comment != null) result += comment.comment + "\n";
		result += "CfFunction["+name+"]";
		return result;
	}
}
