/*
 * 쐬: 2008/05/25
 */
package cfdoc.parser;

import java.io.File;
import java.util.ArrayList;

import cfdoc.util.Logger;

/** ColdFusion̍\͊ */
public class CfParser {
	/** Oo */
    private static Logger logger = Logger.getLogger(CfParser.class);
	private CfScanner parser = new CfScanner();

	/**
	 * ftHg̃GR[fBOw肷B
	 * cfprocessingdirective^OɃGR[fBO̎w肪Ȃꍇ́A
	 * ̃GR[fBOœǂݍށB
	 * GR[hɂ JavãGR[fBO iUTF-8 Shift_JIS windows-31j EUC-JP jw肵܂B
	 * http://java.sun.com/j2se/1.5.0/ja/docs/ja/guide/intl/encoding.doc.html
	 * @param	encoding	GR[fBO nulls
	 */
	public void setDefaultEncoding(String encoding) {
    	parser.defaultEncoding = encoding;
    }
	/**
	 * w肳ꂽt@Cꗗ\͂.
	 * @param	dir	\[XfBNg.nullsBׂẴ\[Xt@C͕@IɐƁB
	 * @return	͌ʂԂBnulls
	 * @exception	CfParserException	\[Xt@Cɕ@G[ꍇB
	 */
	public CfSystem parseDir(File basedir) throws CfParserException {
		ArrayList files = collectFile(basedir);
		return parseFiles(basedir, files);
	}    
	/**
	 * w肳ꂽt@Cꗗ\͂.
	 * @param	files	\[Xt@CꗗBArray<File>.nullsBׂẴ\[Xt@C͕@IɐƁB
	 * @return	͌ʂԂBnulls
	 * @exception	CfParserException	\[Xt@Cɕ@G[ꍇB
	 */
	public CfSystem parseFiles(File basedir, ArrayList files) throws CfParserException {
		// \[Xǂݍ݁A͂B
		CfSystem system = new CfSystem();
		for (int i=0; i<files.size(); i++) {
			File file = (File) files.get(i);
			logger.info(file);
			parseFile(file, basedir, system);
		}
		return system;
	}
	
    public void parseFile(File file, File basedir, CfSystem system) throws CfParserException {
		if (file.getName().endsWith(".cfc")) {
			parseCfc(file, basedir, system);
		} 
		else if(file.getName().endsWith(".cfm")) {
			parseCfm(file, basedir, system);
		} 
		else {
			System.out.println("cfc, cfmł͂܂:"+file);
		}
	}
	public void parseCfc(File file, File basedir, CfSystem system) throws CfParserException {
		// ͂sB
		logger.debug(file);
		CfFile cffile = parser.parse(file, basedir);
		system.addFile(cffile);
		CfComponent comp = null;
		// [U`֐(UDF)𒊏oB 
		CfFunction func = null;
		CfComment comment = null;
		for (int i=0; i<cffile.taglist.size(); i++) {
			CfNode node = (CfNode) cffile.taglist.get(i);
//			if (i<3 && node instanceof CfComment) {
//				CfComment comment = (CfComment) node;
//				System.out.println(comment);
//			}
			if (node instanceof CfComment) {
				comment = (CfComment) node;
				if (comp != null && comp.comment == null && func == null) {
					comp.comment = comment;
				}
			}
			if (isElement(node, "cfcomponent")) {
				CfElement elem = (CfElement) node;
				if (elem.type == CfElement.OPEN_TAG) {
					comp = new CfComponent(cffile, elem.attrMap);
					cffile.addComponent(comp);
				} else {
					system.addComponent(comp);
				}
			}
			if (isElement(node, "cffunction")) {
				CfElement elem = (CfElement) node;
				if (elem.type == CfElement.OPEN_TAG) {
					String name = elem.getAttributeValue("name");
					func = new CfFunction(name, elem.attrMap, cffile, comp, comment);
					comp.addFunction(func);
					system.addFunction(func);
					cffile.addFunction(func);
				}
				comment = null;
			}
			if (isElement(node, "cfargument")) {
				CfElement elem = (CfElement) node;
				CfArgument arg = new CfArgument(elem.attrMap, comment);
				comment = null;
				if (func == null) 
					throw new CfParserException("cffunction ^O܂", new ScannerPosition(file));
				func.addArgument(arg);
			}
		}
	}
	public void parseCfm(File file, File basedir, CfSystem system) throws CfParserException {
		// ͂sB
		logger.debug(file);
//		CfScanner parser = new CfScanner();
		CfFile cffile = parser.parse(file, basedir);
		system.addFile(cffile);
//		CfComponent comp = null;
		// [U`֐(UDF)𒊏oB 
		CfFunction func = null;
		CfComment comment = null;
		for (int i=0; i<cffile.taglist.size(); i++) {
			CfNode node = (CfNode) cffile.taglist.get(i);
//			if (i<3 && node instanceof CfComment) {
//				CfComment comment = (CfComment) node;
//				System.out.println(comment);
//			}
			if (node instanceof CfComment) {
				comment = (CfComment) node;
			}
			if (isElement(node, "cffunction")) {
				CfElement elem = (CfElement) node;
				if (elem.type == CfElement.OPEN_TAG) {
					String name = elem.getAttributeValue("name");
					func = new CfFunction(name, elem.attrMap, cffile, null, comment);
					system.addFunction(func);
					cffile.addFunction(func);
				}
				comment = null;
			}
			if (isElement(node, "cfargument")) {
				CfElement elem = (CfElement) node;
				CfArgument arg = new CfArgument(elem.attrMap, comment);
				comment = null;
				if (func == null) 
					throw new CfParserException("cffunction ^O܂", new ScannerPosition(file));
				func.addArgument(arg);
			}
		}
	}	
	/** w肳ꂽGgH */
	boolean isElement(CfNode node, String name) {
		if (! (node instanceof CfElement)) return false;
		CfElement elem = (CfElement) node;
		// TODO:CLOSEǂH
		//if (elem.type == CfElement.CLOSE_TAG) return false;
		return elem.tagname.equalsIgnoreCase(name);
	}
	/**
	 * w肳ꂽfBNgȉ ColdFusioñ\[Xt@CW߂B
	 * TufBNg΍ċAIɒTB
	 * gq".cfc",܂́A".cfm"̃t@CB
	 * @param	dir	fBNgBnullsB
	 * @return	File̔zBt@C݂Ȃꍇ́AvfOԂB(null͕ԂȂ) 
	 */
	public ArrayList collectFile(File dir) {
		assert dir != null;
		ArrayList filelist = new ArrayList();
		File[] files = dir.listFiles();
		for (int i=0; i<files.length; i++) {
			if (files[i].isDirectory()) {
				filelist.addAll(collectFile(files[i]));
			} else {
				String fname = files[i].getName();
				if (fname.endsWith(".cfc") || fname.endsWith(".cfm")) {
					filelist.add(files[i]);
				}
			}
		}
		return filelist;
	}	
}
