/*
 * 쐬: 2008/05/18
 */
package cfdoc.parser;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;


import cfdoc.util.FileUtil;
import cfdoc.util.Logger;



/**
 * ͊.
 */
public class CfScanner {
	/** Oo */
    private static Logger logger = Logger.getLogger(CfScanner.class);
    /** ɋ̂^O */
    static final String[] TAG_NAMES = new String[] {
    	"cfprocessingdirective",
    	"cffunction",
    	"cfargument",
    	"cfcomponent",
    };
	CharReader reader = new CharReader();
	/** 擾 */
	int ch = -1;
	String defaultEncoding = Charset.defaultCharset().name();
//	File basedir;
	/**
	 * \͂sA^ÕXgԂBDOMc[ł͂ȂB
	 * @param	file	\[Xt@C
	 * @return	CfNode̔zB
	 */
	public CfFile parse(File file, File basedir) throws CfParserException {
		// \[Xt@C̕R[h𔻒fB킩Ȃꍇ̓ftHg̕R[hɂB
		String encoding = findEncoding(file);
		logger.debug("encoding="+encoding);
		if (encoding == null) {
			encoding = defaultEncoding;
		}
		String source;
		try {
			source = CharReader.readFile(file, encoding);
		} catch (IOException e) {
			throw new CfParserException("t@C̓ǂݍ݂Ɏs܂B:"+file, e);
		}
		// m[hSǂݍށB
		reader.setSource(source, file);
		logger.debug(source);
		ch = reader.getChar();
		ArrayList taglist = new ArrayList();
		CfNode t;
		do {
			t = getToken();
			logger.debug(t);
			taglist.add(t);
		} while (ch != CharReader.EOF);
		return new CfFile(file, basedir, source, encoding, taglist);
	}
	/**
	 * m[h擾B
	 * @return	m[hBCfComment, CfHttpComment, CfElement, CfText̂ꂩ
	 */
    CfNode getToken() throws CfParserException {
		ScannerPosition srcpos = reader.getScannerPosition();
		if (ch == '<') {
			String type = CfElement.OPEN_TAG;
			ch = reader.getChar();
			// <!-- RĝƂ -->
			if (ch == '!') {
				ch = reader.getChar();
				if (ch != '-') {
					// <!DOCTYPE ...> ꍇ
					String sval = "";
					while (ch != '>') {
						sval += ch;
						ch = reader.getChar();
					}
					ch = reader.getChar();
					return new CfElement(CfElement.SINGLE_TAG, sval, srcpos);
				}
				ch = reader.getChar();
				if (ch != '-') reader.throwException("'-' ܂:"+(char)ch);
				ch = reader.getChar();
				if (ch == '-') {
					ch = reader.getChar();
					return new CfComment(getCfComment(srcpos), srcpos);
				} else {
					ch = reader.getChar();
					return new CfHtmlComment(getHttpComment(srcpos), srcpos);
				}
			}
			if (ch == '/') {
				type = CfElement.CLOSE_TAG;
				ch = reader.getChar();
			}
			ch = skipWhiteSpace();
			String tagname = getIdentifier();
			ch = skipWhiteSpace();
			CfElement tag = new CfElement(type, tagname, srcpos);
			if (isOneOf(tagname, TAG_NAMES)) {
				while (ch != '>' && ch != '/') {
					ch = skipWhiteSpace();
					String attrname = getAttributeLeft();
					//logger.debug("attrname="+attrname+" ch="+(char)ch);
					ch = skipWhiteSpace();
					if (ch == '=') {
						ch = reader.getChar();
						ch = skipWhiteSpace();
	//					String attrvalue;
	//					if (ch == '"') {
	//						attrvalue = getString();
	//					} else {
	//						attrvalue = getIdentifier();
	//					}
						String attrvalue = getAttributeLeft();
						logger.debug("name="+attrname+" value="+attrvalue+" ch="+(char)ch);
						// Õ_uNH[e[VȂ
						if (attrvalue.charAt(0) == '"') attrvalue = attrvalue.substring(1);
						if (attrvalue.endsWith("\"")) attrvalue = attrvalue.substring(0, attrvalue.length()-1);
						tag.addAttribute(attrname.toLowerCase(), attrvalue);
					}
					else {
						//reader.throwException("'=' ܂:"+(char)ch);
						logger.debug("name="+null+" value="+attrname+" ch="+(char)ch);
						tag.addExpression(attrname);
					}
				}
			} else {
				while (ch != '>') {
					ch = reader.getChar();
				}				
			}
			if (ch == '/') {
				tag.type = CfElement.SINGLE_TAG;
				ch = reader.getChar();
			}
			if (ch != '>') reader.throwException("'>' ܂ ch="+(char)ch);
			ch = reader.getChar();
			return tag;
		} else {
			String text = "";
			do {
				text += (char) ch;
				ch = reader.getChar();
			} while (ch != '<' && ch != CharReader.EOF);
			return new CfText(text, srcpos);
		}
    }
    /** 󔒕ǂݔ΂. */
    int skipWhiteSpace() throws CfParserException {
//		if (Character.isWhitespace((char) ch)) {
			// 󔒕Ȃ玟̃g[N擾B
			while (Character.isWhitespace((char) ch)) {
				ch = reader.getChar();
			}
//		}
		return ch;
    }
	/** ʎq */
    String getIdentifier() throws CfParserException {
		assert Character.isJavaIdentifierStart((char) ch): ch;
		String sval = "";
		do {
			sval += (char) ch;
			ch = reader.getChar();
		} while (Character.isJavaIdentifierPart((char) ch));
		return sval;
    }
//    Object getExpression() throws CfParserException {
//    	switch (ch) {
//    	case '"':
//    		return getString();
//    	case '#':
//    		return getQuotedString('#');
//    	default:
//    		if (Character.isJavaIdentifierStart((char) ch)) {
//    			String id = getIdentifier();
//    			ch = skipWhiteSpace();
//    			if (ch == '.') {
//    				String member = getExpression();
//    				exp = new CfMemberSelect(id, member);
//    			}
//    		}
//    	}
//    	return null;
//    }
	/** ̍Ӓl */
    String getAttributeLeft() throws CfParserException {
		assert Character.isJavaIdentifierStart((char) ch): ch;
		String sval = "";
		while (true) {
			if (ch == '=') break;
			if (ch == '/') break;
			if (ch == '>') break;
			if (ch == '"') {
				sval += getString();
				break;
			} else {
				sval += (char) ch;
				ch = reader.getChar();
			}
		}// while (Character.isJavaIdentifierPart((char) ch) || ch=='.');
		logger.debug("getAttributeLeft()=["+sval+"] ch="+(char)ch);
		return sval;
    }
    /** _uNH[gň͂܂ꂽ.Ar#ƁA */
    String getString() throws CfParserException {
		assert ch == '"': ch;
		String str = "\"";
		ch = reader.getChar();
		while (ch != '\"') {
			if (ch == '#') {
				str += getQuotedString('#');
			} else {
				str += (char) ch;
				ch = reader.getChar();
			}
		}
		ch = reader.getChar();
		return str + "\"";
    }
    String getQuotedString(char q) throws CfParserException {
		assert ch == q: ch;
		String str = ""+q;
		ch = reader.getChar();
		while (ch != q) {
			str += (char) ch;
			ch = reader.getChar();
		}
		ch = reader.getChar();
		return str + q;
    }
    /** ColdFusioñRg<!--- ---> */
    String getCfComment(ScannerPosition start) throws CfParserException {
    	// 󔒕Ȃ玟̃g[N擾B
		while (true) {
			ch = reader.getChar();
			ScannerPosition pos = reader.getScannerPosition();
			if (reader.source.startsWith("--->", pos.pos)) {
				ch = reader.getChar();
				ch = reader.getChar();
				ch = reader.getChar();
				ch = reader.getChar();
				ch = reader.getChar();
				return reader.source.substring(start.pos-1, pos.pos+4);
			}
		}
    }
    /** HTTP̃Rg<!-- --> */
    String getHttpComment(ScannerPosition start) throws CfParserException {
    	// 󔒕Ȃ玟̃g[N擾B
		while (true) {
			ch = reader.getChar();
			ScannerPosition pos = reader.getScannerPosition();
			if (reader.source.startsWith("-->", pos.pos)) {
				ch = reader.getChar();
				ch = reader.getChar();
				ch = reader.getChar();
				ch = reader.getChar();
				return reader.source.substring(start.pos-1, pos.pos+3);
			}
		}
    }   
    /**
     * \[X̕R[h肷B
     * cfprocessingdirective ^O pageencoding 擾B
     * @param file	\[Xt@CB
     * @return	GR[fBOBȂꍇ́Anull ԂB
     * @throws CfParserException
     */
    String findEncoding(File file) throws CfParserException {
    	assert file != null;
		String source;
		try {
			source = CharReader.readFile(file);
		} catch (IOException e) {
			throw new CfParserException("t@C̓ǂݍ݂Ɏs܂B:"+file, e);
		}
		reader.setSource(source, file);
		ch = reader.getChar();
		do {
			CfNode t = getToken();
			if (t instanceof CfElement) {
				CfElement elem = (CfElement) t;
				if (elem.tagname.equalsIgnoreCase("cfprocessingdirective")) {
					String encoding = elem.getAttributeValue("pageencoding");
					if (encoding == null) return null;	// pageencodingȂ
					if (encoding.charAt(0) == '"') {
						encoding = encoding.substring(1, encoding.length()-1);
					}
					return encoding;	// GR[fBO
				}
			}
		} while (ch != CharReader.EOF);
		return null;	// cfprocessingdirective^OȂB
	}
    boolean isOneOf(String name, String[] names) {
    	for (int i=0; i<names.length; i++) {
    		if (names[i].equalsIgnoreCase(name)) return true;
    	}
    	return false;
    }
    
    public static void main(String[] args) {
		System.out.println("CfScanner.main()");
		System.out.println("defaultCharset="+Charset.defaultCharset().name());
		logger.threshold = Logger.ALL;
		if (args.length==0) {
			System.out.println("usage:java CfScanner <ColdFusion sourcefile>");
			return;
		}
		//String fname = args[0];
		// pr01\action\_template_action.cfm
		//String fname = "sample/pr01/action/_template_action.cfm";
		//String fname = "sample/proto_new/Application.cfc";
		//String fname = "sample/pr01/Application.cfc";
		//String fname = "sample/pr01/AuthInfo.cfc";
		//String fname = "sample/pr01/command/rfp_copy_command.cfc";
		//String fname = "sample/pr01/action/c009action.cfm";
		String fname = "sample/pr01/Application.cfc";
		File basedir = new File("sample/pr01");
		try {
			CfScanner scanner = new CfScanner();
			File file = new File(fname);
			if (file.isDirectory()) {
				ArrayList files = FileUtil.collectFiles(new File("sample"));
				for (int i=0; i<files.size(); i++) {
					file = (File) files.get(i);
					if (file.isDirectory()) continue;
					if (! (file.getPath().endsWith(".cfc") || file.getPath().endsWith(".cfm"))) continue;
					fname = file.getAbsolutePath();
					System.out.println("fname="+fname);
					scanner.parse(basedir, file);
				}
			} else {
				 fname = file.getAbsolutePath();
				 System.out.println("fname="+fname);
				 scanner.parse(basedir, file);
			}
		}
		catch (Exception ex) { ex.printStackTrace(); }
	}


}
