/*
 * 쐬: 2008/08/03
 */
package cfdoc.parser;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;

import java.util.StringTokenizer;

public class CfSystem implements Serializable {
	ArrayList fileList = new ArrayList();
	ArrayList compList = new ArrayList();
	ArrayList funcList = new ArrayList();
	HashMap prop = new HashMap();	// Map<String key, Object value>
	
	CfSystem() {}

	public void addFile(CfFile file) {
		fileList.add(file);
	}
	public CfFile getFile(int index) {
		return (CfFile) fileList.get(index);
	}
	public int getFileCount() {
		return fileList.size();
	}
	public void addComponent(CfComponent comp) {
		compList.add(comp);
	}
	public int getComponentCount() {
		return compList.size();
	}
	public CfComponent getComponent(int index) {
		return (CfComponent) compList.get(index);
	}
	public void addFunction(CfFunction func) {
		funcList.add(func);
	}
	public int getFunctionCount() {
		return funcList.size();
	}
	public CfFunction getFunction(int index) {
		return (CfFunction) funcList.get(index);
	}	

	public String encodeString() {
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(baos);
			oos.writeObject(this);
			byte[] bytes = baos.toByteArray();
			String result = "" + bytes.length;
			for (int i=0; i<bytes.length; i++) {
				result += "," + bytes[i];
			}
			return result;
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		return "";
	}
	public void store(String fname) {
		try {
			FileOutputStream baos = new FileOutputStream(fname);
			ObjectOutputStream oos = new ObjectOutputStream(baos);
			oos.writeObject(this);
			oos.close();
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
	public static CfSystem decodeString(String str) {
		StringTokenizer st = new StringTokenizer(str, ",");
		String bs = st.nextToken();
		int len = Integer.parseInt(bs);
		byte[] bytes = new byte[len];
		int i = 0;
		while (st.hasMoreTokens()) {
			bs = st.nextToken();
			bytes[i++] = Byte.parseByte(bs);
		}
		try {
			ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
			ObjectInputStream ois = new ObjectInputStream(bais);
			return (CfSystem) ois.readObject();
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		return null;
	}
	public static CfSystem load(String fname) {
		try {
			FileInputStream bais = new FileInputStream(fname);
			ObjectInputStream ois = new ObjectInputStream(bais);
			CfSystem sys = (CfSystem) ois.readObject();
			ois.close();
			return sys;
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}
	public void putProperty(String name, Object value) {
		prop.put(name, value);
	}
	public Object getProperty(String name, Object def) {
		Object value = prop.get(name);
		if (value == null) return def;
		return value;
	}
}
