package cfdoc.parser;

/*
 * 쐬: 2005/07/30
 */
import java.io.*;
import java.nio.charset.Charset;

import cfdoc.util.Logger;

/**
 * t@C當ǂݍ݂܂.
 * sI[qFĂ܂B(CR,LF,CR+LF)
 * sAJʒuLĂ܂B
 * P̐ǂ݋@\Ă܂Bmark()/reset()
 * 
 * 
 */
public class CharReader {
	/** Oo */
    private static Logger logger = Logger.getLogger(CharReader.class);

	static final int EOF = -1;
//	static final int TT_LINE_TERMINATOR = -2;
	
	/** t@C. */
	File file;
	/** \[Xt@C */
	String source;
	/** XL̈ʒu */
	int pos;

	/** ǂݍ񂾕 */
//	protected int ch;
	/** sԍ */
	int line;
	/** Jʒu */
	int col;
//private	int last_ch = -1;

    /**
     * t@CeLXgCɓǂݍށB 
     * @param	file	\[Xt@C. nulls
     * @param	charsetName	LN^Zbg("windows-31j"Ȃ) nulls
     * @return	\[Xt@C̓e
     */
	public static String readFile(File file, String charsetName) throws IOException {
		assert file != null;
		assert charsetName != null;
        String source = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), charsetName));
		while (reader.ready()) {
			String line = reader.readLine();
			source += line + "\n";
		}
		reader.close();
		return source;
	}

	/**
     * t@CeLXgCɓǂݍށB 
     * @param	file	\[Xt@C. nulls
     * @return	\[Xt@C̓e
     */
	public static String readFile(File file) throws IOException {
		assert file != null;
		return readFile(file, Charset.defaultCharset().name());
	}	

	/**
	 * @param source	\[X(nulls)
	 * @param file		t@C(null) ΘbIȏꍇnullw肷B
	 */
	void setSource(String source, File file) {
		assert source != null;
        // oɐݒ
		this.file = file;
		this.source = source;
		this.pos = 0;
		this.line = this.col = 1;
//		this.ch = -1;
	}

	private int getChar0() {
		int ch;
		if (pos < source.length()) {
			ch = source.charAt(pos);
			pos++;
			// line;colύX
			if (ch == '\n') {
				line++;
				col = 1;
			} else {
				col++;
			}
		} else {
			ch = EOF;
		}
		return ch;
	}
	int getChar() throws CfParserException {
		return getChar0();
	}

	void throwException(String message) throws CfParserException {
		throw new CfParserException(message, new ScannerPosition(file, pos, line, col));
	}
	void throwException(String message, Exception cause) throws CfParserException {
		throw new CfParserException(message, new ScannerPosition(file, pos, line, col), cause);
	}
	/**
	 * ݂͊̌̏ԂԂB
	 */
	ScannerPosition getScannerPosition() {
        //logger.fine("getScannerPosition()");
        return new ScannerPosition(file, pos, line, col);
	}
//	/**
//	 * ͊w肳ꂽԂɖ߂B
//	 * @param srcpos
//	 */
//	void setScannerPosition(ScannerPosition srcpos) {
//		assert srcpos != null;
//        logger.debug("setScannerPosition()");
//        this.pos = srcpos.pos;
////        this.ch = srcpos.ch;
//        this.line = srcpos.line;
//        this.col = srcpos.col;
//        logger.debug(source.substring(0, pos)+"-----------------\n");
//	}
//	SourcePosition getSourcePosition() {
//		return new SourcePosition(file, line, col);
//	}
	
	public static void main(String[] args) {
		try {
			File file = new File(args[0]);
			String source = readFile(file);
			CharReader scanner = new CharReader();
			scanner.setSource(source, file);
			int ch = -1;
			do {
				System.out.print(file+" "+scanner.pos+"("+scanner.line+";"+scanner.col+")");
				ch = scanner.getChar();
				System.out.println("'"+(char)ch+"'");
			} while (ch != EOF);
		}
		catch (Exception ex) { ex.printStackTrace(); }
	}
}
