/*
 * 쐬: 2006/06/11
 */
package cfdoc.util;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;


/**
 * OLogger
 * 
 * @author a-san
 */
public class Logger {
	public static final int OFF   = Integer.MAX_VALUE;
	public static final int FATAL = 50000;
	public static final int ERROR = 40000;
	public static final int WARN  = 30000;
	public static final int INFO  = 20000;
	public static final int DEBUG = 10000;
	public static final int ALL   = Integer.MIN_VALUE;
	
	String filename = "cfdoc" + new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())+".log";
	private Class cls;
	SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
//	public static int threshold = DEBUG;
	public static int threshold = OFF;
	
	private Logger(Class cls) {
		this.cls = cls;
	}
	public static Logger getLogger(Class cls) {
		return new Logger(cls);
	}
	public void log(int level, Object msg, Throwable th) {
		StringBuffer sb = new StringBuffer();
		StackTraceElement ste = getCallSideStackTraceElement();
		sb.append(formatter.format(Calendar.getInstance().getTime()));
		switch (level) {
		case FATAL:	sb.append("[FATAL]");	break;
		case ERROR:	sb.append("[ERROR]");	break;
		case WARN:	sb.append("[WARN]");	break;
		case INFO:	sb.append("[INFO]");	break;
		case DEBUG:	sb.append("[DEBUG]");	break;
		default:	sb.append("["+level+"]");	break;
		}
		sb.append(cls.getName());
		sb.append(".");
		sb.append(ste.getMethodName());
		sb.append("(");
		sb.append(ste.getFileName());
		sb.append(":");
		sb.append(ste.getLineNumber());
		sb.append(")- ");
		sb.append(msg);
		PrintWriter writer = null;
		try {
			writer = new PrintWriter(new FileWriter(filename, true));
			writer.println(sb.toString());
			if (th != null) {
				th.printStackTrace(writer);
			}
		} catch (IOException ex) {
			// 
		} finally {
			if (writer != null) writer.close();
		}
		if (level > threshold) System.out.println(msg);
		if (th != null) th.printStackTrace();
	}
	public void debug(Object msg) {
		log(DEBUG, msg, null);
	}
	public void debug(Object msg, Throwable th) {
		log(DEBUG, msg, th);
	}
	public void info(Object msg) {
		log(INFO, msg, null);
	}
	public void info(Object msg, Throwable th) {
		log(INFO, msg, th);
	}
	StackTraceElement getCallSideStackTraceElement() {
		//StackTraceElement[] traces = Thread.currentThread().getStackTrace();
		StackTraceElement[] traces = new Throwable().getStackTrace();
//		for (int i=0; i<traces.length-1; i++) {
//			System.out.println(i+" "+traces[i]);
//			if (traces[i].getClass().equals(Logger.class) &&
//				! traces[i+1].getClass().equals(Logger.class)) {
//				return traces[i+1];
//			}
//		}
//		return traces[5];
		return traces[3];
	}
}
