<cfprocessingdirective pageencoding="UTF-8"/>
<cfcontent type="text/html; charset=UTF-8"/>
<cfoutput>
<html>
<head>
	<title>cfdoc</title>
	<link rel ="stylesheet" type="text/css" href="stylesheet.css" title="Style">
</head>
<body>
<h1>cfdoc</h1>
	<cfform name="cfdoc" action="cfdoc.cfm" method="post">
		<table>
			<tr>
				<th>システム名</th>
				<td><cfinput type="text" name="SystemName" value="cfdocシステム" size="80"></td>
			</tr>
			<tr>
				<th>ソースディレクトリ</th>
				<td><cfinput type="text" name="SourceDirectory" value="C:\ColdFusion8\wwwroot\cfdoc\" size="80"></td>
			</tr>
			<tr>
				<th>出力ディレクトリ</th>
				<td><cfinput type="text" name="OutDirectory" value="C:\ColdFusion8\wwwroot\cfdoc\api\" size="80"></td>
			</tr>
			<tr>
				<th>文字エンコード</th>
				<td><cfinput type="text" name="Encoding" value="UTF-8" size="80"></td>
			</tr>
		</table>
		<div class="message">文字エンコードには
		<a href="http://java.sun.com/j2se/1.5.0/ja/docs/ja/guide/intl/encoding.doc.html" target="_blank">Javaのエンコーディング名</a>
		（UTF-8 Shift_JIS windows-31j EUC-JP 等）を指定します。</div>
		<br>

		<cfset OnGenerating=false />
		<cfset ErrorMessage="" />
		<cfif IsDefined("Form.Generate") >

			<!--- 入力チェック --->
			<cfif NOT DirectoryExists(Form.SourceDirectory) >
				<cfset ErrorMessage="ソースディレクトリが存在しません。" />
				<cfreturn false/>
			</cfif>

			<!--- ディレクトリの末尾に\ をつける --->
			<cfif NOT Form.SourceDirectory.endsWith("\")>
				<cfset Form.SourceDirectory=Form.SourceDirectory & "\" />
			</cfif>
			<cfif NOT Form.OutDirectory.endsWith("\")>
				<cfset Form.OutDirectory=Form.OutDirectory & "\" />
			</cfif>

			<!--- 別スレッドで実行。でないとソースが多い場合はタイムアウトになってしまう。 --->
			<cfthread name="cfdoc_generator" action="run">
				<cfinvoke method="generate">
				</cfinvoke>
			</cfthread>
			<br/>
			<cfset OnGenerating=true />

			<!--- 処理中のみ表示 --->
			<cfoutput>
			別スレッドで実行中です。<br>
			ソースの量により、時間がかかる場合があります。<br>
			実行後、以下のリンクを開いてください。<br>
			（リンク先に飛ばない場合は、Webブラウザに以下のアドレスを直接指定してください）<br>
			<br>
			<a href="file:///#Form.OutDirectory#index.html" target="cfdoc" />file:///#Form.OutDirectory#index.html</a><br>
			<br>
			</cfoutput>

		</cfif>
		<input type="submit" name="generate" value=" 生 成 ">
	</cfform>
	<div class="Error">#ErrorMessage#</div>
	<!---
	<cfdump var="#Form#" />
	--->
	<br>
	<br>
	<br>
	<br>
	<a href="https://sourceforge.jp/projects/cfdoc" target="sourceforge">cfdoc@SOURCEFORGE.JP</a><br>
	<a href="http://sourceforge.jp/" target="sourceforge"><img src="http://sourceforge.jp/sflogo.php?group_id=673" width="96" height="31" border="0" alt="SourceForge.jp"></a>
</body>
</html>
</cfoutput>

<!--- ドキュメントを生成する --->
<cffunction name="generate" returntype="boolean">

	<!--- ソース解析 --->
	<cfobject type="Java" class="java.io.File" name="class_File">
	<cfobject type="Java" class="cfdoc.parser.CfParser" name="class_CfParser">
	<cfset dir = class_File.init(Form.SourceDirectory) >
	<cfset parser = class_CfParser.init() />
	<cfset parser.setDefaultEncoding(Form.Encoding) />
	<cfset cfSystem = parser.parseDir(dir) />
	<cfset cfSystem.putProperty("SystemName", Form.SystemName) />
	<cfset cfSystem.putProperty("SourceDirectory", Form.SourceDirectory) />
	<cfset t = now() />
	<cfset nowstr = DateFormat(t, "YYYY/MM/DD") & " " & TimeFormat(t, "hh:mm:ss") />
	<cfset cfSystem.putProperty("GenerateDate", nowstr) />

	<!--- ディレクトリ作成 --->
	<cfif NOT DirectoryExists(Form.OutDirectory)>
		<cfdirectory action="create" directory="#Form.OutDirectory#" />
	</cfif>
	<!--- 解析結果を出力 --->
	<cfset cfSystem.store("#Form.OutDirectory#cfsystem.bin") />

	<!--- リソースをコピー --->
	<cfset basedir="C:\ColdFusion8\wwwroot\cfdoc\" />
	<cffile action="copy" source="#basedir#stylesheet.css" destination="#Form.OutDirectory#stylesheet.css" />
	<cfif NOT DirectoryExists(Form.OutDirectory & "resources")>
		<cfdirectory action="create" directory="#Form.OutDirectory#resources" />
	</cfif>
	<cffile action="copy" source="#basedir#resources/folder.png" destination="#Form.OutDirectory#resources/folder.png" />
	<cffile action="copy" source="#basedir#resources/cffile.png" destination="#Form.OutDirectory#resources/cffile.png" />
	<cffile action="copy" source="#basedir#resources/component.png" destination="#Form.OutDirectory#resources/component.png" />
	<cffile action="copy" source="#basedir#resources/function.png" destination="#Form.OutDirectory#resources/function.png" />

	<!--- ソース生成 --->
	<cfhttp url="http://localhost:8500/cfdoc/generateIndex.cfm" method="POST">
		<cfhttpparam type="formField" name="binfile" value="#Form.OutDirectory#cfsystem.bin" />
	</cfhttp>
	<cfset contents=CFHTTP.FileContent />
	<cffile action="write" file="#Form.OutDirectory#index.html" output="#contents#" charset="utf-8" />

	<!--- ソース生成 --->
	<cfhttp url="http://localhost:8500/cfdoc/generateFileList.cfm" method="POST">
		<cfhttpparam type="formField" name="binfile" value="#Form.OutDirectory#cfsystem.bin" />
	</cfhttp>
	<cfset contents=CFHTTP.FileContent />
	<cffile action="write" file="#Form.OutDirectory#filelist.html" output="#contents#" charset="utf-8" />

	<!--- ソース生成 --->
	<cfhttp url="http://localhost:8500/cfdoc/generateSummary.cfm" method="POST">
		<cfhttpparam type="formField" name="binfile" value="#Form.OutDirectory#cfsystem.bin" />
	</cfhttp>
	<cfset contents=CFHTTP.FileContent />
	<cffile action="write" file="#Form.OutDirectory#summary.html" output="#contents#" charset="utf-8" />

	<cfset progressfile="#Form.OutDirectory#progress.txt" />
	<cffile action = "write" file="#progressfile#" output = "start!!!" charset="utf-8" />

	<!--- ファイル単位のドキュメントを生成 --->
	<cfloop index="index" from="0" to="#cfSystem.getFileCount()-1#">
		<cfset cffile=cfSystem.getFile(index) />
		<cffile action="append" file="#progressfile#" output="#cffile.file#" charset="utf-8">
		<cfhttp url="http://localhost:8500/cfdoc/generateFile.cfm" method="POST">
			<cfhttpparam type="formField" name="binfile" value="#Form.OutDirectory#cfsystem.bin" />
			<cfhttpparam type="formField" name="index" value="#index#" />
		</cfhttp>
		<cfset contents=CFHTTP.FileContent />
		<cffile action="write" file="#Form.OutDirectory#file_#cffile.file.getName()#.html" output="#contents#" charset="utf-8" />
	</cfloop>

	<cfreturn true />
</cffunction>
