<cfcomponent>
	<!---
		ユーザ定義関数のシグネチャを人間にわかりやすい形で表示する。
	--->
	<cffunction name="writeFunctionSignature" output="true" returntype="void" access="public">
		<cfargument name="cffunc" required="yes" />
		<cfargument name="anchor" type="boolean" default="yes" />

		<img src="./resources/function.png">
		<font class="FrameItemFont">
			<cfset name=cffunc.getAttribute("name","") />
			#cffunc.getAttribute("access","")#
			<cfif anchor>
				<a href="file_#cffunc.file.file.getName()#.html###name#" target="contentFrame">
				#name#
				</a>
			<cfelse>
				#name#
			</cfif>
			(
			<cfloop index="a" from=0 to="#cffunc.getArgumentCount()-1#">
				<cfset arg=cffunc.getArgument(a) />
				<cfset required=arg.getAttribute("required","no") />
				<cfset hasDefault=(arg.getAttribute("required","") EQ "") />
				<cfif NOT required><i>[</cfif>
				<cfif a NEQ "0">, </cfif>
				#arg.getAttribute("name", "")#
				:#arg.getAttribute("type", "any")#
				<cfif #hasDefault#>
					= #arg.getAttribute("default", "")#
				</cfif>
				<cfif NOT required>]</i></cfif>
			</cfloop>
			):
			#cffunc.getAttribute("returnType", "any")#
		</font>
	</cffunction>
</cfcomponent>
