<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="assert" access="public" returntype="void">
		<cfargument name="caseNo" type="string" required="true" />
		<cfargument name="note" type="string" required="true" />
		<cfargument name="input" type="any" required="true" />
		<cfargument name="expected" type="any" required="true" />
		<cfargument name="actual" type="any" required="true" />
		<cfargument name="result" type="string" required="true" />
		<cfargument name="expact" type="boolean" required="true" />
		<cfset var assertResult="failed" />
		<cfset var failedData="" />
		<cfset var expactFlag=false />
		<cfif ARGUMENTS.result neq "">
			<cfset assertResult="none" />
		<cfelse>
			<cftry>
				<cfset assertData(ARGUMENTS.expected, ARGUMENTS.actual) />
				<cfset assertResult="success" />
				<cfcatch>
					<cfset APPLICATION.logger.debuglog("CfneoTestRunner##assert type:[#cfcatch.Type#]") />
					<cfset APPLICATION.logger.debuglog("CfneoTestRunner##assert errorcode:[#cfcatch.ErrorCode#]") />
					<cfset APPLICATION.logger.debuglog("CfneoTestRunner##assert message:[#cfcatch.Message#]") />
					<cfif cfcatch.Type is "AssertEquals">
						<cfset assertResult="failed" />
					<cfelseif cfcatch.Type is "EqualsCaution">
						<cfset assertResult="caution" />
					<cfelse>
						<cfset assertResult="error" />
					</cfif>
					<cfset failedData=cfcatch />
				</cfcatch>
			</cftry>
		</cfif>
		<cfoutput>
			<cfif expactFlag>
				<tr>
					<th rowspan="2">#ARGUMENTS.caseNo#</th>
					<td rowspan="2">#ARGUMENTS.note#</td>
					<td rowspan="2">#outputData(ARGUMENTS.input)#</td>
					<td>#outputData(ARGUMENTS.expected)#</td>
					<cfswitch expression="#assertResult#">
						<cfcase value="none">
							<td rowspan="2">#ARGUMENTS.result#</td>
						</cfcase>
						<cfcase value="success">
							<td rowspan="2" class="success"></td>
						</cfcase>
						<cfcase value="failed">
							<td rowspan="2" class="failed">s<br />#failedData.Message#<br />(#failedData.ErrorCode#)</td>
						</cfcase>
						<cfcase value="caution">
							<td rowspan="2" class="caution"><br />#failedData.Message#<br />(#failedData.ErrorCode#)</td>
						</cfcase>
						<cfcase value="error">
							<td rowspan="2"><cfdump label="ERROR" var="#failedData#" /></td>
						</cfcase>
						<cfdefaultcase>
							<td rowspan="2"></td>
						</cfdefaultcase>
					</cfswitch>
				</tr>
				<tr>
					<td>#outputData(ARGUMENTS.actual)#</td>
				</tr>
			<cfelse>
				<tr>
					<th>#ARGUMENTS.caseNo#</th>
					<td>#ARGUMENTS.note#</td>
					<td>#outputData(ARGUMENTS.input)#</td>
					<td>#outputData(ARGUMENTS.expected)#</td>
					<td>#outputData(ARGUMENTS.actual)#</td>
					<cfswitch expression="#assertResult#">
						<cfcase value="none">
							<td>#ARGUMENTS.result#</td>
						</cfcase>
						<cfcase value="success">
							<td class="success"></td>
						</cfcase>
						<cfcase value="failed">
							<td class="failed">s<br />#failedData.Message#<br />(#failedData.ErrorCode#)</td>
						</cfcase>
						<cfcase value="caution">
							<td class="caution"><br />#failedData.Message#<br />(#failedData.ErrorCode#)</td>
						</cfcase>
						<cfcase value="error">
							<td><cfdump label="ERROR" var="#failedData#" /></td>
						</cfcase>
						<cfdefaultcase>
							<td />
						</cfdefaultcase>
					</cfswitch>
				</tr>
			</cfif>
		</cfoutput>
	</cffunction>

	<cffunction name="outputData" access="public" output="true" returntype="void">
		<cfargument name="data" type="any" required="true" />
		<cfset var comUtil=THIS.comMgr.getComponent("appcore.utils.ComponentUtil") />
		<cfoutput>
			<cfswitch expression="#comUtil.getDataType(ARGUMENTS.data)#">
				<cfcase value="date">
					[#DateFormat(ARGUMENTS.data, "YYYY-MM-DD")# #TimeFormat(ARGUMENTS.data, "HH:MM:SS")#]
				</cfcase>
				<cfcase value="string">
					<cfif REFind("\n", ARGUMENTS.data, 0, false) gt 0>
						<cfset outputData(convertString4Array(ARGUMENTS.data)) />
					<cfelse>
						[#ARGUMENTS.data#]
					</cfif>
				</cfcase>
				<cfcase value="array">
					<cfif ArrayLen(ARGUMENTS.data) gt 0 and ListFind("object,struct", comUtil.getDataType(ARGUMENTS.data[1])) is 0>
						<cfset ArraySort(ARGUMENTS.data, "text") />
					</cfif>
					<cfdump label="input" var="#ARGUMENTS.data#" expand="true" />
				</cfcase>
				<cfcase value="boolean">
					<cfif ARGUMENTS.data>
						[true]
					<cfelse>
						[false]
					</cfif>
				</cfcase>
				<cfdefaultcase>
					<cfdump label="input" var="#ARGUMENTS.data#" expand="true" />
				</cfdefaultcase>
			</cfswitch>
		</cfoutput>
	</cffunction>

	<cffunction name="assertData" access="public" output="false" returntype="void">
		<cfargument name="exp" type="any" required="true" />
		<cfargument name="act" type="any" required="true" />
		<cfset var expColList="" />
		<cfset var actColList="" />
		<cfset var idx1="" />
		<cfset var idx2="" />
		<cfset var tmpExp="" />
		<cfset var tmpAct="" />
		<cfset var comUtil=THIS.comMgr.getComponent("appcore.utils.ComponentUtil") />
		<cfset var dType=comUtil.getDataType(ARGUMENTS.exp) />
		<cfif comUtil.getDataType(ARGUMENTS.exp) neq comUtil.getDataType(ARGUMENTS.act)>
			<cfthrow type="AssertEquals" errorcode="assertData-001"
					message="DataType is unmatch.<br />exp:[#comUtil.getDataType(ARGUMENTS.exp)#]<br />act:[#comUtil.getDataType(ARGUMENTS.act)#]" />
		</cfif>
		<cfswitch expression="#dType#">
			<cfcase value="array">
				<cfset assertArray(ARGUMENTS.exp, ARGUMENTS.act) />
			</cfcase>
			<cfcase value="query">
				<cfset assertQuery(ARGUMENTS.exp, ARGUMENTS.act) />
			</cfcase>
			<cfcase value="struct,object">
				<cfset assertStruct(ARGUMENTS.exp, ARGUMENTS.act) />
			</cfcase>
			<cfcase value="method">
				<cfset assertStruct(ARGUMENTS.exp.metadata, ARGUMENTS.act.metadata) />
			</cfcase>
			<cfcase value="boolean">
				<cfset tmpExp=false />
				<cfif ARGUMENTS.exp>
					<cfset tmpExp=true />
				</cfif>
				<cfset tmpAct=false />
				<cfif ARGUMENTS.act>
					<cfset tmpAct=true />
				</cfif>
				<cfif tmpExp neq tmpAct>
					<cfthrow type="AssertEquals" errorcode="assertData-003"
							message="Data unmatch.<br />expected=[#tmpExp#]<br />actual=[#tmpAct#]" />
				</cfif>
			</cfcase>
			<cfdefaultcase>
				<cfif dType is "string" and REFind("\n", ARGUMENTS.exp, 0, false) gt 0>
					<cfset assertArray(
							convertString4Array(ARGUMENTS.exp),
							convertString4Array(ARGUMENTS.act)) />
				<cfelse>
					<cfset tmpExp=convertStringValue(ARGUMENTS.exp) />
					<cfset tmpAct=convertStringValue(ARGUMENTS.act) />
					<cfif Compare(tmpExp, tmpAct) neq 0>
						<cfif tmpExp is tmpAct>
							<cfthrow type="EqualsCaution" errorcode="assertData-004"
									message="Case unmatch.<br />expected=[#ARGUMENTS.exp#]<br />actual=[#ARGUMENTS.act#]" />
						<cfelse>
							<cfthrow type="AssertEquals" errorcode="assertData-002"
									message="Data unmatch.<br />expected=[#ARGUMENTS.exp#]<br />actual=[#ARGUMENTS.act#]" />
						</cfif>
					</cfif>
				</cfif>
			</cfdefaultcase>
		</cfswitch>
	</cffunction>

	<cffunction name="assertArray" access="public" output="false" returntype="void">
		<cfargument name="exp" type="any" required="true" />
		<cfargument name="act" type="any" required="true" />
		<cfset var comUtil=THIS.comMgr.getComponent("appcore.utils.ComponentUtil") />
		<cfset var arrcnt=0 />
		<cfset var e=ARGUMENTS.exp />
		<cfset var a=ARGUMENTS.act />
		<cfif ArrayLen(e) neq ArrayLen(a)>
			<cfthrow type="AssertEquals" errorcode="assertArray-001"
					message="Array length is unmatch.<br />exp=[#ArrayLen(e)#]<br />act=[#ArrayLen(a)#]" />
		</cfif>
		<cfif ArrayIsEmpty(e) and ArrayIsEmpty(a)>
			<cfreturn />
		</cfif>
		<cfset APPLICATION.logger.debuglog("##assertArray dataType:[#comUtil.getDataType(e[1])#]")>
		<cfif ListFind("object,struct,array", comUtil.getDataType(e[1])) is 0
				and ListFind("object,struct,array", comUtil.getDataType(a[1])) is 0>
			<cfset ArraySort(e, "text") />
			<cfset ArraySort(a, "text") />
		</cfif>
		<cfloop index="arrcnt" from="1" to="#ArrayLen(e)#">
			<cftry>
				<cfset assertData(e[arrcnt], a[arrcnt]) />
				<cfcatch>
					<cfif cfcatch.ErrorCode is "assertData-002">
						<cfthrow type="AssertEquals" errorcode="assertArray-002"
								message="Data unmatch.<br />(row=#arrcnt#)<br />expected=[#HtmlEditFormat(e[arrcnt])#]<br />actual=[#HtmlEditFormat(a[arrcnt])#]" />
					<cfelse>
						<cfrethrow />
					</cfif>
				</cfcatch>
			</cftry>
		</cfloop>
	</cffunction>

	<cffunction name="assertStruct" access="public" output="false" returntype="void">
		<cfargument name="exp" type="any" required="true" />
		<cfargument name="act" type="any" required="true" />
		<cfset var comUtil=THIS.comMgr.getComponent("appcore.utils.ComponentUtil") />
		<cfset var expKeyList="" />
		<cfset var actKeyList="" />
		<cfset var idx="" />
		<cfset expKeyList=StructKeyList(ARGUMENTS.exp) />
		<cfset actKeyList=StructKeyList(ARGUMENTS.act) />
		<cfif (ListLen(expKeyList) neq ListLen(actKeyList)) or (ListSort(expKeyList, "text") neq ListSort(actKeyList, "text"))>
			<cfthrow type="AssertEquals" errorcode="assertStruct-001"
					message="Key list is unmatch.<br />expKeyList:[#expKeyList#]<br />actKeyList:[#actKeyList#]" />
		</cfif>
		<cfloop index="idx" list="#expKeyList#">
			<cftry>
				<cfset assertData(ARGUMENTS.exp[idx], ARGUMENTS.act[idx]) />
				<cfcatch>
					<cfif cfcatch.ErrorCode is "assertData-002">
						<cfthrow type="AssertEquals" errorcode="assertStruct-002"
								message="Data unmatch.<br />key=[#idx#]" />
					<cfelse>
						<cfrethrow />
					</cfif>
				</cfcatch>
			</cftry>
		</cfloop>
	</cffunction>

	<cffunction name="convertStringValue" access="private" output="false" returntype="string">
		<cfargument name="p" type="string" required="true" />
		<cfset var v=ARGUMENTS.p />
		<cfset var idx=0 />
		<cfif Len(v) is 0>
			<cfreturn "" />
		</cfif>
		<cfloop index="idx" from="0" to="32">
			<cfif Find(v, Chr(idx)) gt 0>
				<cfset v=Replace(v, Chr(idx), "", "all") />
			</cfif>
		</cfloop>
		<cfreturn v />
	</cffunction>

	<cffunction name="assertQuery" access="public" output="false" returntype="void">
		<cfargument name="exp" type="query" required="true" />
		<cfargument name="act" type="query" required="true" />
		<cfset var expstr="" />
		<cfset var actstr="" />
		<cfif ARGUMENTS.exp.RecordCount neq ARGUMENTS.act.RecordCount>
			<cfthrow type="AssertEquals" errorcode="assertQuery-001"
					message="Record count unmatch.<br />exp=[#ARGUMENTS.exp.RecordCount#]<br />act=[#ARGUMENTS.act.RecordCount#]" />
		</cfif>
		<cfset expColList=ARGUMENTS.exp.ColumnList />
		<cfset actColList=ARGUMENTS.act.ColumnList />
		<cfif (ListLen(expColList) neq ListLen(actColList)) or (expColList neq actColList)>
			<cfthrow type="AssertEquals" errorcode="assertQuery-002"
					message="Result set's columns are unmatch.<br />exp=[#expColList#]<br />act=[#actColList#]" />
		</cfif>
		<cfset expstr=convertQ4Struct(ARGUMENTS.exp) />
		<cfset actstr=convertQ4Struct(ARGUMENTS.act) />
		<cfset assertStruct(expstr, actstr) />
	</cffunction>

	<cffunction name="convertQ4Struct" access="public" output="true" returntype="struct">
		<cfargument name="q" type="query" required="true" />
		<cfset var ret=StructNew() />
		<cfset var colList=ARGUMENTS.q.ColumnList />
		<cfset var col="" />
		<cfset var row=0 />
		<cfset var rowobj="" />
		<cfset var cellvalue="" />
		<cfloop query="ARGUMENTS.q">
			<cfset row=IncrementValue(row) />
			<cfset ret[row]=StructNew() />
			<cfloop index="col" list="#colList#">
				<cfset cellvalue=ARGUMENTS.q[col] />
				<cfset ret[row][col]=ToString(cellvalue) />
			</cfloop>
		</cfloop>
		<cfreturn ret />
	</cffunction>

	<cffunction name="convertString4Array" access="public" output="false" returntype="array">
		<cfargument name="s" type="string" required="true" />
		<cfset var row="" />
		<cfset var contArray=ArrayNew(1) />
		<cfloop index="row" list="#ARGUMENTS.s#" delimiters="#Chr(10)##Chr(13)#">
			<cfset ArrayAppend(contArray, ToString(row)) />
		</cfloop>
		<cfreturn contArray />
	</cffunction>

</cfcomponent>
