<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="getAnchor" access="public" output="false" returntype="string">
		<cfargument name="modulePath" type="string" required="true" />
		<cfset var pathutil=THIS.comMgr.getComponent("appcore.utils.PathUtil") />
		<cfset ret="" />
		<cfif isExistTestDriver(ARGUMENTS.modulePath)>
			<cfset ret=pathutil.convertPathImpl2Test(ARGUMENTS.modulePath) />
		</cfif>
		<cfreturn ret />
	</cffunction>

	<cffunction name="isExistTestDriver" access="public" output="false" returntype="boolean">
		<cfargument name="modulePath" type="string" required="true" />
		<cfset var pathutil=THIS.comMgr.getComponent("appcore.utils.PathUtil") />
		<cfset var testDriver=pathutil.convertPathImpl2Test(ARGUMENTS.modulePath) />
		<cfset var ret=false />
		<cfif FileExists(ExpandPath(testDriver))>
			<cfset ret=true />
		</cfif>
		<cfreturn ret />
	</cffunction>

</cfcomponent>