<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="absolute2Relative" access="public" output="true" returntype="string">
		<cfargument name="path" type="string" required="true" />
		<cfset var approot=Replace(ExpandPath(""), "\", "/", "all") />
		<cfset var ret=Replace(Replace(LCase(ARGUMENTS.path), "\", "/", "all"), LCase(approot), "", "all") />
		<cfreturn ret />
	</cffunction>

	<cffunction name="getFileNameFromAbsoPath" access="public" output="false" returntype="string">
		<cfargument name="path" type="string" required="true" />
		<cfset var findret=REFind("[^\\]*$", ARGUMENTS.path, 0, true) />
		<cfif findret.POS[1] gt 0 and findret.LEN[1] gt 0>
			<cfreturn Mid(ARGUMENTS.path, findret.POS[1], findret.LEN[1]) />
		</cfif>
		<cfreturn "" />
	</cffunction>

	<cffunction name="getExtension" access="public" output="false" returntype="string">
		<cfargument name="filename" type="string" required="true" />
		<cfset var p=REFind("\..{3}$", ARGUMENTS.filename, 0, true) />
		<cfset var ret="" />
		<cfif p.POS[1] gt 0>
			<cfset ret=Mid(ARGUMENTS.filename, p.POS[1], p.LEN[1]) />
		</cfif>
		<cfreturn ret />
	</cffunction>

	<cffunction name="isAbsolutePath" access="public" returntype="boolean">
		<cfargument name="TargetPath" type="string" required="true" />
		<cfif REFind("\\", Arguments.TargetPath, 0) gt 0>
			<cfreturn true />
		</cfif>
		<cfreturn false />
	</cffunction>

	<cffunction name="convertPathTest2Impl" access="public" output="false" returntype="string">
		<cfargument name="path" type="string" required="true" />
		<cfset var ret=ARGUMENTS.path />
		<cfif isAbsolutePath(ARGUMENTS.path)>
			<cfset ret=absolute2Relative(ARGUMENTS.path) />
		<cfelse>
			<cfset ret=absolute2Relative(ExpandPath(ret)) />
		</cfif>
		<cfset ret=Replace(Replace(ret, Replace(APPLICATION.TestingRoot, APPLICATION.ContentsRoot, ""), ""), "test.cfm", ".cfc") />
		<cfreturn ret />
	</cffunction>

	<cffunction name="convertPathImpl2Test" access="public" output="false" returntype="string">
		<cfargument name="path" type="string" required="true" />
		<cfset var ret=ARGUMENTS.path />
		<cfset var find="" />
		<cfif isAbsolutePath(ARGUMENTS.path)>
			<cfset ret=absolute2Relative(ARGUMENTS.path) />
		<cfelse>
			<cfset ret=absolute2Relative(ExpandPath(ret)) />
		</cfif>
		<cfset APPLICATION.logger.debuglog("convertPathImpl2Test ret1:[#ret#]") />
		<cfset ret=Replace(ret, APPLICATION.TestingRoot, "") />
		<cfset ret=Replace(ret, APPLICATION.ContentsRoot, "") />
		<cfset find=REFind(ret, APPLICATION.TestingRoot, 0, true) />
		<cfset APPLICATION.logger.debuglog("convertPathImpl2Test ret2:[#ret#]") />
		<cfset APPLICATION.logger.debuglog("convertPathImpl2Test find.pos:[#find.POS[1]#] / find.len:[#find.LEN[1]#]") />
		<cfset ret=Replace(ret, ".cfc", "Test.cfm") />
		<cfset ret=APPLICATION.TestingRoot & ret />
		<cfset APPLICATION.logger.debuglog("convertPathImpl2Test return:[#ret#]") />
		<cfreturn ret />
	</cffunction>

	<cffunction name="createComPackage" access="public" output="false" returntype="string">
		<cfargument name="absPath" type="string" required="true" />
		<cfset var ret=absolute2Relative(ARGUMENTS.absPath) />
		<cfset ret=REReplace(ret, "/", ".", "all") />
		<cfset ret=REReplace(ret, "^\.", "") />
		<cfset ret=Replace(ret, getExtension(ARGUMENTS.absPath), "") />
		<cfreturn ret />
	</cffunction>

</cfcomponent>
