<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cfset This.name="testapp" />

	<cfset This.applicationtimeout=CreateTimespan(0, 0, 5, 0) />
	<cfset This.sessionmanagement=true />
	<cfset This.sessiontimeout=CreateTimespan(0, 0, 0, 30) />
	<cfset This.scriptprotect=true />

	<cffunction name="onApplicationStart" returntype="boolean">
		<cfset initializeApp() />
		<cfreturn true />
	</cffunction>

	<cffunction name="onApplicationEnd" returntype="void">
		<cfargument name="ApplicationScope" required="true" />
	</cffunction>

	<cffunction name="onSessionStart" returntype="void">
	</cffunction>

	<cffunction name="onSessionEnd" returntype="void">
		<cfargument name="SessionScope" required="true" />
		<cfargument name="ApplicationScope" required="false" />
	</cffunction>

	<cffunction name="onRequestStart" returntype="boolean">
		<cfargument name="TargetPage" type="string" required="true" />
		<cfreturn true />
	</cffunction>

	<cffunction name="onRequest" returntype="void">
		<cfargument name="TargetPage" type="string" required="true" />
		<cfinclude template="#ARGUMENTS.TargetPage#" />
	</cffunction>

	<cffunction name="onRequestEnd" returntype="void">
		<cfargument name="TargetPage" type="string" required="true" />
	</cffunction>

	<cffunction name="onError" returntype="void">
		<cfargument name="Exception" required="true" />
		<cfargument name="EventName" type="string" required="true" />

		<cfif IsDefined("APPLICATION.debugMode") and APPLICATION.debugMode>
			<cfdump label="#ARGUMENTS.EventName#" var="#ARGUMENTS.Exception#" />
		<cfelse>
			<cfdump label="#ARGUMENTS.EventName#" var="#ARGUMENTS.Exception#" />
		</cfif>
	</cffunction>

	<!---//
	////////////////////////////////////////////////////////////////////////////
	// User defined functions
	////////////////////////////////////////////////////////////////////////////
	//--->

	<cffunction name="debuglog" access="public" output="false" returntype="void">
		<cfargument name="msg" type="string" required="true" />
		<cfset APPLICATION.logger.debuglog(ARGUMENTS.msg) />
	</cffunction>

	<cffunction name="initializeApp" access="public" output="false" returntype="void">
		<cfset var context=getComponentManager()
				.getComponent("appcore.facade.AppCoreFacade") />
		<cfset context.comMgr=getComponentManager() />
		<cfset context.setupContext(APPLICATION) />
	</cffunction>

	<cffunction name="getComponentManager" access="public" output="false" returntype="any">
		<cfset var obj="" />
		<cfif IsDefined("REQUEST.comMgr") and IsObject(REQUEST.comMgr)>
			<cfset obj=REQUEST.comMgr />
		<cfelse>
			<cfobject component="#APPLICATION.ApplicationName#.appcore.ComponentManager" name="obj" />
		</cfif>
		<cfreturn obj />
	</cffunction>

	<cffunction name="getSessionManager" access="private" output="false" returntype="any">
		<cfif IsDefined("SESSION.sesMgr") and IsObject(SESSION.sesMgr)>
			<cfset sesMgr=SESSION.sesMgr />
		<cfelse>
			<cflock scope="session" type="exclusive" throwontimeout="true" timeout="0">
				<cfset SESSION.sesMgr=getComponentManager().getComponent("appcore.SessionManager") />
			</cflock>
		</cfif>
		<cfreturn SESSION.sesMgr />
	</cffunction>

	<cffunction name="getValue" access="public" output="false" returntype="any">
		<cfargument name="name" type="string" required="true" />
		<cfargument name="defaultvalue" type="any" required="false" />
		<cfset var val="" />
		<cfset var defval="" />
		<cfset var sesMgr=getSessionManager() />
		<cfif IsDefined("ARGUMENTS.defaultvalue")>
			<cfset defval=ARGUMENTS.defaultvalue />
		</cfif>
		<cflock scope="session" type="exclusive" throwontimeout="true" timeout="0">
			<cfset val=sesMgr.getValue(SESSION, ARGUMENTS.name, defval) />
		</cflock>
		<cfreturn val />
	</cffunction>

	<cffunction name="setValue" access="public" output="false" returntype="void">
		<cfargument name="name" type="string" required="true" />
		<cfargument name="value" type="any" required="false" />
		<cfset var sesMgr=getSessionManager() />
		<cflock scope="session" type="exclusive" throwontimeout="true" timeout="0">
			<cfset sesMgr.setValue(SESSION, ARGUMENTS.name, ARGUMENTS.value) />
		</cflock>
	</cffunction>

	<cffunction name="isExistValue" access="public" output="false" returntype="boolean">
		<cfargument name="name" type="string" required="true" />
		<cfset var sesMgr=getSessionManager() />
		<cflock scope="session" type="exclusive" throwontimeout="true" timeout="0">
			<cfreturn sesMgr.isExistValue(SESSION, ARGUMENTS.name) />
		</cflock>
	</cffunction>

</cfcomponent>








