<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [/appcore/utils/Logger.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset logger=getComponentManager().getComponent("appcore.utils.Logger") />
			<cfset futil=getComponentManager().getComponent("appcore.utils.FileUtil") />
			<fieldset>
				<legend>Information</legend>
				OEt@C:[#APPLICATION.logfile#]
			</fieldset>
			<fieldset>
				<legend>debuglog</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th width="500px">expected</th>
						<th width="500px">actual</th>
						<th>result</th>
					</tr>

					<cfset logfile=APPLICATION.logfile />
					<cfset APPLICATION.logfile=ExpandPath("./LoggerTest/log.log") />
					<cfset APPLICATION.debugMode=true />

					<cfset in="aaa" />
					<cfset logger.debuglog(in) />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert("1", "o͂<br />debuglog@debugMode:[#APPLICATION.debugMode#]",
							in, exp, act) />

					<cfset in="debuglog-test-aaa" />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset logger.debuglog(in) />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert("2", "o͂<br />debuglog@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />

					<cfset APPLICATION.debugMode=false />
					<cfset in="debuglog-test-bbb" />
					<!--- o͂ȂeXgȂ̂ŁAݏo͂Ă郍OƔr --->
					<cffile action="read" file="#APPLICATION.logfile#" variable="exp" />
					<cfset logger.debuglog(in) />
					<cffile action="read" file="#APPLICATION.logfile#" variable="act" />
					<cfset assert("3", "o͂Ȃ<br />debuglog@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />
					<cfset APPLICATION.debugMode=true />
				</table>
			</fieldset>
			<fieldset>
				<legend>putlog</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>

					<cfset in="" />
					<cffile action="read" file="#APPLICATION.logfile#" variable="file" />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset logger.putlog(in) />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert("1", "o͂<br />putlog@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />

					<cfset in="debuglog-test-aaa" />
					<cffile action="read" file="#APPLICATION.logfile#" variable="file" />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset logger.putlog(in) />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert("2", "o͂<br />putlog@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />

					<cfset APPLICATION.debugMode=false />
					<cfset in="debuglog-test-bbb" />
					<cffile action="read" file="#APPLICATION.logfile#" variable="file" />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset logger.putlog(in) />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert("3", "o͂<br />putlog@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />
					<cfset APPLICATION.debugMode=true />
				</table>
			</fieldset>
			<fieldset>
				<legend>resetLogfile</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>

					<cffile action="read" file="#APPLICATION.logfile#" variable="file" />
					<cfset exp="" />
					<cfset logger.resetLogfile() />
					<cffile action="read" file="#APPLICATION.logfile#" variable="act" />
					<cfset assert("1", "(폜)<br />resetLogfile@debugMode:#APPLICATION.debugMode#",
							in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
