<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [/appcore/utils/PathUtil.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<fieldset>
				<legend>absolute2Relative</legend>
				<cfset com=getComponentManager().getComponent("appcore.utils.pathUtil") />
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/") />
					<cfset exp="/cfneo/test/" />
					<cfset act=com.absolute2Relative(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/testTest.test") />
					<cfset exp="/cfneo/test/testTest.test" />
					<cfset act=com.absolute2Relative(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./testTest.test") />
					<cfset exp="/cfneo/dev/test/appcore/utils/testTest.test" />
					<cfset act=com.absolute2Relative(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>getFileNameFromAbsoPath</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/test.cfm") />
					<cfset exp="test.cfm" />
					<cfset act=com.getFileNameFromAbsoPath(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/testTest.cfm") />
					<cfset exp="testTest.cfm" />
					<cfset act=com.getFileNameFromAbsoPath(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>getExtension</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/test.txt") />
					<cfset exp=".txt" />
					<cfset act=com.getExtension(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/test/txt.txt.txt") />
					<cfset exp=".txt" />
					<cfset act=com.getExtension(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>isAbsolutePath</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./test.txt") />
					<cfset exp=true />
					<cfset doAssert(caseNo, "invoke", in, exp, com.isAbsolutePath(in)) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/dev/test/appcore/utils/PathUtilTest.cfm" />
					<cfset exp=false />
					<cfset doAssert(caseNo, "invoke", in, exp, com.isAbsolutePath(in)) />
				</table>
			</fieldset>
			<fieldset>
				<legend>convertPathTest2Impl</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./PathUtilTest.cfm") />
					<cfset exp="/cfneo/appcore/utils/PathUtil.cfc" />
					<cfset act=com.convertPathTest2Impl(in) />
					<cfset doAssert(caseNo, "΃pXŎw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="./PathUtilTest.cfm" />
					<cfset exp="/cfneo/appcore/utils/PathUtil.cfc" />
					<cfset act=com.convertPathTest2Impl(in) />
					<cfset doAssert(caseNo, "΃pXŎw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/dev/test/appcore/utils/PathUtilTest.cfm" />
					<cfset exp="/cfneo/appcore/utils/PathUtil.cfc" />
					<cfset act=com.convertPathTest2Impl(in) />
					<cfset doAssert(caseNo, "URIɎw", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>convertPathImpl2Test</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("/cfneo/dummy/PathUtil.cfc") />
					<cfset exp="/cfneo/dev/test/dummy/PathUtilTest.cfm" />
					<cfset act=com.convertPathImpl2Test(in) />
					<cfset doAssert(caseNo, "΃pXŎw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="./PathUtil.cfc" />
					<cfset exp="/cfneo/dev/test/appcore/utils/PathUtilTest.cfm" />
					<cfset act=com.convertPathImpl2Test(in) />
					<cfset doAssert(caseNo, "΃pXŎw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/appcore/utils/PathUtil.cfc" />
					<cfset exp="/cfneo/dev/test/appcore/utils/PathUtilTest.cfm" />
					<cfset act=com.convertPathImpl2Test(in) />
					<cfset doAssert(caseNo, "r[", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/appcore/utils/PathUtil.cfc" />
					<cfset exp="/cfneo/dev/test/appcore/utils/PathUtilTest.cfm" />
					<cfset act=com.convertPathImpl2Test(in) />
					<cfset doAssert(caseNo, "URIɎw", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>createComPackage</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/appcore/Application.cfc" />
					<cfset exp="cfneo.appcore.Application" />
					<cfset act=com.createComPackage(in) />
					<cfset doAssert(caseNo, "", in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="doAssert" access="" output="true" returntype="void">
	<cfargument name="caseNo" type="string" required="true" />
	<cfargument name="note" type="string" required="true" />
	<cfargument name="in" type="any" required="true" />
	<cfargument name="exp" type="any" required="true" />
	<cfargument name="act" type="any" required="true" />
	<cfset assert(ARGUMENTS.caseNo, ARGUMENTS.note, ARGUMENTS.in,
			LCase(ARGUMENTS.exp), LCase(ARGUMENTS.act)) />
</cffunction>
